/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.L2Character;

public final class AggroInfo {
    private final L2Character _attacker;
    private long _hate = 0L;
    private int _damage = 0;

    public AggroInfo(L2Character pAttacker) {
        this._attacker = pAttacker;
    }

    public L2Character getAttacker() {
        return this._attacker;
    }

    public long getHate() {
        return this._hate;
    }

    public long checkHate(L2Character owner) {
        if (this._attacker.isAlikeDead() || !this._attacker.isVisible() || !owner.getKnownList().knowsObject(this._attacker)) {
            this._hate = 0L;
        }
        return this._hate;
    }

    public void addHate(long value) {
        this._hate = Math.min(this._hate + value, 999999999L);
    }

    public void stopHate() {
        this._hate = 0L;
    }

    public int getDamage() {
        return this._damage;
    }

    public void addDamage(int value) {
        this._damage = (int)Math.min((long)this._damage + (long)value, 999999999L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AggroInfo) {
            return ((AggroInfo)obj).getAttacker() == this._attacker;
        }
        return false;
    }

    public int hashCode() {
        return this._attacker.getObjectId();
    }

    public String toString() {
        return "AggroInfo [attacker=" + String.valueOf(this._attacker) + ", hate=" + this._hate + ", damage=" + this._damage + "]";
    }
}

