/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.FuncAdd;
import java.util.HashMap;
import java.util.Map;

public final class Elementals {
    private static final Map<Integer, ElementalItems> TABLE = new HashMap<Integer, ElementalItems>();
    public static final byte NONE = -1;
    public static final byte FIRE = 0;
    public static final byte WATER = 1;
    public static final byte WIND = 2;
    public static final byte EARTH = 3;
    public static final byte HOLY = 4;
    public static final byte DARK = 5;
    public static final int FIRST_WEAPON_BONUS = 20;
    public static final int NEXT_WEAPON_BONUS = 5;
    public static final int ARMOR_BONUS = 6;
    public static final int[] WEAPON_VALUES;
    public static final int[] ARMOR_VALUES;
    private final ElementalStatBoni _boni;
    private byte _element;
    private int _value;

    public static byte getItemElement(int itemId) {
        ElementalItems item = TABLE.get(itemId);
        if (item != null) {
            return item._element;
        }
        return -1;
    }

    public static ElementalItems getItemElemental(int itemId) {
        return TABLE.get(itemId);
    }

    public static int getMaxElementLevel(int itemId) {
        ElementalItems item = TABLE.get(itemId);
        if (item != null) {
            return item._type._maxLevel;
        }
        return -1;
    }

    public static String getElementName(byte element) {
        return switch (element) {
            case 0 -> "Fire";
            case 1 -> "Water";
            case 2 -> "Wind";
            case 3 -> "Earth";
            case 5 -> "Dark";
            case 4 -> "Holy";
            default -> "None";
        };
    }

    public static byte getElementId(String name) {
        String tmp = name.toLowerCase();
        if (tmp.equals("fire")) {
            return 0;
        }
        if (tmp.equals("water")) {
            return 1;
        }
        if (tmp.equals("wind")) {
            return 2;
        }
        if (tmp.equals("earth")) {
            return 3;
        }
        if (tmp.equals("dark")) {
            return 5;
        }
        if (tmp.equals("holy")) {
            return 4;
        }
        return -1;
    }

    public static byte getOppositeElement(byte element) {
        return (byte)(element % 2 == 0 ? element + 1 : element - 1);
    }

    public byte getElement() {
        return this._element;
    }

    public void setElement(byte type) {
        this._element = type;
        this._boni.setElement(type);
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int val) {
        this._value = val;
        this._boni.setValue(val);
    }

    public String toString() {
        return Elementals.getElementName(this._element) + " +" + this._value;
    }

    public Elementals(byte type, int value) {
        this._element = type;
        this._value = value;
        this._boni = new ElementalStatBoni(this._element, this._value);
    }

    public void applyBonus(L2PcInstance player, boolean isArmor) {
        this._boni.applyBonus(player, isArmor);
    }

    public void removeBonus(L2PcInstance player) {
        this._boni.removeBonus(player);
    }

    public void updateBonus(L2PcInstance player, boolean isArmor) {
        this._boni.removeBonus(player);
        this._boni.applyBonus(player, isArmor);
    }

    static {
        for (ElementalItems item : ElementalItems.values()) {
            TABLE.put(item._itemId, item);
        }
        WEAPON_VALUES = new int[]{0, 25, 75, 150, 175, 225, 300, 325, 375, 450, 475, 525, 600, Integer.MAX_VALUE};
        ARMOR_VALUES = new int[]{0, 12, 30, 60, 72, 90, 120, 132, 150, 180, 192, 210, 240, Integer.MAX_VALUE};
    }

    public static enum ElementalItems {
        fireStone(0, 9546, ElementalItemType.Stone),
        waterStone(1, 9547, ElementalItemType.Stone),
        windStone(2, 9549, ElementalItemType.Stone),
        earthStone(3, 9548, ElementalItemType.Stone),
        divineStone(4, 9551, ElementalItemType.Stone),
        darkStone(5, 9550, ElementalItemType.Stone),
        fireRoughtore(0, 10521, ElementalItemType.Roughore),
        waterRoughtore(1, 10522, ElementalItemType.Roughore),
        windRoughtore(2, 10524, ElementalItemType.Roughore),
        earthRoughtore(3, 10523, ElementalItemType.Roughore),
        divineRoughtore(4, 10526, ElementalItemType.Roughore),
        darkRoughtore(5, 10525, ElementalItemType.Roughore),
        fireCrystal(0, 9552, ElementalItemType.Crystal),
        waterCrystal(1, 9553, ElementalItemType.Crystal),
        windCrystal(2, 9555, ElementalItemType.Crystal),
        earthCrystal(3, 9554, ElementalItemType.Crystal),
        divineCrystal(4, 9557, ElementalItemType.Crystal),
        darkCrystal(5, 9556, ElementalItemType.Crystal),
        fireJewel(0, 9558, ElementalItemType.Jewel),
        waterJewel(1, 9559, ElementalItemType.Jewel),
        windJewel(2, 9561, ElementalItemType.Jewel),
        earthJewel(3, 9560, ElementalItemType.Jewel),
        divineJewel(4, 9563, ElementalItemType.Jewel),
        darkJewel(5, 9562, ElementalItemType.Jewel),
        fireEnergy(0, 9564, ElementalItemType.Energy),
        waterEnergy(1, 9565, ElementalItemType.Energy),
        windEnergy(2, 9567, ElementalItemType.Energy),
        earthEnergy(3, 9566, ElementalItemType.Energy),
        divineEnergy(4, 9569, ElementalItemType.Energy),
        darkEnergy(5, 9568, ElementalItemType.Energy);

        public byte _element;
        public int _itemId;
        public ElementalItemType _type;

        private ElementalItems(byte element, int itemId, ElementalItemType type) {
            this._element = element;
            this._itemId = itemId;
            this._type = type;
        }
    }

    public static enum ElementalItemType {
        Stone(3),
        Roughore(3),
        Crystal(6),
        Jewel(9),
        Energy(12);

        public int _maxLevel;

        private ElementalItemType(int maxLvl) {
            this._maxLevel = maxLvl;
        }
    }

    public static class ElementalStatBoni {
        private byte _elementalType;
        private int _elementalValue;
        private boolean _active;

        public ElementalStatBoni(byte type, int value) {
            this._elementalType = type;
            this._elementalValue = value;
            this._active = false;
        }

        public void applyBonus(L2PcInstance player, boolean isArmor) {
            if (this._active) {
                return;
            }
            switch (this._elementalType) {
                case 0: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.FIRE_RES : Stats.FIRE_POWER, 64, this, this._elementalValue, null));
                    break;
                }
                case 1: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.WATER_RES : Stats.WATER_POWER, 64, this, this._elementalValue, null));
                    break;
                }
                case 2: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.WIND_RES : Stats.WIND_POWER, 64, this, this._elementalValue, null));
                    break;
                }
                case 3: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.EARTH_RES : Stats.EARTH_POWER, 64, this, this._elementalValue, null));
                    break;
                }
                case 5: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.DARK_RES : Stats.DARK_POWER, 64, this, this._elementalValue, null));
                    break;
                }
                case 4: {
                    player.addStatFuncs(new FuncAdd(isArmor ? Stats.HOLY_RES : Stats.HOLY_POWER, 64, this, this._elementalValue, null));
                }
            }
            this._active = true;
        }

        public void removeBonus(L2PcInstance player) {
            if (!this._active) {
                return;
            }
            player.removeStatsOwner(this);
            this._active = false;
        }

        public void setValue(int val) {
            this._elementalValue = val;
        }

        public void setElement(byte type) {
            this._elementalType = type;
        }
    }
}

