/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.data.xml.impl.OptionData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.options.Options;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2Augmentation {
    private final int _effectsId;
    private final AugmentationStatBoni _boni;

    public L2Augmentation(int effects) {
        this._effectsId = effects;
        this._boni = new AugmentationStatBoni(this._effectsId);
    }

    public int getAttributes() {
        return this._effectsId;
    }

    public int getAugmentationId() {
        return this._effectsId;
    }

    public void applyBonus(L2PcInstance player) {
        this._boni.applyBonus(player);
    }

    public void removeBonus(L2PcInstance player) {
        this._boni.removeBonus(player);
    }

    public static class AugmentationStatBoni {
        private static final Logger LOG = LoggerFactory.getLogger(AugmentationStatBoni.class);
        private final List<Options> _options = new ArrayList<Options>();
        private boolean _active = false;

        public AugmentationStatBoni(int augmentationId) {
            int[] stats = new int[]{0xFFFF & augmentationId, augmentationId >> 16};
            for (int stat : stats) {
                Options op = OptionData.getInstance().getOptions(stat);
                if (op != null) {
                    this._options.add(op);
                    continue;
                }
                LOG.warn("Couldn't find option: {}", (Object)stat);
            }
        }

        public void applyBonus(L2PcInstance player) {
            if (this._active) {
                return;
            }
            for (Options op : this._options) {
                op.apply(player);
            }
            this._active = true;
        }

        public void removeBonus(L2PcInstance player) {
            if (!this._active) {
                return;
            }
            for (Options op : this._options) {
                op.remove(player);
            }
            this._active = false;
        }
    }
}

