/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.network.serverpackets.AllyCrest;
import com.l2jserver.gameserver.network.serverpackets.ExPledgeCrestLarge;
import com.l2jserver.gameserver.network.serverpackets.PledgeCrest;

public final class L2Crest
implements IIdentifiable {
    private final int _id;
    private final byte[] _data;
    private final CrestType _type;

    public L2Crest(int id, byte[] data, CrestType type) {
        this._id = id;
        this._data = data;
        this._type = type;
    }

    @Override
    public int getId() {
        return this._id;
    }

    public byte[] getData() {
        return this._data;
    }

    public CrestType getType() {
        return this._type;
    }

    public String getClientPath(L2PcInstance activeChar) {
        String path = null;
        switch (this.getType().ordinal()) {
            case 0: {
                activeChar.sendPacket(new PledgeCrest(this.getId(), this.getData()));
                path = "Crest.crest_" + Configuration.hexId().getServerID() + "_" + this.getId();
                break;
            }
            case 1: {
                activeChar.sendPacket(new ExPledgeCrestLarge(this.getId(), this.getData()));
                path = "Crest.crest_" + Configuration.hexId().getServerID() + "_" + this.getId() + "_l";
                break;
            }
            case 2: {
                activeChar.sendPacket(new AllyCrest(this.getId(), this.getData()));
                path = "Crest.crest_" + Configuration.hexId().getServerID() + "_" + this.getId();
            }
        }
        return path;
    }

    public static enum CrestType {
        PLEDGE(1),
        PLEDGE_LARGE(2),
        ALLY(3);

        private final int _id;

        private CrestType(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public static CrestType getById(int id) {
            for (CrestType crestType : CrestType.values()) {
                if (crestType.getId() != id) continue;
                return crestType;
            }
            return null;
        }
    }
}

