/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2PeaceZone;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2WorldRegion {
    private static final Logger LOG = LoggerFactory.getLogger(L2WorldRegion.class);
    private final Map<Integer, L2Playable> _allPlayable = new ConcurrentHashMap<Integer, L2Playable>();
    private final Map<Integer, L2Object> _visibleObjects = new ConcurrentHashMap<Integer, L2Object>();
    private final Queue<L2WorldRegion> _surroundingRegions = new ConcurrentLinkedQueue<L2WorldRegion>();
    private final int _tileX;
    private final int _tileY;
    private boolean _active;
    private ScheduledFuture<?> _neighborsTask = null;
    private final List<L2ZoneType> _zones = new CopyOnWriteArrayList<L2ZoneType>();

    public L2WorldRegion(int pTileX, int pTileY) {
        this._tileX = pTileX;
        this._tileY = pTileY;
        this._active = Configuration.general().gridsAlwaysOn();
    }

    public int getTileX() {
        return this._tileX;
    }

    public int getTileY() {
        return this._tileY;
    }

    public List<L2ZoneType> getZones() {
        return this._zones;
    }

    public void addZone(L2ZoneType zone) {
        this._zones.add(zone);
    }

    public void removeZone(L2ZoneType zone) {
        this._zones.remove(zone);
    }

    public void revalidateZones(L2Character character) {
        if (character.isTeleporting()) {
            return;
        }
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.revalidateInZone(character);
        }
    }

    public void removeFromZones(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.removeCharacter(character);
        }
    }

    public boolean containsZone(int zoneId) {
        for (L2ZoneType z : this.getZones()) {
            if (z.getId() != zoneId) continue;
            return true;
        }
        return false;
    }

    public boolean checkEffectRangeInsidePeaceZone(Skill skill, int x, int y, int z) {
        int range = skill.getEffectRange();
        int up = y + range;
        int down = y - range;
        int left = x + range;
        int right = x - range;
        for (L2ZoneType e : this.getZones()) {
            if (!(e instanceof L2PeaceZone)) continue;
            if (e.isInsideZone(x, up, z)) {
                return false;
            }
            if (e.isInsideZone(x, down, z)) {
                return false;
            }
            if (e.isInsideZone(left, y, z)) {
                return false;
            }
            if (e.isInsideZone(right, y, z)) {
                return false;
            }
            if (!e.isInsideZone(x, y, z)) continue;
            return false;
        }
        return true;
    }

    public void onDeath(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.onDieInside(character);
        }
    }

    public void onRevive(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.onReviveInside(character);
        }
    }

    private void switchAI(boolean isOn) {
        int c = 0;
        if (!isOn) {
            for (L2Object o : this._visibleObjects.values()) {
                if (o instanceof L2Attackable) {
                    L2Attackable mob = (L2Attackable)o;
                    ++c;
                    mob.setTarget(null);
                    mob.stopMove(null);
                    mob.stopAllEffects();
                    mob.clearAggroList();
                    mob.getAttackByList().clear();
                    mob.getKnownList().removeAllKnownObjects();
                    if (!mob.hasAI()) continue;
                    mob.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    mob.getAI().stopAITask();
                    continue;
                }
                if (!(o instanceof L2Vehicle)) continue;
                L2Vehicle vehicle = (L2Vehicle)o;
                ++c;
                vehicle.getKnownList().removeAllKnownObjects();
            }
            LOG.debug("{} mobs were turned off", (Object)c);
        } else {
            for (L2Object o : this._visibleObjects.values()) {
                if (o instanceof L2Attackable) {
                    L2Attackable attackable = (L2Attackable)o;
                    ++c;
                    attackable.getStatus().startHpMpRegeneration();
                    continue;
                }
                if (!(o instanceof L2Npc)) continue;
                L2Npc npc = (L2Npc)o;
                npc.startRandomAnimationTimer();
            }
            LOG.debug("{} mobs were turned on", (Object)c);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean areNeighborsEmpty() {
        if (this.isActive() && !this._allPlayable.isEmpty()) {
            return false;
        }
        for (L2WorldRegion neighbor : this._surroundingRegions) {
            if (!neighbor.isActive() || neighbor._allPlayable.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setActive(boolean value) {
        if (this._active == value) {
            return;
        }
        this._active = value;
        this.switchAI(value);
        if (value) {
            LOG.debug("Starting Grid {}, {}", (Object)this._tileX, (Object)this._tileY);
        } else {
            LOG.debug("Stopping Grid {}, {}", (Object)this._tileX, (Object)this._tileY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startActivation() {
        this.setActive(true);
        L2WorldRegion l2WorldRegion = this;
        synchronized (l2WorldRegion) {
            if (this._neighborsTask != null) {
                this._neighborsTask.cancel(true);
                this._neighborsTask = null;
            }
            this._neighborsTask = ThreadPoolManager.getInstance().scheduleGeneral(new NeighborsTask(true), 1000L * (long)Configuration.general().getGridNeighborTurnOnTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDeactivation() {
        L2WorldRegion l2WorldRegion = this;
        synchronized (l2WorldRegion) {
            if (this._neighborsTask != null) {
                this._neighborsTask.cancel(true);
                this._neighborsTask = null;
            }
            this._neighborsTask = ThreadPoolManager.getInstance().scheduleGeneral(new NeighborsTask(false), 1000L * (long)Configuration.general().getGridNeighborTurnOffTime());
        }
    }

    public void addVisibleObject(L2Object object) {
        if (object == null) {
            return;
        }
        assert (object.getWorldRegion() == this);
        this._visibleObjects.put(object.getObjectId(), object);
        if (object instanceof L2Playable) {
            L2Playable playable = (L2Playable)object;
            this._allPlayable.put(object.getObjectId(), playable);
            if (this._allPlayable.size() == 1 && !Configuration.general().gridsAlwaysOn()) {
                this.startActivation();
            }
        }
    }

    public void removeVisibleObject(L2Object object) {
        if (object == null) {
            return;
        }
        assert (object.getWorldRegion() == this || object.getWorldRegion() == null);
        this._visibleObjects.remove(object.getObjectId());
        if (object instanceof L2Playable) {
            this._allPlayable.remove(object.getObjectId());
            if (this._allPlayable.isEmpty() && !Configuration.general().gridsAlwaysOn()) {
                this.startDeactivation();
            }
        }
    }

    public void addSurroundingRegion(L2WorldRegion region) {
        this._surroundingRegions.add(region);
    }

    public Queue<L2WorldRegion> getSurroundingRegions() {
        return this._surroundingRegions;
    }

    public Map<Integer, L2Playable> getVisiblePlayable() {
        return this._allPlayable;
    }

    public Map<Integer, L2Object> getVisibleObjects() {
        return this._visibleObjects;
    }

    public String getName() {
        return "(" + this._tileX + ", " + this._tileY + ")";
    }

    public void deleteVisibleNpcSpawns() {
        LOG.debug("Deleting all visible NPCs in Region: {}", (Object)this.getName());
        for (L2Object obj : this._visibleObjects.values()) {
            if (!(obj instanceof L2Npc)) continue;
            L2Npc target = (L2Npc)obj;
            target.deleteMe();
            L2Spawn spawn = target.getSpawn();
            if (spawn != null) {
                spawn.stopRespawn();
                SpawnTable.getInstance().deleteSpawn(spawn, false);
            }
            LOG.trace("Removed NPC {}", (Object)target.getObjectId());
        }
        LOG.info("All visible NPCs deleted in Region: {}", (Object)this.getName());
    }

    public class NeighborsTask
    implements Runnable {
        private final boolean _isActivating;

        public NeighborsTask(boolean isActivating) {
            this._isActivating = isActivating;
        }

        @Override
        public void run() {
            if (this._isActivating) {
                for (L2WorldRegion neighbor : L2WorldRegion.this.getSurroundingRegions()) {
                    neighbor.setActive(true);
                }
            } else {
                if (L2WorldRegion.this.areNeighborsEmpty()) {
                    L2WorldRegion.this.setActive(false);
                }
                for (L2WorldRegion neighbor : L2WorldRegion.this.getSurroundingRegions()) {
                    if (!neighbor.areNeighborsEmpty()) continue;
                    neighbor.setActive(false);
                }
            }
        }
    }
}

