/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.handler.BypassHandler;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2ClanHallManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TeleporterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2WarehouseInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import com.l2jserver.gameserver.model.actor.stat.NpcStat;
import com.l2jserver.gameserver.model.actor.status.NpcStatus;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcCanBeSeen;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSpawn;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcTeleport;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.variables.NpcVariables;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExChangeNpcState;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Npc
extends L2Character {
    private static final Logger LOG = LoggerFactory.getLogger(L2Npc.class);
    public static final int INTERACTION_DISTANCE = 150;
    public static final int RANDOM_ITEM_DROP_LIMIT = 70;
    private L2Spawn _spawn;
    private boolean _isBusy = false;
    private String _busyMessage = "";
    private volatile boolean _isDecayed = false;
    private int _castleIndex = -2;
    private int _fortIndex = -2;
    private boolean _eventMob = false;
    private boolean _isInTown = false;
    private boolean _isAutoAttackable = false;
    private long _lastSocialBroadcast = 0L;
    private static final int MINIMUM_SOCIAL_INTERVAL = 6000;
    private boolean _isRandomAnimationEnabled = true;
    private boolean _isTalking = true;
    protected RandomAnimationTask _rAniTask = null;
    private int _currentLHandId;
    private int _currentRHandId;
    private int _currentEnchant;
    private double _currentCollisionHeight;
    private double _currentCollisionRadius;
    private int _soulshotamount = 0;
    private int _spiritshotamount = 0;
    private int _displayEffect = 0;
    private int _shotsMask = 0;
    private int _killingBlowWeaponId;
    private volatile Map<Integer, L2Npc> _summonedNpcs = null;

    public L2Npc(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Npc);
        this.initCharStatusUpdateValues();
        this._currentLHandId = this.getTemplate().getLHandId();
        this._currentRHandId = this.getTemplate().getRHandId();
        this._currentEnchant = Configuration.npc().randomEnchantEffect() ? Rnd.get((int)4, (int)21) : this.getTemplate().getWeaponEnchant();
        this._currentCollisionHeight = this.getTemplate().getfCollisionHeight();
        this._currentCollisionRadius = this.getTemplate().getfCollisionRadius();
        this.setIsFlying(template.isFlying());
        for (Skill skill : template.getSkills().values()) {
            this.addSkill(skill);
        }
    }

    public L2Npc(int objectId, int npcId) {
        this(objectId, NpcData.getInstance().getTemplate(npcId));
    }

    public int getSoulShotChance() {
        return this.getTemplate().getSoulShotChance();
    }

    public int getSpiritShotChance() {
        return this.getTemplate().getSpiritShotChance();
    }

    public boolean hasSkillChance() {
        return Rnd.get((int)100) < Rnd.get((int)this.getTemplate().getMinSkillChance(), (int)this.getTemplate().getMaxSkillChance());
    }

    public boolean canMove() {
        return this.getTemplate().canMove();
    }

    public boolean isChaos() {
        return this.getTemplate().isChaos();
    }

    public List<Skill> getLongRangeSkills() {
        return this.getTemplate().getAISkills(AISkillScope.LONG_RANGE);
    }

    public List<Skill> getShortRangeSkills() {
        return this.getTemplate().getAISkills(AISkillScope.SHORT_RANGE);
    }

    public void onRandomAnimation(int animationId) {
        long now = System.currentTimeMillis();
        if (now - this._lastSocialBroadcast > 6000L) {
            this._lastSocialBroadcast = now;
            this.broadcastPacket(new SocialAction(this.getObjectId(), animationId));
        }
    }

    public void startRandomAnimationTimer() {
        if (!this.hasRandomAnimation()) {
            return;
        }
        int minWait = this.isMob() ? Configuration.general().getMinMonsterAnimation() : Configuration.general().getMinNPCAnimation();
        int maxWait = this.isMob() ? Configuration.general().getMaxMonsterAnimation() : Configuration.general().getMaxNPCAnimation();
        int interval = Rnd.get((int)minWait, (int)maxWait) * 1000;
        this._rAniTask = new RandomAnimationTask(this);
        ThreadPoolManager.getInstance().scheduleGeneral(this._rAniTask, interval);
    }

    public boolean hasRandomAnimation() {
        return Configuration.general().getMaxNPCAnimation() > 0 && this._isRandomAnimationEnabled && !this.getAiType().equals((Object)AIType.CORPSE);
    }

    public void setRandomAnimationEnabled(boolean val) {
        this._isRandomAnimationEnabled = val;
    }

    public boolean isRandomAnimationEnabled() {
        return this._isRandomAnimationEnabled;
    }

    @Override
    public NpcKnownList getKnownList() {
        return (NpcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NpcKnownList(this));
    }

    @Override
    public NpcStat getStat() {
        return (NpcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new NpcStat(this));
    }

    @Override
    public NpcStatus getStatus() {
        return (NpcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new NpcStatus(this));
    }

    @Override
    public final L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    @Override
    public int getId() {
        return this.getTemplate().getId();
    }

    @Override
    public boolean canBeAttacked() {
        return Configuration.npc().attackableNpcs();
    }

    @Override
    public final int getLevel() {
        return this.getTemplate().getLevel();
    }

    public boolean isAggressive() {
        return false;
    }

    public int getAggroRange() {
        int aiAggroRange = this.getAIValue("aggroRange");
        if (aiAggroRange >= 0) {
            return aiAggroRange;
        }
        int maxAggroRange = Configuration.npc().getMaxAggroRange();
        if (maxAggroRange > 0) {
            return Math.min(this.getTemplate().getAggroRange(), maxAggroRange);
        }
        return this.getTemplate().getAggroRange();
    }

    public boolean isInMyClan(L2Npc npc) {
        return this.getTemplate().isClan(npc.getTemplate().getClans());
    }

    @Override
    public boolean isUndead() {
        return this.getTemplate().getRace() == Race.UNDEAD;
    }

    public boolean isSevenNpc() {
        return this.getTemplate().isClan("C_DUNGEON", new String[0]) && !this.getTemplate().isClan("ALL", new String[0]);
    }

    @Override
    public void updateAbnormalEffect() {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isVisibleFor(player)) continue;
            if (this.getRunSpeed() == 0.0) {
                player.sendPacket(new ServerObjectInfo(this, player));
                continue;
            }
            player.sendPacket(new AbstractNpcInfo.NpcInfo(this, player));
        }
    }

    public boolean isEventMob() {
        return this._eventMob;
    }

    public void setEventMob(boolean val) {
        this._eventMob = val;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._isAutoAttackable;
    }

    public void setAutoAttackable(boolean flag) {
        this._isAutoAttackable = flag;
    }

    public int getLeftHandItem() {
        return this._currentLHandId;
    }

    public int getRightHandItem() {
        return this._currentRHandId;
    }

    public int getEnchantEffect() {
        return this._currentEnchant;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public void setBusy(boolean isBusy) {
        this._isBusy = isBusy;
    }

    public final String getBusyMessage() {
        return this._busyMessage;
    }

    public void setBusyMessage(String message) {
        this._busyMessage = message;
    }

    public boolean isWarehouse() {
        return false;
    }

    public boolean canTarget(L2PcInstance player) {
        if (player.isOutOfControl()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (player.isLockedTarget() && player.getLockedTarget() != this) {
            player.sendPacket(SystemMessageId.FAILED_CHANGE_TARGET);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        return true;
    }

    public boolean canInteract(L2PcInstance player) {
        if (player.isCastingNow() || player.isCastingSimultaneouslyNow()) {
            return false;
        }
        if (player.isDead() || player.isFakeDeath()) {
            return false;
        }
        if (player.isSitting()) {
            return false;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            return false;
        }
        if (!this.isInsideRadius(player, 150, true, false)) {
            return false;
        }
        if (player.getInstanceId() != this.getInstanceId() && player.getInstanceId() != -1) {
            return false;
        }
        return !this.isBusy();
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            L2TownZone town = TownManager.getTown(this.getX(), this.getY(), this.getZ());
            if (town != null) {
                this._castleIndex = CastleManager.getInstance().getCastleIndex(town.getTaxById());
            }
            if (this._castleIndex < 0) {
                this._castleIndex = CastleManager.getInstance().findNearestCastleIndex(this);
            } else {
                this._isInTown = true;
            }
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public boolean isMyLord(L2PcInstance player) {
        if (player.isClanLeader()) {
            int castleId = this.getCastle() != null ? this.getCastle().getResidenceId() : -1;
            int fortId = this.getFort() != null ? this.getFort().getResidenceId() : -1;
            return player.getClan().getCastleId() == castleId || player.getClan().getFortId() == fortId;
        }
        return false;
    }

    public boolean isDominionOfLord(int dominionId) {
        int castleId = this.getCastle() != null ? this.getCastle().getResidenceId() : -1;
        int fortId = this.getFort() != null ? this.getFort().getResidenceId() : -1;
        return dominionId == castleId || dominionId == fortId;
    }

    public final SiegableHall getConquerableHall() {
        return ClanHallSiegeManager.getInstance().getNearbyClanHall(this.getX(), this.getY(), 10000);
    }

    public final Castle getCastle(long maxDistance) {
        int index = CastleManager.getInstance().findNearestCastleIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(index);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            Fort fort = FortManager.getInstance().getFort(this.getX(), this.getY(), this.getZ());
            if (fort != null) {
                this._fortIndex = FortManager.getInstance().getFortIndex(fort.getResidenceId());
            }
            if (this._fortIndex < 0) {
                this._fortIndex = FortManager.getInstance().findNearestFortIndex(this);
            }
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public final Fort getFort(long maxDistance) {
        int index = FortManager.getInstance().findNearestFortIndex(this, maxDistance);
        if (index < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(index);
    }

    public final boolean getIsInTown() {
        if (this._castleIndex < 0) {
            this.getCastle();
        }
        return this._isInTown;
    }

    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.isBusy() && this.getBusyMessage().length() > 0) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/npcbusy.htm");
            html.replace("%busymessage%", this.getBusyMessage());
            html.replace("%npcname%", this.getName());
            html.replace("%playername%", player.getName());
            player.sendPacket(html);
        } else {
            IBypassHandler handler = BypassHandler.getInstance().getHandler(command);
            if (handler != null) {
                handler.useBypass(command, player, this);
            } else {
                LOG.info("Unknown NPC bypass: \"{}\" NpcId: {}", (Object)command, (Object)this.getId());
            }
        }
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        int weaponId = this.getTemplate().getRHandId();
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().getRHandId());
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        int weaponId = this.getTemplate().getLHandId();
        if (weaponId < 1) {
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getTemplate().getLHandId());
        if (!(item instanceof L2Weapon)) {
            return null;
        }
        return (L2Weapon)item;
    }

    public void insertObjectIdAndShowChatWindow(L2PcInstance player, String content) {
        content = content.replaceAll("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(new NpcHtmlMessage(this.getObjectId(), content));
    }

    public String getHtmlPath(int npcId, int val) {
        Object pom = "";
        pom = val == 0 ? "" + npcId : npcId + "-" + val;
        String temp = "data/html/default/" + (String)pom + ".htm";
        if (!Configuration.general().lazyCache() ? HtmCache.getInstance().contains(temp) : HtmCache.getInstance().isLoadable(temp)) {
            return temp;
        }
        return "data/html/npcdefault.htm";
    }

    public void showChatWindow(L2PcInstance player) {
        this.showChatWindow(player, 0);
    }

    private boolean showPkDenyChatWindow(L2PcInstance player, String type) {
        String html = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/" + type + "/" + this.getId() + "-pk.htm");
        if (html != null) {
            this.insertObjectIdAndShowChatWindow(player, html);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return false;
    }

    public void showChatWindow(L2PcInstance player, int val) {
        if (!this.isTalking()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!(!player.isCursedWeaponEquipped() || player.getTarget() instanceof L2ClanHallManagerInstance && player.getTarget() instanceof L2DoormenInstance)) {
            player.setTarget(player);
            return;
        }
        if (player.getKarma() > 0 && (!Configuration.character().karmaPlayerCanShop() && this instanceof L2MerchantInstance ? this.showPkDenyChatWindow(player, "merchant") : (!Configuration.character().karmaPlayerCanUseGK() && this instanceof L2TeleporterInstance ? this.showPkDenyChatWindow(player, "teleporter") : !Configuration.character().karmaPlayerCanUseWareHouse() && this instanceof L2WarehouseInstance && this.showPkDenyChatWindow(player, "warehouse")))) {
            return;
        }
        if (this.getTemplate().isType("L2Auctioneer") && val == 0) {
            return;
        }
        int npcId = this.getTemplate().getId();
        Object filename = "data/html/seven_signs/";
        switch (npcId) {
            case 31127: 
            case 31128: 
            case 31129: 
            case 31130: 
            case 31131: {
                filename = (String)filename + "festival/dawn_guide.htm";
                break;
            }
            case 31137: 
            case 31138: 
            case 31139: 
            case 31140: 
            case 31141: {
                filename = (String)filename + "festival/dusk_guide.htm";
                break;
            }
            case 31132: 
            case 31133: 
            case 31134: 
            case 31135: 
            case 31136: 
            case 31142: 
            case 31143: 
            case 31144: 
            case 31145: 
            case 31146: {
                filename = (String)filename + "festival/festival_witch.htm";
                break;
            }
            case 31688: {
                if (player.isNoble()) {
                    filename = "data/html/olympiad/noble_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 31690: 
            case 31769: 
            case 31770: 
            case 31771: 
            case 31772: {
                if (player.isHero() || player.isNoble()) {
                    filename = "data/html/olympiad/hero_main.htm";
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            case 36402: {
                if (player.getOlympiadBuffCount() > 0) {
                    filename = player.getOlympiadBuffCount() == Configuration.olympiad().getMaxBuffs() ? "data/html/olympiad/olympiad_buffs.htm" : "data/html/olympiad/olympiad_5buffs.htm";
                    break;
                }
                filename = "data/html/olympiad/olympiad_nobuffs.htm";
                break;
            }
            case 30298: {
                if (player.isAcademyMember()) {
                    filename = this.getHtmlPath(npcId, 1);
                    break;
                }
                filename = this.getHtmlPath(npcId, val);
                break;
            }
            default: {
                if (npcId >= 31093 && npcId <= 31094 || npcId >= 31172 && npcId <= 31201 || npcId >= 31239 && npcId <= 31254) {
                    return;
                }
                filename = this.getHtmlPath(npcId, val);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), (String)filename);
        if (this instanceof L2MerchantInstance && Configuration.npc().getPetRentNPCs().contains(npcId)) {
            html.replace("_Quest", "_RentPet\">Rent Pet</a><br><a action=\"bypass -h npc_%objectId%_Quest");
        }
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%festivalMins%", SevenSignsFestival.getInstance().getTimeToNextFestivalStr());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showChatWindow(L2PcInstance player, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public long getExpReward() {
        return (long)((double)(this.getLevel() * this.getLevel()) * this.getTemplate().getExpRate() * (double)Configuration.rates().getRateXp());
    }

    public int getSpReward() {
        return (int)(this.getTemplate().getSP() * (double)Configuration.rates().getRateSp());
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this._currentLHandId = this.getTemplate().getLHandId();
        this._currentRHandId = this.getTemplate().getRHandId();
        this._currentCollisionHeight = this.getTemplate().getfCollisionHeight();
        this._currentCollisionRadius = this.getTemplate().getfCollisionRadius();
        L2Weapon weapon = killer != null ? killer.getActiveWeaponItem() : null;
        this._killingBlowWeaponId = weapon != null ? weapon.getId() : 0;
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    public void setSpawn(L2Spawn spawn) {
        this._spawn = spawn;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._soulshotamount = this.getTemplate().getSoulShot();
        this._spiritshotamount = this.getTemplate().getSpiritShot();
        this._killingBlowWeaponId = 0;
        if (this.isTeleporting()) {
            EventDispatcher.getInstance().notifyEventAsync(new NpcTeleport(this), this);
        } else {
            WalkingManager.getInstance().onSpawn(this);
            EventDispatcher.getInstance().notifyEventAsync(new NpcSpawn(this), this);
        }
    }

    @Override
    public void onDecay() {
        if (this.isDecayed()) {
            return;
        }
        this.setDecayed(true);
        super.onDecay();
        if (this._spawn != null) {
            this._spawn.decreaseCount(this);
        }
        WalkingManager.getInstance().onDeath(this);
        L2Character summoner = this.getSummoner();
        if (summoner != null && summoner.isNpc()) {
            ((L2Npc)summoner).removeSummonedNpc(this.getObjectId());
        }
    }

    @Override
    public boolean deleteMe() {
        L2WorldRegion oldRegion;
        try {
            this.onDecay();
        }
        catch (Exception e) {
            LOG.error("Failed decayMe(). {}", e);
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        if ((oldRegion = this.getWorldRegion()) != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            LOG.error("Failed removing cleaning knownlist. {}", e);
        }
        L2World.getInstance().removeObject(this);
        return super.deleteMe();
    }

    public L2Spawn getSpawn() {
        return this._spawn;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName() + "(" + this.getId() + ")[" + this.getObjectId() + "]";
    }

    public boolean isDecayed() {
        return this._isDecayed;
    }

    public void setDecayed(boolean decayed) {
        this._isDecayed = decayed;
    }

    public void endDecayTask() {
        if (!this.isDecayed()) {
            DecayTaskManager.getInstance().cancel(this);
            this.onDecay();
        }
    }

    public boolean isMob() {
        return false;
    }

    public void setLHandId(int newWeaponId) {
        this._currentLHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setRHandId(int newWeaponId) {
        this._currentRHandId = newWeaponId;
        this.updateAbnormalEffect();
    }

    public void setLRHandId(int newLWeaponId, int newRWeaponId) {
        this._currentRHandId = newRWeaponId;
        this._currentLHandId = newLWeaponId;
        this.updateAbnormalEffect();
    }

    public void setEnchant(int newEnchantValue) {
        this._currentEnchant = newEnchantValue;
        this.updateAbnormalEffect();
    }

    public boolean isShowName() {
        return this.getTemplate().isShowName();
    }

    @Override
    public boolean isTargetable() {
        return this.getTemplate().isTargetable();
    }

    public void setCollisionHeight(double height) {
        this._currentCollisionHeight = height;
    }

    public void setCollisionRadius(double radius) {
        this._currentCollisionRadius = radius;
    }

    public double getCollisionHeight() {
        return this._currentCollisionHeight;
    }

    public double getCollisionRadius() {
        return this._currentCollisionRadius;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this.isVisibleFor(activeChar)) {
            if (Configuration.general().checkKnownList() && activeChar.isGM()) {
                activeChar.sendMessage("Added NPC: " + this.getName());
            }
            if (this.getRunSpeed() == 0.0) {
                activeChar.sendPacket(new ServerObjectInfo(this, activeChar));
            } else {
                activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
            }
        }
    }

    public L2Npc scheduleDespawn(long delay) {
        ThreadPoolManager.getInstance().scheduleGeneral(() -> {
            if (!this.isDecayed()) {
                this.deleteMe();
            }
        }, delay);
        return this;
    }

    @Override
    protected final void notifyQuestEventSkillFinished(Skill skill, L2Object target) {
        if (target != null && target.isPlayable()) {
            EventDispatcher.getInstance().notifyEventAsync(new NpcSkillFinished(this, target.getActingPlayer(), skill), this);
        }
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || !this.canMove() || this.getAiType().equals((Object)AIType.CORPSE);
    }

    public AIType getAiType() {
        return this.getTemplate().getAIType();
    }

    public void setDisplayEffect(int val) {
        if (val != this._displayEffect) {
            this._displayEffect = val;
            this.broadcastPacket(new ExChangeNpcState(this.getObjectId(), val));
        }
    }

    public int getDisplayEffect() {
        return this._displayEffect;
    }

    public int getColorEffect() {
        return 0;
    }

    @Override
    public boolean isNpc() {
        return true;
    }

    @Override
    public void setTeam(Team team) {
        super.setTeam(team);
        this.broadcastInfo();
    }

    @Override
    public boolean isWalker() {
        return WalkingManager.getInstance().isRegistered(this);
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        return (this._shotsMask & type.getMask()) == type.getMask();
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        this._shotsMask = charged ? (this._shotsMask |= type.getMask()) : (this._shotsMask &= ~type.getMask());
    }

    @Override
    public void rechargeShots(boolean physical, boolean magic) {
        if (this._soulshotamount > 0 || this._spiritshotamount > 0) {
            if (physical) {
                if (this._soulshotamount == 0) {
                    return;
                }
                if (Rnd.get((int)100) > this.getSoulShotChance()) {
                    return;
                }
                --this._soulshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2154, 1, 0, 0), 600);
                this.setChargedShot(ShotType.SOULSHOTS, true);
            }
            if (magic) {
                if (this._spiritshotamount == 0) {
                    return;
                }
                if (Rnd.get((int)100) > this.getSpiritShotChance()) {
                    return;
                }
                --this._spiritshotamount;
                Broadcast.toSelfAndKnownPlayersInRadius(this, new MagicSkillUse(this, this, 2061, 1, 0, 0), 600);
                this.setChargedShot(ShotType.SPIRITSHOTS, true);
            }
        }
    }

    public int getScriptValue() {
        return this.getVariables().getInt("SCRIPT_VAL");
    }

    public void setScriptValue(int val) {
        this.getVariables().set("SCRIPT_VAL", val);
    }

    public boolean isScriptValue(int val) {
        return this.getVariables().getInt("SCRIPT_VAL") == val;
    }

    public int getAIValue(String paramName) {
        if (this.getSpawn() == null || this.getSpawn().getName() == null) {
            return -1;
        }
        return NpcPersonalAIData.getInstance().getAIValue(this.getSpawn().getName(), paramName);
    }

    public boolean hasAIValue(String paramName) {
        return this.getSpawn() != null && this.getSpawn().getName() != null && NpcPersonalAIData.getInstance().hasAIValue(this.getSpawn().getName(), paramName);
    }

    public boolean isInMySpawnGroup(L2Npc npc) {
        return this.getSpawn() != null && npc.getSpawn() != null && this.getSpawn().getName() != null && this.getSpawn().getName().equals(npc.getSpawn().getName());
    }

    public boolean staysInSpawnLoc() {
        return this.getSpawn() != null && this.getSpawn().getX(this) == this.getX() && this.getSpawn().getY(this) == this.getY();
    }

    public boolean hasVariables() {
        return this.getScript(NpcVariables.class) != null;
    }

    public NpcVariables getVariables() {
        NpcVariables vars = this.getScript(NpcVariables.class);
        return vars != null ? vars : this.addScript(new NpcVariables());
    }

    public void broadcastScriptEvent(String eventName, int radius) {
        this.broadcastScriptEvent(eventName, radius, null, 0, 0);
    }

    public void broadcastScriptEvent(String eventName, int radius, L2Object reference) {
        this.broadcastScriptEvent(eventName, radius, reference, 0, 0);
    }

    public void broadcastScriptEvent(String eventName, int radius, int arg1) {
        this.broadcastScriptEvent(eventName, radius, null, arg1, 0);
    }

    public void broadcastScriptEvent(String eventName, int radius, L2Object reference, int arg1, int arg2) {
        for (L2Object obj : L2World.getInstance().getVisibleObjects(this, radius)) {
            L2Npc npc;
            if (!(obj instanceof L2Npc) || !(npc = (L2Npc)obj).hasListener(EventType.NPC_EVENT_RECEIVED)) continue;
            EventDispatcher.getInstance().notifyEventAsync(new NpcEventReceived(eventName, this, npc, reference, arg1, arg2), npc);
        }
    }

    public void sendScriptEvent(String eventName, L2Object receiver, L2Object reference) {
        EventDispatcher.getInstance().notifyEventAsync(new NpcEventReceived(eventName, this, (L2Npc)receiver, reference, 0, 0), receiver);
    }

    public Location getPointInRange(int radiusMin, int radiusMax) {
        if (radiusMax == 0 || radiusMax < radiusMin) {
            return new Location(this.getX(), this.getY(), this.getZ());
        }
        int radius = Rnd.get((int)radiusMin, (int)radiusMax);
        double angle = Rnd.nextDouble() * 2.0 * Math.PI;
        return new Location((int)((double)this.getX() + (double)radius * Math.cos(angle)), (int)((double)this.getY() + (double)radius * Math.sin(angle)), this.getZ());
    }

    public L2ItemInstance dropItem(L2PcInstance player, int itemId, long itemCount) {
        L2ItemInstance item = null;
        int i = 0;
        while ((long)i < itemCount) {
            int newX = this.getX() + Rnd.get((int)141) - 70;
            int newY = this.getY() + Rnd.get((int)141) - 70;
            int newZ = this.getZ() + 20;
            if (ItemTable.getInstance().getTemplate(itemId) == null) {
                LOG.error("Item doesn't exist so cannot be dropped. Item ID: {} Quest: {}", (Object)itemId, (Object)this.getName());
                return null;
            }
            item = ItemTable.getInstance().createItem("Loot", itemId, itemCount, player, this);
            if (item == null) {
                return null;
            }
            if (player != null) {
                item.getDropProtection().protect(player);
            }
            item.dropMe(this, newX, newY, newZ);
            if (!Configuration.general().getProtectedItems().contains(itemId) && (Configuration.general().getAutoDestroyDroppedItemAfter() > 0 && !item.getItem().hasExImmediateEffect() || Configuration.general().getAutoDestroyHerbTime() > 0L && item.getItem().hasExImmediateEffect())) {
                ItemsAutoDestroy.getInstance().addItem(item);
            }
            item.setProtected(false);
            if (item.isStackable() || !Configuration.general().multipleItemDrop()) break;
            ++i;
        }
        return item;
    }

    public L2ItemInstance dropItem(L2PcInstance player, ItemHolder item) {
        return this.dropItem(player, item.getId(), item.getCount());
    }

    @Override
    public final String getName() {
        return this.getTemplate().getName();
    }

    @Override
    public boolean isVisibleFor(L2Character character) {
        TerminateReturn term;
        if (this.hasListener(EventType.NPC_CAN_BE_SEEN) && (term = EventDispatcher.getInstance().notifyEvent(new NpcCanBeSeen(this, character), this, TerminateReturn.class)) != null) {
            return term.terminate();
        }
        return super.isVisibleFor(character);
    }

    public void setTalking(boolean val) {
        this._isTalking = val;
    }

    public boolean isTalking() {
        return this._isTalking;
    }

    public void setKillingBlowWeapon(int weaponId) {
        this._killingBlowWeaponId = weaponId;
    }

    public int getKillingBlowWeapon() {
        return this._killingBlowWeaponId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSummonedNpc(L2Npc npc) {
        if (this._summonedNpcs == null) {
            L2Npc l2Npc = this;
            synchronized (l2Npc) {
                if (this._summonedNpcs == null) {
                    this._summonedNpcs = new ConcurrentHashMap<Integer, L2Npc>();
                }
            }
        }
        this._summonedNpcs.put(npc.getObjectId(), npc);
        npc.setSummoner(this);
    }

    public final void removeSummonedNpc(int objectId) {
        if (this._summonedNpcs != null) {
            this._summonedNpcs.remove(objectId);
        }
    }

    public final Collection<L2Npc> getSummonedNpcs() {
        return this._summonedNpcs != null ? this._summonedNpcs.values() : Collections.emptyList();
    }

    public final L2Npc getSummonedNpc(int objectId) {
        if (this._summonedNpcs != null) {
            return this._summonedNpcs.get(objectId);
        }
        return null;
    }

    public final int getSummonedNpcCount() {
        return this._summonedNpcs != null ? this._summonedNpcs.size() : 0;
    }

    public final void resetSummonedNpcs() {
        if (this._summonedNpcs != null) {
            this._summonedNpcs.clear();
        }
    }

    protected static class RandomAnimationTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(RandomAnimationTask.class);
        private final L2Npc _npc;

        protected RandomAnimationTask(L2Npc npc) {
            this._npc = npc;
        }

        @Override
        public void run() {
            try {
                if (this._npc.isMob() ? this._npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_ACTIVE : !this._npc.isInActiveRegion()) {
                    return;
                }
                if (!(this._npc.isDead() || this._npc.isStunned() || this._npc.isSleeping())) {
                    this._npc.onRandomAnimation(Rnd.get((int)2, (int)3));
                }
                this._npc.startRandomAnimationTimer();
            }
            catch (Exception e) {
                LOG.error("There has been an error trying to perform a random animation for NPC {}!", (Object)this._npc, (Object)e);
            }
        }
    }
}

