/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2DoormenInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Evolve;
import java.util.Arrays;
import java.util.StringTokenizer;

public class L2ClanHallDoormenInstance
extends L2DoormenInstance {
    private volatile boolean _init = false;
    private ClanHall _clanHall = null;
    private boolean _hasEvolve = false;
    private static final int[] CH_WITH_EVOLVE = new int[]{36, 37, 38, 39, 40, 41, 51, 52, 53, 54, 55, 56, 57};

    public L2ClanHallDoormenInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ClanHallDoormenInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this._hasEvolve && command.startsWith("evolve") && this.isOwnerClan(player)) {
            StringTokenizer st = new StringTokenizer(command, " ");
            if (st.countTokens() < 2) {
                return;
            }
            st.nextToken();
            boolean ok = switch (Integer.parseInt(st.nextToken())) {
                case 1 -> Evolve.doEvolve(player, this, 9882, 10307, 55);
                case 2 -> Evolve.doEvolve(player, this, 4422, 10308, 55);
                case 3 -> Evolve.doEvolve(player, this, 4423, 10309, 55);
                case 4 -> Evolve.doEvolve(player, this, 4424, 10310, 55);
                case 5 -> Evolve.doEvolve(player, this, 10426, 10611, 70);
                default -> false;
            };
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (ok) {
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/evolve-ok.htm");
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/evolve-no.htm");
            }
            player.sendPacket(html);
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (this.getClanHall() != null) {
            L2Clan owner = ClanTable.getInstance().getClan(this.getClanHall().getOwnerId());
            if (this.isOwnerClan(player)) {
                if (this._hasEvolve) {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/doormen2.htm");
                    html.replace("%clanname%", owner.getName());
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/doormen1.htm");
                    html.replace("%clanname%", owner.getName());
                }
            } else if (owner != null && owner.getLeader() != null) {
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/doormen-no.htm");
                html.replace("%leadername%", owner.getLeaderName());
                html.replace("%clanname%", owner.getName());
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/emptyowner.htm");
                html.replace("%hallname%", this.getClanHall().getName());
            }
        } else {
            return;
        }
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    @Override
    protected final void openDoors(L2PcInstance player, String command) {
        this.getClanHall().openCloseDoors(true);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/doormen-opened.htm");
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    @Override
    protected final void closeDoors(L2PcInstance player, String command) {
        this.getClanHall().openCloseDoors(false);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/clanHallDoormen/doormen-closed.htm");
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClanHall getClanHall() {
        if (!this._init) {
            L2ClanHallDoormenInstance l2ClanHallDoormenInstance = this;
            synchronized (l2ClanHallDoormenInstance) {
                if (!this._init) {
                    this._clanHall = ClanHallManager.getInstance().getNearbyClanHall(this.getX(), this.getY(), 500);
                    if (this._clanHall != null) {
                        this._hasEvolve = Arrays.binarySearch(CH_WITH_EVOLVE, this._clanHall.getId()) >= 0;
                    }
                    this._init = true;
                }
            }
        }
        return this._clanHall;
    }

    @Override
    protected final boolean isOwnerClan(L2PcInstance player) {
        if (player.getClan() != null && this.getClanHall() != null) {
            return player.getClanId() == this.getClanHall().getOwnerId();
        }
        return false;
    }
}

