/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.ControllableAirShipStat;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.concurrent.Future;

public class L2ControllableAirShipInstance
extends L2AirShipInstance {
    private static final int HELM = 13556;
    private static final int LOW_FUEL = 40;
    private int _fuel = 0;
    private int _maxFuel = 0;
    private final int _ownerId;
    private int _helmId;
    private L2PcInstance _captain = null;
    private Future<?> _consumeFuelTask;
    private Future<?> _checkTask;

    public L2ControllableAirShipInstance(int objectId, L2CharTemplate template, int ownerId) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ControllableAirShipInstance);
        this._ownerId = ownerId;
        this._helmId = IdFactory.getInstance().getNextId();
    }

    @Override
    public ControllableAirShipStat getStat() {
        return (ControllableAirShipStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new ControllableAirShipStat(this));
    }

    @Override
    public boolean canBeControlled() {
        return super.canBeControlled() && !this.isInDock();
    }

    @Override
    public boolean isOwner(L2PcInstance player) {
        if (this._ownerId == 0) {
            return false;
        }
        return player.getClanId() == this._ownerId || player.getObjectId() == this._ownerId;
    }

    @Override
    public int getOwnerId() {
        return this._ownerId;
    }

    @Override
    public boolean isCaptain(L2PcInstance player) {
        return this._captain != null && player == this._captain;
    }

    @Override
    public int getCaptainId() {
        return this._captain != null ? this._captain.getObjectId() : 0;
    }

    @Override
    public int getHelmObjectId() {
        return this._helmId;
    }

    @Override
    public int getHelmItemId() {
        return 13556;
    }

    @Override
    public boolean setCaptain(L2PcInstance player) {
        if (player == null) {
            this._captain = null;
        } else if (this._captain == null && player.getAirShip() == this) {
            int z;
            int y;
            int x = player.getInVehiclePosition().getX() - 366;
            if (x * x + (y = player.getInVehiclePosition().getY()) * y + (z = player.getInVehiclePosition().getZ() - 107) * z > 2500) {
                player.sendPacket(SystemMessageId.CANT_CONTROL_TOO_FAR);
                return false;
            }
            if (player.isInCombat()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_BATTLE);
                return false;
            }
            if (player.isSitting()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_SITTING_POSITION);
                return false;
            }
            if (player.isStunned()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_YOU_ARE_PETRIFIED);
                return false;
            }
            if (player.isCursedWeaponEquipped()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_A_CURSED_WEAPON_IS_EQUIPPED);
                return false;
            }
            if (player.isFishing()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_FISHING);
                return false;
            }
            if (player.isDead() || player.isFakeDeath()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHEN_YOU_ARE_DEAD);
                return false;
            }
            if (player.isCastingNow()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_USING_A_SKILL);
                return false;
            }
            if (player.isTransformed()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_TRANSFORMED);
                return false;
            }
            if (player.isCombatFlagEquipped()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_HOLDING_A_FLAG);
                return false;
            }
            if (player.isInDuel()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_DUEL);
                return false;
            }
            this._captain = player;
            player.broadcastUserInfo();
        } else {
            return false;
        }
        this.updateAbnormalEffect();
        return true;
    }

    @Override
    public int getFuel() {
        return this._fuel;
    }

    @Override
    public void setFuel(int f) {
        int old = this._fuel;
        this._fuel = Math.min(Math.max(f, 0), this._maxFuel);
        if (this._fuel == 0 && old > 0) {
            this.broadcastToPassengers(SystemMessage.getSystemMessage(SystemMessageId.THE_AIRSHIP_FUEL_RUN_OUT));
        } else if (this._fuel < 40) {
            this.broadcastToPassengers(SystemMessage.getSystemMessage(SystemMessageId.THE_AIRSHIP_FUEL_SOON_RUN_OUT));
        }
    }

    @Override
    public int getMaxFuel() {
        return this._maxFuel;
    }

    @Override
    public void setMaxFuel(int mf) {
        this._maxFuel = mf;
    }

    @Override
    public void oustPlayer(L2PcInstance player) {
        if (player == this._captain) {
            this.setCaptain(null);
        }
        super.oustPlayer(player);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._checkTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckTask(), 60000L, 10000L);
        this._consumeFuelTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ConsumeFuelTask(), 60000L, 60000L);
    }

    @Override
    public boolean deleteMe() {
        if (!super.deleteMe()) {
            return false;
        }
        if (this._checkTask != null) {
            this._checkTask.cancel(false);
            this._checkTask = null;
        }
        if (this._consumeFuelTask != null) {
            this._consumeFuelTask.cancel(false);
            this._consumeFuelTask = null;
        }
        this.broadcastPacket(new DeleteObject(this._helmId));
        return true;
    }

    @Override
    public void refreshID() {
        super.refreshID();
        IdFactory.getInstance().releaseId(this._helmId);
        this._helmId = IdFactory.getInstance().getNextId();
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        super.sendInfo(activeChar);
        if (this._captain != null) {
            this._captain.sendInfo(activeChar);
        }
    }

    protected final class CheckTask
    implements Runnable {
        protected CheckTask() {
        }

        @Override
        public void run() {
            if (L2ControllableAirShipInstance.this.isVisible() && L2ControllableAirShipInstance.this.isEmpty() && !L2ControllableAirShipInstance.this.isInDock()) {
                ThreadPoolManager.getInstance().executeGeneral(new DecayTask());
            }
        }
    }

    protected final class ConsumeFuelTask
    implements Runnable {
        protected ConsumeFuelTask() {
        }

        @Override
        public void run() {
            int fuel = L2ControllableAirShipInstance.this.getFuel();
            if (fuel > 0) {
                if ((fuel -= 10) < 0) {
                    fuel = 0;
                }
                L2ControllableAirShipInstance.this.setFuel(fuel);
                L2ControllableAirShipInstance.this.updateAbnormalEffect();
            }
        }
    }

    protected final class DecayTask
    implements Runnable {
        protected DecayTask() {
        }

        @Override
        public void run() {
            L2ControllableAirShipInstance.this.deleteMe();
        }
    }
}

