/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.data.xml.impl.BuyListData;
import com.l2jserver.gameserver.datatables.MerchantPriceConfigTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.BuyList;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2MerchantInstance
extends L2NpcInstance {
    private static final Logger LOG = LoggerFactory.getLogger(L2MerchantInstance.class);
    private MerchantPriceConfigTable.MerchantPriceConfig _mpc;

    public L2MerchantInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2MerchantInstance);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._mpc = MerchantPriceConfigTable.getInstance().getMerchantPriceConfig(this);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        String pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/merchant/" + pom + ".htm";
    }

    public MerchantPriceConfigTable.MerchantPriceConfig getMpc() {
        return this._mpc;
    }

    public final void showBuyWindow(L2PcInstance player, int val) {
        this.showBuyWindow(player, val, true);
    }

    public final void showBuyWindow(L2PcInstance player, int val, boolean applyTax) {
        L2BuyList buyList = BuyListData.getInstance().getBuyList(val);
        if (buyList == null) {
            LOG.warn("BuyList not found! BuyListId: {}", (Object)val);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!buyList.isNpcAllowed(this.getId())) {
            LOG.warn("Npc not allowed in BuyList! BuyListId: {} NpcId: {}", (Object)val, (Object)this.getId());
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        double taxRate = applyTax ? this.getMpc().getTotalTaxRate() : 0.0;
        player.setInventoryBlockingStatus(true);
        if (player.isGM()) {
            player.sendMessage("Buy List [" + buyList.getListId() + "]");
        }
        player.sendPacket(new BuyList(buyList, player.getAdena(), taxRate));
        player.sendPacket(new ExBuySellList(player, false));
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

