/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.agathion.Agathion;
import com.l2jserver.gameserver.agathion.repository.AgathionRepository;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.bbs.model.Forum;
import com.l2jserver.gameserver.bbs.model.ForumType;
import com.l2jserver.gameserver.bbs.model.ForumVisibility;
import com.l2jserver.gameserver.bbs.service.ForumsBBSManager;
import com.l2jserver.gameserver.cache.WarehouseCacheManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.sql.impl.CharSummonTable;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.data.xml.impl.FishData;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.data.xml.impl.PlayerTemplateData;
import com.l2jserver.gameserver.data.xml.impl.PlayerXpPercentLostData;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.DuelState;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.enums.PartyDistributionType;
import com.l2jserver.gameserver.enums.PlayerAction;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.ShortcutType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.enums.audio.Music;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2ContactList;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2PremiumItem;
import com.l2jserver.gameserver.model.L2Radar;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2Request;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroList;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.ShortCuts;
import com.l2jserver.gameserver.model.Shortcut;
import com.l2jserver.gameserver.model.TeleportBookmark;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.TerritoryWard;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.UIKeysSettings;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.appearance.PcAppearance;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ControlTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TamedBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PcKnownList;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.status.PcStatus;
import com.l2jserver.gameserver.model.actor.tasks.player.DismountTask;
import com.l2jserver.gameserver.model.actor.tasks.player.FameTask;
import com.l2jserver.gameserver.model.actor.tasks.player.GameGuardCheckTask;
import com.l2jserver.gameserver.model.actor.tasks.player.InventoryEnableTask;
import com.l2jserver.gameserver.model.actor.tasks.player.LookingForFishTask;
import com.l2jserver.gameserver.model.actor.tasks.player.PetFeedTask;
import com.l2jserver.gameserver.model.actor.tasks.player.PvPFlagTask;
import com.l2jserver.gameserver.model.actor.tasks.player.RentPetTask;
import com.l2jserver.gameserver.model.actor.tasks.player.ResetChargesTask;
import com.l2jserver.gameserver.model.actor.tasks.player.ResetSoulsTask;
import com.l2jserver.gameserver.model.actor.tasks.player.SitDownTask;
import com.l2jserver.gameserver.model.actor.tasks.player.StandUpTask;
import com.l2jserver.gameserver.model.actor.tasks.player.TeleportWatchdogTask;
import com.l2jserver.gameserver.model.actor.tasks.player.VitalityTask;
import com.l2jserver.gameserver.model.actor.tasks.player.WarnUserTakeBreakTask;
import com.l2jserver.gameserver.model.actor.tasks.player.WaterTask;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.actor.transform.Transform;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.ClassLevel;
import com.l2jserver.gameserver.model.base.PlayerClass;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Duel;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.HuntingSystem;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.RecommendationSystem;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerEquipItem;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerFameChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerHennaRemove;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerKarmaChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLevelChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLogin;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLogout;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPKChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionCancel;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionChange;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPvPChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPvPKill;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSit;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerStand;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTransform;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.fishing.L2Fish;
import com.l2jserver.gameserver.model.fishing.L2Fishing;
import com.l2jserver.gameserver.model.holders.AdditionalSkillHolder;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.PlayerEventHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.holders.SkillUseHolder;
import com.l2jserver.gameserver.model.interfaces.IEventListener;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcFreight;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.itemcontainer.PcRefund;
import com.l2jserver.gameserver.model.itemcontainer.PcWarehouse;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Henna;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.ActionType;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.TargetType;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.variables.AccountVariables;
import com.l2jserver.gameserver.model.variables.PlayerVariables;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.ExBR_AgathionEnergyInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExDominionWarStart;
import com.l2jserver.gameserver.network.serverpackets.ExDuelUpdateUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExFishingEnd;
import com.l2jserver.gameserver.network.serverpackets.ExFishingStart;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMode;
import com.l2jserver.gameserver.network.serverpackets.ExPrivateStoreSetWholeMsg;
import com.l2jserver.gameserver.network.serverpackets.ExSetCompassZoneCode;
import com.l2jserver.gameserver.network.serverpackets.ExStartScenePlayer;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.FriendStatusPacket;
import com.l2jserver.gameserver.network.serverpackets.GameGuardQuery;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.LeaveWorld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NicknameChanged;
import com.l2jserver.gameserver.network.serverpackets.ObservationMode;
import com.l2jserver.gameserver.network.serverpackets.ObservationReturn;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDelete;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgSell;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopMsg;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopSellList;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.Ride;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SkillList;
import com.l2jserver.gameserver.network.serverpackets.Snoop;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TargetSelected;
import com.l2jserver.gameserver.network.serverpackets.TargetUnselected;
import com.l2jserver.gameserver.network.serverpackets.TradeDone;
import com.l2jserver.gameserver.network.serverpackets.TradeOtherDone;
import com.l2jserver.gameserver.network.serverpackets.TradeStart;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.EnumIntBitmask;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class L2PcInstance
extends L2Playable {
    public static final int ID_NONE = -1;
    public static final int REQUEST_TIMEOUT = 15;
    private static final Logger LOG = LoggerFactory.getLogger(L2PcInstance.class);
    private static final String COND_OVERRIDE_KEY = "cond_override";
    private static final int FALLING_VALIDATION_DELAY = 10000;
    public final ReentrantLock soulShotLock = new ReentrantLock();
    private final Queue<IEventListener> _eventListeners = new ConcurrentLinkedQueue<IEventListener>();
    private final String _accountName;
    private final ReentrantLock _subclassLock = new ReentrantLock();
    private final PcAppearance _appearance;
    private final L2ContactList _contactList = new L2ContactList(this);
    private final Map<Integer, TeleportBookmark> _tpbookmarks = new ConcurrentHashMap<Integer, TeleportBookmark>();
    private final Map<Integer, L2RecipeList> _dwarvenRecipeBook = new ConcurrentHashMap<Integer, L2RecipeList>();
    private final Map<Integer, L2RecipeList> _commonRecipeBook = new ConcurrentHashMap<Integer, L2RecipeList>();
    private final Map<Integer, L2PremiumItem> _premiumItems = new ConcurrentHashMap<Integer, L2PremiumItem>();
    private final Location _lastLoc = new Location(0, 0, 0);
    private final Location _lastServerPosition = new Location(0, 0, 0);
    private final PcInventory _inventory = new PcInventory(this);
    private final PcFreight _freight = new PcFreight(this);
    private final Map<String, QuestState> _quests = new ConcurrentHashMap<String, QuestState>();
    private final ShortCuts _shortCuts = new ShortCuts(this);
    private final MacroList _macros = new MacroList(this);
    private final Set<L2PcInstance> _snoopListener = ConcurrentHashMap.newKeySet(1);
    private final Set<L2PcInstance> _snoopedPlayer = ConcurrentHashMap.newKeySet(1);
    private final L2Radar _radar;
    private final AtomicInteger _charges = new AtomicInteger();
    private final L2Request _request = new L2Request(this);
    private final Map<Integer, String> _chars = new LinkedHashMap<Integer, String>();
    private final Map<Integer, L2CubicInstance> _cubics = new ConcurrentSkipListMap<Integer, L2CubicInstance>();
    private final Set<Integer> _activeSoulShots = ConcurrentHashMap.newKeySet(1);
    private final int[] _loto = new int[5];
    private final int[] _race = new int[2];
    private final BlockList _blockList = new BlockList(this);
    private final int[] _htmlActionOriginObjectIds = new int[HtmlActionScope.values().length];
    private final LinkedList<String>[] _htmlActionCaches = new LinkedList[HtmlActionScope.values().length];
    private volatile Set<Integer> _friends;
    private PartyDistributionType _partyDistributionType;
    private L2GameClient _client;
    private long _deleteTimer;
    private Calendar _createDate = Calendar.getInstance();
    private String _lang = null;
    private String _htmlPrefix = null;
    private volatile boolean _isOnline = false;
    private long _onlineTime;
    private long _onlineBeginTime;
    private long _lastAccess;
    private long _uptime;
    private int _baseClass;
    private int _activeClass;
    private int _classIndex = 0;
    private int _controlItemId;
    private L2PetLevelData _leveldata;
    private int _curFeed;
    private Future<?> _mountFeedTask;
    private ScheduledFuture<?> _dismountTask;
    private boolean _petItems = false;
    private Map<Integer, SubClass> _subClasses;
    private long _expBeforeDeath;
    private int _karma;
    private int _pvpKills;
    private int _pkKills;
    private byte _pvpFlag;
    private int _fame;
    private ScheduledFuture<?> _fameTask;
    private ScheduledFuture<?> _vitalityTask;
    private volatile ScheduledFuture<?> _teleportWatchdog;
    private byte _siegeState = 0;
    private int _siegeSide = 0;
    private int _curWeightPenalty = 0;
    private int _lastCompassZone;
    private boolean _isIn7sDungeon = false;
    private int _bookmarkslot = 0;
    private boolean _canFeed;
    private boolean _isInSiege;
    private boolean _isInHideoutSiege = false;
    private boolean _inOlympiadMode = false;
    private boolean _OlympiadStart = false;
    private int _olympiadGameId = -1;
    private int _olympiadSide = -1;
    private int _olyBuffsCount = 0;
    private DuelState _duelState = DuelState.NO_DUEL;
    private int _duelId = 0;
    private L2Vehicle _vehicle = null;
    private Location _inVehiclePosition;
    private ScheduledFuture<?> _taskforfish;
    private MountType _mountType = MountType.NONE;
    private int _mountNpcId;
    private int _mountLevel;
    private int _mountObjectID = 0;
    private int _telemode = 0;
    private boolean _inCrystallize;
    private boolean _inCraftMode;
    private long _offlineShopStart = 0L;
    private Transform _transformation;
    private volatile Map<Integer, Skill> _transformSkills;
    private boolean _waitTypeSitting;
    private boolean _observerMode = false;
    private final HuntingSystem _huntingSystem = new HuntingSystem(this);
    private final RecommendationSystem _recSystem = new RecommendationSystem(this);
    private PcWarehouse _warehouse;
    private PcRefund _refund;
    private PrivateStoreType _privateStoreType = PrivateStoreType.NONE;
    private TradeList _activeTradeList;
    private ItemContainer _activeWarehouse;
    private volatile Map<Integer, L2ManufactureItem> _manufactureItems;
    private String _storeName = "";
    private TradeList _sellList;
    private TradeList _buyList;
    private PreparedListContainer _currentMultiSell = null;
    private int _newbie;
    private boolean _noble = false;
    private boolean _hero = false;
    private L2Npc _lastFolkNpc = null;
    private int _questNpcObject = 0;
    private L2Henna[] _henna = new L2Henna[3];
    private int _hennaSTR;
    private int _hennaINT;
    private int _hennaDEX;
    private int _hennaMEN;
    private int _hennaWIT;
    private int _hennaCON;
    private L2Summon _summon = null;
    private L2Decoy _decoy = null;
    private L2TrapInstance _trap = null;
    private int _agathionId = 0;
    private volatile Set<L2TamedBeastInstance> _tamedBeasts = null;
    private boolean _minimapAllowed = false;
    private int _partyroom = 0;
    private int _clanId;
    private L2Clan _clan;
    private int _apprentice = 0;
    private int _sponsor = 0;
    private long _clanJoinExpiryTime;
    private long _clanCreateExpiryTime;
    private int _powerGrade = 0;
    private volatile EnumIntBitmask<ClanPrivilege> _clanPrivileges = new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false);
    private int _pledgeClass = 0;
    private int _pledgeType = 0;
    private int _lvlJoinedAcademy = 0;
    private int _wantsPeace = 0;
    private int _deathPenaltyBuffLevel = 0;
    private volatile ScheduledFuture<?> _chargeTask = null;
    private int _souls = 0;
    private ScheduledFuture<?> _soulTask = null;
    private Location _currentSkillWorldPosition;
    private L2AccessLevel _accessLevel;
    private boolean _messageRefusal = false;
    private boolean _silenceMode = false;
    private List<Integer> _silenceModeExcluded;
    private boolean _dietMode = false;
    private boolean _tradeRefusal = false;
    private boolean _exchangeRefusal = false;
    private L2Party _party;
    private L2PcInstance _activeRequester;
    private long _requestExpireTime = 0L;
    private L2ItemInstance _arrowItem;
    private L2ItemInstance _boltItem;
    private long _protectEndTime = 0L;
    private L2ItemInstance _lure = null;
    private long _teleportProtectEndTime = 0L;
    private long _recentFakeDeathEndTime = 0L;
    private boolean _isFakeDeath;
    private L2Weapon _fistsWeaponItem;
    private int _expertiseArmorPenalty = 0;
    private int _expertiseWeaponPenalty = 0;
    private int _expertisePenaltyBonus = 0;
    private boolean _isEnchanting = false;
    private int _activeEnchantItemId = -1;
    private int _activeEnchantSupportItemId = -1;
    private int _activeEnchantAttrItemId = -1;
    private long _activeEnchantTimestamp = 0L;
    private boolean _inventoryDisable = false;
    private PlayerEventHolder eventStatus = null;
    private byte _handysBlockCheckerEventArena = (byte)-1;
    private L2Fishing _fishCombat;
    private boolean _fishing = false;
    private int _fishx = 0;
    private int _fishy = 0;
    private int _fishz = 0;
    private ScheduledFuture<?> _taskRentPet;
    private ScheduledFuture<?> _taskWater;
    private int _lastHtmlActionOriginObjId;
    private Forum _forumMail;
    private Forum _forumMemo;
    private SkillUseHolder _currentSkill;
    private SkillUseHolder _currentPetSkill;
    private SkillUseHolder _queuedSkill;
    private int _cursedWeaponEquippedId = 0;
    private boolean _combatFlagEquippedId = false;
    private boolean _canRevive = true;
    private int _reviveRequested = 0;
    private double _revivePower = 0.0;
    private int _reviveRecovery = 0;
    private boolean _revivePet = false;
    private double _cpUpdateIncCheck = 0.0;
    private double _cpUpdateDecCheck = 0.0;
    private double _cpUpdateInterval = 0.0;
    private double _mpUpdateIncCheck = 0.0;
    private double _mpUpdateDecCheck = 0.0;
    private double _mpUpdateInterval = 0.0;
    private int _clientX;
    private int _clientY;
    private int _clientZ;
    private int _clientHeading;
    private volatile long _fallingTimestamp = 0L;
    private int _multiSocialTarget = 0;
    private int _multiSociaAction = 0;
    private int _movieId = 0;
    private String _adminConfirmCmd = null;
    private volatile long _lastItemAuctionInfoRequest = 0L;
    private Future<?> _PvPRegTask;
    private long _pvpFlagLasts;
    private long _notMoveUntil = 0L;
    private Map<Integer, Skill> _customSkills = null;
    private volatile int _actionMask;
    private Map<Stats, Double> _servitorShare;
    private UIKeysSettings _uiKeySettings;
    private boolean _enableAutoLoot = false;
    private boolean _enableAutoLootItem = false;
    private boolean _enableAutoLootHerb = false;
    private boolean _married = false;
    private int _partnerId = 0;
    private int _coupleId = 0;
    private boolean _engagerequest = false;
    private int _engageid = 0;
    private boolean _marryrequest = false;
    private boolean _marryaccepted = false;
    private String _lastPetitionGmName = null;
    private boolean _hasCharmOfCourage = false;
    private volatile Set<QuestState> _notifyQuestOfDeathList;
    private ClassId _learningClass = this.getClassId();
    private ScheduledFuture<?> _taskWarnUserTakeBreak;
    private L2Fish _fish;

    public L2PcInstance(int objectId, int classId, String accountName, PcAppearance app) {
        super(objectId, PlayerTemplateData.getInstance().getTemplate(classId));
        this.setInstanceType(InstanceType.L2PcInstance);
        super.initCharStatusUpdateValues();
        this.initPcStatusUpdateValues();
        for (int i = 0; i < this._htmlActionCaches.length; ++i) {
            this._htmlActionCaches[i] = new LinkedList();
        }
        this._accountName = accountName;
        app.setOwner(this);
        this._appearance = app;
        this.getAI();
        this._radar = new L2Radar(this);
        this.startVitalityTask();
        Formulas.addFuncsToNewPlayer(this);
    }

    public static L2PcInstance create(int classId, String accountName, String name, PcAppearance app) {
        int objectId = IdFactory.getInstance().getNextId();
        L2PcInstance player = new L2PcInstance(objectId, classId, accountName, app);
        player.setName(name);
        player.setCreateDate(Calendar.getInstance());
        player.setBaseClass(player.getClassId());
        player.setNewbie(1);
        player.getRecSystem().setLeft(20);
        player.getRecSystem().setBonusTime(3600);
        return DAOFactory.getInstance().getPlayerDAO().insert(player) ? player : null;
    }

    public static L2PcInstance load(int objectId) {
        try {
            L2PcInstance player = DAOFactory.getInstance().getPlayerDAO().load(objectId);
            if (player == null) {
                return null;
            }
            DAOFactory.getInstance().getPlayerDAO().loadCharacters(player);
            player.getInventory().restore();
            player.getFreight().restore();
            if (!Configuration.general().warehouseCache()) {
                player.getWarehouse();
            }
            DAOFactory.getInstance().getSkillDAO().load(player);
            player._macros.restoreMe();
            player._shortCuts.restoreMe();
            DAOFactory.getInstance().getHennaDAO().load(player);
            DAOFactory.getInstance().getTeleportBookmarkDAO().load(player);
            DAOFactory.getInstance().getRecipeBookDAO().load(player, true);
            if (Configuration.character().storeRecipeShopList()) {
                DAOFactory.getInstance().getRecipeShopListDAO().load(player);
            }
            DAOFactory.getInstance().getPremiumItemDAO().load(player);
            DAOFactory.getInstance().getItemDAO().loadPetInventory(player);
            player.rewardSkills();
            DAOFactory.getInstance().getItemReuseDAO().load(player);
            if (Configuration.character().storeSkillCooltime()) {
                player.restoreEffects();
            }
            if (player.getCurrentHp() < 0.5) {
                player.setIsDead(true);
                player.stopHpMpRegeneration();
            }
            player.setPet(L2World.getInstance().getPet(player.getObjectId()));
            if (player.hasSummon()) {
                player.getSummon().setOwner(player);
            }
            player.refreshOverloaded();
            player.refreshExpertisePenalty();
            DAOFactory.getInstance().getFriendDAO().load(player);
            if (Configuration.character().storeUISettings()) {
                player.restoreUISettings();
            }
            if (player.isGM()) {
                long masks = player.getVariables().getLong(COND_OVERRIDE_KEY, PcCondOverride.getAllExceptionsMask());
                player.setOverrideCond(masks);
            }
            player.getRecSystem().startGiveTask();
            DAOFactory.getInstance().getRecommendationBonusDAO().load(player);
            return player;
        }
        catch (Exception e) {
            LOG.error("Failed loading character.", e);
            return null;
        }
    }

    public void restoreStatusFromLoadedValues() {
        this.setCurrentCp(this.getClient().getCharSelection().getCurrentCp());
        this.setCurrentHp(this.getClient().getCharSelection().getCurrentHp());
        this.setCurrentMp(this.getClient().getCharSelection().getCurrentMp());
    }

    public boolean isSpawnProtected() {
        return this._protectEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public boolean isTeleportProtected() {
        return this._teleportProtectEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public long getPvpFlagLasts() {
        return this._pvpFlagLasts;
    }

    public void setPvpFlagLasts(long time) {
        this._pvpFlagLasts = time;
    }

    public void startPvPFlag() {
        this.updatePvPFlag(1);
        if (this._PvPRegTask == null) {
            this._PvPRegTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PvPFlagTask(this), 1000L, 1000L);
        }
    }

    public void stopPvpRegTask() {
        if (this._PvPRegTask != null) {
            this._PvPRegTask.cancel(true);
            this._PvPRegTask = null;
        }
    }

    public void stopPvPFlag() {
        this.stopPvpRegTask();
        this.updatePvPFlag(0);
        this._PvPRegTask = null;
    }

    public String getAccountName() {
        if (this.getClient() == null) {
            return this.getAccountNamePlayer();
        }
        return this.getClient().getAccountName();
    }

    public String getAccountNamePlayer() {
        return this._accountName;
    }

    public Map<Integer, String> getAccountChars() {
        return this._chars;
    }

    public int getRelation(L2PcInstance target) {
        int result = 0;
        if (this.getClan() != null) {
            result |= 0x40;
            if (this.getClan() == target.getClan()) {
                result |= 0x100;
            }
            if (this.getAllyId() != 0) {
                result |= 0x10000;
            }
        }
        if (this.isClanLeader()) {
            result |= 0x80;
        }
        if (this.getParty() != null && this.getParty() == target.getParty()) {
            result |= 0x20;
            block11: for (int i = 0; i < this.getParty().getMembers().size(); ++i) {
                if (this.getParty().getMembers().get(i) != this) continue;
                switch (i) {
                    case 0: {
                        result |= 0x10;
                        continue block11;
                    }
                    case 1: {
                        result |= 8;
                        continue block11;
                    }
                    case 2: {
                        result |= 7;
                        continue block11;
                    }
                    case 3: {
                        result |= 6;
                        continue block11;
                    }
                    case 4: {
                        result |= 5;
                        continue block11;
                    }
                    case 5: {
                        result |= 4;
                        continue block11;
                    }
                    case 6: {
                        result |= 3;
                        continue block11;
                    }
                    case 7: {
                        result |= 2;
                        continue block11;
                    }
                    case 8: {
                        result |= 1;
                    }
                }
            }
        }
        if (this.getSiegeState() != 0) {
            if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(this) != 0) {
                result |= 0x80000;
            } else {
                result |= 0x200;
                result = this.getSiegeState() != target.getSiegeState() ? (result |= 0x1000) : (result |= 0x800);
                if (this.getSiegeState() == 1) {
                    result |= 0x400;
                }
            }
        }
        if (this.getClan() != null && target.getClan() != null && target.getPledgeType() != -1 && this.getPledgeType() != -1 && target.getClan().isAtWarWith(this.getClan().getId())) {
            result |= 0x8000;
            if (this.getClan().isAtWarWith(target.getClan().getId())) {
                result |= 0x4000;
            }
        }
        if (this.getBlockCheckerArena() != -1) {
            result |= 0x200;
            ArenaParticipantsHolder holder = HandysBlockCheckerManager.getInstance().getHolder(this.getBlockCheckerArena());
            result = holder.getPlayerTeam(this) == 0 ? (result |= 0x1000) : (result |= 0x800);
            result |= 0x400;
        }
        return result;
    }

    private void initPcStatusUpdateValues() {
        this._cpUpdateInterval = (double)this.getMaxCp() / 352.0;
        this._cpUpdateIncCheck = this.getMaxCp();
        this._cpUpdateDecCheck = (double)this.getMaxCp() - this._cpUpdateInterval;
        this._mpUpdateInterval = (double)this.getMaxMp() / 352.0;
        this._mpUpdateIncCheck = this.getMaxMp();
        this._mpUpdateDecCheck = (double)this.getMaxMp() - this._mpUpdateInterval;
    }

    @Override
    public PcKnownList getKnownList() {
        return (PcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new PcKnownList(this));
    }

    @Override
    public PcStat getStat() {
        return (PcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PcStat(this));
    }

    @Override
    public PcStatus getStatus() {
        return (PcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new PcStatus(this));
    }

    public PcAppearance getAppearance() {
        return this._appearance;
    }

    public L2PcTemplate getBaseTemplate() {
        return PlayerTemplateData.getInstance().getTemplate(this._baseClass);
    }

    @Override
    public L2PcTemplate getTemplate() {
        return (L2PcTemplate)super.getTemplate();
    }

    public void setTemplate(ClassId newclass) {
        super.setTemplate(PlayerTemplateData.getInstance().getTemplate(newclass));
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2PlayerAI(this);
    }

    @Override
    public int getLevel() {
        if (this.isSubClassActive()) {
            return this.getSubClasses().get(this.getClassIndex()).getStat().getLevel();
        }
        return this.getStat().getLevel();
    }

    public int getBaseLevel() {
        return this.getStat().getLevel();
    }

    public long getBaseExp() {
        return this.getStat().getExp();
    }

    public int getBaseSp() {
        return this.getStat().getSp();
    }

    @Override
    public double getLevelMod() {
        double levelMod;
        if (this.isTransformed() && (levelMod = this.getTransformation().getLevelMod(this)) > -1.0) {
            return levelMod;
        }
        return super.getLevelMod();
    }

    public int getNewbie() {
        return this._newbie;
    }

    public void setNewbie(int newbieRewards) {
        this._newbie = newbieRewards;
    }

    public void setBaseClass(int baseClass) {
        this._baseClass = baseClass;
    }

    public boolean isInStoreMode() {
        return this.getPrivateStoreType() != PrivateStoreType.NONE;
    }

    public boolean isInCraftMode() {
        return this._inCraftMode;
    }

    public void isInCraftMode(boolean b) {
        this._inCraftMode = b;
    }

    public void logout() {
        this.logout(true);
    }

    public void logout(boolean closeClient) {
        try {
            this.closeNetConnection(closeClient);
        }
        catch (Exception ex) {
            LOG.warn("Error trying to logout!", ex);
        }
    }

    public L2RecipeList[] getCommonRecipeBook() {
        return this._commonRecipeBook.values().toArray(new L2RecipeList[this._commonRecipeBook.size()]);
    }

    public L2RecipeList[] getDwarvenRecipeBook() {
        return this._dwarvenRecipeBook.values().toArray(new L2RecipeList[this._dwarvenRecipeBook.size()]);
    }

    public void registerCommonRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._commonRecipeBook.put(recipe.getId(), recipe);
        if (saveToDb) {
            DAOFactory.getInstance().getRecipeBookDAO().insert(this, recipe.getId(), false);
        }
    }

    public void registerDwarvenRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._dwarvenRecipeBook.put(recipe.getId(), recipe);
        if (saveToDb) {
            DAOFactory.getInstance().getRecipeBookDAO().insert(this, recipe.getId(), true);
        }
    }

    public boolean hasRecipeList(int recipeId) {
        return this._dwarvenRecipeBook.containsKey(recipeId) || this._commonRecipeBook.containsKey(recipeId);
    }

    public void unregisterRecipeList(int recipeId) {
        if (this._dwarvenRecipeBook.remove(recipeId) != null) {
            DAOFactory.getInstance().getRecipeBookDAO().delete(this, recipeId, true);
        } else if (this._commonRecipeBook.remove(recipeId) != null) {
            DAOFactory.getInstance().getRecipeBookDAO().delete(this, recipeId, false);
        } else {
            LOG.warn("Attempted to remove unknown RecipeList: {}", (Object)recipeId);
        }
        for (Shortcut sc : this.getAllShortCuts()) {
            if (sc == null || sc.getId() != recipeId || sc.getType() != ShortcutType.RECIPE) continue;
            this.deleteShortCut(sc.getSlot(), sc.getPage());
        }
    }

    public int getLastQuestNpcObject() {
        return this._questNpcObject;
    }

    public void setLastQuestNpcObject(int npcId) {
        this._questNpcObject = npcId;
    }

    public QuestState getQuestState(String quest) {
        return this._quests.get(quest);
    }

    public void setQuestState(QuestState qs) {
        this._quests.put(qs.getQuestName(), qs);
    }

    public boolean hasQuestState(String quest) {
        return this._quests.containsKey(quest);
    }

    public boolean hasQuestCompleted(String quest) {
        QuestState qs = this._quests.get(quest);
        return qs != null && qs.isCompleted();
    }

    public void delQuestState(String quest) {
        this._quests.remove(quest);
    }

    public List<Quest> getAllActiveQuests() {
        LinkedList<Quest> quests = new LinkedList<Quest>();
        for (QuestState qs : this._quests.values()) {
            int questId;
            if (qs == null || qs.getQuest() == null || !qs.isStarted() && !Configuration.general().developer() || (questId = qs.getQuest().getId()) > 19999 || questId < 1) continue;
            quests.add(qs.getQuest());
        }
        return quests;
    }

    public void processQuestEvent(String questName, String event) {
        L2Object object;
        Quest quest = QuestManager.getInstance().getQuest(questName);
        if (quest == null || event == null || event.isEmpty()) {
            return;
        }
        if (this.getLastQuestNpcObject() > 0 && (object = L2World.getInstance().findObject(this.getLastQuestNpcObject())).isNpc() && this.isInsideRadius(object, 150, false, false)) {
            L2Npc npc = (L2Npc)object;
            quest.notifyEvent(event, npc, this);
        }
    }

    public void addNotifyQuestOfDeath(QuestState qs) {
        if (qs == null) {
            return;
        }
        if (!this.getNotifyQuestOfDeath().contains(qs)) {
            this.getNotifyQuestOfDeath().add(qs);
        }
    }

    public void removeNotifyQuestOfDeath(QuestState qs) {
        if (qs == null || this._notifyQuestOfDeathList == null) {
            return;
        }
        this._notifyQuestOfDeathList.remove(qs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<QuestState> getNotifyQuestOfDeath() {
        if (this._notifyQuestOfDeathList == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._notifyQuestOfDeathList == null) {
                    this._notifyQuestOfDeathList = ConcurrentHashMap.newKeySet(1);
                }
            }
        }
        return this._notifyQuestOfDeathList;
    }

    public boolean isNotifyQuestOfDeathEmpty() {
        return this._notifyQuestOfDeathList == null || this._notifyQuestOfDeathList.isEmpty();
    }

    public Shortcut[] getAllShortCuts() {
        return this._shortCuts.getAllShortCuts();
    }

    public Shortcut getShortCut(int slot, int page) {
        return this._shortCuts.getShortCut(slot, page);
    }

    public void registerShortCut(Shortcut shortcut) {
        this._shortCuts.registerShortCut(shortcut);
    }

    public void updateShortCuts(int skillId, int skillLevel) {
        this._shortCuts.updateShortCuts(skillId, skillLevel);
    }

    public void deleteShortCut(int slot, int page) {
        this._shortCuts.deleteShortCut(slot, page);
    }

    public void registerMacro(Macro macro) {
        this._macros.registerMacro(macro);
    }

    public void deleteMacro(int id) {
        this._macros.deleteMacro(id);
    }

    public MacroList getMacros() {
        return this._macros;
    }

    @Override
    public byte getSiegeState() {
        return this._siegeState;
    }

    public void setSiegeState(byte siegeState) {
        this._siegeState = siegeState;
    }

    public boolean isRegisteredOnThisSiegeField(int val) {
        return this._siegeSide == val || this._siegeSide >= 81 && this._siegeSide <= 89;
    }

    @Override
    public int getSiegeSide() {
        return this._siegeSide;
    }

    public void setSiegeSide(int val) {
        this._siegeSide = val;
    }

    @Override
    public byte getPvpFlag() {
        return this._pvpFlag;
    }

    public void setPvpFlag(int pvpFlag) {
        this._pvpFlag = (byte)pvpFlag;
    }

    @Override
    public void updatePvPFlag(int value) {
        if (this.getPvpFlag() == value) {
            return;
        }
        this.setPvpFlag(value);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        if (this.hasSummon()) {
            this.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(this), false));
        }
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance target : plrs) {
            target.sendPacket(new RelationChanged(this, this.getRelation(target), this.isAutoAttackable(target)));
            if (!this.hasSummon()) continue;
            target.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(target), this.isAutoAttackable(target)));
        }
    }

    @Override
    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
        if (Configuration.general().allowWater()) {
            this.checkWaterState();
        }
        if (this.isInsideZone(ZoneId.ALTERED)) {
            if (this._lastCompassZone == 8) {
                return;
            }
            this._lastCompassZone = 8;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(8);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.SIEGE)) {
            if (this._lastCompassZone == 11) {
                return;
            }
            this._lastCompassZone = 11;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(11);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.PVP)) {
            if (this._lastCompassZone == 14) {
                return;
            }
            this._lastCompassZone = 14;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(14);
            this.sendPacket(cz);
        } else if (this.isIn7sDungeon()) {
            if (this._lastCompassZone == 13) {
                return;
            }
            this._lastCompassZone = 13;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(13);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.PEACE)) {
            if (this._lastCompassZone == 12) {
                return;
            }
            this._lastCompassZone = 12;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(12);
            this.sendPacket(cz);
        } else {
            if (this._lastCompassZone == 15) {
                return;
            }
            if (this._lastCompassZone == 11) {
                this.updatePvPStatus();
            }
            this._lastCompassZone = 15;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(15);
            this.sendPacket(cz);
        }
    }

    public boolean hasDwarvenCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_DWARVEN.getId()) >= 1;
    }

    public int getDwarvenCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_DWARVEN.getId());
    }

    public boolean hasCommonCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_COMMON.getId()) >= 1;
    }

    public int getCommonCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_COMMON.getId());
    }

    public boolean canCrystallize() {
        return this.getSkillLevel(CommonSkill.CRYSTALLIZE.getId()) >= 1;
    }

    public int getPkKills() {
        return this._pkKills;
    }

    public void setPkKills(int pkKills) {
        EventDispatcher.getInstance().notifyEventAsync(new PlayerPKChanged(this, this._pkKills, pkKills), this);
        this._pkKills = pkKills;
    }

    public long getDeleteTimer() {
        return this._deleteTimer;
    }

    public void setDeleteTimer(long deleteTimer) {
        this._deleteTimer = deleteTimer;
    }

    public long getExpBeforeDeath() {
        return this._expBeforeDeath;
    }

    public void setExpBeforeDeath(long exp) {
        this._expBeforeDeath = exp;
    }

    @Override
    public int getKarma() {
        return this._karma;
    }

    public void setKarma(int karma) {
        EventDispatcher.getInstance().notifyEventAsync(new PlayerKarmaChanged(this, this.getKarma(), karma), this);
        if (karma < 0) {
            karma = 0;
        }
        if (this._karma == 0 && karma > 0) {
            Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
            for (L2Object object : objs) {
                if (!(object instanceof L2GuardInstance) || ((L2GuardInstance)object).getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE) continue;
                ((L2GuardInstance)object).getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        } else if (this._karma > 0 && karma == 0) {
            this.setKarmaFlag(0);
        }
        this._karma = karma;
        this.broadcastKarma();
    }

    public int getExpertiseArmorPenalty() {
        return this._expertiseArmorPenalty;
    }

    public int getExpertiseWeaponPenalty() {
        return this._expertiseWeaponPenalty;
    }

    public int getExpertisePenaltyBonus() {
        return this._expertisePenaltyBonus;
    }

    public void setExpertisePenaltyBonus(int bonus) {
        this._expertisePenaltyBonus = bonus;
    }

    public int getWeightPenalty() {
        if (this._dietMode) {
            return 0;
        }
        return this._curWeightPenalty;
    }

    public void refreshOverloaded() {
        long weightproc;
        int newWeightPenalty;
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0 && this._curWeightPenalty != (newWeightPenalty = (weightproc = (long)(this.getCurrentLoad() - this.getBonusWeightPenalty()) * 1000L / (long)this.getMaxLoad()) < 500L || this._dietMode ? 0 : (weightproc < 666L ? 1 : (weightproc < 800L ? 2 : (weightproc < 1000L ? 3 : 4))))) {
            this._curWeightPenalty = newWeightPenalty;
            if (newWeightPenalty > 0 && !this._dietMode) {
                this.addSkill(SkillData.getInstance().getSkill(4270, newWeightPenalty));
                this.setIsOverloaded(this.getCurrentLoad() > maxLoad);
            } else {
                this.removeSkill(this.getKnownSkill(4270), false, true);
                this.setIsOverloaded(false);
            }
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new EtcStatusUpdate(this));
            this.broadcastPacket(new CharInfo(this));
            this.broadcastPacket(new ExBrExtraUserInfo(this));
        }
    }

    public void refreshExpertisePenalty() {
        if (!Configuration.character().expertisePenalty()) {
            return;
        }
        int expertiseLevel = this.getExpertiseLevel();
        int armorPenalty = 0;
        int weaponPenalty = 0;
        for (L2ItemInstance item : this.getInventory().getItems()) {
            int crystaltype;
            if (item == null || !item.isEquipped() || item.getItemType() == EtcItemType.ARROW || item.getItemType() == EtcItemType.BOLT || (crystaltype = item.getItem().getCrystalType().getId()) <= expertiseLevel) continue;
            if (item.isWeapon() && crystaltype > weaponPenalty) {
                weaponPenalty = crystaltype;
                continue;
            }
            if (crystaltype <= armorPenalty) continue;
            armorPenalty = crystaltype;
        }
        boolean changed = false;
        int bonus = this.getExpertisePenaltyBonus();
        weaponPenalty = weaponPenalty - expertiseLevel - bonus;
        weaponPenalty = Math.min(Math.max(weaponPenalty, 0), 4);
        if (this.getExpertiseWeaponPenalty() != weaponPenalty || this.getSkillLevel(CommonSkill.WEAPON_GRADE_PENALTY.getId()) != weaponPenalty) {
            this._expertiseWeaponPenalty = weaponPenalty;
            if (this._expertiseWeaponPenalty > 0) {
                this.addSkill(SkillData.getInstance().getSkill(CommonSkill.WEAPON_GRADE_PENALTY.getId(), this._expertiseWeaponPenalty));
            } else {
                this.removeSkill(this.getKnownSkill(CommonSkill.WEAPON_GRADE_PENALTY.getId()), false, true);
            }
            changed = true;
        }
        armorPenalty = armorPenalty - expertiseLevel - bonus;
        armorPenalty = Math.min(Math.max(armorPenalty, 0), 4);
        if (this.getExpertiseArmorPenalty() != armorPenalty || this.getSkillLevel(CommonSkill.ARMOR_GRADE_PENALTY.getId()) != armorPenalty) {
            this._expertiseArmorPenalty = armorPenalty;
            if (this._expertiseArmorPenalty > 0) {
                this.addSkill(SkillData.getInstance().getSkill(CommonSkill.ARMOR_GRADE_PENALTY.getId(), this._expertiseArmorPenalty));
            } else {
                this.removeSkill(this.getKnownSkill(CommonSkill.ARMOR_GRADE_PENALTY.getId()), false, true);
            }
            changed = true;
        }
        if (changed) {
            this.sendPacket(new EtcStatusUpdate(this));
        }
    }

    public void useEquippableItem(int objectId, boolean abortAttack) {
        Agathion agathionInfo;
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null) {
            return;
        }
        L2ItemInstance[] items = null;
        boolean isEquiped = item.isEquipped();
        int oldInvLimit = this.getInventoryLimit();
        SystemMessage sm = null;
        if (isEquiped) {
            if (item.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(item.getEnchantLevel());
                sm.addItemName(item);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(item);
            }
            this.sendPacket(sm);
            int slot = this.getInventory().getSlotFromItem(item);
            items = slot == 0x400000 ? this.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot()) : this.getInventory().unEquipItemInBodySlotAndRecord(slot);
        } else {
            items = this.getInventory().equipItemAndRecord(item);
            if (item.isEquipped()) {
                if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_S2_EQUIPPED);
                    sm.addInt(item.getEnchantLevel());
                    sm.addItemName(item);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
                    sm.addItemName(item);
                }
                this.sendPacket(sm);
                item.decreaseMana(false);
                if ((item.getItem().getBodyPart() & 0x4080) != 0) {
                    this.rechargeShots(true, true);
                }
            } else {
                this.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
            }
        }
        this.refreshExpertisePenalty();
        this.broadcastUserInfo();
        InventoryUpdate iu = new InventoryUpdate();
        iu.addItems(Arrays.asList(items));
        this.sendPacket(iu);
        if (abortAttack) {
            this.abortAttack();
        }
        if (this.getInventoryLimit() != oldInvLimit) {
            this.sendPacket(new ExStorageMaxCount(this));
        }
        if ((agathionInfo = AgathionRepository.getInstance().getByItemId(item.getId())) != null && agathionInfo.getMaxEnergy() > 0) {
            this.sendPacket(new ExBR_AgathionEnergyInfo(List.of(item)));
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerEquipItem(this, item), this);
    }

    public int getPvpKills() {
        return this._pvpKills;
    }

    public void setPvpKills(int pvpKills) {
        EventDispatcher.getInstance().notifyEventAsync(new PlayerPvPChanged(this, this._pvpKills, pvpKills), this);
        this._pvpKills = pvpKills;
    }

    public int getFame() {
        return this._fame;
    }

    public void setFame(int fame) {
        EventDispatcher.getInstance().notifyEventAsync(new PlayerFameChanged(this, this._fame, fame), this);
        this._fame = fame > Configuration.character().getMaxPersonalFamePoints() ? Configuration.character().getMaxPersonalFamePoints() : fame;
    }

    public ClassId getClassId() {
        return this.getTemplate().getClassId();
    }

    public void setClassId(int Id2) {
        if (!this._subclassLock.tryLock()) {
            return;
        }
        try {
            if (this.getLvlJoinedAcademy() != 0 && this._clan != null && PlayerClass.values()[Id2].getLevel() == ClassLevel.Third) {
                if (this.getLvlJoinedAcademy() <= 16) {
                    this._clan.addReputationScore(Configuration.clan().getCompleteAcademyMaxPoints(), true);
                } else if (this.getLvlJoinedAcademy() >= 39) {
                    this._clan.addReputationScore(Configuration.clan().getCompleteAcademyMinPoints(), true);
                } else {
                    this._clan.addReputationScore(Configuration.clan().getCompleteAcademyMaxPoints() - (this.getLvlJoinedAcademy() - 16) * 20, true);
                }
                this.setLvlJoinedAcademy(0);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_EXPELLED);
                msg.addPcName(this);
                this._clan.broadcastToOnlineMembers(msg);
                this._clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(this.getName()));
                this._clan.removeClanMember(this.getObjectId(), 0L);
                this.sendPacket(SystemMessageId.ACADEMY_MEMBERSHIP_TERMINATED);
                this.getInventory().addItem("Gift", 8181, 1L, this, null);
            }
            if (this.isSubClassActive()) {
                this.getSubClasses().get(this._classIndex).setClassId(Id2);
            }
            this.setTarget(this);
            this.broadcastPacket(new MagicSkillUse(this, 5103, 1, 1000, 0));
            this.setClassTemplate(Id2);
            if (this.getClassId().level() == 3) {
                this.sendPacket(SystemMessageId.THIRD_CLASS_TRANSFER);
            } else {
                this.sendPacket(SystemMessageId.CLASS_TRANSFER);
            }
            if (this.isInParty()) {
                this.getParty().broadcastPacket(new PartySmallWindowUpdate(this));
            }
            if (this.getClan() != null) {
                this.getClan().broadcastToOnlineMembers(new PledgeShowMemberListUpdate(this));
            }
            this.rewardSkills();
            if (!this.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && Configuration.character().decreaseSkillOnDelevel()) {
                this.checkPlayerSkills();
            }
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public ClassId getLearningClass() {
        return this._learningClass;
    }

    public void setLearningClass(ClassId learningClass) {
        this._learningClass = learningClass;
    }

    @Override
    public long getExp() {
        if (this.isSubClassActive()) {
            return this.getSubClasses().get(this.getClassIndex()).getStat().getExp();
        }
        return this.getStat().getExp();
    }

    public void setExp(long exp) {
        if (exp < 0L) {
            LOG.warn("For player {} is set negative amount of exp [{}]", this, exp, new IllegalArgumentException());
            exp = 0L;
        }
        this.getSubStat().setExp(exp);
    }

    public void setLevel(int level) {
        this.getSubStat().setLevel(Math.min(level, this.getMaxLevel()));
    }

    public int getMaxLevel() {
        return this.getSubStat().getMaxLevel();
    }

    public int getMaxExpLevel() {
        return this.getSubStat().getMaxExpLevel();
    }

    private PcStat getSubStat() {
        return this.isSubClassActive() ? this.getSubClasses().get(this.getClassIndex()).getStat() : this.getStat();
    }

    @Override
    public boolean addLevel(int value) {
        if (this.getLevel() + value > this.getMaxLevel()) {
            return false;
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerLevelChanged(this, this.getLevel(), this.getLevel() + value), this);
        boolean levelIncreased = this.getSubStat().addLevel(value);
        this.onLevelChange(levelIncreased);
        return levelIncreased;
    }

    @Override
    public void onLevelChange(boolean levelIncreased) {
        L2PetInstance pet;
        if (levelIncreased) {
            this.setCurrentCp(this.getMaxCp());
            this.setCurrentHp(this.getMaxHp());
            this.setCurrentMp(this.getMaxMp());
            this.broadcastPacket(new SocialAction(this.getObjectId(), 2122));
            this.sendPacket(SystemMessageId.YOU_INCREASED_YOUR_LEVEL);
        } else if (!this.isGM() && Configuration.character().decreaseSkillOnDelevel()) {
            this.checkPlayerSkills();
        }
        this.rewardSkills();
        if (this.getClan() != null) {
            this.getClan().updateClanMember(this);
            this.getClan().broadcastToOnlineMembers(new PledgeShowMemberListUpdate(this));
        }
        if (this.isInParty()) {
            this.getParty().recalculatePartyLevel();
        }
        if (this.isTransformed() || this.isInStance()) {
            this.getTransformation().onLevelUp(this);
        }
        if (this.hasPet() && (pet = (L2PetInstance)this.getSummon()).getPetData().isSyncLevel() && pet.getLevel() != this.getLevel()) {
            pet.getStat().setLevel(this.getLevel());
            pet.getStat().getExpForLevel(this.getLevel());
            pet.setCurrentHp(pet.getMaxHp());
            pet.setCurrentMp(pet.getMaxMp());
            pet.broadcastPacket(new SocialAction(this.getObjectId(), 2122));
            pet.updateAndBroadcastStatus(1);
        }
        if (this.getActingPlayer().getHuntingSystem().isNevitBlessingActive()) {
            this.getActingPlayer().getHuntingSystem().addPoints(Configuration.hunting().getNevitLevelAcquirePoints2());
        } else {
            this.getActingPlayer().getHuntingSystem().addPoints(Configuration.hunting().getNevitLevelAcquirePoints());
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(1, this.getLevel());
        su.addAttribute(34, this.getMaxCp());
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(12, this.getMaxMp());
        this.sendPacket(su);
        this.refreshOverloaded();
        this.refreshExpertisePenalty();
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.sendPacket(new ExVoteSystemInfo(this));
    }

    public int getActiveEnchantAttrItemId() {
        return this._activeEnchantAttrItemId;
    }

    public void setActiveEnchantAttrItemId(int objectId) {
        this._activeEnchantAttrItemId = objectId;
    }

    public int getActiveEnchantItemId() {
        return this._activeEnchantItemId;
    }

    public void setActiveEnchantItemId(int objectId) {
        if (objectId == -1) {
            this.setActiveEnchantSupportItemId(-1);
            this.setActiveEnchantTimestamp(0L);
            this.setIsEnchanting(false);
        }
        this._activeEnchantItemId = objectId;
    }

    public int getActiveEnchantSupportItemId() {
        return this._activeEnchantSupportItemId;
    }

    public void setActiveEnchantSupportItemId(int objectId) {
        this._activeEnchantSupportItemId = objectId;
    }

    public long getActiveEnchantTimestamp() {
        return this._activeEnchantTimestamp;
    }

    public void setActiveEnchantTimestamp(long val) {
        this._activeEnchantTimestamp = val;
    }

    public void setIsEnchanting(boolean val) {
        this._isEnchanting = val;
    }

    public boolean isEnchanting() {
        return this._isEnchanting;
    }

    public L2Weapon getFistsWeaponItem() {
        return this._fistsWeaponItem;
    }

    public void setFistsWeaponItem(L2Weapon weaponItem) {
        this._fistsWeaponItem = weaponItem;
    }

    public L2Weapon findFistsWeaponItem(int classId) {
        L2Weapon weaponItem = null;
        if (classId >= 0 && classId <= 9) {
            L2Item temp = ItemTable.getInstance().getTemplate(246);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 10 && classId <= 17) {
            L2Item temp = ItemTable.getInstance().getTemplate(251);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 18 && classId <= 24) {
            L2Item temp = ItemTable.getInstance().getTemplate(244);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 25 && classId <= 30) {
            L2Item temp = ItemTable.getInstance().getTemplate(249);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 31 && classId <= 37) {
            L2Item temp = ItemTable.getInstance().getTemplate(245);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 38 && classId <= 43) {
            L2Item temp = ItemTable.getInstance().getTemplate(250);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 44 && classId <= 48) {
            L2Item temp = ItemTable.getInstance().getTemplate(248);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 49 && classId <= 52) {
            L2Item temp = ItemTable.getInstance().getTemplate(252);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 53 && classId <= 57) {
            L2Item temp = ItemTable.getInstance().getTemplate(247);
            weaponItem = (L2Weapon)temp;
        }
        return weaponItem;
    }

    public void rewardSkills() {
        if (Configuration.character().autoLearnSkills()) {
            this.giveAvailableSkills(Configuration.character().autoLearnForgottenScrollSkills(), true);
        } else {
            this.giveAvailableAutoGetSkills();
        }
        this.checkPlayerSkills();
        this.checkItemRestriction();
        this.sendSkillList();
    }

    public void regiveTemporarySkills() {
        if (this.isNoble()) {
            this.setNoble(true);
        }
        if (this.isHero()) {
            this.setHero(true);
        }
        if (this.getClan() != null) {
            L2Clan clan = this.getClan();
            clan.addSkillEffects(this);
            if (clan.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel() && this.isClanLeader()) {
                SiegeManager.getInstance().addSiegeSkills(this);
            }
            if (this.getClan().getCastleId() > 0) {
                CastleManager.getInstance().getCastleByOwner(this.getClan()).giveResidentialSkills(this);
            }
            if (this.getClan().getFortId() > 0) {
                FortManager.getInstance().getFortByOwner(this.getClan()).giveResidentialSkills(this);
            }
        }
        this.getInventory().reloadEquippedItems();
        this.restoreDeathPenaltyBuffLevel();
    }

    public int giveAvailableSkills(boolean includedByFs, boolean includeAutoGet) {
        int skillCounter = 0;
        Collection<Skill> skills = SkillTreesData.getInstance().getAllAvailableSkills(this, this.getClassId(), includedByFs, includeAutoGet);
        ArrayList<Skill> skillsForStore = new ArrayList<Skill>();
        for (Skill sk : skills) {
            if (this.getKnownSkill(sk.getId()) == sk) continue;
            if (this.getSkillLevel(sk.getId()) == -1) {
                ++skillCounter;
            }
            if (sk.isToggle() && this.isAffectedBySkill(sk.getId())) {
                this.stopSkillEffects(true, sk.getId());
            }
            this.addSkill(sk, false);
            skillsForStore.add(sk);
        }
        DAOFactory.getInstance().getSkillDAO().insert(this, -1, skillsForStore);
        if (Configuration.character().autoLearnSkills() && skillCounter > 0) {
            this.sendMessage("You have learned " + skillCounter + " new skills.");
        }
        return skillCounter;
    }

    public void giveAvailableAutoGetSkills() {
        List<L2SkillLearn> autoGetSkills = SkillTreesData.getInstance().getAvailableAutoGetSkills(this);
        SkillData st = SkillData.getInstance();
        for (L2SkillLearn s : autoGetSkills) {
            Skill skill = st.getSkill(s.getSkillId(), s.getSkillLevel());
            if (skill != null) {
                this.addSkill(skill, true);
                continue;
            }
            LOG.warn("Skipping null auto-get skill for player: {}", (Object)this);
        }
    }

    @Override
    public Race getRace() {
        if (!this.isSubClassActive()) {
            return this.getTemplate().getRace();
        }
        return PlayerTemplateData.getInstance().getTemplate(this._baseClass).getRace();
    }

    public L2Radar getRadar() {
        return this._radar;
    }

    public boolean isMinimapAllowed() {
        return this._minimapAllowed;
    }

    public void setMinimapAllowed(boolean b) {
        this._minimapAllowed = b;
    }

    public void addSp(int sp) {
        this.getSubStat().addSp(sp);
    }

    @Override
    public int getSp() {
        return this.isSubClassActive() ? this.getSubClasses().get(this.getClassIndex()).getStat().getSp() : this.getStat().getSp();
    }

    public void setSp(int sp) {
        if (sp < 0) {
            sp = 0;
        }
        if (this.isSubClassActive()) {
            this.getSubClasses().get(this.getClassIndex()).getStat().setSp(sp);
        } else {
            super.getStat().setSp(sp);
        }
    }

    public boolean isCastleLord(int castleId) {
        Castle castle;
        L2Clan clan = this.getClan();
        return clan != null && clan.getLeader().getPlayerInstance() == this && (castle = CastleManager.getInstance().getCastleByOwner(clan)) != null && castle == CastleManager.getInstance().getCastleById(castleId);
    }

    @Override
    public int getClanId() {
        return this._clanId;
    }

    public int getClanCrestId() {
        if (this._clan != null) {
            return this._clan.getCrestId();
        }
        return 0;
    }

    public int getClanCrestLargeId() {
        if (this._clan != null && (this._clan.getCastleId() != 0 || this._clan.getHideoutId() != 0)) {
            return this._clan.getCrestLargeId();
        }
        return 0;
    }

    public long getClanJoinExpiryTime() {
        return this._clanJoinExpiryTime;
    }

    public void setClanJoinExpiryTime(long time) {
        this._clanJoinExpiryTime = time;
    }

    public long getClanCreateExpiryTime() {
        return this._clanCreateExpiryTime;
    }

    public void setClanCreateExpiryTime(long time) {
        this._clanCreateExpiryTime = time;
    }

    @Override
    public PcInventory getInventory() {
        return this._inventory;
    }

    public void removeItemFromShortCut(int objectId) {
        this._shortCuts.deleteShortCutByObjectId(objectId);
    }

    public boolean isSitting() {
        return this._waitTypeSitting;
    }

    public void setIsSitting(boolean state) {
        this._waitTypeSitting = state;
    }

    public void sitDown() {
        this.sitDown(true);
    }

    public void sitDown(boolean checkCast) {
        TerminateReturn terminate = EventDispatcher.getInstance().notifyEvent(new PlayerSit(this), this, TerminateReturn.class);
        if (terminate != null && terminate.terminate()) {
            return;
        }
        if (checkCast && this.isCastingNow()) {
            return;
        }
        if (!(this._waitTypeSitting || this.isAttackingDisabled() || this.isOutOfControl() || this.isImmobilized() || this.isMoving())) {
            this.breakAttack();
            this.setIsSitting(true);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
            this.broadcastPacket(new ChangeWaitType(this, 0));
            ThreadPoolManager.getInstance().scheduleGeneral(new SitDownTask(this), 2500L);
            this.startStunning();
        }
    }

    public void standUp() {
        TerminateReturn terminate = EventDispatcher.getInstance().notifyEvent(new PlayerStand(this), Containers.Players(), TerminateReturn.class);
        if (terminate != null && terminate.terminate()) {
            return;
        }
        if (this._waitTypeSitting && !this.isInStoreMode() && !this.isAlikeDead()) {
            if (this.getEffectList().isAffected(EffectFlag.RELAXING)) {
                this.stopEffects(L2EffectType.RELAXING);
            }
            this.broadcastPacket(new ChangeWaitType(this, 1));
            ThreadPoolManager.getInstance().scheduleGeneral(new StandUpTask(this), 2500L);
        }
    }

    public PcWarehouse getWarehouse() {
        if (this._warehouse == null) {
            this._warehouse = new PcWarehouse(this);
            this._warehouse.restore();
        }
        if (Configuration.general().warehouseCache()) {
            WarehouseCacheManager.getInstance().addCacheTask(this);
        }
        return this._warehouse;
    }

    public void clearWarehouse() {
        if (this._warehouse != null) {
            this._warehouse.deleteMe();
        }
        this._warehouse = null;
    }

    public PcFreight getFreight() {
        return this._freight;
    }

    public boolean hasRefund() {
        return this._refund != null && this._refund.getSize() > 0 && Configuration.general().allowRefund();
    }

    public PcRefund getRefund() {
        if (this._refund == null) {
            this._refund = new PcRefund(this);
        }
        return this._refund;
    }

    public void clearRefund() {
        if (this._refund != null) {
            this._refund.deleteMe();
        }
        this._refund = null;
    }

    public long getAdena() {
        return this._inventory.getAdena();
    }

    public long getAncientAdena() {
        return this._inventory.getAncientAdena();
    }

    public void addAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            sm.addLong(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAdena(process, count, this, reference);
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance adenaItem = this._inventory.getAdenaInstance();
            if (!this._inventory.reduceAdena(process, count, this, reference)) {
                return false;
            }
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(adenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA);
                sm.addLong(count);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public void addAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm.addItemName(5575);
            sm.addLong(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAncientAdena(process, count, this, reference);
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAncientAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAncientAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance ancientAdenaItem = this._inventory.getAncientAdenaInstance();
            if (!this._inventory.reduceAncientAdena(process, count, this, reference)) {
                return false;
            }
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(ancientAdenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                if (count > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(5575);
                    sm.addLong(count);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(5575);
                    this.sendPacket(sm);
                }
            }
        }
        return true;
    }

    public void addItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        if (item.getCount() > 0L) {
            TerritoryWard ward;
            if (sendMessage) {
                if (item.getCount() > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                    sm.addItemName(item);
                    sm.addLong(item.getCount());
                    this.sendPacket(sm);
                } else if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_A_S1_S2);
                    sm.addInt(item.getEnchantLevel());
                    sm.addItemName(item);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(item);
                    this.sendPacket(sm);
                }
            }
            L2ItemInstance newitem = this._inventory.addItem(process, item, this, (Object)reference);
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate playerIU = new InventoryUpdate();
                playerIU.addItem(newitem);
                this.sendPacket(playerIU);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(14, this.getCurrentLoad());
            this.sendPacket(su);
            if (!(this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) || this._inventory.validateCapacity(0L, item.isQuestItem()) || !newitem.isDroppable() || newitem.isStackable() && newitem.getLastChange() == 2)) {
                this.dropItem("InvDrop", newitem, null, true, true);
            } else if (CursedWeaponsManager.getInstance().isCursed(newitem.getId())) {
                CursedWeaponsManager.getInstance().activate(this, newitem);
            } else if (FortSiegeManager.getInstance().isCombat(item.getId())) {
                if (FortSiegeManager.getInstance().activateCombatFlag(this, item)) {
                    Fort fort = FortManager.getInstance().getFort(this);
                    fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.C1_ACQUIRED_THE_FLAG), this.getName());
                }
            } else if (item.getId() >= 13560 && item.getId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(item.getId() - 13479)) != null) {
                ward.activate(this, item);
            }
        }
    }

    public L2ItemInstance addItem(String process, int itemId, L2Object reference, boolean sendMessage) {
        return this.addItem(process, itemId, 1L, -1, reference, sendMessage);
    }

    public L2ItemInstance addItem(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return this.addItem(process, itemId, count, -1, reference, sendMessage);
    }

    public L2ItemInstance addItem(String process, int itemId, long count, int enchantLevel, L2Object reference, boolean sendMessage) {
        if (count > 0L) {
            L2Item item = ItemTable.getInstance().getTemplate(itemId);
            if (item == null) {
                LOG.error("Item doesn't exist so cannot be added. Item ID: {}", (Object)itemId);
                return null;
            }
            if (sendMessage) {
                if (count > 1L) {
                    if (process.equalsIgnoreCase("Sweeper") || process.equalsIgnoreCase("Quest")) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(itemId);
                        sm.addLong(count);
                        this.sendPacket(sm);
                    } else {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                        sm.addItemName(itemId);
                        sm.addLong(count);
                        this.sendPacket(sm);
                    }
                } else if (process.equalsIgnoreCase("Sweeper") || process.equalsIgnoreCase("Quest")) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                }
            }
            if (item.hasExImmediateEffect()) {
                IItemHandler handler = ItemHandler.getInstance().getHandler(item instanceof L2EtcItem ? (L2EtcItem)item : null);
                if (handler == null) {
                    LOG.warn("No item handler registered for Herb {}!", (Object)item);
                } else {
                    int objectId = IdFactory.getInstance().getNextId();
                    handler.useItem(this, new L2ItemInstance(objectId, itemId), false);
                }
            } else {
                TerritoryWard ward;
                L2ItemInstance createdItem = this._inventory.addItem(process, itemId, count, enchantLevel, this, reference);
                if (!(this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) || this._inventory.validateCapacity(0L, item.isQuestItem()) || !createdItem.isDroppable() || createdItem.isStackable() && createdItem.getLastChange() == 2)) {
                    this.dropItem("InvDrop", createdItem, null, true);
                } else if (CursedWeaponsManager.getInstance().isCursed(createdItem.getId())) {
                    CursedWeaponsManager.getInstance().activate(this, createdItem);
                } else if (createdItem.getId() >= 13560 && createdItem.getId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(createdItem.getId() - 13479)) != null) {
                    ward.activate(this, createdItem);
                }
                return createdItem;
            }
        }
        return null;
    }

    public void addItem(String process, ItemHolder item, L2Object reference, boolean sendMessage) {
        this.addItem(process, item.getId(), item.getCount(), reference, sendMessage);
    }

    public boolean destroyItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.destroyItem(process, item, item.getCount(), reference, sendMessage);
    }

    public boolean destroyItem(String process, L2ItemInstance item, long count, L2Object reference, boolean sendMessage) {
        if ((item = this._inventory.destroyItem(process, item, count, this, (Object)reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item);
                sm.addLong(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        return this.destroyItem(process, item, count, reference, sendMessage);
    }

    public boolean destroyItemWithoutTrace(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null || item.getCount() < count) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        return this.destroyItem(null, item, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (itemId == 57) {
            return this.reduceAdena(process, count, reference, sendMessage);
        }
        L2ItemInstance item = this._inventory.getItemByItemId(itemId);
        if (item == null || item.getCount() < count || this._inventory.destroyItemByItemId(process, itemId, count, this, reference) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(itemId);
                sm.addLong(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(itemId);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2Object reference) {
        L2ItemInstance oldItem = this.checkItemManipulation(objectId, count, "transfer");
        if (oldItem == null) {
            return null;
        }
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, this, reference);
        if (newItem == null) {
            return null;
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate playerIU = new InventoryUpdate();
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
            } else {
                playerIU.addRemovedItem(oldItem);
            }
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate playerSU = new StatusUpdate(this);
        playerSU.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(playerSU);
        if (target instanceof PcInventory) {
            L2PcInstance targetPlayer = ((PcInventory)target).getOwner();
            if (!Configuration.general().forceInventoryUpdate()) {
                InventoryUpdate playerIU = new InventoryUpdate();
                if (newItem.getCount() > count) {
                    playerIU.addModifiedItem(newItem);
                } else {
                    playerIU.addNewItem(newItem);
                }
                targetPlayer.sendPacket(playerIU);
            } else {
                targetPlayer.sendPacket(new ItemList(targetPlayer, false));
            }
            playerSU = new StatusUpdate(targetPlayer);
            playerSU.addAttribute(14, targetPlayer.getCurrentLoad());
            targetPlayer.sendPacket(playerSU);
        } else if (target instanceof PetInventory) {
            PetInventoryUpdate petIU = new PetInventoryUpdate();
            if (newItem.getCount() > count) {
                petIU.addModifiedItem(newItem);
            } else {
                petIU.addNewItem(newItem);
            }
            ((PetInventory)target).getOwner().sendPacket(petIU);
        }
        return newItem;
    }

    public boolean exchangeItemsById(String process, L2Object reference, int coinId, long cost, int rewardId, long count, boolean sendMessage) {
        PcInventory inv = this.getInventory();
        if (!inv.validateCapacityByItemId(rewardId, count)) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.SLOTS_FULL);
            }
            return false;
        }
        if (!inv.validateWeightByItemId(rewardId, count)) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            }
            return false;
        }
        if (this.destroyItemByItemId(process, coinId, cost, reference, sendMessage)) {
            this.addItem(process, rewardId, count, reference, sendMessage);
            return true;
        }
        return false;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage, boolean protectItem) {
        if ((item = this._inventory.dropItem(process, item, this, reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        item.dropMe(this, this.getX() + Rnd.get((int)50) - 25, this.getY() + Rnd.get((int)50) - 25, this.getZ() + 20);
        if (Configuration.general().getAutoDestroyDroppedItemAfter() > 0 && Configuration.general().destroyPlayerDroppedItem() && !Configuration.general().getProtectedItems().contains(item.getId()) && (item.isEquipable() && Configuration.general().destroyEquipableItem() || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Configuration.general().destroyPlayerDroppedItem()) {
            if (!item.isEquipable() || item.isEquipable() && Configuration.general().destroyEquipableItem()) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return true;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.dropItem(process, item, reference, sendMessage, false);
    }

    public L2ItemInstance dropItem(String process, int objectId, long count, int x, int y, int z, L2Object reference, boolean sendMessage, boolean protectItem) {
        L2ItemInstance invitem = this._inventory.getItemByObjectId(objectId);
        L2ItemInstance item = this._inventory.dropItem(process, objectId, count, this, reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return null;
        }
        item.dropMe(this, x, y, z);
        if (Configuration.general().getAutoDestroyDroppedItemAfter() > 0 && Configuration.general().destroyPlayerDroppedItem() && !Configuration.general().getProtectedItems().contains(item.getId()) && (item.isEquipable() && Configuration.general().destroyEquipableItem() || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Configuration.general().destroyPlayerDroppedItem()) {
            if (!item.isEquipable() || item.isEquipable() && Configuration.general().destroyEquipableItem()) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(invitem);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return item;
    }

    public L2ItemInstance checkItemManipulation(int objectId, long count, String action) {
        if (L2World.getInstance().findObject(objectId) == null) {
            LOG.warn("{} tried to {} item not available in L2World", (Object)this, (Object)action);
            return null;
        }
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            LOG.warn("{} tried to {} item he is not owner of", (Object)this, (Object)action);
            return null;
        }
        if (count < 0L || count > 1L && !item.isStackable()) {
            LOG.warn("{} tried to {} item with invalid count: {}", this, action, count);
            return null;
        }
        if (count > item.getCount()) {
            LOG.warn("{} tried to {} more items than he owns", (Object)this, (Object)action);
            return null;
        }
        if (this.hasSummon() && this.getSummon().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Configuration.general().debug()) {
                LOG.debug("{} tried to {} item controling pet", (Object)this, (Object)action);
            }
            return null;
        }
        if (this.getActiveEnchantItemId() == objectId) {
            if (Configuration.general().debug()) {
                LOG.debug("{} tried to {} an enchant scroll he was using", (Object)this, (Object)action);
            }
            return null;
        }
        if (item.isAugmented() && (this.isCastingNow() || this.isCastingSimultaneouslyNow())) {
            return null;
        }
        return item;
    }

    public void setProtection(boolean protect) {
        if (Configuration.general().developer() && (protect || this._protectEndTime > 0L)) {
            LOG.debug("{}: Protection {} (currently {})", this, protect ? "ON " + (GameTimeController.getInstance().getGameTicks() + Configuration.character().getPlayerSpawnProtection() * 10) : "OFF", GameTimeController.getInstance().getGameTicks());
        }
        this._protectEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Configuration.character().getPlayerSpawnProtection() * 10) : 0L;
    }

    public void setTeleportProtection(boolean protect) {
        if (Configuration.general().developer() && (protect || this._teleportProtectEndTime > 0L)) {
            LOG.debug("{}: Tele Protection {} (currently {})", this, protect ? "ON " + (GameTimeController.getInstance().getGameTicks() + Configuration.character().getPlayerTeleportProtection() * 10) : "OFF", GameTimeController.getInstance().getGameTicks());
        }
        this._teleportProtectEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Configuration.character().getPlayerTeleportProtection() * 10) : 0L;
    }

    public boolean isRecentFakeDeath() {
        return this._recentFakeDeathEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public void setRecentFakeDeath(boolean protect) {
        this._recentFakeDeathEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Configuration.character().getPlayerFakeDeathUpProtection() * 10) : 0L;
    }

    public boolean isFakeDeath() {
        return this._isFakeDeath;
    }

    public void setIsFakeDeath(boolean value) {
        this._isFakeDeath = value;
    }

    @Override
    public boolean isAlikeDead() {
        return super.isAlikeDead() || this.isFakeDeath();
    }

    public L2GameClient getClient() {
        return this._client;
    }

    public void setClient(L2GameClient client) {
        this._client = client;
    }

    public String getIPAddress() {
        String ip = "N/A";
        if (this._client != null && this._client.getConnectionAddress() != null) {
            ip = this._client.getConnectionAddress().getHostAddress();
        }
        return ip;
    }

    private void closeNetConnection(boolean closeClient) {
        L2GameClient client = this._client;
        if (client != null) {
            if (client.isDetached()) {
                client.cleanMe(true);
            } else if (!client.getConnection().isClosed()) {
                if (closeClient) {
                    client.close(LeaveWorld.STATIC_PACKET);
                } else {
                    client.close(ServerClose.STATIC_PACKET);
                }
            }
        }
    }

    public Location getCurrentSkillWorldPosition() {
        return this._currentSkillWorldPosition;
    }

    public void setCurrentSkillWorldPosition(Location worldPosition) {
        this._currentSkillWorldPosition = worldPosition;
    }

    @Override
    public void enableSkill(Skill skill) {
        super.enableSkill(skill);
        this.removeTimeStamp(skill);
    }

    @Override
    public boolean checkDoCastConditions(Skill skill) {
        if (!super.checkDoCastConditions(skill)) {
            return false;
        }
        if (this.inObserverMode()) {
            return false;
        }
        if (this.isInOlympiadMode() && skill.isBlockedInOlympiad()) {
            this.sendPacket(SystemMessageId.THIS_SKILL_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT);
            return false;
        }
        if (this.getCharges() < skill.getChargeConsume() || this.isInAirShip() && !skill.hasEffectType(L2EffectType.REFUEL_AIRSHIP, new L2EffectType[0])) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            this.sendPacket(sm);
            return false;
        }
        return true;
    }

    private boolean needCpUpdate() {
        double currentCp = this.getCurrentCp();
        if (currentCp <= 1.0 || (double)this.getMaxCp() < 352.0) {
            return true;
        }
        if (currentCp <= this._cpUpdateDecCheck || currentCp >= this._cpUpdateIncCheck) {
            if (currentCp == (double)this.getMaxCp()) {
                this._cpUpdateIncCheck = currentCp + 1.0;
                this._cpUpdateDecCheck = currentCp - this._cpUpdateInterval;
            } else {
                double doubleMulti = currentCp / this._cpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._cpUpdateDecCheck = this._cpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._cpUpdateIncCheck = this._cpUpdateDecCheck + this._cpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    private boolean needMpUpdate() {
        double currentMp = this.getCurrentMp();
        if (currentMp <= 1.0 || (double)this.getMaxMp() < 352.0) {
            return true;
        }
        if (currentMp <= this._mpUpdateDecCheck || currentMp >= this._mpUpdateIncCheck) {
            if (currentMp == (double)this.getMaxMp()) {
                this._mpUpdateIncCheck = currentMp + 1.0;
                this._mpUpdateDecCheck = currentMp - this._mpUpdateInterval;
            } else {
                double doubleMulti = currentMp / this._mpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._mpUpdateDecCheck = this._mpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._mpUpdateIncCheck = this._mpUpdateDecCheck + this._mpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    @Override
    public void broadcastStatusUpdate() {
        OlympiadGameTask game;
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(9, (int)this.getCurrentHp());
        su.addAttribute(12, this.getMaxMp());
        su.addAttribute(11, (int)this.getCurrentMp());
        su.addAttribute(34, this.getMaxCp());
        su.addAttribute(33, (int)this.getCurrentCp());
        this.sendPacket(su);
        boolean needCpUpdate = this.needCpUpdate();
        boolean needHpUpdate = this.needHpUpdate();
        if (this.isInParty() && (needCpUpdate || needHpUpdate || this.needMpUpdate())) {
            this.getParty().broadcastToPartyMembers(this, new PartySmallWindowUpdate(this));
        }
        if (this.isInOlympiadMode() && this.isOlympiadStart() && (needCpUpdate || needHpUpdate) && (game = OlympiadGameManager.getInstance().getOlympiadTask(this.getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastStatusUpdate(this);
        }
        if (this.isInDuel() && (needCpUpdate || needHpUpdate)) {
            DuelManager.getInstance().broadcastToOpposingTeam(this, new ExDuelUpdateUserInfo(this));
        }
    }

    public void broadcastUserInfo() {
        this.sendPacket(new UserInfo(this));
        this.broadcastPacket(new CharInfo(this));
        this.broadcastPacket(new ExBrExtraUserInfo(this));
        if (TerritoryWarManager.getInstance().isTWInProgress() && (TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getObjectId()) || TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getClan()))) {
            this.broadcastPacket(new ExDominionWarStart(this));
        }
    }

    public void broadcastTitleInfo() {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.broadcastPacket(new NicknameChanged(this));
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.isInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isVisibleFor(player)) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), relation, this.isAutoAttackable(player)));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.isInvisible());
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), relation, this.isAutoAttackable(player)));
        }
    }

    @Override
    public int getAllyId() {
        if (this._clan == null) {
            return 0;
        }
        return this._clan.getAllyId();
    }

    public int getAllyCrestId() {
        if (this.getClanId() == 0) {
            return 0;
        }
        if (this.getClan().getAllyId() == 0) {
            return 0;
        }
        return this.getClan().getAllyCrestId();
    }

    public void queryGameGuard() {
        if (this.getClient() != null) {
            this.getClient().setGameGuardOk(false);
            this.sendPacket(GameGuardQuery.STATIC_PACKET);
        }
        if (Configuration.general().gameGuardEnforce()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new GameGuardCheckTask(this), 30000L);
        }
    }

    @Override
    public void sendPacket(L2GameServerPacket packet) {
        if (this._client != null) {
            this._client.sendPacket(packet);
        }
    }

    @Override
    public void sendPacket(SystemMessageId id) {
        this.sendPacket(SystemMessage.getSystemMessage(id));
    }

    public void doInteract(L2Character target) {
        if (target instanceof L2PcInstance) {
            L2PcInstance temp = (L2PcInstance)target;
            this.sendPacket(ActionFailed.STATIC_PACKET);
            if (temp.getPrivateStoreType() == PrivateStoreType.SELL || temp.getPrivateStoreType() == PrivateStoreType.PACKAGE_SELL) {
                this.sendPacket(new PrivateStoreListSell(this, temp));
            } else if (temp.getPrivateStoreType() == PrivateStoreType.BUY) {
                this.sendPacket(new PrivateStoreListBuy(this, temp));
            } else if (temp.getPrivateStoreType() == PrivateStoreType.MANUFACTURE) {
                this.sendPacket(new RecipeShopSellList(this, temp));
            }
        } else {
            target.onAction(this);
        }
    }

    public void doAutoLoot(L2Attackable target, int itemId, long itemCount) {
        if (this.isInParty() && !ItemTable.getInstance().getTemplate(itemId).hasExImmediateEffect()) {
            this.getParty().distributeItem(this, itemId, itemCount, false, target);
        } else if (itemId == 57) {
            this.addAdena("Loot", itemCount, target, true);
        } else {
            this.addItem("Loot", itemId, itemCount, target, true);
        }
    }

    public void doAutoLoot(L2Attackable target, ItemHolder item) {
        this.doAutoLoot(target, item.getId(), item.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPickupItem(L2Object object) {
        if (this.isAlikeDead() || this.isFakeDeath() || this.isInvisible()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (!object.isItem()) {
            LOG.warn("{} trying to pickup wrong target.", (Object)this, (Object)this.getTarget());
            return;
        }
        L2ItemInstance target = (L2ItemInstance)object;
        this.sendPacket(new StopMove(this));
        SystemMessage smsg = null;
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!target.getDropProtection().tryPickUp(this)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if ((this.isInParty() && this.getParty().getDistributionType() == PartyDistributionType.FINDERS_KEEPERS || !this.isInParty()) && !this._inventory.validateCapacity(target)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.SLOTS_FULL);
                return;
            }
            if (this.isInvisible() && !this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS)) {
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getObjectId() && !this.isInLooterParty(target.getOwnerId())) {
                if (target.getId() == 57) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    smsg.addLong(target.getCount());
                } else if (target.getCount() > 1L) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    smsg.addItemName(target);
                    smsg.addLong(target.getCount());
                } else {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    smsg.addItemName(target);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(smsg);
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(target.getId()) && !FortSiegeManager.getInstance().checkIfCanPickup(this)) {
                return;
            }
            if (target.getItemLootSchedule() != null && (target.getOwnerId() == this.getObjectId() || this.isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Configuration.general().saveDroppedItem()) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItem().hasExImmediateEffect()) {
            IItemHandler handler = ItemHandler.getInstance().getHandler(target.getEtcItem());
            if (handler == null) {
                LOG.warn("No item handler registered for item ID: {}.", (Object)target.getId());
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this, null);
        } else if (CursedWeaponsManager.getInstance().isCursed(target.getId())) {
            this.addItem("Pickup", target, null, true);
        } else if (FortSiegeManager.getInstance().isCombat(target.getId())) {
            this.addItem("Pickup", target, null, true);
        } else {
            if (target.getItemType() instanceof ArmorType || target.getItemType() instanceof WeaponType) {
                if (target.getEnchantLevel() > 0) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2_S3);
                    smsg.addPcName(this);
                    smsg.addInt(target.getEnchantLevel());
                    smsg.addItemName(target.getId());
                    this.broadcastPacket(smsg, 1400);
                } else {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2);
                    smsg.addPcName(this);
                    smsg.addItemName(target.getId());
                    this.broadcastPacket(smsg, 1400);
                }
            }
            if (this.isInParty()) {
                this.getParty().distributeItem(this, target);
            } else if (target.getId() == 57 && this.getInventory().getAdenaInstance() != null) {
                this.addAdena("Pickup", target.getCount(), null, true);
                ItemTable.getInstance().destroyItem("Pickup", target, this, null);
            } else {
                L2EtcItem etcItem;
                this.addItem("Pickup", target, null, true);
                L2ItemInstance weapon = this.getInventory().getPaperdollItem(5);
                if (weapon != null && (etcItem = target.getEtcItem()) != null) {
                    EtcItemType itemType = etcItem.getItemType();
                    if (weapon.getItemType() == WeaponType.BOW && itemType == EtcItemType.ARROW) {
                        this.checkAndEquipArrows();
                    } else if (weapon.getItemType() == WeaponType.CROSSBOW && itemType == EtcItemType.BOLT) {
                        this.checkAndEquipBolts();
                    }
                }
            }
        }
    }

    @Override
    public void doAttack(L2Character target) {
        super.doAttack(target);
        this.setRecentFakeDeath(false);
    }

    @Override
    public void doCast(Skill skill) {
        if (this.getCurrentSkill() != null && !this.checkUseMagicConditions(skill, this.getCurrentSkill().isCtrlPressed(), this.getCurrentSkill().isShiftPressed())) {
            this.setIsCastingNow(false);
            return;
        }
        super.doCast(skill);
        this.setRecentFakeDeath(false);
    }

    public boolean canOpenPrivateStore() {
        return !this.isAlikeDead() && !this.isInOlympiadMode() && !this.isMounted() && !this.isInsideZone(ZoneId.NO_STORE) && !this.isCastingNow();
    }

    public void tryOpenPrivateBuyStore() {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == PrivateStoreType.BUY || this.getPrivateStoreType() == PrivateStoreType.BUY_MANAGE) {
                this.setPrivateStoreType(PrivateStoreType.NONE);
            }
            if (this.getPrivateStoreType() == PrivateStoreType.NONE) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(PrivateStoreType.BUY_MANAGE);
                this.sendPacket(new PrivateStoreManageListBuy(this));
            }
        } else {
            if (this.isInsideZone(ZoneId.NO_STORE)) {
                this.sendPacket(SystemMessageId.NO_PRIVATE_STORE_HERE);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public void tryOpenPrivateSellStore(boolean isPackageSale) {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == PrivateStoreType.SELL || this.getPrivateStoreType() == PrivateStoreType.SELL_MANAGE || this.getPrivateStoreType() == PrivateStoreType.PACKAGE_SELL) {
                this.setPrivateStoreType(PrivateStoreType.NONE);
            }
            if (this.getPrivateStoreType() == PrivateStoreType.NONE) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(PrivateStoreType.SELL_MANAGE);
                this.sendPacket(new PrivateStoreManageListSell(this, isPackageSale));
            }
        } else {
            if (this.isInsideZone(ZoneId.NO_STORE)) {
                this.sendPacket(SystemMessageId.NO_PRIVATE_STORE_HERE);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public PreparedListContainer getMultiSell() {
        return this._currentMultiSell;
    }

    public void setMultiSell(PreparedListContainer list) {
        this._currentMultiSell = list;
    }

    @Override
    public boolean isTransformed() {
        return this._transformation != null && !this._transformation.isStance();
    }

    public boolean isInStance() {
        return this._transformation != null && this._transformation.isStance();
    }

    public void transform(Transform transformation) {
        if (this._transformation != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN);
            this.sendPacket(msg);
            return;
        }
        this.setQueuedSkill(null, false, false);
        if (this.isMounted()) {
            this.dismount();
        }
        this._transformation = transformation;
        this.getEffectList().stopAllToggles();
        transformation.onTransform(this);
        this.sendSkillList();
        this.sendPacket(new SkillCoolTime(this));
        this.broadcastUserInfo();
        EventDispatcher.getInstance().notifyEventAsync(new PlayerTransform(this, transformation.getId()), this);
    }

    @Override
    public void untransform() {
        if (this._transformation != null) {
            this.setQueuedSkill(null, false, false);
            this._transformation.onUntransform(this);
            this._transformation = null;
            this.getEffectList().stopAllToggles(false);
            this.getEffectList().stopSkillEffects(false, AbnormalType.TRANSFORM);
            this.sendSkillList();
            this.sendPacket(new SkillCoolTime(this));
            this.broadcastUserInfo();
            EventDispatcher.getInstance().notifyEventAsync(new PlayerTransform(this, 0), this);
        }
    }

    @Override
    public Transform getTransformation() {
        return this._transformation;
    }

    public int getTransformationId() {
        return this.isTransformed() ? this.getTransformation().getId() : 0;
    }

    public int getTransformationDisplayId() {
        return this.isTransformed() ? this.getTransformation().getDisplayId() : 0;
    }

    @Override
    public void setTarget(L2Object newTarget) {
        L2Object oldTarget;
        if (newTarget != null) {
            boolean isInParty;
            boolean bl = isInParty = newTarget.isPlayer() && this.isInParty() && this.getParty().containsPlayer(newTarget.getActingPlayer());
            if (!isInParty && Math.abs(newTarget.getZ() - this.getZ()) > 1000) {
                newTarget = null;
            }
            if (newTarget != null && !isInParty && !newTarget.isVisible()) {
                newTarget = null;
            }
            if (!this.isGM() && newTarget instanceof L2Vehicle) {
                newTarget = null;
            }
        }
        if ((oldTarget = this.getTarget()) != null) {
            if (oldTarget.equals(newTarget)) {
                if (newTarget != null && newTarget.getObjectId() != this.getObjectId()) {
                    this.sendPacket(new ValidateLocation(newTarget));
                }
                return;
            }
            oldTarget.removeStatusListener(this);
        }
        if (newTarget instanceof L2Character) {
            L2Character target = (L2Character)newTarget;
            if (newTarget.getObjectId() != this.getObjectId()) {
                this.sendPacket(new ValidateLocation(target));
            }
            this.sendPacket(new MyTargetSelected(this, target));
            target.addStatusListener(this);
            StatusUpdate su = new StatusUpdate(target);
            su.addAttribute(10, target.getMaxHp());
            su.addAttribute(9, (int)target.getCurrentHp());
            this.sendPacket(su);
            Broadcast.toKnownPlayers(this, new TargetSelected(this.getObjectId(), newTarget.getObjectId(), this.getX(), this.getY(), this.getZ()));
        }
        if (newTarget == null && this.getTarget() != null) {
            this.broadcastPacket(new TargetUnselected(this));
        }
        super.setTarget(newTarget);
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return this.getInventory().getPaperdollItem(5);
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return this.getFistsWeaponItem();
        }
        return (L2Weapon)weapon.getItem();
    }

    public L2ItemInstance getChestArmorInstance() {
        return this.getInventory().getPaperdollItem(6);
    }

    public L2ItemInstance getLegsArmorInstance() {
        return this.getInventory().getPaperdollItem(11);
    }

    public L2Armor getActiveChestArmorItem() {
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor == null) {
            return null;
        }
        return (L2Armor)armor.getItem();
    }

    public L2Armor getActiveLegsArmorItem() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        if (legs == null) {
            return null;
        }
        return (L2Armor)legs.getItem();
    }

    public boolean isWearingHeavyArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && legs.getItemType() == ArmorType.HEAVY && armor.getItemType() == ArmorType.HEAVY) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && armor.getItemType() == ArmorType.HEAVY;
    }

    public boolean isWearingLightArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && legs.getItemType() == ArmorType.LIGHT && armor.getItemType() == ArmorType.LIGHT) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && armor.getItemType() == ArmorType.LIGHT;
    }

    public boolean isWearingMagicArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && legs.getItemType() == ArmorType.MAGIC && armor.getItemType() == ArmorType.MAGIC) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && armor.getItemType() == ArmorType.MAGIC;
    }

    public boolean isAutoLoot() {
        return this._enableAutoLoot;
    }

    public void setAutoLoot(boolean val) {
        this._enableAutoLoot = val;
    }

    public boolean isAutoLootItem() {
        return this._enableAutoLootItem;
    }

    public void setAutoLootItem(boolean val) {
        this._enableAutoLootItem = val;
    }

    public boolean isAutoLootHerb() {
        return this._enableAutoLootHerb;
    }

    public void setAutoLootHerbs(boolean val) {
        this._enableAutoLootHerb = val;
    }

    public boolean isMarried() {
        return this._married;
    }

    public void setMarried(boolean state) {
        this._married = state;
    }

    public boolean isEngageRequest() {
        return this._engagerequest;
    }

    public void setEngageRequest(boolean state, int playerid) {
        this._engagerequest = state;
        this._engageid = playerid;
    }

    public boolean isMarryRequest() {
        return this._marryrequest;
    }

    public void setMarryRequest(boolean state) {
        this._marryrequest = state;
    }

    public boolean isMarryAccepted() {
        return this._marryaccepted;
    }

    public void setMarryAccepted(boolean state) {
        this._marryaccepted = state;
    }

    public int getEngageId() {
        return this._engageid;
    }

    public int getPartnerId() {
        return this._partnerId;
    }

    public void setPartnerId(int partnerid) {
        this._partnerId = partnerid;
    }

    public int getCoupleId() {
        return this._coupleId;
    }

    public void setCoupleId(int coupleId) {
        this._coupleId = coupleId;
    }

    public void engageAnswer(int answer) {
        if (!this._engagerequest) {
            return;
        }
        if (this._engageid == 0) {
            return;
        }
        L2PcInstance ptarget = L2World.getInstance().getPlayer(this._engageid);
        this.setEngageRequest(false, 0);
        if (ptarget != null) {
            if (answer == 1) {
                CoupleManager.getInstance().createCouple(ptarget, this);
                ptarget.sendMessage("Request to Engage has been >ACCEPTED<");
            } else {
                ptarget.sendMessage("Request to Engage has been >DENIED<!");
            }
        }
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return this.getInventory().getPaperdollItem(7);
    }

    @Override
    public L2Item getSecondaryWeaponItem() {
        L2ItemInstance item = this.getInventory().getPaperdollItem(7);
        if (item != null) {
            return item.getItem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (killer != null) {
            L2PcInstance pk = killer.getActingPlayer();
            if (pk != null) {
                EventDispatcher.getInstance().notifyEventAsync(new PlayerPvPKill(pk, this), this);
                TvTEvent.onKill(killer, this);
                if (L2Event.isParticipant(pk)) {
                    pk.getEventStatus().getKills().add(this);
                }
            }
            this.broadcastStatusUpdate();
            this.setExpBeforeDeath(0L);
            if (this.isCursedWeaponEquipped()) {
                CursedWeaponsManager.getInstance().drop(this._cursedWeaponEquippedId, killer);
            } else if (this.isCombatFlagEquipped()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    TerritoryWarManager.getInstance().dropCombatFlag(this, true, false);
                } else {
                    Fort fort = FortManager.getInstance().getFort(this);
                    if (fort != null) {
                        FortSiegeManager.getInstance().dropCombatFlag(this, fort.getResidenceId());
                    } else {
                        int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                        this.getInventory().unEquipItemInBodySlot(slot);
                        this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                    }
                }
            } else {
                boolean insidePvpZone = this.isInsideZone(ZoneId.PVP);
                boolean insideSiegeZone = this.isInsideZone(ZoneId.SIEGE);
                if (pk == null || !pk.isCursedWeaponEquipped()) {
                    this.onDieDropItem(killer);
                    if (!insidePvpZone && !insideSiegeZone && pk != null && pk.getClan() != null && this.getClan() != null && !this.isAcademyMember() && !pk.isAcademyMember() && (this._clan.isAtWarWith(pk.getClanId()) && pk.getClan().isAtWarWith(this._clan.getId()) || this.isInSiege() && pk.isInSiege()) && AntiFeedManager.getInstance().check(killer, this)) {
                        if (this.getClan().getReputationScore() > 0) {
                            pk.getClan().addReputationScore(Configuration.clan().getReputationScorePerKill(), false);
                        }
                        if (pk.getClan().getReputationScore() > 0) {
                            this._clan.takeReputationScore(Configuration.clan().getReputationScorePerKill(), false);
                        }
                    }
                    if (!(!Configuration.character().delevel() || this.isLucky() || insideSiegeZone || insidePvpZone || this.getHuntingSystem().isNevitBlessingActive())) {
                        this.calculateDeathExpPenalty(killer, this.isAtWarWith(pk));
                    }
                }
            }
        }
        if (this.isMounted()) {
            this.stopFeed();
        }
        L2PcInstance l2PcInstance = this;
        synchronized (l2PcInstance) {
            if (this.isFakeDeath()) {
                this.stopFakeDeath(true);
            }
        }
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift()) {
            this.getParty().getDimensionalRift().getDeadMemberList().add(this);
        }
        if (this.getAgathionId() != 0) {
            this.setAgathionId(0);
        }
        this.calculateDeathPenaltyBuffLevel(killer);
        this.stopRentPet();
        this.stopWaterTask();
        AntiFeedManager.getInstance().setLastDeathTime(this.getObjectId());
        return true;
    }

    private void onDieDropItem(L2Character killer) {
        if (L2Event.isParticipant(this) || killer == null) {
            return;
        }
        L2PcInstance pk = killer.getActingPlayer();
        if (this.getKarma() <= 0 && pk != null && pk.getClan() != null && this.getClan() != null && pk.getClan().isAtWarWith(this.getClanId())) {
            return;
        }
        if (!(this.isInsideZone(ZoneId.PVP) && pk != null || this.isGM() && !Configuration.pvp().canGMDropEquipment())) {
            boolean isKarmaDrop = false;
            boolean isKillerNpc = killer instanceof L2Npc;
            int pkLimit = Configuration.pvp().getMinimumPKRequiredToDrop();
            int dropEquip = 0;
            int dropEquipWeapon = 0;
            int dropItem = 0;
            int dropLimit = 0;
            int dropPercent = 0;
            if (this.getKarma() > 0 && this.getPkKills() >= pkLimit) {
                isKarmaDrop = true;
                dropPercent = Configuration.rates().getKarmaRateDrop();
                dropEquip = Configuration.rates().getKarmaRateDropEquip();
                dropEquipWeapon = Configuration.rates().getKarmaRateDropEquipWeapon();
                dropItem = Configuration.rates().getKarmaRateDropItem();
                dropLimit = Configuration.rates().getKarmaDropLimit();
            } else if (isKillerNpc && this.getLevel() > 4 && !this.isFestivalParticipant()) {
                dropPercent = Configuration.rates().getPlayerRateDrop();
                dropEquip = Configuration.rates().getPlayerRateDropEquip();
                dropEquipWeapon = Configuration.rates().getPlayerRateDropEquipWeapon();
                dropItem = Configuration.rates().getPlayerRateDropItem();
                dropLimit = Configuration.rates().getPlayerDropLimit();
            }
            if (dropPercent > 0 && Rnd.get((int)100) < dropPercent) {
                int dropCount = 0;
                int itemDropPercent = 0;
                for (L2ItemInstance itemDrop : this.getInventory().getItems()) {
                    if (itemDrop.isShadowItem() || itemDrop.isTimeLimitedItem() || !itemDrop.isDroppable() || itemDrop.getId() == 57 || itemDrop.getItem().getType2() == ItemType2.QUEST || this.hasSummon() && this.getSummon().getControlObjectId() == itemDrop.getObjectId() || Configuration.pvp().getNonDroppableItems().contains(itemDrop.getId()) || Configuration.pvp().getPetItems().contains(itemDrop.getId())) continue;
                    if (itemDrop.isEquipped()) {
                        itemDropPercent = itemDrop.getItem().getType2() == ItemType2.WEAPON ? dropEquipWeapon : dropEquip;
                        this.getInventory().unEquipItemInSlot(itemDrop.getLocationSlot());
                    } else {
                        itemDropPercent = dropItem;
                    }
                    if (Rnd.get((int)100) >= itemDropPercent) continue;
                    this.dropItem("DieDrop", itemDrop, killer, true);
                    if (isKarmaDrop) {
                        LOG.info("{} has karma and dropped id = {}, count = {}", this, itemDrop.getId(), itemDrop.getCount());
                    } else {
                        LOG.info("{} dropped id = {}, count = {}", this, itemDrop.getId(), itemDrop.getCount());
                    }
                    if (++dropCount >= dropLimit) break;
                }
            }
        }
    }

    public void onKillUpdatePvPKarma(L2Character target) {
        if (target == null || !target.isPlayable()) {
            return;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null || targetPlayer == this) {
            return;
        }
        if (this.isCursedWeaponEquipped() && target.isPlayer()) {
            CursedWeaponsManager.getInstance().increaseKills(this._cursedWeaponEquippedId);
            return;
        }
        if (this.isInDuel() && targetPlayer.isInDuel()) {
            return;
        }
        if (this.isInsideZone(ZoneId.PVP) || targetPlayer.isInsideZone(ZoneId.PVP)) {
            if (this.getSiegeState() > 0 && targetPlayer.getSiegeState() > 0 && this.getSiegeState() != targetPlayer.getSiegeState()) {
                L2Clan killerClan = this.getClan();
                L2Clan targetClan = targetPlayer.getClan();
                if (killerClan != null && targetClan != null) {
                    killerClan.addSiegeKill();
                    targetClan.addSiegeDeath();
                }
            }
            return;
        }
        if (this.checkIfPvP(target) && targetPlayer.getPvpFlag() != 0 || this.isInsideZone(ZoneId.PVP) && targetPlayer.isInsideZone(ZoneId.PVP)) {
            this.increasePvpKills(target);
        } else {
            if (targetPlayer.getClan() != null && this.getClan() != null && this.getClan().isAtWarWith(targetPlayer.getClanId()) && targetPlayer.getClan().isAtWarWith(this.getClanId()) && targetPlayer.getPledgeType() != -1 && this.getPledgeType() != -1) {
                this.increasePvpKills(target);
                return;
            }
            if (targetPlayer.getKarma() > 0) {
                if (Configuration.pvp().awardPKKillPVPPoint()) {
                    this.increasePvpKills(target);
                }
            } else if (targetPlayer.getPvpFlag() == 0) {
                this.increasePkKillsAndKarma(target);
                this.stopPvPFlag();
                this.checkItemRestriction();
            }
        }
    }

    public void increasePvpKills(L2Character target) {
        if (target instanceof L2PcInstance && AntiFeedManager.getInstance().check(this, target)) {
            this.setPvpKills(this.getPvpKills() + 1);
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
    }

    public void increasePkKillsAndKarma(L2Character target) {
        if (target == null || !target.isPlayable()) {
            return;
        }
        this.setKarma(this.getKarma() + Formulas.calculateKarmaGain(this.getPkKills(), target.isSummon()));
        if (target.isPlayer()) {
            this.setPkKills(this.getPkKills() + 1);
        }
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public void updatePvPStatus() {
        if (this.isInsideZone(ZoneId.PVP)) {
            return;
        }
        this.setPvpFlagLasts(System.currentTimeMillis() + (long)Configuration.pvp().getPvPVsNormalTime());
        if (this.getPvpFlag() == 0) {
            this.startPvPFlag();
        }
    }

    public void updatePvPStatus(L2Character target) {
        L2PcInstance player_target = target.getActingPlayer();
        if (player_target == null) {
            return;
        }
        if (this.isInDuel() && player_target.getDuelId() == this.getDuelId()) {
            return;
        }
        if (!(this.isInsideZone(ZoneId.PVP) && player_target.isInsideZone(ZoneId.PVP) || player_target.getKarma() != 0)) {
            if (this.checkIfPvP(player_target)) {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Configuration.pvp().getPvPVsPvPTime());
            } else {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Configuration.pvp().getPvPVsNormalTime());
            }
            if (this.getPvpFlag() == 0) {
                this.startPvPFlag();
            }
        }
    }

    public boolean isLucky() {
        return this.getLevel() <= 9 && this.isAffectedBySkill(CommonSkill.LUCKY.getId());
    }

    public void restoreExp(double restorePercent) {
        if (this.getExpBeforeDeath() > 0L) {
            this.getSubStat().addExp(Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * restorePercent / 100.0));
            this.setExpBeforeDeath(0L);
        }
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        this.addExpAndSp(addToExp, addToSp, false);
    }

    public void addExpAndSpQuest(long addToExp, int addToSp) {
        SystemMessage sm;
        if (addToExp != 0L) {
            this.getSubStat().addExp(addToExp);
            sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_EXPERIENCE);
            sm.addLong(addToExp);
            this.sendPacket(sm);
        }
        if (addToSp != 0) {
            this.getSubStat().addSp(addToSp);
            sm = SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_S1_SP);
            sm.addInt(addToSp);
            this.sendPacket(sm);
        }
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public void removeExpAndSp(long removeFromExp, int removeFromSp) {
        this.getSubStat().removeExp(removeFromExp);
        this.getSubStat().removeSp(removeFromSp);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public void addExpAndSp(long addToExp, int addToSp, boolean useBonuses) {
        if (!this.getAccessLevel().canGainExp()) {
            return;
        }
        this.changeKarma(addToExp);
        long baseExp = addToExp;
        int baseSp = addToSp;
        if (useBonuses) {
            addToExp = (long)((double)addToExp * this.getStat().getExpBonusMultiplier());
            addToSp = (int)((double)addToSp * this.getStat().getSpBonusMultiplier());
        }
        float ratioTakenByPlayer = 0.0f;
        if (this.hasPet() && Util.checkIfInShortRadius(Configuration.character().getPartyRange(), this, this.getSummon(), false)) {
            L2PetInstance pet = (L2PetInstance)this.getSummon();
            ratioTakenByPlayer = (float)pet.getPetLevelData().getOwnerExpTaken() / 100.0f;
            if (ratioTakenByPlayer > 1.0f) {
                ratioTakenByPlayer = 1.0f;
            }
            if (!pet.isDead()) {
                pet.addExpAndSp((long)((float)addToExp * (1.0f - ratioTakenByPlayer)), (int)((float)addToSp * (1.0f - ratioTakenByPlayer)));
            }
            baseExp = (long)((float)addToExp * ratioTakenByPlayer);
            baseSp = (int)((float)addToSp * ratioTakenByPlayer);
            addToExp = (long)((float)addToExp * ratioTakenByPlayer);
            addToSp = (int)((float)addToSp * ratioTakenByPlayer);
        }
        boolean gainedExp = this.getSubStat().addExp(addToExp);
        this.getSubStat().addSp(addToSp);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_EARNED_S1_EXP_BONUS_S2_AND_S3_SP_BONUS_S4);
        if (gainedExp) {
            sm.addLong(addToExp);
            sm.addLong(addToExp - baseExp);
        } else {
            sm.addLong(0L);
            sm.addLong(0L);
        }
        sm.addInt(addToSp);
        sm.addInt(addToSp - baseSp);
        this.sendPacket(sm);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public void removeExp(long exp) {
        this.changeKarma(exp);
        this.getSubStat().removeExp(exp);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    private void changeKarma(long exp) {
        int karmaLost;
        if (!(this.isCursedWeaponEquipped() || this.getKarma() <= 0 || !this.isGM() && this.isInsideZone(ZoneId.PVP) || (karmaLost = Formulas.calculateKarmaLost(this, exp)) <= 0)) {
            this.setKarma(this.getKarma() - karmaLost);
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_KARMA_HAS_BEEN_CHANGED_TO_S1);
            msg.addInt(this.getKarma());
            this.sendPacket(msg);
        }
    }

    public boolean removeSp(int sp) {
        return this.getSubStat().removeSp(sp);
    }

    public void calculateDeathExpPenalty(L2Character killer, boolean atWar) {
        int lvl = this.getLevel();
        double percentLost = PlayerXpPercentLostData.getInstance().getXpPercent(this.getLevel());
        if (killer != null) {
            if (killer.isRaid()) {
                percentLost *= this.calcStat(Stats.REDUCE_EXP_LOST_BY_RAID, 1.0);
            } else if (killer.isMonster()) {
                percentLost *= this.calcStat(Stats.REDUCE_EXP_LOST_BY_MOB, 1.0);
            } else if (killer.isPlayable()) {
                percentLost *= this.calcStat(Stats.REDUCE_EXP_LOST_BY_PVP, 1.0);
            }
        }
        if (this.getKarma() > 0) {
            percentLost *= Configuration.rates().getRateKarmaExpLost();
        }
        long lostExp = 0L;
        if (!L2Event.isParticipant(this)) {
            lostExp = this.getHuntingSystem().isNevitBlessingActive() ? 0L : (lvl < Configuration.character().getMaxPlayerLevel() ? Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0) : Math.round((double)(this.getStat().getExpForLevel(Configuration.character().getMaxPlayerLevel() + 1) - this.getStat().getExpForLevel(Configuration.character().getMaxPlayerLevel())) * percentLost / 100.0));
        }
        if (this.isFestivalParticipant() || atWar) {
            lostExp = (long)((double)lostExp / 4.0);
        }
        this.setExpBeforeDeath(this.getExp());
        this.removeExp(lostExp);
    }

    public boolean isPartyWaiting() {
        return PartyMatchWaitingList.getInstance().getPlayers().contains(this);
    }

    public int getPartyRoom() {
        return this._partyroom;
    }

    public void setPartyRoom(int id) {
        this._partyroom = id;
    }

    public boolean isInPartyMatchRoom() {
        return this._partyroom > 0;
    }

    public void stopAllTimers() {
        this.stopHpMpRegeneration();
        this.stopWarnUserTakeBreak();
        this.stopWaterTask();
        this.stopFeed();
        DAOFactory.getInstance().getPetDAO().updateFood(this, this._mountNpcId);
        this.stopRentPet();
        this.stopPvpRegTask();
        this.stopSoulTask();
        this.stopChargeTask();
        this.stopFameTask();
        this.stopVitalityTask();
        this.getRecSystem().stopBonusTask(false);
        this.getRecSystem().stopGiveTask();
    }

    @Override
    public L2Summon getSummon() {
        return this._summon;
    }

    public L2Decoy getDecoy() {
        return this._decoy;
    }

    public void setDecoy(L2Decoy decoy) {
        this._decoy = decoy;
    }

    public L2TrapInstance getTrap() {
        return this._trap;
    }

    public void setTrap(L2TrapInstance trap) {
        this._trap = trap;
    }

    public void setPet(L2Summon summon) {
        this._summon = summon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<L2TamedBeastInstance> getTamedBeasts() {
        if (this._tamedBeasts == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._tamedBeasts == null) {
                    this._tamedBeasts = ConcurrentHashMap.newKeySet(1);
                }
            }
        }
        return this._tamedBeasts;
    }

    public boolean hasTamedBeasts() {
        return this._tamedBeasts != null && !this._tamedBeasts.isEmpty();
    }

    public void addTamedBeast(L2TamedBeastInstance tamedBeast) {
        this.getTamedBeasts().add(tamedBeast);
    }

    public void removeTamedBeast(L2TamedBeastInstance tamedBeast) {
        if (this.hasTamedBeasts()) {
            this._tamedBeasts.remove(tamedBeast);
        }
    }

    public L2Request getRequest() {
        return this._request;
    }

    public L2PcInstance getActiveRequester() {
        L2PcInstance requester = this._activeRequester;
        if (requester != null && requester.isRequestExpired() && this._activeTradeList == null) {
            this._activeRequester = null;
        }
        return this._activeRequester;
    }

    public void setActiveRequester(L2PcInstance requester) {
        this._activeRequester = requester;
    }

    public boolean isProcessingRequest() {
        return this.getActiveRequester() != null || this._requestExpireTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public boolean isProcessingTransaction() {
        return this.getActiveRequester() != null || this._activeTradeList != null || this._requestExpireTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public void onTransactionRequest(L2PcInstance partner) {
        this._requestExpireTime = GameTimeController.getInstance().getGameTicks() + 150;
        partner.setActiveRequester(this);
    }

    public boolean isRequestExpired() {
        return this._requestExpireTime <= (long)GameTimeController.getInstance().getGameTicks();
    }

    public void onTransactionResponse() {
        this._requestExpireTime = 0L;
    }

    public ItemContainer getActiveWarehouse() {
        return this._activeWarehouse;
    }

    public void setActiveWarehouse(ItemContainer warehouse) {
        this._activeWarehouse = warehouse;
    }

    public TradeList getActiveTradeList() {
        return this._activeTradeList;
    }

    public void setActiveTradeList(TradeList tradeList) {
        this._activeTradeList = tradeList;
    }

    public void onTradeStart(L2PcInstance partner) {
        this._activeTradeList = new TradeList(this);
        this._activeTradeList.setPartner(partner);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.BEGIN_TRADE_WITH_C1);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(new TradeStart(this));
    }

    public void onTradeConfirm(L2PcInstance partner) {
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CONFIRMED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(TradeOtherDone.STATIC_PACKET);
    }

    public void onTradeCancel(L2PcInstance partner) {
        if (this._activeTradeList == null) {
            return;
        }
        this._activeTradeList.lock();
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(0));
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CANCELED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
    }

    public void onTradeFinish(boolean successfull) {
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(1));
        if (successfull) {
            this.sendPacket(SystemMessageId.TRADE_SUCCESSFUL);
        }
    }

    public void startTrade(L2PcInstance partner) {
        this.onTradeStart(partner);
        partner.onTradeStart(this);
    }

    public void cancelActiveTrade() {
        if (this._activeTradeList == null) {
            return;
        }
        L2PcInstance partner = this._activeTradeList.getPartner();
        if (partner != null) {
            partner.onTradeCancel(this);
        }
        this.onTradeCancel(this);
    }

    public boolean hasManufactureShop() {
        return this._manufactureItems != null && !this._manufactureItems.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, L2ManufactureItem> getManufactureItems() {
        if (this._manufactureItems == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._manufactureItems == null) {
                    this._manufactureItems = Collections.synchronizedMap(new LinkedHashMap());
                }
            }
        }
        return this._manufactureItems;
    }

    public String getStoreName() {
        return this._storeName;
    }

    public void setStoreName(String name) {
        this._storeName = name == null ? "" : name;
    }

    public TradeList getSellList() {
        if (this._sellList == null) {
            this._sellList = new TradeList(this);
        }
        return this._sellList;
    }

    public TradeList getBuyList() {
        if (this._buyList == null) {
            this._buyList = new TradeList(this);
        }
        return this._buyList;
    }

    public PrivateStoreType getPrivateStoreType() {
        return this._privateStoreType;
    }

    public void setPrivateStoreType(PrivateStoreType privateStoreType) {
        this._privateStoreType = privateStoreType;
        if (Configuration.customs().offlineDisconnectFinished() && privateStoreType == PrivateStoreType.NONE && (this.getClient() == null || this.getClient().isDetached())) {
            this.deleteMe();
        }
    }

    @Override
    public L2Clan getClan() {
        return this._clan;
    }

    public void setClan(L2Clan clan) {
        this._clan = clan;
        if (clan == null) {
            this._clanId = 0;
            this._clanPrivileges = new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false);
            this._pledgeType = 0;
            this._powerGrade = 0;
            this._lvlJoinedAcademy = 0;
            this._apprentice = 0;
            this._sponsor = 0;
            this._activeWarehouse = null;
            return;
        }
        if (!clan.isMember(this.getObjectId())) {
            this.setClan(null);
            return;
        }
        this._clanId = clan.getId();
    }

    public boolean isClanLeader() {
        if (this.getClan() == null) {
            return false;
        }
        return this.getObjectId() == this.getClan().getLeaderId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reduceArrowCount(boolean bolts) {
        L2ItemInstance arrows = this.getInventory().getPaperdollItem(7);
        if (arrows == null) {
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (arrows.getCount() > 1L) {
            L2ItemInstance l2ItemInstance = arrows;
            synchronized (l2ItemInstance) {
                arrows.changeCountWithoutTrace(-1, this, null);
                arrows.setLastChange(2);
                if (GameTimeController.getInstance().getGameTicks() % 10 == 0) {
                    arrows.updateDatabase();
                }
                this._inventory.refreshWeight();
            }
        } else {
            this._inventory.destroyItem("Consume", arrows, this, null);
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(arrows);
            this.sendPacket(iu);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
    }

    @Override
    protected boolean checkAndEquipArrows() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._arrowItem = this.getInventory().findArrowForBow(this.getActiveWeaponItem());
            if (this._arrowItem != null) {
                this.getInventory().setPaperdollItem(7, this._arrowItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._arrowItem = this.getInventory().getPaperdollItem(7);
        }
        return this._arrowItem != null;
    }

    @Override
    protected boolean checkAndEquipBolts() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._boltItem = this.getInventory().findBoltForCrossBow(this.getActiveWeaponItem());
            if (this._boltItem != null) {
                this.getInventory().setPaperdollItem(7, this._boltItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._boltItem = this.getInventory().getPaperdollItem(7);
        }
        return this._boltItem != null;
    }

    public boolean disarmWeapons() {
        L2ItemInstance wpn = this.getInventory().getPaperdollItem(5);
        if (wpn == null) {
            return true;
        }
        if (this.isCursedWeaponEquipped()) {
            return false;
        }
        if (this.isCombatFlagEquipped()) {
            return false;
        }
        if (wpn.getWeaponItem().isForceEquip()) {
            return false;
        }
        L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(wpn.getItem().getBodyPart());
        InventoryUpdate iu = new InventoryUpdate();
        for (L2ItemInstance itm : unequiped) {
            iu.addModifiedItem(itm);
        }
        this.sendPacket(iu);
        this.abortAttack();
        this.broadcastUserInfo();
        if (unequiped.length > 0) {
            SystemMessage sm;
            if (unequiped[0].getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(unequiped[0].getEnchantLevel());
                sm.addItemName(unequiped[0]);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(unequiped[0]);
            }
            this.sendPacket(sm);
        }
        return true;
    }

    public boolean disarmShield() {
        L2ItemInstance sld = this.getInventory().getPaperdollItem(7);
        if (sld != null) {
            L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(sld.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            this.sendPacket(iu);
            this.abortAttack();
            this.broadcastUserInfo();
            if (unequiped.length > 0) {
                SystemMessage sm = null;
                if (unequiped[0].getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                    sm.addInt(unequiped[0].getEnchantLevel());
                    sm.addItemName(unequiped[0]);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                    sm.addItemName(unequiped[0]);
                }
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public boolean mount(L2Summon pet) {
        if (!this.disarmWeapons() || !this.disarmShield() || this.isTransformed()) {
            return false;
        }
        this.getEffectList().stopAllToggles();
        this.setMount(pet.getId(), pet.getLevel());
        this.setMountObjectID(pet.getControlObjectId());
        this.startFeed(pet.getId());
        this.broadcastPacket(new Ride(this));
        this.broadcastUserInfo();
        pet.unSummon(this);
        return true;
    }

    public boolean mount(int npcId, int controlItemObjId, boolean useFood) {
        if (!this.disarmWeapons() || !this.disarmShield() || this.isTransformed()) {
            return false;
        }
        this.getEffectList().stopAllToggles();
        this.setMount(npcId, this.getLevel());
        this.setMountObjectID(controlItemObjId);
        this.broadcastPacket(new Ride(this));
        this.broadcastUserInfo();
        if (useFood) {
            this.startFeed(npcId);
        }
        return true;
    }

    public boolean mountPlayer(L2Summon pet) {
        if (pet != null && pet.isMountable() && !this.isMounted() && !this.isBetrayed()) {
            if (this.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_DEAD);
                return false;
            }
            if (pet.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.DEAD_STRIDER_CANT_BE_RIDDEN);
                return false;
            }
            if (pet.isInCombat() || pet.isRooted()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_IN_BATLLE_CANT_BE_RIDDEN);
                return false;
            }
            if (this.isInCombat()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_IN_BATTLE);
                return false;
            }
            if (this.isSitting()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CAN_BE_RIDDEN_ONLY_WHILE_STANDING);
                return false;
            }
            if (this.isFishing()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_2);
                return false;
            }
            if (this.isTransformed() || this.isCursedWeaponEquipped()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.getInventory().getItemByItemId(9819) != null) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendMessage("You cannot mount a steed while holding a flag.");
                return false;
            }
            if (pet.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT);
                return false;
            }
            if (!Util.checkIfInRange(200, this, pet, true)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.TOO_FAR_AWAY_FROM_FENRIR_TO_MOUNT);
                return false;
            }
            if (!pet.isDead() && !this.isMounted()) {
                this.mount(pet);
            }
        } else if (this.isRentedPet()) {
            this.stopRentPet();
        } else if (this.isMounted()) {
            if (this.getMountType() == MountType.WYVERN && this.isInsideZone(ZoneId.NO_LANDING)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.NO_DISMOUNT_HERE);
                return false;
            }
            if (this.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT);
                return false;
            }
            this.dismount();
        }
        return true;
    }

    public boolean dismount() {
        boolean wasFlying = this.isFlying();
        this.sendPacket(new SetupGauge(3, 0, 0));
        int petId = this._mountNpcId;
        this.setMount(0, 0);
        this.stopFeed();
        if (wasFlying) {
            this.removeSkill(CommonSkill.WYVERN_BREATH.getSkill());
        }
        this.broadcastPacket(new Ride(this));
        this.setMountObjectID(0);
        DAOFactory.getInstance().getPetDAO().updateFood(this, petId);
        this.broadcastUserInfo();
        return true;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._uptime;
    }

    public void setUptime(long time) {
        this._uptime = time;
    }

    @Override
    public boolean isInvul() {
        return super.isInvul() || this._isTeleporting;
    }

    @Override
    public boolean isInParty() {
        return this._party != null;
    }

    public void joinParty(L2Party party) {
        if (party != null) {
            this._party = party;
            party.addPartyMember(this);
        }
    }

    public void leaveParty() {
        if (this.isInParty()) {
            this._party.removePartyMember(this, L2Party.messageType.Disconnected);
            this._party = null;
        }
    }

    @Override
    public L2Party getParty() {
        return this._party;
    }

    public void setParty(L2Party party) {
        this._party = party;
    }

    public PartyDistributionType getPartyDistributionType() {
        return this._partyDistributionType;
    }

    public void setPartyDistributionType(PartyDistributionType pdt) {
        this._partyDistributionType = pdt;
    }

    @Override
    public boolean isGM() {
        return this.getAccessLevel().isGm();
    }

    public void setAccountAccesslevel(int level) {
        LoginServerThread.getInstance().sendAccessLevel(this.getAccountName(), level);
    }

    @Override
    public L2AccessLevel getAccessLevel() {
        if (Configuration.general().everybodyHasAdminRights()) {
            return AdminData.getInstance().getMasterAccessLevel();
        }
        if (this._accessLevel == null) {
            this.setAccessLevel(0);
        }
        return this._accessLevel;
    }

    public void setAccessLevel(int level) {
        this._accessLevel = AdminData.getInstance().getAccessLevel(level);
        this.getAppearance().setNameColor(this._accessLevel.getNameColor());
        this.getAppearance().setTitleColor(this._accessLevel.getTitleColor());
        this.broadcastUserInfo();
        CharNameTable.getInstance().addName(this);
        if (!AdminData.getInstance().hasAccessLevel(level)) {
            LOG.warn("Tried to set unregistered access level {} for {}. Setting access level without privileges!", (Object)level, (Object)this);
        } else if (level > 0) {
            LOG.info("{} access level set for character {}.", (Object)this._accessLevel.getName(), (Object)this);
        }
    }

    public void updateAndBroadcastStatus(int broadcastType) {
        this.refreshOverloaded();
        this.refreshExpertisePenalty();
        if (broadcastType == 1) {
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
        if (broadcastType == 2) {
            this.broadcastUserInfo();
        }
    }

    public void setKarmaFlag(int flag) {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void broadcastKarma() {
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(27, this.getKarma());
        this.sendPacket(su);
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void setOnlineStatus(boolean isOnline, boolean updateInDb) {
        if (this._isOnline != isOnline) {
            this._isOnline = isOnline;
        }
        if (updateInDb) {
            DAOFactory.getInstance().getPlayerDAO().updateOnlineStatus(this);
        }
    }

    public void setIsIn7sDungeon(boolean isIn7sDungeon) {
        this._isIn7sDungeon = isIn7sDungeon;
    }

    public Forum getMail() {
        if (this._forumMail == null) {
            Forum mailRootForum = ForumsBBSManager.getInstance().getForumByName("MailRoot");
            this.setMail(mailRootForum.getChildByName(this.getName()));
            if (this._forumMail == null) {
                ForumsBBSManager.getInstance().create(this.getName(), mailRootForum, ForumType.MAIL, ForumVisibility.OWNER_ONLY, this.getObjectId());
                this.setMail(mailRootForum.getChildByName(this.getName()));
            }
        }
        return this._forumMail;
    }

    public void setMail(Forum forum) {
        this._forumMail = forum;
    }

    public Forum getMemo() {
        if (this._forumMemo == null) {
            Forum memoRootForum = ForumsBBSManager.getInstance().getForumByName("MemoRoot");
            this.setMemo(memoRootForum.getChildByName(this._accountName));
            if (this._forumMemo == null) {
                ForumsBBSManager.getInstance().create(this._accountName, memoRootForum, ForumType.MEMO, ForumVisibility.OWNER_ONLY, this.getObjectId());
                this.setMemo(memoRootForum.getChildByName(this._accountName));
            }
        }
        return this._forumMemo;
    }

    public void setMemo(Forum forum) {
        this._forumMemo = forum;
    }

    public Map<Integer, L2PremiumItem> getPremiumItemList() {
        return this._premiumItems;
    }

    public synchronized void store(boolean storeActiveEffects) {
        AccountVariables aVars;
        DAOFactory.getInstance().getPlayerDAO().storeCharBase(this);
        DAOFactory.getInstance().getSubclassDAO().update(this);
        this.storeEffect(storeActiveEffects);
        DAOFactory.getInstance().getItemReuseDAO().insert(this);
        if (Configuration.character().storeRecipeShopList()) {
            DAOFactory.getInstance().getRecipeShopListDAO().delete(this);
            DAOFactory.getInstance().getRecipeShopListDAO().insert(this);
        }
        if (Configuration.character().storeUISettings()) {
            this.storeUISettings();
        }
        SevenSigns.getInstance().saveSevenSignsData(this.getObjectId());
        PlayerVariables vars = this.getScript(PlayerVariables.class);
        if (vars != null) {
            vars.storeMe();
        }
        if ((aVars = this.getScript(AccountVariables.class)) != null) {
            aVars.storeMe();
        }
    }

    @Override
    public void storeMe() {
        this.store(true);
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        if (!Configuration.character().storeSkillCooltime()) {
            return;
        }
        DAOFactory.getInstance().getPlayerSkillSaveDAO().delete(this);
        DAOFactory.getInstance().getPlayerSkillSaveDAO().insert(this, storeEffects);
    }

    public boolean isOnline() {
        return this._isOnline;
    }

    public int isOnlineInt() {
        if (this._isOnline && this._client != null) {
            return this._client.isDetached() ? 2 : 1;
        }
        return 0;
    }

    public boolean isInOfflineMode() {
        return this._client == null || this._client.isDetached();
    }

    public boolean isIn7sDungeon() {
        return this._isIn7sDungeon;
    }

    @Override
    public Skill addSkill(Skill newSkill) {
        this.addCustomSkill(newSkill);
        return super.addSkill(newSkill);
    }

    public Skill addSkill(Skill newSkill, boolean store) {
        Skill oldSkill = this.addSkill(newSkill);
        if (store) {
            this.storeSkill(newSkill, oldSkill, -1);
        }
        return oldSkill;
    }

    @Override
    public Skill removeSkill(Skill skill, boolean store) {
        this.removeCustomSkill(skill);
        return store ? this.removeSkill(skill) : super.removeSkill(skill, true);
    }

    public Skill removeSkill(Skill skill, boolean store, boolean cancelEffect) {
        this.removeCustomSkill(skill);
        return store ? this.removeSkill(skill) : super.removeSkill(skill, cancelEffect);
    }

    public Skill removeSkill(Skill skill) {
        this.removeCustomSkill(skill);
        Skill oldSkill = super.removeSkill(skill, true);
        if (oldSkill != null) {
            DAOFactory.getInstance().getSkillDAO().delete(this, oldSkill);
        }
        if (this.getTransformationId() > 0 || this.isCursedWeaponEquipped()) {
            return oldSkill;
        }
        if (skill != null) {
            for (Shortcut sc : this.getAllShortCuts()) {
                if (sc == null || sc.getId() != skill.getId() || sc.getType() != ShortcutType.SKILL || skill.getId() >= 3080 && skill.getId() <= 3259) continue;
                this.deleteShortCut(sc.getSlot(), sc.getPage());
            }
        }
        return oldSkill;
    }

    private void storeSkill(Skill newSkill, Skill oldSkill, int newClassIndex) {
        int classIndex;
        int n = classIndex = newClassIndex > -1 ? newClassIndex : this._classIndex;
        if (oldSkill != null && newSkill != null) {
            DAOFactory.getInstance().getSkillDAO().update(this, classIndex, newSkill, oldSkill);
        } else if (newSkill != null) {
            DAOFactory.getInstance().getSkillDAO().insert(this, classIndex, newSkill);
        } else {
            LOG.warn("Could not store new skill, it's null!");
        }
    }

    @Override
    public void restoreEffects() {
        DAOFactory.getInstance().getPlayerSkillSaveDAO().load(this);
        DAOFactory.getInstance().getPlayerSkillSaveDAO().delete(this);
    }

    public int getHennaEmptySlots() {
        int totalSlots = 0;
        totalSlots = this.getClassId().level() == 1 ? 2 : 3;
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            --totalSlots;
        }
        if (totalSlots <= 0) {
            return 0;
        }
        return totalSlots;
    }

    public boolean removeHenna(int slot) {
        L2Henna henna;
        if (slot < 1 || slot > 3) {
            return false;
        }
        if ((henna = this._henna[--slot]) == null) {
            return false;
        }
        this._henna[slot] = null;
        DAOFactory.getInstance().getHennaDAO().delete(this, slot + 1);
        this.recalcHennaStats();
        this.sendPacket(new HennaInfo(this));
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.getInventory().addItem("Henna", henna.getDyeItemId(), henna.getCancelCount(), this, null);
        this.reduceAdena("Henna", henna.getCancelFee(), this, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
        sm.addItemName(henna.getDyeItemId());
        sm.addLong(henna.getCancelCount());
        this.sendPacket(sm);
        this.sendPacket(SystemMessageId.SYMBOL_DELETED);
        EventDispatcher.getInstance().notifyEventAsync(new PlayerHennaRemove(this, henna), this);
        return true;
    }

    public boolean addHenna(L2Henna henna) {
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] != null) continue;
            this._henna[i] = henna;
            this.recalcHennaStats();
            DAOFactory.getInstance().getHennaDAO().insert(this, henna, i + 1);
            this.sendPacket(new HennaInfo(this));
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
            EventDispatcher.getInstance().notifyEventAsync(new PlayerHennaRemove(this, henna), this);
            return true;
        }
        return false;
    }

    public void recalcHennaStats() {
        this._hennaINT = 0;
        this._hennaSTR = 0;
        this._hennaCON = 0;
        this._hennaMEN = 0;
        this._hennaWIT = 0;
        this._hennaDEX = 0;
        for (L2Henna h : this._henna) {
            if (h == null) continue;
            this._hennaINT += this._hennaINT + h.getStatINT() > 5 ? 5 - this._hennaINT : h.getStatINT();
            this._hennaSTR += this._hennaSTR + h.getStatSTR() > 5 ? 5 - this._hennaSTR : h.getStatSTR();
            this._hennaMEN += this._hennaMEN + h.getStatMEN() > 5 ? 5 - this._hennaMEN : h.getStatMEN();
            this._hennaCON += this._hennaCON + h.getStatCON() > 5 ? 5 - this._hennaCON : h.getStatCON();
            this._hennaWIT += this._hennaWIT + h.getStatWIT() > 5 ? 5 - this._hennaWIT : h.getStatWIT();
            this._hennaDEX += this._hennaDEX + h.getStatDEX() > 5 ? 5 - this._hennaDEX : h.getStatDEX();
        }
    }

    public L2Henna getHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return null;
        }
        return this._henna[slot - 1];
    }

    public boolean hasHennas() {
        for (L2Henna henna : this._henna) {
            if (henna == null) continue;
            return true;
        }
        return false;
    }

    public L2Henna[] getHennaList() {
        return this._henna;
    }

    public int getHennaStatINT() {
        return this._hennaINT;
    }

    public int getHennaStatSTR() {
        return this._hennaSTR;
    }

    public int getHennaStatCON() {
        return this._hennaCON;
    }

    public int getHennaStatMEN() {
        return this._hennaMEN;
    }

    public int getHennaStatWIT() {
        return this._hennaWIT;
    }

    public int getHennaStatDEX() {
        return this._hennaDEX;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker == null) {
            return false;
        }
        if (attacker == this || attacker == this.getSummon()) {
            return false;
        }
        if (attacker instanceof L2FriendlyMobInstance) {
            return false;
        }
        if (attacker.isMonster()) {
            return true;
        }
        if (attacker.isPlayable() && this.getDuelState() == DuelState.DUELLING && this.getDuelId() == attacker.getActingPlayer().getDuelId()) {
            Duel duel = DuelManager.getInstance().getDuel(this.getDuelId());
            if (duel.getTeamA().contains(this) && duel.getTeamA().contains(attacker)) {
                return false;
            }
            return !duel.getTeamB().contains(this) || !duel.getTeamB().contains(attacker);
        }
        if (this.isInParty() && this.getParty().getMembers().contains(attacker)) {
            return false;
        }
        if (attacker.isPlayer() && attacker.getActingPlayer().isInOlympiadMode()) {
            return this.isInOlympiadMode() && this.isOlympiadStart() && ((L2PcInstance)attacker).getOlympiadGameId() == this.getOlympiadGameId();
        }
        if (this.isOnEvent()) {
            return true;
        }
        if (attacker.isPlayable()) {
            if (this.isInsideZone(ZoneId.PEACE)) {
                return false;
            }
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (this.getClan() != null) {
                Siege siege = SiegeManager.getInstance().getSiege(this.getX(), this.getY(), this.getZ());
                if (siege != null) {
                    if (siege.checkIsDefender(attackerPlayer.getClan()) && siege.checkIsDefender(this.getClan())) {
                        return false;
                    }
                    if (siege.checkIsAttacker(attackerPlayer.getClan()) && siege.checkIsAttacker(this.getClan())) {
                        return false;
                    }
                }
                if (this.getClan() != null && attackerPlayer.getClan() != null && this.getClan().isAtWarWith(attackerPlayer.getClanId()) && attackerPlayer.getClan().isAtWarWith(this.getClanId()) && this.getWantsPeace() == 0 && attackerPlayer.getWantsPeace() == 0 && !this.isAcademyMember()) {
                    return true;
                }
            }
            if (this.isInsideZone(ZoneId.PVP) && attackerPlayer.isInsideZone(ZoneId.PVP) && (!this.isInsideZone(ZoneId.SIEGE) || !attackerPlayer.isInsideZone(ZoneId.SIEGE))) {
                return true;
            }
            if (this.getClan() != null && this.getClan().isMember(attacker.getObjectId())) {
                return false;
            }
            if (attacker.isPlayer() && this.getAllyId() != 0 && this.getAllyId() == attackerPlayer.getAllyId()) {
                return false;
            }
            if (this.isInsideZone(ZoneId.PVP) && attackerPlayer.isInsideZone(ZoneId.PVP) && this.isInsideZone(ZoneId.SIEGE) && attackerPlayer.isInsideZone(ZoneId.SIEGE)) {
                return true;
            }
        } else if (attacker instanceof L2DefenderInstance && this.getClan() != null) {
            Siege siege = SiegeManager.getInstance().getSiege(this);
            return siege != null && siege.checkIsAttacker(this.getClan());
        }
        return this.getKarma() > 0 || this.getPvpFlag() > 0;
    }

    @Override
    public boolean useMagic(Skill skill, boolean forceUse, boolean dontMove) {
        if (skill.isPassive()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isCastingNow()) {
            SkillUseHolder currentSkill = this.getCurrentSkill();
            if (currentSkill != null && skill.getId() == currentSkill.getSkillId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isSkillDisabled(skill)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            this.setQueuedSkill(skill, forceUse, dontMove);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        this.setIsCastingNow(true);
        this.setCurrentSkill(skill, forceUse, dontMove);
        if (this.getQueuedSkill() != null) {
            this.setQueuedSkill(null, false, false);
        }
        L2PcInstance target = switch (skill.getTargetType()) {
            case TargetType.GROUND, TargetType.SELF -> this;
            default -> {
                List<L2Object> targets = skill.getTargets(this);
                if (targets.isEmpty()) {
                    yield null;
                }
                yield targets.get(0);
            }
        };
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        return true;
    }

    private boolean checkUseMagicConditions(Skill skill, boolean forceUse, boolean dontMove) {
        L2PcInstance cha;
        if (this.isOutOfControl() || this.isStunned() || this.isSleeping()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFishing() && !skill.hasEffectType(L2EffectType.FISHING, L2EffectType.FISHING_START)) {
            this.sendPacket(SystemMessageId.ONLY_FISHING_SKILLS_NOW);
            return false;
        }
        if (this.inObserverMode()) {
            this.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
            this.abortCast();
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isSitting()) {
            this.sendPacket(SystemMessageId.CANT_MOVE_SITTING);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isToggle() && this.isAffectedBySkill(skill.getId())) {
            this.stopSkillEffects(true, skill.getId());
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFakeDeath()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        L2Object target = null;
        TargetType sklTargetType = skill.getTargetType();
        Location worldPosition = this.getCurrentSkillWorldPosition();
        if (sklTargetType == TargetType.GROUND && worldPosition == null) {
            LOG.warn("WorldPosition is null for {}, {}", (Object)skill.getName(), (Object)this);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case GROUND: 
            case SELF: {
                L2Object l2Object = this;
                break;
            }
            case SUMMON: {
                L2Object l2Object = this.getSummon();
                break;
            }
            default: {
                L2Object l2Object = target = this.getTarget();
            }
        }
        if (target == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (target.isDoor()) {
            L2DoorInstance door = (L2DoorInstance)target;
            if (door.getCastle() != null && door.getCastle().getResidenceId() > 0) {
                if (!door.getCastle().getSiege().isInProgress()) {
                    this.sendPacket(SystemMessageId.INCORRECT_TARGET);
                    return false;
                }
            } else if (!(door.getFort() == null || door.getFort().getResidenceId() <= 0 || door.getFort().getSiege().isInProgress() && door.getIsShowHp())) {
                this.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return false;
            }
        }
        if (this.isInDuel() && (cha = target.getActingPlayer()) != null && cha.getDuelId() != this.getDuelId()) {
            this.sendMessage("You cannot do this while duelling.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isSkillDisabled(skill)) {
            SystemMessage sm;
            if (this.hasSkillReuse(skill.getReuseHashCode())) {
                int remainingTime = (int)(this.getSkillRemainingReuseTime(skill.getReuseHashCode()) / 1000L);
                int hours = remainingTime / 3600;
                int minutes = remainingTime % 3600 / 60;
                int seconds = remainingTime % 60;
                if (hours > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addInt(hours);
                    sm.addInt(minutes);
                } else if (minutes > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addInt(minutes);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                }
                sm.addInt(seconds);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_PREPARED_FOR_REUSE);
                sm.addSkillName(skill);
            }
            this.sendPacket(sm);
            return false;
        }
        if (!skill.checkCondition(this, target, false)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isBad()) {
            if (this.isInsidePeaceZone(this, target) && !this.getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isInOlympiadMode() && !this.isOlympiadStart()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target.getActingPlayer() != null && this.getSiegeState() > 0 && this.isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeState() == this.getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == this.getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
                } else {
                    this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!(target.canBeAttacked() || this.getAccessLevel().allowPeaceAttack() || target.isDoor())) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target instanceof L2EventMonsterInstance && ((L2EventMonsterInstance)target).eventSkillAttackBlocked()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!target.isAutoAttackable(this) && !forceUse) {
                switch (sklTargetType) {
                    case GROUND: 
                    case SELF: 
                    case DOOR_TREASURE: {
                        break;
                    }
                    default: {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                }
            }
            if (dontMove) {
                if (sklTargetType == TargetType.GROUND) {
                    if (!this.isInsideRadius(worldPosition.getX(), worldPosition.getY(), worldPosition.getZ(), skill.getCastRange() + this.getTemplate().getCollisionRadius(), false, false)) {
                        this.sendPacket(SystemMessageId.TARGET_TOO_FAR);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                } else if (skill.getCastRange() > 0 && !this.isInsideRadius(target, skill.getCastRange() + this.getTemplate().getCollisionRadius(), false, false)) {
                    this.sendPacket(SystemMessageId.TARGET_TOO_FAR);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (skill.getEffectPoint() > 0 && target.isMonster() && !forceUse) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case GROUND: 
            case SELF: 
            case ENEMY: {
                break;
            }
            default: {
                if (!target.isPlayable() || this.getAccessLevel().allowPeaceAttack() || this.checkPvpSkill(target, skill)) break;
                this.sendPacket(SystemMessageId.INCORRECT_TARGET);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.getCastRange() > 0) {
            if (sklTargetType == TargetType.GROUND) {
                if (!GeoData.getInstance().canSeeTarget((L2Object)this, worldPosition)) {
                    this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.isFlyType() && !GeoData.getInstance().canMove(this, target)) {
            this.sendPacket(SystemMessageId.THE_TARGET_IS_LOCATED_WHERE_YOU_CANNOT_CHARGE);
            return false;
        }
        return true;
    }

    public boolean isInLooterParty(int LooterId) {
        L2PcInstance looter = L2World.getInstance().getPlayer(LooterId);
        if (this.isInParty() && this.getParty().isInCommandChannel() && looter != null) {
            return this.getParty().getCommandChannel().getMembers().contains(looter);
        }
        if (this.isInParty() && looter != null) {
            return this.getParty().getMembers().contains(looter);
        }
        return false;
    }

    public boolean checkPvpSkill(L2Object target, Skill skill) {
        if (skill == null || target == null) {
            return false;
        }
        if (!target.isPlayable()) {
            return true;
        }
        if (skill.isDebuff() || skill.hasEffectType(L2EffectType.STEAL_ABNORMAL, new L2EffectType[0]) || skill.isBad()) {
            boolean isCtrlPressed;
            L2PcInstance targetPlayer = target.getActingPlayer();
            if (targetPlayer == null || this == target) {
                return false;
            }
            boolean bl = isCtrlPressed = this.getCurrentSkill() != null && this.getCurrentSkill().isCtrlPressed();
            if (target.isInsideZone(ZoneId.PEACE)) {
                return false;
            }
            if (this.getSiegeState() != 0 && targetPlayer.getSiegeState() != 0 && this.getSiegeSide() == targetPlayer.getSiegeSide() && this.getSiegeState() == targetPlayer.getSiegeState()) {
                this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                return false;
            }
            if (this.isInDuel() && targetPlayer.isInDuel() && this.getDuelId() == targetPlayer.getDuelId()) {
                return true;
            }
            if (this.isInParty() && targetPlayer.isInParty()) {
                if (this.getParty().getLeader() == targetPlayer.getParty().getLeader()) {
                    return skill.getEffectRange() > 0 && isCtrlPressed && this.getTarget() == target && skill.isDamage();
                }
                if (this.getParty().getCommandChannel() != null && this.getParty().getCommandChannel().containsPlayer(targetPlayer)) {
                    return skill.getEffectRange() > 0 && isCtrlPressed && this.getTarget() == target && skill.isDamage();
                }
            }
            if (this.isInsideZone(ZoneId.PVP) && targetPlayer.isInsideZone(ZoneId.PVP)) {
                return true;
            }
            if (this.isInOlympiadMode() && targetPlayer.isInOlympiadMode() && this.getOlympiadGameId() == targetPlayer.getOlympiadGameId()) {
                return true;
            }
            L2Clan aClan = this.getClan();
            L2Clan tClan = targetPlayer.getClan();
            if (aClan != null && tClan != null) {
                if (aClan.isAtWarWith(tClan.getId()) && tClan.isAtWarWith(aClan.getId())) {
                    if (skill.isAOE() && skill.getEffectRange() > 0 && isCtrlPressed && this.getTarget() == target) {
                        return true;
                    }
                    return isCtrlPressed;
                }
                if (this.getClanId() == targetPlayer.getClanId() || this.getAllyId() > 0 && this.getAllyId() == targetPlayer.getAllyId()) {
                    return skill.getEffectRange() > 0 && isCtrlPressed && this.getTarget() == target && skill.isDamage();
                }
            }
            if (targetPlayer.getPvpFlag() == 0 && targetPlayer.getKarma() == 0) {
                return skill.getEffectRange() > 0 && isCtrlPressed && this.getTarget() == target && skill.isDamage();
            }
            return targetPlayer.getPvpFlag() > 0 || targetPlayer.getKarma() > 0;
        }
        return true;
    }

    public boolean isMageClass() {
        return this.getClassId().isMage();
    }

    public boolean isMounted() {
        return this._mountType != MountType.NONE;
    }

    public boolean checkLandingState() {
        if (this.isInsideZone(ZoneId.NO_LANDING)) {
            return true;
        }
        return this.isInsideZone(ZoneId.SIEGE) && (this.getClan() == null || CastleManager.getInstance().getCastle(this) != CastleManager.getInstance().getCastleByOwner(this.getClan()) || this != this.getClan().getLeader().getPlayerInstance());
    }

    public void setMount(int npcId, int npcLevel) {
        MountType type = MountType.findByNpcId(npcId);
        switch (type) {
            case NONE: {
                this.setIsFlying(false);
                break;
            }
            case STRIDER: {
                if (!this.isNoble()) break;
                this.addSkill(CommonSkill.STRIDER_SIEGE_ASSAULT.getSkill(), false);
                break;
            }
            case WYVERN: {
                this.setIsFlying(true);
            }
        }
        this._mountType = type;
        this._mountNpcId = npcId;
        this._mountLevel = npcLevel;
    }

    public MountType getMountType() {
        return this._mountType;
    }

    @Override
    public void stopAllEffects() {
        super.stopAllEffects();
        this.updateAndBroadcastStatus(2);
    }

    @Override
    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        super.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.updateAndBroadcastStatus(2);
    }

    public void stopAllEffectsNotStayOnSubclassChange() {
        this.getEffectList().stopAllEffectsNotStayOnSubclassChange();
        this.updateAndBroadcastStatus(2);
    }

    public void stopCubics() {
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
            this.broadcastUserInfo();
        }
    }

    public void stopCubicsByOthers() {
        if (!this._cubics.isEmpty()) {
            boolean broadcast = false;
            for (L2CubicInstance cubic : this._cubics.values()) {
                if (!cubic.givenByOther()) continue;
                cubic.stopAction();
                cubic.cancelDisappear();
                this._cubics.remove(cubic.getId());
                broadcast = true;
            }
            if (broadcast) {
                this.broadcastUserInfo();
            }
        }
    }

    @Override
    public void updateAbnormalEffect() {
        this.broadcastUserInfo();
    }

    public void setInventoryBlockingStatus(boolean val) {
        this._inventoryDisable = val;
        if (val) {
            ThreadPoolManager.getInstance().scheduleGeneral(new InventoryEnableTask(this), 1500L);
        }
    }

    public boolean isInventoryDisabled() {
        return this._inventoryDisable;
    }

    public L2CubicInstance addCubic(int cubicId, int level, double cubicPower, int cubicDelay, int cubicSkillChance, int cubicMaxCount, int cubicDuration, boolean givenByOther) {
        return this._cubics.put(cubicId, new L2CubicInstance(this, cubicId, level, (int)cubicPower, cubicDelay, cubicSkillChance, cubicMaxCount, cubicDuration, givenByOther));
    }

    public Map<Integer, L2CubicInstance> getCubics() {
        return this._cubics;
    }

    public L2CubicInstance getCubicById(int cubicId) {
        return this._cubics.get(cubicId);
    }

    public int getEnchantEffect() {
        L2ItemInstance wpn = this.getActiveWeaponInstance();
        if (wpn == null) {
            return 0;
        }
        return Math.min(127, wpn.getEnchantLevel());
    }

    public L2Npc getLastFolkNPC() {
        return this._lastFolkNpc;
    }

    public void setLastFolkNPC(L2Npc folkNpc) {
        this._lastFolkNpc = folkNpc;
    }

    public boolean isFestivalParticipant() {
        return SevenSignsFestival.getInstance().isParticipant(this);
    }

    public void addAutoSoulShot(int itemId) {
        this._activeSoulShots.add(itemId);
    }

    public boolean removeAutoSoulShot(int itemId) {
        return this._activeSoulShots.remove(itemId);
    }

    public Set<Integer> getAutoSoulShot() {
        return this._activeSoulShots;
    }

    @Override
    public void rechargeShots(boolean physical, boolean magic) {
        if (this._activeSoulShots == null || this._activeSoulShots.isEmpty()) {
            return;
        }
        for (int itemId : this._activeSoulShots) {
            L2ItemInstance item = this.getInventory().getItemByItemId(itemId);
            if (item != null) {
                IItemHandler handler;
                if (magic && item.getItem().getDefaultAction() == ActionType.SPIRITSHOT && (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) != null) {
                    handler.useItem(this, item, false);
                }
                if (!physical || item.getItem().getDefaultAction() != ActionType.SOULSHOT || (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) == null) continue;
                handler.useItem(this, item, false);
                continue;
            }
            this.removeAutoSoulShot(itemId);
        }
    }

    public void disableAutoShotByCrystalType(int crystalType) {
        for (int itemId : this._activeSoulShots) {
            if (ItemTable.getInstance().getTemplate(itemId).getCrystalType().getId() != crystalType) continue;
            this.disableAutoShot(itemId);
        }
    }

    public boolean disableAutoShot(int itemId) {
        if (this._activeSoulShots.contains(itemId)) {
            this.removeAutoSoulShot(itemId);
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
            sm.addItemName(itemId);
            this.sendPacket(sm);
            return true;
        }
        return false;
    }

    public void disableAutoShotsAll() {
        for (int itemId : this._activeSoulShots) {
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
            sm.addItemName(itemId);
            this.sendPacket(sm);
        }
        this._activeSoulShots.clear();
    }

    public EnumIntBitmask<ClanPrivilege> getClanPrivileges() {
        return this._clanPrivileges;
    }

    public void setClanPrivileges(EnumIntBitmask<ClanPrivilege> clanPrivileges) {
        this._clanPrivileges = clanPrivileges.clone();
    }

    public boolean hasClanPrivilege(ClanPrivilege privilege) {
        return this._clanPrivileges.has(privilege, new ClanPrivilege[0]);
    }

    public int getPledgeClass() {
        return this._pledgeClass;
    }

    public void setPledgeClass(int classId) {
        this._pledgeClass = classId;
        this.checkItemRestriction();
    }

    @Override
    public int getPledgeType() {
        return this._pledgeType;
    }

    public void setPledgeType(int typeId) {
        this._pledgeType = typeId;
    }

    public int getApprentice() {
        return this._apprentice;
    }

    public void setApprentice(int apprentice_id) {
        this._apprentice = apprentice_id;
    }

    public int getSponsor() {
        return this._sponsor;
    }

    public void setSponsor(int sponsor_id) {
        this._sponsor = sponsor_id;
    }

    public int getBookMarkSlot() {
        return this._bookmarkslot;
    }

    public void setBookMarkSlot(int slot) {
        this._bookmarkslot = slot;
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    @Override
    public void sendMessage(String message) {
        this.sendPacket(SystemMessage.sendString(message));
    }

    public void enterObserverMode(Location loc) {
        this.setLastLocation();
        this.getEffectList().stopSkillEffects(true, AbnormalType.HIDE);
        this._observerMode = true;
        this.setTarget(null);
        this.startStunning();
        this.setIsInvul(true);
        this.setInvisible(true);
        this.sendPacket(new ObservationMode(loc));
        this.teleToLocation((ILocational)loc, false);
        this.broadcastUserInfo();
    }

    public void setLastLocation() {
        this._lastLoc.setXYZ(this.getX(), this.getY(), this.getZ());
    }

    public void unsetLastLocation() {
        this._lastLoc.setXYZ(0, 0, 0);
    }

    public void enterOlympiadObserverMode(Location loc, int id) {
        if (this.hasSummon()) {
            this.getSummon().unSummon(this);
        }
        this.getEffectList().stopSkillEffects(true, AbnormalType.HIDE);
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
        }
        if (this.getParty() != null) {
            this.getParty().removePartyMember(this, L2Party.messageType.Expelled);
        }
        this._olympiadGameId = id;
        if (this.isSitting()) {
            this.standUp();
        }
        if (!this._observerMode) {
            this.setLastLocation();
        }
        this._observerMode = true;
        this.setTarget(null);
        this.setIsInvul(true);
        this.setInvisible(true);
        this.teleToLocation((ILocational)loc, false);
        this.sendPacket(new ExOlympiadMode(3));
        this.broadcastUserInfo();
    }

    public void leaveObserverMode() {
        this.setTarget(null);
        this.teleToLocation((ILocational)this._lastLoc, false);
        this.unsetLastLocation();
        this.sendPacket(new ObservationReturn(this.getLocation()));
        this.stopStunning(false);
        if (!this.isGM()) {
            this.setInvisible(false);
            this.setIsInvul(false);
        }
        if (this.hasAI()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.setFalling();
        this._observerMode = false;
        this.broadcastUserInfo();
    }

    public void leaveOlympiadObserverMode() {
        if (this._olympiadGameId == -1) {
            return;
        }
        this._olympiadGameId = -1;
        this._observerMode = false;
        this.setTarget(null);
        this.sendPacket(new ExOlympiadMode(0));
        this.setInstanceId(0);
        this.teleToLocation((ILocational)this._lastLoc, true);
        if (!this.isGM()) {
            this.setInvisible(false);
            this.setIsInvul(false);
        }
        if (this.hasAI()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.unsetLastLocation();
        this.broadcastUserInfo();
    }

    public int getOlympiadSide() {
        return this._olympiadSide;
    }

    public void setOlympiadSide(int i) {
        this._olympiadSide = i;
    }

    public int getOlympiadGameId() {
        return this._olympiadGameId;
    }

    public void setOlympiadGameId(int id) {
        this._olympiadGameId = id;
    }

    public int getOlympiadBuffCount() {
        return this._olyBuffsCount;
    }

    public void setOlympiadBuffCount(int buffs) {
        this._olyBuffsCount = buffs;
    }

    public Location getLastLocation() {
        return this._lastLoc;
    }

    public boolean inObserverMode() {
        return this._observerMode;
    }

    public int getTeleMode() {
        return this._telemode;
    }

    public void setTeleMode(int mode) {
        this._telemode = mode;
    }

    public void setLoto(int i, int val) {
        this._loto[i] = val;
    }

    public int getLoto(int i) {
        return this._loto[i];
    }

    public void setRace(int i, int val) {
        this._race[i] = val;
    }

    public int getRace(int i) {
        return this._race[i];
    }

    public boolean getMessageRefusal() {
        return this._messageRefusal;
    }

    public void setMessageRefusal(boolean mode) {
        this._messageRefusal = mode;
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean getDietMode() {
        return this._dietMode;
    }

    public void setDietMode(boolean mode) {
        this._dietMode = mode;
    }

    public boolean getTradeRefusal() {
        return this._tradeRefusal;
    }

    public void setTradeRefusal(boolean mode) {
        this._tradeRefusal = mode;
    }

    public boolean getExchangeRefusal() {
        return this._exchangeRefusal;
    }

    public void setExchangeRefusal(boolean mode) {
        this._exchangeRefusal = mode;
    }

    public BlockList getBlockList() {
        return this._blockList;
    }

    public void setIsInOlympiadMode(boolean b) {
        this._inOlympiadMode = b;
    }

    public void setIsOlympiadStart(boolean b) {
        this._OlympiadStart = b;
    }

    public boolean isOlympiadStart() {
        return this._OlympiadStart;
    }

    public boolean isHero() {
        return this._hero;
    }

    public void setHero(boolean hero) {
        if (hero && this._baseClass == this._activeClass) {
            for (Skill skill : SkillTreesData.getInstance().getHeroSkillTree().values()) {
                this.addSkill(skill, false);
            }
        } else {
            for (Skill skill : SkillTreesData.getInstance().getHeroSkillTree().values()) {
                this.removeSkill(skill, false, true);
            }
        }
        this._hero = hero;
        this.sendSkillList();
    }

    public boolean isInOlympiadMode() {
        return this._inOlympiadMode;
    }

    @Override
    public boolean isInDuel() {
        return this._duelState != DuelState.NO_DUEL;
    }

    @Override
    public int getDuelId() {
        return this._duelId;
    }

    public DuelState getDuelState() {
        return this._duelState;
    }

    public void setDuelState(DuelState mode) {
        this._duelState = mode;
    }

    public void setIsInDuel(int duelId) {
        if (duelId > 0) {
            this._duelState = DuelState.DUELLING;
            this._duelId = duelId;
        } else {
            if (this._duelState == DuelState.DEAD) {
                this.enableAllSkills();
                this.getStatus().startHpMpRegeneration();
            }
            this._duelState = DuelState.NO_DUEL;
            this._duelId = 0;
        }
    }

    public boolean isNoble() {
        return this._noble;
    }

    public void setNoble(boolean val) {
        Collection<Skill> nobleSkillTree = SkillTreesData.getInstance().getNobleSkillTree().values();
        if (val) {
            for (Skill skill : nobleSkillTree) {
                this.addSkill(skill, false);
            }
        } else {
            for (Skill skill : nobleSkillTree) {
                this.removeSkill(skill, false, true);
            }
        }
        this._noble = val;
        this.sendSkillList();
    }

    public int getLvlJoinedAcademy() {
        return this._lvlJoinedAcademy;
    }

    public void setLvlJoinedAcademy(int lvl) {
        this._lvlJoinedAcademy = lvl;
    }

    @Override
    public boolean isAcademyMember() {
        return this._lvlJoinedAcademy > 0;
    }

    @Override
    public void setTeam(Team team) {
        super.setTeam(team);
        this.broadcastUserInfo();
        if (this.hasSummon()) {
            this.getSummon().broadcastStatusUpdate();
        }
    }

    public int getWantsPeace() {
        return this._wantsPeace;
    }

    public void setWantsPeace(int wantsPeace) {
        this._wantsPeace = wantsPeace;
    }

    public boolean isFishing() {
        return this._fishing;
    }

    public void setFishing(boolean fishing) {
        this._fishing = fishing;
    }

    public void sendSkillList() {
        boolean isDisabled = false;
        SkillList sl = new SkillList();
        for (Skill s : this.getAllSkills()) {
            L2EnchantSkillLearn esl;
            boolean bl;
            if (s == null || this._transformation != null && !s.isPassive() || this.hasTransformSkill(s.getId()) && s.isPassive()) continue;
            if (this.getClan() != null) {
                boolean bl2 = isDisabled = s.isClanSkill() && this.getClan().getReputationScore() < 0;
            }
            if ((bl = SkillData.getInstance().isEnchantable(s.getId())) && ((esl = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(s.getId())) == null || s.getLevel() < esl.getBaseLevel())) {
                bl = false;
            }
            sl.addSkill(s.getDisplayId(), s.getDisplayLevel(), s.isPassive(), isDisabled, bl);
        }
        if (this._transformation != null) {
            TreeMap<Integer, Integer> ts = new TreeMap<Integer, Integer>();
            for (SkillHolder skillHolder : this._transformation.getTemplate(this).getSkills()) {
                ts.putIfAbsent(skillHolder.getSkillId(), skillHolder.getSkillLvl());
                if ((Integer)ts.get(skillHolder.getSkillId()) >= skillHolder.getSkillLvl()) continue;
                ts.put(skillHolder.getSkillId(), skillHolder.getSkillLvl());
            }
            for (AdditionalSkillHolder additionalSkillHolder : this._transformation.getTemplate(this).getAdditionalSkills()) {
                if (this.getLevel() < additionalSkillHolder.getMinLevel()) continue;
                ts.putIfAbsent(additionalSkillHolder.getSkillId(), additionalSkillHolder.getSkillLvl());
                if ((Integer)ts.get(additionalSkillHolder.getSkillId()) >= additionalSkillHolder.getSkillLvl()) continue;
                ts.put(additionalSkillHolder.getSkillId(), additionalSkillHolder.getSkillLvl());
            }
            for (L2SkillLearn l2SkillLearn : SkillTreesData.getInstance().getCollectSkillTree().values()) {
                if (this.getKnownSkill(l2SkillLearn.getSkillId()) == null) continue;
                this.addTransformSkill(SkillData.getInstance().getSkill(l2SkillLearn.getSkillId(), l2SkillLearn.getSkillLevel()));
            }
            for (Map.Entry entry : ts.entrySet()) {
                Skill sk = SkillData.getInstance().getSkill((Integer)entry.getKey(), (Integer)entry.getValue());
                this.addTransformSkill(sk);
                sl.addSkill((Integer)entry.getKey(), (Integer)entry.getValue(), false, false, false);
            }
        }
        this.sendPacket(sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubClass(int classId, int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            if (this.getTotalSubClasses() == Configuration.character().getMaxSubclass() || classIndex == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.getSubClasses().containsKey(classIndex)) {
                boolean bl = false;
                return bl;
            }
            SubClass newClass = new SubClass(this);
            newClass.setClassId(classId);
            newClass.setClassIndex(classIndex);
            if (!DAOFactory.getInstance().getSubclassDAO().insert(this, newClass)) {
                boolean bl = false;
                return bl;
            }
            this.getSubClasses().put(newClass.getClassIndex(), newClass);
            ClassId subTemplate = ClassId.getClassId(classId);
            Map<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(subTemplate);
            HashMap<Integer, Skill> prevSkillList = new HashMap<Integer, Skill>();
            for (L2SkillLearn skillInfo : skillTree.values()) {
                if (skillInfo.getGetLevel() > 40) continue;
                Skill prevSkill = (Skill)prevSkillList.get(skillInfo.getSkillId());
                Skill newSkill = SkillData.getInstance().getSkill(skillInfo.getSkillId(), skillInfo.getSkillLevel());
                if (prevSkill != null && prevSkill.getLevel() > newSkill.getLevel()) continue;
                prevSkillList.put(newSkill.getId(), newSkill);
                this.storeSkill(newSkill, prevSkill, classIndex);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifySubClass(int classIndex, int newClassId) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            DAOFactory.getInstance().getHennaDAO().deleteAll(this, classIndex);
            DAOFactory.getInstance().getSkillDAO().deleteAll(this, classIndex);
            DAOFactory.getInstance().getShortcutDAO().delete(this, classIndex);
            DAOFactory.getInstance().getPlayerSkillSaveDAO().delete(this, classIndex);
            DAOFactory.getInstance().getSubclassDAO().delete(this, classIndex);
            int classId = this.getSubClasses().get(classIndex).getClassId();
            EventDispatcher.getInstance().notifyEventAsync(new PlayerProfessionCancel(this, classId), this);
            this.getSubClasses().remove(classIndex);
        }
        finally {
            this._subclassLock.unlock();
        }
        return this.addSubClass(newClassId, classIndex);
    }

    public boolean isSubClassActive() {
        return this._classIndex > 0;
    }

    public Map<Integer, SubClass> getSubClasses() {
        if (this._subClasses == null) {
            this._subClasses = new ConcurrentSkipListMap<Integer, SubClass>();
        }
        return this._subClasses;
    }

    public int getTotalSubClasses() {
        return this.getSubClasses().size();
    }

    public int getBaseClass() {
        return this._baseClass;
    }

    public void setBaseClass(ClassId classId) {
        this._baseClass = classId.ordinal();
    }

    public int getActiveClass() {
        return this._activeClass;
    }

    public void setActiveClass(int classId) {
        this._activeClass = classId;
    }

    public int getClassIndex() {
        return this._classIndex;
    }

    public void setClassIndex(int classIndex) {
        this._classIndex = classIndex;
    }

    private void setClassTemplate(int classId) {
        this._activeClass = classId;
        L2PcTemplate pcTemplate = PlayerTemplateData.getInstance().getTemplate(classId);
        if (pcTemplate == null) {
            LOG.error("Missing template for classId: {}", (Object)classId);
            throw new Error();
        }
        this.setTemplate(pcTemplate);
        EventDispatcher.getInstance().notifyEventAsync(new PlayerProfessionChange(this, pcTemplate, this.isSubClassActive()), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeActiveClass(int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            if (this._transformation != null) {
                boolean bl = false;
                return bl;
            }
            for (L2ItemInstance item : this.getInventory().getAugmentedItems()) {
                if (item == null || !item.isEquipped()) continue;
                item.getAugmentation().removeBonus(this);
            }
            this.abortCast();
            if (this.isChannelized()) {
                this.getSkillChannelized().abortChannelization();
            }
            this.store(Configuration.character().subclassStoreSkillCooltime());
            this.resetTimeStamps();
            this._charges.set(0);
            this.stopChargeTask();
            if (this.hasServitor()) {
                this.getSummon().unSummon(this);
            }
            if (classIndex == 0) {
                this.setClassTemplate(this.getBaseClass());
            } else {
                try {
                    this.setClassTemplate(this.getSubClasses().get(classIndex).getClassId());
                }
                catch (Exception e) {
                    LOG.warn("Could not switch {} sub class to class index {}, {}", this, classIndex, e);
                    int n = 0;
                    this._subclassLock.unlock();
                    return n != 0;
                }
            }
            this._classIndex = classIndex;
            this.setLearningClass(this.getClassId());
            if (this.isInParty()) {
                this.getParty().recalculatePartyLevel();
            }
            for (Skill oldSkill : this.getAllSkills()) {
                this.removeSkill(oldSkill, false, true);
            }
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.stopAllEffectsNotStayOnSubclassChange();
            this.stopCubics();
            DAOFactory.getInstance().getRecipeBookDAO().load(this, false);
            this.restoreDeathPenaltyBuffLevel();
            DAOFactory.getInstance().getSkillDAO().load(this);
            this.rewardSkills();
            this.regiveTemporarySkills();
            this.resetDisabledSkills();
            this.restoreEffects();
            this.sendPacket(new EtcStatusUpdate(this));
            QuestState st = this.getQuestState("Q00422_RepentYourSins");
            if (st != null) {
                st.exitQuest(true);
            }
            for (int i = 0; i < 3; ++i) {
                this._henna[i] = null;
            }
            DAOFactory.getInstance().getHennaDAO().load(this);
            this.recalcHennaStats();
            this.sendPacket(new HennaInfo(this));
            if (this.getCurrentHp() > (double)this.getMaxHp()) {
                this.setCurrentHp(this.getMaxHp());
            }
            if (this.getCurrentMp() > (double)this.getMaxMp()) {
                this.setCurrentMp(this.getMaxMp());
            }
            if (this.getCurrentCp() > (double)this.getMaxCp()) {
                this.setCurrentCp(this.getMaxCp());
            }
            this.refreshOverloaded();
            this.refreshExpertisePenalty();
            this.broadcastUserInfo();
            this.setExpBeforeDeath(0L);
            this._shortCuts.restoreMe();
            this.sendPacket(new ShortCutInit(this));
            this.broadcastPacket(new SocialAction(this.getObjectId(), 2122));
            this.sendPacket(new SkillCoolTime(this));
            this.sendPacket(new ExStorageMaxCount(this));
            boolean bl = true;
            return bl;
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public boolean isLocked() {
        return this._subclassLock.isLocked();
    }

    public void stopWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak != null) {
            this._taskWarnUserTakeBreak.cancel(true);
            this._taskWarnUserTakeBreak = null;
        }
    }

    public void startWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak == null) {
            this._taskWarnUserTakeBreak = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new WarnUserTakeBreakTask(this), 0x6DDD00L, 0x6DDD00L);
        }
    }

    public void stopRentPet() {
        if (this._taskRentPet != null) {
            if (this.checkLandingState() && this.getMountType() == MountType.WYVERN) {
                this.teleToLocation(TeleportWhereType.TOWN);
            }
            if (this.dismount()) {
                this._taskRentPet.cancel(true);
                this._taskRentPet = null;
            }
        }
    }

    public void startRentPet(int seconds) {
        if (this._taskRentPet == null) {
            this._taskRentPet = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RentPetTask(this), (long)seconds * 1000L, (long)seconds * 1000L);
        }
    }

    public boolean isRentedPet() {
        return this._taskRentPet != null;
    }

    public void stopWaterTask() {
        if (this._taskWater != null) {
            this._taskWater.cancel(false);
            this._taskWater = null;
            this.sendPacket(new SetupGauge(2, 0));
        }
    }

    public void startWaterTask() {
        if (!this.isDead() && this._taskWater == null) {
            int timeinwater = (int)this.calcStat(Stats.BREATH, 60000.0, this, null);
            this.sendPacket(new SetupGauge(2, timeinwater));
            this._taskWater = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new WaterTask(this), timeinwater, 1000L);
        }
    }

    public boolean isInWater() {
        return this._taskWater != null;
    }

    public void checkWaterState() {
        if (this.isInsideZone(ZoneId.WATER)) {
            this.startWaterTask();
        } else {
            this.stopWaterTask();
        }
    }

    public void onPlayerEnter() {
        this.startWarnUserTakeBreak();
        this.getHuntingSystem().onPlayerLogin();
        if (this.isGM()) {
            if (this.isInvul()) {
                this.sendMessage("Entering world in Invulnerable mode.");
            }
            if (this.isInvisible()) {
                this.sendMessage("Entering world in Invisible mode.");
            }
            if (this.isSilenceMode()) {
                this.sendMessage("Entering world in Silence mode.");
            }
        }
        this.revalidateZone(true);
        this.notifyFriends();
        if (!this.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && Configuration.character().decreaseSkillOnDelevel()) {
            this.checkPlayerSkills();
        }
        try {
            for (L2ZoneType zone : ZoneManager.getInstance().getZones(this)) {
                zone.onPlayerLoginInside(this);
            }
        }
        catch (Exception e) {
            LOG.error("{}", e);
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerLogin(this), this);
    }

    public long getLastAccess() {
        return this._lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this._lastAccess = lastAccess;
    }

    @Override
    public void doRevive() {
        Instance instance;
        super.doRevive();
        this.updateEffectIcons();
        this.sendPacket(new EtcStatusUpdate(this));
        this._revivePet = false;
        this._reviveRequested = 0;
        this._revivePower = 0.0;
        if (this.isMounted()) {
            this.startFeed(this._mountNpcId);
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift() && !DimensionalRiftManager.getInstance().checkIfInPeaceZone(this.getX(), this.getY(), this.getZ())) {
            this.getParty().getDimensionalRift().memberResurrected(this);
        }
        if (this.getInstanceId() > 0 && (instance = InstanceManager.getInstance().getInstance(this.getInstanceId())) != null) {
            instance.cancelEjectDeadPlayer(this);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        if (Configuration.general().cacheCharNames()) {
            CharNameTable.getInstance().addName(this);
        }
    }

    @Override
    public void doRevive(double revivePower) {
        this.doRevive();
        this.restoreExp(revivePower);
    }

    public void reviveRequest(L2PcInstance reviver, Skill skill, boolean Pet, int resPower, int resRecovery) {
        if (this.isResurrectionBlocked()) {
            return;
        }
        if (this._reviveRequested == 1) {
            if (this._revivePet == Pet) {
                reviver.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
            } else if (Pet) {
                reviver.sendPacket(SystemMessageId.CANNOT_RES_PET2);
            } else {
                reviver.sendPacket(SystemMessageId.MASTER_CANNOT_RES);
            }
            return;
        }
        if (Pet && this.hasPet() && this.getSummon().isDead() || !Pet && this.isDead()) {
            this._reviveRequested = 1;
            this._reviveRecovery = resRecovery;
            int restoreExp = 0;
            this._revivePower = Formulas.calculateSkillResurrectRestorePercent(resPower, reviver);
            restoreExp = (int)Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * this._revivePower / 100.0);
            this._revivePet = Pet;
            if (this.hasCharmOfCourage()) {
                ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESURRECT_USING_CHARM_OF_COURAGE.getId());
                dlg.addTime(60000);
                this.sendPacket(dlg);
                return;
            }
            ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESURRECTION_REQUEST_BY_C1_FOR_S2_XP.getId());
            dlg.addPcName(reviver);
            dlg.addString(Integer.toString(Math.abs(restoreExp)));
            this.sendPacket(dlg);
        }
    }

    public void reviveAnswer(int answer) {
        if (this._reviveRequested != 1 || !this.isDead() && !this._revivePet || this._revivePet && this.hasPet() && !this.getSummon().isDead()) {
            return;
        }
        if (answer == 1) {
            if (!this._revivePet) {
                if (this._revivePower != 0.0) {
                    this.doRevive(this._revivePower);
                } else {
                    this.doRevive();
                }
                if (this._reviveRecovery != 0) {
                    this.setCurrentHpMp((double)this.getMaxHp() * ((double)this._reviveRecovery / 100.0), (double)this.getMaxMp() * ((double)this._reviveRecovery / 100.0));
                    this.setCurrentCp(0.0);
                }
            } else if (this.hasPet()) {
                if (this._revivePower != 0.0) {
                    this.getSummon().doRevive(this._revivePower);
                } else {
                    this.getSummon().doRevive();
                }
                if (this._reviveRecovery != 0) {
                    this.getSummon().setCurrentHpMp((double)this.getSummon().getMaxHp() * ((double)this._reviveRecovery / 100.0), (double)this.getSummon().getMaxMp() * ((double)this._reviveRecovery / 100.0));
                }
            }
        }
        this._revivePet = false;
        this._reviveRequested = 0;
        this._revivePower = 0.0;
        this._reviveRecovery = 0;
    }

    public boolean isReviveRequested() {
        return this._reviveRequested == 1;
    }

    public boolean isRevivingPet() {
        return this._revivePet;
    }

    public void removeReviving() {
        this._reviveRequested = 0;
        this._revivePower = 0.0;
    }

    public void onActionRequest() {
        if (this.isSpawnProtected()) {
            this.sendPacket(SystemMessageId.YOU_ARE_NO_LONGER_PROTECTED_FROM_AGGRESSIVE_MONSTERS);
            if (Configuration.character().restoreServitorOnReconnect() && !this.hasSummon() && CharSummonTable.getInstance().getServitors().containsKey(this.getObjectId())) {
                CharSummonTable.getInstance().restoreServitor(this);
            }
            if (Configuration.character().restorePetOnReconnect() && !this.hasSummon() && CharSummonTable.getInstance().getPets().containsKey(this.getObjectId())) {
                CharSummonTable.getInstance().restorePet(this);
            }
        }
        if (this.isTeleportProtected()) {
            this.sendMessage("Teleport spawn protection ended.");
        }
        this.setProtection(false);
        this.setTeleportProtection(false);
    }

    public int getExpertiseLevel() {
        int level = this.getSkillLevel(239);
        if (level < 0) {
            level = 0;
        }
        return level;
    }

    @Override
    public void teleToLocation(ILocational loc, boolean allowRandomOffset) {
        if (this.getVehicle() != null && !this.getVehicle().isTeleporting()) {
            this.setVehicle(null);
        }
        if (this.isFlyingMounted() && loc.getZ() < -1005) {
            super.teleToLocation(loc.getX(), loc.getY(), -1005, loc.getHeading(), loc.getInstanceId());
        }
        super.teleToLocation(loc, allowRandomOffset);
    }

    @Override
    public void onTeleported() {
        L2Summon summon;
        super.onTeleported();
        if (this.isInAirShip()) {
            this.getAirShip().sendInfo(this);
        }
        this.revalidateZone(true);
        this.checkItemRestriction();
        if (Configuration.character().getPlayerTeleportProtection() > 0 && !this.isInOlympiadMode()) {
            this.setTeleportProtection(true);
        }
        if (this.hasTamedBeasts()) {
            for (L2TamedBeastInstance tamedBeast : this._tamedBeasts) {
                tamedBeast.deleteMe();
            }
            this._tamedBeasts.clear();
        }
        if ((summon = this.getSummon()) != null) {
            summon.setFollowStatus(false);
            summon.teleToLocation((ILocational)this.getLocation(), false);
            ((L2SummonAI)summon.getAI()).setStartFollowController(true);
            summon.setFollowStatus(true);
            summon.updateAndBroadcastStatus(0);
        }
        TvTEvent.onTeleported(this);
    }

    @Override
    public void setIsTeleporting(boolean teleport) {
        this.setIsTeleporting(teleport, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsTeleporting(boolean teleport, boolean useWatchDog) {
        super.setIsTeleporting(teleport);
        if (!useWatchDog) {
            return;
        }
        if (teleport) {
            if (this._teleportWatchdog == null && Configuration.character().getTeleportWatchdogTimeout() > 0L) {
                L2PcInstance l2PcInstance = this;
                synchronized (l2PcInstance) {
                    if (this._teleportWatchdog == null) {
                        this._teleportWatchdog = ThreadPoolManager.getInstance().scheduleGeneral(new TeleportWatchdogTask(this), Configuration.character().getTeleportWatchdogTimeout());
                    }
                }
            }
        } else if (this._teleportWatchdog != null) {
            this._teleportWatchdog.cancel(false);
            this._teleportWatchdog = null;
        }
    }

    public void setLastServerPosition(int x, int y, int z) {
        this._lastServerPosition.setXYZ(x, y, z);
    }

    public Location getLastServerPosition() {
        return this._lastServerPosition;
    }

    public int getLastServerDistance(int x, int y, int z) {
        return (int)Util.calculateDistance(x, y, z, this._lastServerPosition.getX(), this._lastServerPosition.getY(), this._lastServerPosition.getZ(), true, false);
    }

    @Override
    public void reduceCurrentHp(double value, L2Character attacker, boolean awake, boolean isDOT, Skill skill) {
        this.getStatus().reduceHp(value, attacker, awake, isDOT, false, false);
        if (this.hasTamedBeasts()) {
            for (L2TamedBeastInstance tamedBeast : this._tamedBeasts) {
                tamedBeast.onOwnerGotAttacked(attacker);
            }
        }
    }

    public void broadcastSnoop(int type, String name, String _text) {
        if (!this._snoopListener.isEmpty()) {
            Snoop sn = new Snoop(this.getObjectId(), this.getName(), type, name, _text);
            for (L2PcInstance pci : this._snoopListener) {
                if (pci == null) continue;
                pci.sendPacket(sn);
            }
        }
    }

    public void addSnooper(L2PcInstance pci) {
        this._snoopListener.add(pci);
    }

    public void removeSnooper(L2PcInstance pci) {
        this._snoopListener.remove(pci);
    }

    public void addSnooped(L2PcInstance pci) {
        this._snoopedPlayer.add(pci);
    }

    public void removeSnooped(L2PcInstance pci) {
        this._snoopedPlayer.remove(pci);
    }

    public void addHtmlAction(HtmlActionScope scope, String action) {
        this._htmlActionCaches[scope.ordinal()].add(action);
    }

    public void clearHtmlActions(HtmlActionScope scope) {
        this._htmlActionCaches[scope.ordinal()].clear();
    }

    public void setHtmlActionOriginObjectId(HtmlActionScope scope, int npcObjId) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._htmlActionOriginObjectIds[scope.ordinal()] = npcObjId;
    }

    public int getLastHtmlActionOriginId() {
        return this._lastHtmlActionOriginObjId;
    }

    private boolean validateHtmlAction(Iterable<String> actionIter, String action) {
        for (String cachedAction : actionIter) {
            if (!(cachedAction.charAt(cachedAction.length() - 1) == '$' ? action.startsWith(cachedAction.substring(0, cachedAction.length() - 1).trim()) : cachedAction.equals(action))) continue;
            return true;
        }
        return false;
    }

    public int validateHtmlAction(String action) {
        for (int i = 0; i < this._htmlActionCaches.length; ++i) {
            if (this._htmlActionCaches[i] == null || !this.validateHtmlAction(this._htmlActionCaches[i], action)) continue;
            this._lastHtmlActionOriginObjId = this._htmlActionOriginObjectIds[i];
            return this._lastHtmlActionOriginObjId;
        }
        return -1;
    }

    public boolean validateItemManipulation(int objectId, String action) {
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            LOG.info("{} tried to {} item he is not owner of", (Object)this, (Object)action);
            return false;
        }
        if (this.hasSummon() && this.getSummon().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Configuration.general().debug()) {
                LOG.debug("{} tried to {} item controling pet", (Object)this, (Object)action);
            }
            return false;
        }
        if (this.getActiveEnchantItemId() == objectId) {
            if (Configuration.general().debug()) {
                LOG.debug("{} tried to {} an enchant scroll he was using", (Object)this, (Object)action);
            }
            return false;
        }
        return !CursedWeaponsManager.getInstance().isCursed(item.getId());
    }

    public boolean isInBoat() {
        return this._vehicle != null && this._vehicle.isBoat();
    }

    public L2BoatInstance getBoat() {
        return (L2BoatInstance)this._vehicle;
    }

    public boolean isInAirShip() {
        return this._vehicle != null && this._vehicle.isAirShip();
    }

    public L2AirShipInstance getAirShip() {
        return (L2AirShipInstance)this._vehicle;
    }

    public L2Vehicle getVehicle() {
        return this._vehicle;
    }

    public void setVehicle(L2Vehicle v) {
        if (v == null && this._vehicle != null) {
            this._vehicle.removePassenger(this);
        }
        this._vehicle = v;
    }

    public boolean isInVehicle() {
        return this._vehicle != null;
    }

    public boolean isInCrystallize() {
        return this._inCrystallize;
    }

    public void setInCrystallize(boolean inCrystallize) {
        this._inCrystallize = inCrystallize;
    }

    public Location getInVehiclePosition() {
        return this._inVehiclePosition;
    }

    public void setInVehiclePosition(Location pt) {
        this._inVehiclePosition = pt;
    }

    @Override
    public boolean deleteMe() {
        this.cleanup();
        this.storeMe();
        return super.deleteMe();
    }

    private synchronized void cleanup() {
        EventDispatcher.getInstance().notifyEventAsync(new PlayerLogout(this), this);
        try {
            for (L2ZoneType zone : ZoneManager.getInstance().getZones(this)) {
                zone.onPlayerLogoutInside(this);
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            if (!this.isOnline()) {
                LOG.error("deleteMe() called on offline {}", (Object)this);
            }
            this.setOnlineStatus(false, true);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            if (Configuration.general().enableBlockCheckerEvent() && this.getBlockCheckerArena() != -1) {
                HandysBlockCheckerManager.getInstance().onDisconnect(this);
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this._isOnline = false;
            this.abortAttack();
            this.abortCast();
            this.stopMove(null);
            this.setDebug(null);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            if (this.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFort(this);
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(this, fort.getResidenceId());
                } else {
                    int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                    this.getInventory().unEquipItemInBodySlot(slot);
                    this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                }
            } else if (this.isCombatFlagEquipped()) {
                TerritoryWarManager.getInstance().dropCombatFlag(this, false, false);
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            PartyMatchRoom room;
            PartyMatchWaitingList.getInstance().removePlayer(this);
            if (this._partyroom != 0 && (room = PartyMatchRoomList.getInstance().getRoom(this._partyroom)) != null) {
                room.deleteMember(this);
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            if (this.isFlying()) {
                this.removeSkill(SkillData.getInstance().getSkill(4289, 1));
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.getRecSystem().store();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.stopAllTimers();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.setIsTeleporting(false);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            RecipeController.getInstance().requestMakeItemAbort(this);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.setTarget(null);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        this.getHuntingSystem().onPlayerLogout();
        this.getEffectList().stopAllToggles();
        L2WorldRegion oldRegion = this.getWorldRegion();
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.decayMe();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        if (this.isInParty()) {
            try {
                this.leaveParty();
            }
            catch (Exception e) {
                LOG.error("deleteMe() {}", e);
            }
        }
        if (OlympiadManager.getInstance().isRegistered(this) || this.getOlympiadGameId() != -1) {
            OlympiadManager.getInstance().removeDisconnectedCompetitor(this);
        }
        if (this.hasSummon()) {
            try {
                this.getSummon().setRestoreSummon(true);
                this.getSummon().unSummon(this);
                if (this.hasSummon()) {
                    this.getSummon().broadcastNpcInfo(0);
                }
            }
            catch (Exception e) {
                LOG.error("deleteMe() {}", e);
            }
        }
        if (this.getClan() != null) {
            try {
                L2ClanMember clanMember = this.getClan().getClanMember(this.getObjectId());
                if (clanMember != null) {
                    clanMember.setPlayerInstance(null);
                }
            }
            catch (Exception e) {
                LOG.error("deleteMe() {}", e);
            }
        }
        if (this.getActiveRequester() != null) {
            this.setActiveRequester(null);
            this.cancelActiveTrade();
        }
        if (this.isGM()) {
            try {
                AdminData.getInstance().deleteGm(this);
            }
            catch (Exception e) {
                LOG.error("deleteMe() {}", e);
            }
        }
        try {
            if (this.inObserverMode()) {
                this.setLocationInvisible(this._lastLoc);
            }
            if (this.getVehicle() != null) {
                this.getVehicle().oustPlayer(this);
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            Instance inst;
            int instanceId = this.getInstanceId();
            if (instanceId != 0 && !Configuration.general().restorePlayerInstance() && (inst = InstanceManager.getInstance().getInstance(instanceId)) != null) {
                inst.removePlayer(this.getObjectId());
                Location loc = inst.getExitLoc();
                if (loc != null) {
                    int x = loc.getX() + Rnd.get((int)-30, (int)30);
                    int y = loc.getY() + Rnd.get((int)-30, (int)30);
                    this.setXYZInvisible(x, y, loc.getZ());
                    if (this.hasSummon()) {
                        this.getSummon().teleToLocation((ILocational)loc, true);
                        this.getSummon().setInstanceId(0);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            TvTEvent.onLogout(this);
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.getInventory().deleteMe();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.clearWarehouse();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        if (Configuration.general().warehouseCache()) {
            WarehouseCacheManager.getInstance().remCacheTask(this);
        }
        try {
            this.getFreight().deleteMe();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        try {
            this.clearRefund();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        if (this.isCursedWeaponEquipped()) {
            try {
                CursedWeaponsManager.getInstance().getCursedWeapon(this._cursedWeaponEquippedId).setPlayer(null);
            }
            catch (Exception e) {
                LOG.error("deleteMe() {}", e);
            }
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            LOG.error("deleteMe() {}", e);
        }
        if (this.getClanId() > 0) {
            this.getClan().broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(this), this);
        }
        for (L2PcInstance player : this._snoopedPlayer) {
            player.removeSnooper(this);
        }
        for (L2PcInstance player : this._snoopListener) {
            player.removeSnooped(this);
        }
        L2World.getInstance().removeObject(this);
        L2World.getInstance().removeFromAllPlayers(this);
        try {
            this.notifyFriends();
            this.getBlockList().playerLogout();
        }
        catch (Exception e) {
            LOG.error("Exception on deleteMe() notifyFriends: {}", e);
        }
    }

    public void startFishing(int _x, int _y, int _z) {
        this.stopMove(null);
        this.setIsImmobilized(true);
        this._fishing = true;
        this._fishx = _x;
        this._fishy = _y;
        this._fishz = _z;
        int lvl = this.getRandomFishLvl();
        int grade = this.getRandomFishGrade();
        int group = this.getRandomFishGroup(grade);
        List<L2Fish> fish = FishData.getInstance().getFish(lvl, group, grade);
        if (fish == null || fish.isEmpty()) {
            this.sendMessage("Error - Fish are not defined");
            this.endFishing(false);
            return;
        }
        this._fish = fish.get(Rnd.get((int)fish.size())).clone();
        fish.clear();
        this.sendPacket(SystemMessageId.CAST_LINE_AND_START_FISHING);
        if (!GameTimeController.getInstance().isNight() && this._lure.isNightLure()) {
            this._fish.setFishGroup(-1);
        }
        this.broadcastPacket(new ExFishingStart(this, this._fish.getFishGroup(), _x, _y, _z, this._lure.isNightLure()));
        this.sendPacket(Music.SF_P_01.getPacket());
        this.startLookingForFishTask();
    }

    public void stopLookingForFishTask() {
        if (this._taskforfish != null) {
            this._taskforfish.cancel(false);
            this._taskforfish = null;
        }
    }

    public void startLookingForFishTask() {
        if (!this.isDead() && this._taskforfish == null) {
            int checkDelay = 0;
            boolean isNoob = false;
            boolean isUpperGrade = false;
            if (this._lure != null) {
                int lureid = this._lure.getId();
                isNoob = this._fish.getFishGrade() == 0;
                boolean bl = isUpperGrade = this._fish.getFishGrade() == 2;
                if (lureid == 6519 || lureid == 6522 || lureid == 6525 || lureid == 8505 || lureid == 8508 || lureid == 8511) {
                    checkDelay = this._fish.getGutsCheckTime() * 133;
                } else if (lureid == 6520 || lureid == 6523 || lureid == 6526 || lureid >= 8505 && lureid <= 8513 || lureid >= 7610 && lureid <= 7613 || lureid >= 7807 && lureid <= 7809 || lureid >= 8484 && lureid <= 8486) {
                    checkDelay = this._fish.getGutsCheckTime() * 100;
                } else if (lureid == 6521 || lureid == 6524 || lureid == 6527 || lureid == 8507 || lureid == 8510 || lureid == 8513) {
                    checkDelay = this._fish.getGutsCheckTime() * 66;
                }
            }
            this._taskforfish = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new LookingForFishTask(this, this._fish.getStartCombatTime(), this._fish.getFishGuts(), this._fish.getFishGroup(), isNoob, isUpperGrade), 10000L, checkDelay);
        }
    }

    private int getRandomFishGrade() {
        return switch (this._lure.getId()) {
            case 7807, 7808, 7809, 8486 -> 0;
            case 8485, 8506, 8509, 8512 -> 2;
            default -> 1;
        };
    }

    private int getRandomFishGroup(int group) {
        int check = Rnd.get((int)100);
        int type = 1;
        block0 : switch (group) {
            case 0: {
                switch (this._lure.getId()) {
                    case 7807: {
                        if (check <= 54) {
                            type = 5;
                            break;
                        }
                        if (check <= 77) {
                            type = 4;
                            break;
                        }
                        type = 6;
                        break;
                    }
                    case 7808: {
                        if (check <= 54) {
                            type = 4;
                            break;
                        }
                        if (check <= 77) {
                            type = 6;
                            break;
                        }
                        type = 5;
                        break;
                    }
                    case 7809: {
                        if (check <= 54) {
                            type = 6;
                            break;
                        }
                        if (check <= 77) {
                            type = 5;
                            break;
                        }
                        type = 4;
                        break;
                    }
                    case 8486: {
                        type = check <= 33 ? 4 : (check <= 66 ? 5 : 6);
                    }
                }
                break;
            }
            case 1: {
                switch (this._lure.getId()) {
                    case 7610: 
                    case 7611: 
                    case 7612: 
                    case 7613: {
                        type = 3;
                        break;
                    }
                    case 6519: 
                    case 6520: 
                    case 6521: 
                    case 8505: 
                    case 8507: {
                        if (check <= 54) {
                            type = 1;
                            break;
                        }
                        if (check <= 74) {
                            type = 0;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6522: 
                    case 6523: 
                    case 6524: 
                    case 8508: 
                    case 8510: {
                        if (check <= 54) {
                            type = 0;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6525: 
                    case 6526: 
                    case 6527: 
                    case 8511: 
                    case 8513: {
                        if (check <= 55) {
                            type = 2;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 0;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 8484: {
                        type = check <= 33 ? 0 : (check <= 66 ? 1 : 2);
                    }
                }
                break;
            }
            case 2: {
                switch (this._lure.getId()) {
                    case 8506: {
                        if (check <= 54) {
                            type = 8;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 7;
                            break block0;
                        }
                        type = 9;
                        break block0;
                    }
                    case 8509: {
                        if (check <= 54) {
                            type = 7;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 9;
                            break block0;
                        }
                        type = 8;
                        break block0;
                    }
                    case 8512: {
                        if (check <= 54) {
                            type = 9;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 8;
                            break block0;
                        }
                        type = 7;
                        break block0;
                    }
                    case 8485: {
                        type = check <= 33 ? 7 : (check <= 66 ? 8 : 9);
                    }
                }
            }
        }
        return type;
    }

    private int getRandomFishLvl() {
        int randomlvl;
        int skilllvl = this.getSkillLevel(1315);
        BuffInfo info = this.getEffectList().getBuffInfoBySkillId(2274);
        if (info != null) {
            skilllvl = 0;
            switch (info.getSkill().getLevel()) {
                case 1: {
                    skilllvl = 2;
                    break;
                }
                case 2: {
                    skilllvl = 5;
                    break;
                }
                case 3: {
                    skilllvl = 8;
                    break;
                }
                case 4: {
                    skilllvl = 11;
                    break;
                }
                case 5: {
                    skilllvl = 14;
                    break;
                }
                case 6: {
                    skilllvl = 17;
                    break;
                }
                case 7: {
                    skilllvl = 20;
                    break;
                }
                case 8: {
                    skilllvl = 23;
                }
            }
        }
        if (skilllvl <= 0) {
            return 1;
        }
        int check = Rnd.get((int)100);
        if (check <= 50) {
            randomlvl = skilllvl;
        } else if (check <= 85) {
            randomlvl = skilllvl - 1;
            if (randomlvl <= 0) {
                randomlvl = 1;
            }
        } else {
            randomlvl = skilllvl + 1;
            if (randomlvl > 27) {
                randomlvl = 27;
            }
        }
        return randomlvl;
    }

    public void startFishCombat(boolean isNoob, boolean isUpperGrade) {
        this._fishCombat = new L2Fishing(this, this._fish, isNoob, isUpperGrade);
    }

    public void endFishing(boolean win) {
        this._fishing = false;
        this._fishx = 0;
        this._fishy = 0;
        this._fishz = 0;
        if (this._fishCombat == null) {
            this.sendPacket(SystemMessageId.BAIT_LOST_FISH_GOT_AWAY);
        }
        this._fishCombat = null;
        this._lure = null;
        this.broadcastPacket(new ExFishingEnd(win, this));
        this.sendPacket(SystemMessageId.REEL_LINE_AND_STOP_FISHING);
        this.setIsImmobilized(false);
        this.stopLookingForFishTask();
    }

    public L2Fishing getFishCombat() {
        return this._fishCombat;
    }

    public int getFishx() {
        return this._fishx;
    }

    public int getFishy() {
        return this._fishy;
    }

    public int getFishz() {
        return this._fishz;
    }

    public L2ItemInstance getLure() {
        return this._lure;
    }

    public void setLure(L2ItemInstance lure) {
        this._lure = lure;
    }

    public int getInventoryLimit() {
        int ivlim = this.isGM() ? Configuration.character().getMaximumSlotsForGMPlayer() : (this.getRace() == Race.DWARF ? Configuration.character().getMaximumSlotsForDwarf() : Configuration.character().getMaximumSlotsForNoDwarf());
        return ivlim += (int)this.getStat().calcStat(Stats.INV_LIM, 0.0, null, null);
    }

    public int getWareHouseLimit() {
        int whlim = this.getRace() == Race.DWARF ? Configuration.character().getMaximumWarehouseSlotsForDwarf() : Configuration.character().getMaximumWarehouseSlotsForNoDwarf();
        return whlim += (int)this.getStat().calcStat(Stats.WH_LIM, 0.0, null, null);
    }

    public int getPrivateSellStoreLimit() {
        int pslim = this.getRace() == Race.DWARF ? Configuration.character().getMaxPvtStoreSellSlotsDwarf() : Configuration.character().getMaxPvtStoreSellSlotsOther();
        return pslim += (int)this.getStat().calcStat(Stats.P_SELL_LIM, 0.0, null, null);
    }

    public int getPrivateBuyStoreLimit() {
        int pblim = this.getRace() == Race.DWARF ? Configuration.character().getMaxPvtStoreBuySlotsDwarf() : Configuration.character().getMaxPvtStoreBuySlotsOther();
        return pblim += (int)this.getStat().calcStat(Stats.P_BUY_LIM, 0.0, null, null);
    }

    public int getDwarfRecipeLimit() {
        int recdlim = Configuration.character().getDwarfRecipeLimit();
        return recdlim += (int)this.getStat().calcStat(Stats.REC_D_LIM, 0.0, null, null);
    }

    public int getCommonRecipeLimit() {
        int recclim = Configuration.character().getCommonRecipeLimit();
        return recclim += (int)this.getStat().calcStat(Stats.REC_C_LIM, 0.0, null, null);
    }

    public int getMountNpcId() {
        return this._mountNpcId;
    }

    public int getMountLevel() {
        return this._mountLevel;
    }

    public int getMountObjectID() {
        return this._mountObjectID;
    }

    public void setMountObjectID(int newID) {
        this._mountObjectID = newID;
    }

    public SkillUseHolder getCurrentSkill() {
        return this._currentSkill;
    }

    public void setCurrentSkill(Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            this._currentSkill = null;
            return;
        }
        this._currentSkill = new SkillUseHolder(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillUseHolder getCurrentPetSkill() {
        return this._currentPetSkill;
    }

    public void setCurrentPetSkill(Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            this._currentPetSkill = null;
            return;
        }
        this._currentPetSkill = new SkillUseHolder(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillUseHolder getQueuedSkill() {
        return this._queuedSkill;
    }

    public void setQueuedSkill(Skill queuedSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (queuedSkill == null) {
            this._queuedSkill = null;
            return;
        }
        this._queuedSkill = new SkillUseHolder(queuedSkill, ctrlPressed, shiftPressed);
    }

    public boolean isJailed() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.JAIL) || PunishmentManager.getInstance().hasPunishment(this.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.JAIL) || PunishmentManager.getInstance().hasPunishment(this.getIPAddress(), PunishmentAffect.IP, PunishmentType.JAIL);
    }

    public boolean isChatBanned() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.CHAT_BAN) || PunishmentManager.getInstance().hasPunishment(this.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.CHAT_BAN) || PunishmentManager.getInstance().hasPunishment(this.getIPAddress(), PunishmentAffect.IP, PunishmentType.CHAT_BAN);
    }

    public void startFameTask(long delay, int fameFixRate) {
        if (this.getLevel() < 40 || this.getClassId().level() < 2) {
            return;
        }
        if (this._fameTask == null) {
            this._fameTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FameTask(this, fameFixRate), delay, delay);
        }
    }

    public void stopFameTask() {
        if (this._fameTask != null) {
            this._fameTask.cancel(false);
            this._fameTask = null;
        }
    }

    public void startVitalityTask() {
        if (Configuration.vitality().enabled() && this._vitalityTask == null) {
            this._vitalityTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new VitalityTask(this), 1000L, 60000L);
        }
    }

    public void stopVitalityTask() {
        if (this._vitalityTask != null) {
            this._vitalityTask.cancel(false);
            this._vitalityTask = null;
        }
    }

    public int getPowerGrade() {
        return this._powerGrade;
    }

    public void setPowerGrade(int power) {
        this._powerGrade = power;
    }

    public boolean isCursedWeaponEquipped() {
        return this._cursedWeaponEquippedId != 0;
    }

    public int getCursedWeaponEquippedId() {
        return this._cursedWeaponEquippedId;
    }

    public void setCursedWeaponEquippedId(int value) {
        this._cursedWeaponEquippedId = value;
    }

    public boolean isCombatFlagEquipped() {
        return this._combatFlagEquippedId;
    }

    public void setCombatFlagEquipped(boolean value) {
        this._combatFlagEquippedId = value;
    }

    public int getChargedSouls() {
        return this._souls;
    }

    public void increaseSouls(int count) {
        this._souls += count;
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SOUL_HAS_INCREASED_BY_S1_SO_IT_IS_NOW_AT_S2);
        sm.addInt(count);
        sm.addInt(this._souls);
        this.sendPacket(sm);
        this.restartSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public int decreaseSouls(int count) {
        int consumedSouls;
        if (this._souls == 0) {
            return 0;
        }
        if (this._souls <= count) {
            consumedSouls = this._souls;
            this._souls = 0;
            this.stopSoulTask();
        } else {
            this._souls -= count;
            consumedSouls = count;
            this.restartSoulTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return consumedSouls;
    }

    public void clearSouls() {
        this._souls = 0;
        this.stopSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    private void restartSoulTask() {
        if (this._soulTask != null) {
            this._soulTask.cancel(false);
            this._soulTask = null;
        }
        this._soulTask = ThreadPoolManager.getInstance().scheduleGeneral(new ResetSoulsTask(this), 600000L);
    }

    public void stopSoulTask() {
        if (this._soulTask != null) {
            this._soulTask.cancel(false);
            this._soulTask = null;
        }
    }

    public int getDeathPenaltyBuffLevel() {
        return this._deathPenaltyBuffLevel;
    }

    public void setDeathPenaltyBuffLevel(int level) {
        this._deathPenaltyBuffLevel = level;
    }

    public void calculateDeathPenaltyBuffLevel(L2Character killer) {
        if (killer == null) {
            LOG.warn("{} called calculateDeathPenaltyBuffLevel with killer null!", (Object)this);
            return;
        }
        if (this.isResurrectSpecialAffected() || this.isLucky() || this.isBlockedFromDeathPenalty() || this.isInsideZone(ZoneId.PVP) || this.isInsideZone(ZoneId.SIEGE) || this.canOverrideCond(PcCondOverride.DEATH_PENALTY)) {
            return;
        }
        double percent = 1.0;
        if (killer.isRaid()) {
            percent *= this.calcStat(Stats.REDUCE_DEATH_PENALTY_BY_RAID, 1.0);
        } else if (killer.isMonster()) {
            percent *= this.calcStat(Stats.REDUCE_DEATH_PENALTY_BY_MOB, 1.0);
        } else if (killer.isPlayable()) {
            percent *= this.calcStat(Stats.REDUCE_DEATH_PENALTY_BY_PVP, 1.0);
        }
        if ((double)Rnd.get((int)1, (int)100) <= (double)Configuration.character().getDeathPenaltyChance() * percent && (!killer.isPlayable() || this.getKarma() > 0)) {
            this.increaseDeathPenaltyBuffLevel();
        }
    }

    public void increaseDeathPenaltyBuffLevel() {
        Skill skill;
        if (this.getDeathPenaltyBuffLevel() >= 15) {
            return;
        }
        if (this.getDeathPenaltyBuffLevel() != 0 && (skill = SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel())) != null) {
            this.removeSkill(skill, true);
        }
        ++this._deathPenaltyBuffLevel;
        this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
        this.sendPacket(new EtcStatusUpdate(this));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
        sm.addInt(this.getDeathPenaltyBuffLevel());
        this.sendPacket(sm);
    }

    public void reduceDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() <= 0) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel());
        if (skill != null) {
            this.removeSkill(skill, true);
        }
        --this._deathPenaltyBuffLevel;
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
            this.sendPacket(new EtcStatusUpdate(this));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
            sm.addInt(this.getDeathPenaltyBuffLevel());
            this.sendPacket(sm);
        } else {
            this.sendPacket(new EtcStatusUpdate(this));
            this.sendPacket(SystemMessageId.DEATH_PENALTY_LIFTED);
        }
    }

    public void restoreDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
        }
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this;
    }

    @Override
    public int getMaxLoad() {
        return (int)this.calcStat(Stats.WEIGHT_LIMIT, Math.floor(BaseStats.CON.calcBonus(this) * 69000.0 * (double)Configuration.character().getWeightLimit()), this, null);
    }

    @Override
    public int getBonusWeightPenalty() {
        return (int)this.calcStat(Stats.WEIGHT_PENALTY, 1.0, this, null);
    }

    @Override
    public int getCurrentLoad() {
        return this.getInventory().getTotalWeight();
    }

    @Override
    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        SystemMessage sm;
        if (miss) {
            SystemMessage sm2;
            if (target.isPlayer()) {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_EVADED_C2_ATTACK);
                sm2.addPcName(target.getActingPlayer());
                sm2.addCharName(this);
                target.sendPacket(sm2);
            }
            sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_ATTACK_WENT_ASTRAY);
            sm2.addPcName(this);
            this.sendPacket(sm2);
            return;
        }
        if (pcrit) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAD_CRITICAL_HIT);
            sm.addPcName(this);
            this.sendPacket(sm);
        }
        if (mcrit) {
            this.sendPacket(SystemMessageId.CRITICAL_HIT_MAGIC);
        }
        if (this.isInOlympiadMode() && target.isPlayer() && target.getActingPlayer().isInOlympiadMode() && target.getActingPlayer().getOlympiadGameId() == this.getOlympiadGameId()) {
            OlympiadGameManager.getInstance().notifyCompetitorDamage(this, damage);
        }
        if ((target.isInvul() || target.isHpBlocked()) && !target.isNpc()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
        } else if (target.isDoor() || target instanceof L2ControlTowerInstance) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DID_S1_DMG);
            sm.addInt(damage);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DONE_S3_DAMAGE_TO_C2);
            sm.addPcName(this);
            sm.addCharName(target);
            sm.addInt(damage);
        }
        this.sendPacket(sm);
    }

    public int getAgathionId() {
        return this._agathionId;
    }

    public void setAgathionId(int npcId) {
        this._agathionId = npcId;
    }

    public int getVitalityPoints() {
        return this.getStat().getVitalityPoints();
    }

    public int getVitalityLevel() {
        return this.getStat().getVitalityLevel();
    }

    public void setVitalityPoints(int points, boolean quiet) {
        this.getStat().setVitalityPoints(points, quiet);
    }

    public void updateVitalityPoints(float points, boolean useRates, boolean quiet) {
        this.getStat().updateVitalityPoints(points, useRates, quiet);
    }

    public void checkItemRestriction() {
        for (int i = 0; i < 25; ++i) {
            L2ItemInstance equippedItem = this.getInventory().getPaperdollItem(i);
            if (equippedItem == null || equippedItem.getItem().checkCondition(this, this, false)) continue;
            this.getInventory().unEquipItemInSlot(i);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(equippedItem);
            this.sendPacket(iu);
            SystemMessage sm = null;
            if (equippedItem.getItem().getBodyPart() == 8192) {
                this.sendPacket(SystemMessageId.CLOAK_REMOVED_BECAUSE_ARMOR_SET_REMOVED);
                return;
            }
            if (equippedItem.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(equippedItem.getEnchantLevel());
                sm.addItemName(equippedItem);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(equippedItem);
            }
            this.sendPacket(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformSkill(Skill sk) {
        if (this._transformSkills == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._transformSkills == null) {
                    this._transformSkills = new ConcurrentHashMap<Integer, Skill>();
                }
            }
        }
        this._transformSkills.put(sk.getId(), sk);
        if (sk.isPassive()) {
            this.addSkill(sk, false);
        }
    }

    public Skill getTransformSkill(int id) {
        if (this._transformSkills == null) {
            return null;
        }
        return this._transformSkills.get(id);
    }

    public boolean hasTransformSkill(int id) {
        if (this._transformSkills == null) {
            return false;
        }
        return this._transformSkills.containsKey(id);
    }

    public void removeAllTransformSkills() {
        this._transformSkills = null;
    }

    protected void startFeed(int npcId) {
        boolean bl = this._canFeed = npcId > 0;
        if (!this.isMounted()) {
            return;
        }
        if (this.hasSummon()) {
            this.setCurrentFeed(((L2PetInstance)this.getSummon()).getCurrentFed());
            this._controlItemId = this.getSummon().getControlObjectId();
            this.sendPacket(new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume()));
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PetFeedTask(this), 10000L, 10000L);
            }
        } else if (this._canFeed) {
            this.setCurrentFeed(this.getMaxFeed());
            SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
            this.sendPacket(sg);
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PetFeedTask(this), 10000L, 10000L);
            }
        }
    }

    public void stopFeed() {
        if (this._mountFeedTask != null) {
            this._mountFeedTask.cancel(false);
            this._mountFeedTask = null;
        }
    }

    private L2PetLevelData getPetLevelData(int npcId) {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetData(npcId).getPetLevelData(this.getMountLevel());
        }
        return this._leveldata;
    }

    public int getCurrentFeed() {
        return this._curFeed;
    }

    public void setCurrentFeed(int num) {
        boolean lastHungryState = this.isHungry();
        this._curFeed = num > this.getMaxFeed() ? this.getMaxFeed() : num;
        SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
        this.sendPacket(sg);
        if (lastHungryState != this.isHungry()) {
            this.broadcastUserInfo();
        }
    }

    public int getFeedConsume() {
        if (this.isAttackingNow()) {
            return this.getPetLevelData(this._mountNpcId).getPetFeedBattle();
        }
        return this.getPetLevelData(this._mountNpcId).getPetFeedNormal();
    }

    private int getMaxFeed() {
        return this.getPetLevelData(this._mountNpcId).getPetMaxFeed();
    }

    public boolean isHungry() {
        return this._canFeed ? (float)this.getCurrentFeed() < (float)PetDataTable.getInstance().getPetData(this.getMountNpcId()).getHungryLimit() / 100.0f * (float)this.getPetLevelData(this.getMountNpcId()).getPetMaxFeed() : false;
    }

    public void enteredNoLanding(int delay) {
        this._dismountTask = ThreadPoolManager.getInstance().scheduleGeneral(new DismountTask(this), delay * 1000);
    }

    public void exitedNoLanding() {
        if (this._dismountTask != null) {
            this._dismountTask.cancel(true);
            this._dismountTask = null;
        }
    }

    public void setIsInSiege(boolean b) {
        this._isInSiege = b;
    }

    public boolean isInSiege() {
        return this._isInSiege;
    }

    public void setIsInHideoutSiege(boolean isInHideoutSiege) {
        this._isInHideoutSiege = isInHideoutSiege;
    }

    public boolean isInHideoutSiege() {
        return this._isInHideoutSiege;
    }

    public FloodProtectors getFloodProtectors() {
        return this.getClient().getFloodProtectors();
    }

    public boolean isFlyingMounted() {
        return this.isTransformed() && this.getTransformation().isFlying();
    }

    public int getCharges() {
        return this._charges.get();
    }

    public void increaseCharges(int count, int max) {
        if (this._charges.get() >= max) {
            this.sendPacket(SystemMessageId.FORCE_MAXLEVEL_REACHED);
            return;
        }
        this.restartChargeTask();
        if (this._charges.addAndGet(count) >= max) {
            this._charges.set(max);
            this.sendPacket(SystemMessageId.FORCE_MAXLEVEL_REACHED);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FORCE_INCREASED_TO_S1);
            sm.addInt(this._charges.get());
            this.sendPacket(sm);
        }
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean decreaseCharges(int count) {
        if (this._charges.get() < count) {
            return false;
        }
        if (this._charges.addAndGet(-count) == 0) {
            this.stopChargeTask();
        } else {
            this.restartChargeTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return true;
    }

    public void clearCharges() {
        this._charges.set(0);
        this.sendPacket(new EtcStatusUpdate(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartChargeTask() {
        if (this._chargeTask != null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._chargeTask != null) {
                    this._chargeTask.cancel(false);
                }
            }
        }
        this._chargeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ResetChargesTask(this), 600000L);
    }

    public void stopChargeTask() {
        if (this._chargeTask != null) {
            this._chargeTask.cancel(false);
            this._chargeTask = null;
        }
    }

    public void teleportBookmarkModify(int id, int icon, String tag, String name) {
        TeleportBookmark bookmark = this._tpbookmarks.get(id);
        if (bookmark != null) {
            bookmark.setIcon(icon);
            bookmark.setTag(tag);
            bookmark.setName(name);
            DAOFactory.getInstance().getTeleportBookmarkDAO().update(this, id, icon, tag, name);
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    public void teleportBookmarkDelete(int id) {
        if (this._tpbookmarks.remove(id) != null) {
            this.sendPacket(new ExGetBookMarkInfoPacket(this));
            DAOFactory.getInstance().getTeleportBookmarkDAO().delete(this, id);
        }
    }

    public void teleportBookmarkGo(int id) {
        if (!this.teleportBookmarkCondition(0)) {
            return;
        }
        if (this.getInventory().getInventoryItemCount(13016, 0) == 0L) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_TELEPORT_BECAUSE_YOU_DO_NOT_HAVE_A_TELEPORT_ITEM);
            return;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(13016);
        this.sendPacket(sm);
        TeleportBookmark bookmark = this._tpbookmarks.get(id);
        if (bookmark != null) {
            this.destroyItem("Consume", this.getInventory().getItemByItemId(13016).getObjectId(), 1L, null, false);
            this.teleToLocation((ILocational)bookmark, false);
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    public boolean teleportBookmarkCondition(int type) {
        if (this.isInCombat()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_BATTLE);
            return false;
        }
        if (this.isInSiege() || this.getSiegeState() != 0) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING);
            return false;
        }
        if (this.isInDuel()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_DUEL);
            return false;
        }
        if (this.isFlying()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_FLYING);
            return false;
        }
        if (this.isInOlympiadMode()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING_IN_AN_OLYMPIAD_MATCH);
            return false;
        }
        if (this.isStunned()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_PARALYZED);
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_DEAD);
            return false;
        }
        if (type == 1 && (this.isIn7sDungeon() || this.isInParty() && this.getParty().isInDimensionalRift())) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            return false;
        }
        if (this.isInWater()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_UNDERWATER);
            return false;
        }
        if (type == 1 && (this.isInsideZone(ZoneId.SIEGE) || this.isInsideZone(ZoneId.CLAN_HALL) || this.isInsideZone(ZoneId.JAIL) || this.isInsideZone(ZoneId.CASTLE) || this.isInsideZone(ZoneId.NO_SUMMON_FRIEND) || this.isInsideZone(ZoneId.FORT))) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            return false;
        }
        if (this.isInsideZone(ZoneId.NO_BOOKMARK) || this.isInBoat() || this.isInAirShip()) {
            if (type == 0) {
                this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA);
            } else if (type == 1) {
                this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            }
            return false;
        }
        return true;
    }

    public void teleportBookmarkAdd(int x, int y, int z, int icon, String tag, String name) {
        int id;
        if (!this.teleportBookmarkCondition(1)) {
            return;
        }
        if (this._tpbookmarks.size() >= this._bookmarkslot) {
            this.sendPacket(SystemMessageId.YOU_HAVE_NO_SPACE_TO_SAVE_THE_TELEPORT_LOCATION);
            return;
        }
        if (this.getInventory().getInventoryItemCount(20033, 0) == 0L) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_BOOKMARK_THIS_LOCATION_BECAUSE_YOU_DO_NOT_HAVE_A_MY_TELEPORT_FLAG);
            return;
        }
        for (id = 1; id <= this._bookmarkslot && this._tpbookmarks.containsKey(id); ++id) {
        }
        this._tpbookmarks.put(id, new TeleportBookmark(id, x, y, z, icon, tag, name));
        this.destroyItem("Consume", this.getInventory().getItemByItemId(20033).getObjectId(), 1L, null, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(20033);
        this.sendPacket(sm);
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
        DAOFactory.getInstance().getTeleportBookmarkDAO().insert(this, id, x, y, z, icon, tag, name);
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this.isInBoat()) {
            this.setXYZ(this.getBoat().getLocation());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new GetOnVehicle(this.getObjectId(), this.getBoat().getObjectId(), this.getInVehiclePosition()));
        } else if (this.isInAirShip()) {
            this.setXYZ(this.getAirShip().getLocation());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new ExGetOnAirShip(this, this.getAirShip()));
        } else {
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
        }
        switch (this.getPrivateStoreType()) {
            case SELL: {
                activeChar.sendPacket(new PrivateStoreMsgSell(this));
                break;
            }
            case PACKAGE_SELL: {
                activeChar.sendPacket(new ExPrivateStoreSetWholeMsg(this));
                break;
            }
            case BUY: {
                activeChar.sendPacket(new PrivateStoreMsgBuy(this));
                break;
            }
            case MANUFACTURE: {
                activeChar.sendPacket(new RecipeShopMsg(this));
            }
        }
        if (this.isTransformed()) {
            this.sendPacket(new CharInfo(activeChar));
        }
    }

    public void showQuestMovie(int id) {
        if (this._movieId > 0) {
            return;
        }
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this._movieId = id;
        this.sendPacket(new ExStartScenePlayer(id));
    }

    public boolean isAllowedToEnchantSkills() {
        if (this.isLocked()) {
            return false;
        }
        if (this.isTransformed() || this.isInStance()) {
            return false;
        }
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this)) {
            return false;
        }
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            return false;
        }
        return !this.isInBoat() && !this.isInAirShip();
    }

    public Calendar getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Calendar createDate) {
        this._createDate = createDate;
    }

    public int checkBirthDay() {
        Calendar now = Calendar.getInstance();
        if (this._createDate.get(5) == 29 && this._createDate.get(2) == 1) {
            this._createDate.add(11, -24);
        }
        if (now.get(2) == this._createDate.get(2) && now.get(5) == this._createDate.get(5) && now.get(1) != this._createDate.get(1)) {
            return 0;
        }
        for (int i = 1; i < 6; ++i) {
            now.add(11, 24);
            if (now.get(2) != this._createDate.get(2) || now.get(5) != this._createDate.get(5) || now.get(1) == this._createDate.get(1)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getFriends() {
        if (this._friends == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._friends == null) {
                    this._friends = ConcurrentHashMap.newKeySet(1);
                }
            }
        }
        return this._friends;
    }

    public boolean hasFriends() {
        return this._friends != null && !this._friends.isEmpty();
    }

    public boolean isFriend(int objectId) {
        return this.hasFriends() && this._friends.contains(objectId);
    }

    public void addFriend(int objectId) {
        this.getFriends().add(objectId);
    }

    public void removeFriend(int objectId) {
        if (this.hasFriends()) {
            this._friends.remove(objectId);
        }
    }

    private void notifyFriends() {
        if (this.hasFriends()) {
            FriendStatusPacket pkt = new FriendStatusPacket(this.getObjectId());
            for (int id : this._friends) {
                L2PcInstance friend = L2World.getInstance().getPlayer(id);
                if (friend == null) continue;
                friend.sendPacket(pkt);
            }
        }
    }

    public boolean isSilenceMode() {
        return this._silenceMode;
    }

    public void setSilenceMode(boolean mode) {
        this._silenceMode = mode;
        if (this._silenceModeExcluded != null) {
            this._silenceModeExcluded.clear();
        }
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean isSilenceMode(int playerObjId) {
        if (Configuration.character().silenceModeExclude() && this._silenceMode && this._silenceModeExcluded != null) {
            return !this._silenceModeExcluded.contains(playerObjId);
        }
        return this._silenceMode;
    }

    public void addSilenceModeExcluded(int playerObjId) {
        if (this._silenceModeExcluded == null) {
            this._silenceModeExcluded = new ArrayList<Integer>(1);
        }
        this._silenceModeExcluded.add(playerObjId);
    }

    public double getCollisionRadius() {
        if (this.isMounted() && this.getMountNpcId() > 0) {
            return NpcData.getInstance().getTemplate(this.getMountNpcId()).getfCollisionRadius();
        }
        if (this.isTransformed()) {
            return this.getTransformation().getCollisionRadius(this);
        }
        return this.getAppearance().getSex() ? this.getBaseTemplate().getFCollisionRadiusFemale() : this.getBaseTemplate().getfCollisionRadius();
    }

    public double getCollisionHeight() {
        if (this.isMounted() && this.getMountNpcId() > 0) {
            return NpcData.getInstance().getTemplate(this.getMountNpcId()).getfCollisionHeight();
        }
        if (this.isTransformed()) {
            return this.getTransformation().getCollisionHeight(this);
        }
        return this.getAppearance().getSex() ? this.getBaseTemplate().getFCollisionHeightFemale() : this.getBaseTemplate().getfCollisionHeight();
    }

    public int getClientX() {
        return this._clientX;
    }

    public void setClientX(int val) {
        this._clientX = val;
    }

    public int getClientY() {
        return this._clientY;
    }

    public void setClientY(int val) {
        this._clientY = val;
    }

    public int getClientZ() {
        return this._clientZ;
    }

    public void setClientZ(int val) {
        this._clientZ = val;
    }

    public int getClientHeading() {
        return this._clientHeading;
    }

    public void setClientHeading(int val) {
        this._clientHeading = val;
    }

    public boolean isFalling(int z) {
        if (this.isDead() || this.isFlying() || this.isFlyingMounted() || this.isInsideZone(ZoneId.WATER)) {
            return false;
        }
        if (System.currentTimeMillis() < this._fallingTimestamp) {
            return true;
        }
        int deltaZ = this.getZ() - z;
        if (deltaZ <= this.getBaseTemplate().getSafeFallHeight()) {
            return false;
        }
        if (!GeoData.getInstance().hasGeo(this.getX(), this.getY())) {
            return false;
        }
        int damage = (int)Formulas.calcFallDam(this, deltaZ);
        if (damage > 0) {
            this.reduceCurrentHp(Math.min((double)damage, this.getCurrentHp() - 1.0), null, false, true, null);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FALL_DAMAGE_S1);
            sm.addInt(damage);
            this.sendPacket(sm);
        }
        this.setFalling();
        return false;
    }

    public void setFalling() {
        this._fallingTimestamp = System.currentTimeMillis() + 10000L;
    }

    public int getMovieId() {
        return this._movieId;
    }

    public void setMovieId(int id) {
        this._movieId = id;
    }

    public void updateLastItemAuctionRequest() {
        this._lastItemAuctionInfoRequest = System.currentTimeMillis();
    }

    public boolean isItemAuctionPolling() {
        return System.currentTimeMillis() - this._lastItemAuctionInfoRequest < 2000L;
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || this._movieId > 0;
    }

    private void restoreUISettings() {
        this._uiKeySettings = new UIKeysSettings(this.getObjectId());
    }

    private void storeUISettings() {
        if (this._uiKeySettings == null) {
            return;
        }
        if (!this._uiKeySettings.isSaved()) {
            this._uiKeySettings.saveInDB();
        }
    }

    public UIKeysSettings getUISettings() {
        return this._uiKeySettings;
    }

    public String getHtmlPrefix() {
        if (!Configuration.customs().multiLangEnable()) {
            return null;
        }
        return this._htmlPrefix;
    }

    public String getLang() {
        return this._lang;
    }

    public boolean setLang(String lang) {
        boolean result = false;
        if (Configuration.customs().multiLangEnable()) {
            if (Configuration.customs().getMultiLangAllowed().contains(lang)) {
                this._lang = lang;
                result = true;
            } else {
                this._lang = Configuration.customs().getMultiLangDefault();
            }
            this._htmlPrefix = "data/lang/" + this._lang + "/";
        } else {
            this._lang = null;
            this._htmlPrefix = null;
        }
        return result;
    }

    public long getOfflineStartTime() {
        return this._offlineShopStart;
    }

    public void setOfflineStartTime(long time) {
        this._offlineShopStart = time;
    }

    public void removeFromBossZone() {
        try {
            for (L2BossZone zone : GrandBossManager.getInstance().getZones().values()) {
                zone.removePlayer(this);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception on removeFromBossZone(): {}", e);
        }
    }

    public void checkPlayerSkills() {
        for (Map.Entry<Integer, Skill> e : this.getSkills().entrySet()) {
            int lvlDiff;
            L2SkillLearn learn = SkillTreesData.getInstance().getClassSkill(e.getKey(), e.getValue().getLevel() % 100, this.getClassId());
            if (learn == null) continue;
            int n = lvlDiff = e.getKey().intValue() == CommonSkill.EXPERTISE.getId() ? 0 : 9;
            if (this.getLevel() >= learn.getGetLevel() - lvlDiff) continue;
            this.deacreaseSkillLevel(e.getValue(), lvlDiff);
        }
    }

    private void deacreaseSkillLevel(Skill skill, int lvlDiff) {
        int nextLevel = -1;
        Map<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(this.getClassId());
        for (L2SkillLearn sl : skillTree.values()) {
            if (sl.getSkillId() != skill.getId() || nextLevel >= sl.getSkillLevel() || this.getLevel() < sl.getGetLevel() - lvlDiff) continue;
            nextLevel = sl.getSkillLevel();
        }
        if (nextLevel == -1) {
            LOG.info("Removing {}, from {}", (Object)skill, (Object)this);
            this.removeSkill(skill, true);
        } else {
            LOG.info("Decreasing {} to {} for {}", skill, nextLevel, this);
            this.addSkill(SkillData.getInstance().getSkill(skill.getId(), nextLevel), true);
        }
    }

    public boolean canMakeSocialAction() {
        return this.getPrivateStoreType() == PrivateStoreType.NONE && this.getActiveRequester() == null && !this.isAlikeDead() && !this.isAllSkillsDisabled() && !this.isCastingNow() && !this.isCastingSimultaneouslyNow() && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE;
    }

    public void setMultiSocialAction(int id, int targetId) {
        this._multiSociaAction = id;
        this._multiSocialTarget = targetId;
    }

    public int getMultiSociaAction() {
        return this._multiSociaAction;
    }

    public int getMultiSocialTarget() {
        return this._multiSocialTarget;
    }

    public Collection<TeleportBookmark> getTeleportBookmarks() {
        return this._tpbookmarks.values();
    }

    public int getBookmarkslot() {
        return this._bookmarkslot;
    }

    public int getQuestInventoryLimit() {
        return Configuration.character().getMaximumSlotsForQuestItems();
    }

    public boolean canAttackCharacter(L2Character cha) {
        if (cha instanceof L2Attackable) {
            return true;
        }
        if (cha instanceof L2Playable) {
            if (cha.isInsideZone(ZoneId.PVP) && !cha.isInsideZone(ZoneId.SIEGE)) {
                return true;
            }
            L2PcInstance target = cha instanceof L2Summon ? ((L2Summon)cha).getOwner() : (L2PcInstance)cha;
            if (this.isInDuel() && target.isInDuel() && target.getDuelId() == this.getDuelId()) {
                return true;
            }
            if (this.isInParty() && target.isInParty()) {
                if (this.getParty() == target.getParty()) {
                    return false;
                }
                if ((this.getParty().getCommandChannel() != null || target.getParty().getCommandChannel() != null) && this.getParty().getCommandChannel() == target.getParty().getCommandChannel()) {
                    return false;
                }
            } else if (this.getClan() != null && target.getClan() != null) {
                if (this.getClanId() == target.getClanId()) {
                    return false;
                }
                if ((this.getAllyId() > 0 || target.getAllyId() > 0) && this.getAllyId() == target.getAllyId()) {
                    return false;
                }
                if (this.getClan().isAtWarWith(target.getClan().getId()) && target.getClan().isAtWarWith(this.getClan().getId())) {
                    return true;
                }
            } else if ((this.getClan() == null || target.getClan() == null) && target.getPvpFlag() == 0 && target.getKarma() == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isInventoryUnder90(boolean includeQuestInv) {
        return (double)this.getInventory().getSize(includeQuestInv) <= (double)this.getInventoryLimit() * 0.9;
    }

    public boolean havePetInvItems() {
        return this._petItems;
    }

    public void setPetInvItems(boolean haveit) {
        this._petItems = haveit;
    }

    public String getAdminConfirmCmd() {
        return this._adminConfirmCmd;
    }

    public void setAdminConfirmCmd(String adminConfirmCmd) {
        this._adminConfirmCmd = adminConfirmCmd;
    }

    public int getBlockCheckerArena() {
        return this._handysBlockCheckerEventArena;
    }

    public void setBlockCheckerArena(byte arena) {
        this._handysBlockCheckerEventArena = arena;
    }

    public HuntingSystem getHuntingSystem() {
        return this._huntingSystem;
    }

    public RecommendationSystem getRecSystem() {
        return this._recSystem;
    }

    public boolean hasAbnormalType(AbnormalType at) {
        return this.getEffectList().getBuffInfoByAbnormalType(at) != null;
    }

    public boolean hasAbnormalTypeVote() {
        return this.hasAbnormalType(AbnormalType.VOTE);
    }

    public String getLastPetitionGmName() {
        return this._lastPetitionGmName;
    }

    public void setLastPetitionGmName(String gmName) {
        this._lastPetitionGmName = gmName;
    }

    public L2ContactList getContactList() {
        return this._contactList;
    }

    public void setEventStatus() {
        this.eventStatus = new PlayerEventHolder(this);
    }

    public PlayerEventHolder getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(PlayerEventHolder pes) {
        this.eventStatus = pes;
    }

    public long getNotMoveUntil() {
        return this._notMoveUntil;
    }

    public void updateNotMoveUntil() {
        this._notMoveUntil = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(Configuration.character().getNpcTalkBlockingTime());
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        return weapon != null && weapon.isChargedShot(type);
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon != null) {
            weapon.setChargedShot(type, charged);
        }
    }

    public Skill getCustomSkill(int skillId) {
        return this._customSkills != null ? this._customSkills.get(skillId) : null;
    }

    private void addCustomSkill(Skill skill) {
        if (skill != null && skill.getDisplayId() != skill.getId()) {
            if (this._customSkills == null) {
                this._customSkills = new ConcurrentHashMap<Integer, Skill>();
            }
            this._customSkills.put(skill.getDisplayId(), skill);
        }
    }

    private void removeCustomSkill(Skill skill) {
        if (skill != null && this._customSkills != null && skill.getDisplayId() != skill.getId()) {
            this._customSkills.remove(skill.getDisplayId());
        }
    }

    @Override
    public boolean canRevive() {
        for (IEventListener listener : this._eventListeners) {
            if (!listener.isOnEvent() || listener.canRevive()) continue;
            return false;
        }
        return this._canRevive;
    }

    @Override
    public void setCanRevive(boolean val) {
        this._canRevive = val;
    }

    @Override
    public boolean isOnEvent() {
        for (IEventListener listener : this._eventListeners) {
            if (!listener.isOnEvent()) continue;
            return true;
        }
        return super.isOnEvent();
    }

    public boolean isBlockedFromExit() {
        for (IEventListener listener : this._eventListeners) {
            if (!listener.isOnEvent() || !listener.isBlockingExit()) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockedFromDeathPenalty() {
        for (IEventListener listener : this._eventListeners) {
            if (!listener.isOnEvent() || !listener.isBlockingDeathPenalty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addOverrideCond(PcCondOverride ... excs) {
        super.addOverrideCond(excs);
        this.getVariables().set(COND_OVERRIDE_KEY, Long.toString(this._exceptions));
    }

    @Override
    public void removeOverridedCond(PcCondOverride ... excs) {
        super.removeOverridedCond(excs);
        this.getVariables().set(COND_OVERRIDE_KEY, Long.toString(this._exceptions));
    }

    public boolean hasVariables() {
        return this.getScript(PlayerVariables.class) != null;
    }

    public PlayerVariables getVariables() {
        PlayerVariables vars = this.getScript(PlayerVariables.class);
        return vars != null ? vars : this.addScript(new PlayerVariables(this.getObjectId()));
    }

    public boolean hasAccountVariables() {
        return this.getScript(AccountVariables.class) != null;
    }

    public AccountVariables getAccountVariables() {
        AccountVariables vars = this.getScript(AccountVariables.class);
        return vars != null ? vars : this.addScript(new AccountVariables(this.getAccountName()));
    }

    public void addEventListener(IEventListener listener) {
        this._eventListeners.add(listener);
    }

    public void removeEventListener(IEventListener listener) {
        this._eventListeners.remove(listener);
    }

    public void removeEventListener(Class<? extends IEventListener> clazz) {
        this._eventListeners.removeIf(e -> e.getClass() == clazz);
    }

    public Collection<IEventListener> getEventListeners() {
        return this._eventListeners;
    }

    @Override
    public int getId() {
        return this.getClassId().getId();
    }

    public boolean isPartyBanned() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.PARTY_BAN);
    }

    public boolean addAction(PlayerAction act) {
        if (!this.hasAction(act)) {
            this._actionMask |= act.getMask();
            return true;
        }
        return false;
    }

    public boolean removeAction(PlayerAction act) {
        if (this.hasAction(act)) {
            this._actionMask &= ~act.getMask();
            return true;
        }
        return false;
    }

    public boolean hasAction(PlayerAction act) {
        return (this._actionMask & act.getMask()) == act.getMask();
    }

    public void setCharmOfCourage(boolean val) {
        this._hasCharmOfCourage = val;
    }

    public boolean hasCharmOfCourage() {
        return this._hasCharmOfCourage;
    }

    public boolean isAtWarWith(L2Character target) {
        if (target == null) {
            return false;
        }
        if (this._clan != null && !this.isAcademyMember() && target.getClan() != null && !target.isAcademyMember()) {
            return this._clan.isAtWarWith(target.getClan());
        }
        return false;
    }

    public boolean isInPartyWith(L2Character target) {
        if (!this.isInParty() || !target.isInParty()) {
            return false;
        }
        return this.getParty().getLeaderObjectId() == target.getParty().getLeaderObjectId();
    }

    public boolean isInCommandChannelWith(L2Character target) {
        if (!this.isInParty() || !target.isInParty()) {
            return false;
        }
        if (!this.getParty().isInCommandChannel() || !target.getParty().isInCommandChannel()) {
            return false;
        }
        return this.getParty().getCommandChannel().getLeaderObjectId() == target.getParty().getCommandChannel().getLeaderObjectId();
    }

    public boolean isInClanWith(L2Character target) {
        if (this.getClanId() == 0 || target.getClanId() == 0) {
            return false;
        }
        return this.getClanId() == target.getClanId();
    }

    public boolean isInAllyWith(L2Character target) {
        if (this.getAllyId() == 0 || target.getAllyId() == 0) {
            return false;
        }
        return this.getAllyId() == target.getAllyId();
    }

    public boolean isInDuelWith(L2Character target) {
        if (!this.isInDuel() || !target.isInDuel()) {
            return false;
        }
        return this.getDuelId() == target.getDuelId();
    }

    public boolean isOnSameSiegeSideWith(L2Character target) {
        return this.getSiegeState() > 0 && this.isInsideZone(ZoneId.SIEGE) && this.getSiegeState() == target.getSiegeState() && this.getSiegeSide() == target.getSiegeSide();
    }

    public void setServitorShare(Map<Stats, Double> map) {
        this._servitorShare = map;
    }

    public double getServitorShareBonus(Stats stat) {
        if (this._servitorShare == null) {
            return 1.0;
        }
        return this._servitorShare.get((Object)stat);
    }

    public boolean canSummonTarget(L2PcInstance target) {
        if (this == target) {
            return false;
        }
        if (target.isAlikeDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_DEAD_AT_THE_MOMENT_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(target);
            this.sendPacket(sm);
            return false;
        }
        if (target.isInStoreMode()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CURRENTLY_TRADING_OR_OPERATING_PRIVATE_STORE_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(target);
            this.sendPacket(sm);
            return false;
        }
        if (target.isRooted() || target.isInCombat()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ENGAGED_IN_COMBAT_AND_CANNOT_BE_SUMMONED);
            sm.addPcName(target);
            this.sendPacket(sm);
            return false;
        }
        if (target.isInOlympiadMode() || OlympiadManager.getInstance().isRegisteredInComp(target)) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_SUMMON_PLAYERS_WHO_ARE_IN_OLYMPIAD);
            return false;
        }
        if (target.isFestivalParticipant() || target.isFlyingMounted() || target.isCombatFlagEquipped() || !TvTEvent.onEscapeUse(target.getObjectId())) {
            this.sendPacket(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING);
            return false;
        }
        if (target.inObserverMode()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_STATE_FORBIDS_SUMMONING);
            sm.addCharName(target);
            this.sendPacket(sm);
            return false;
        }
        if (target.isInsideZone(ZoneId.NO_SUMMON_FRIEND) || target.isInsideZone(ZoneId.JAIL)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IN_SUMMON_BLOCKING_AREA);
            sm.addString(target.getName());
            this.sendPacket(sm);
            return false;
        }
        if (this.isInsideZone(ZoneId.NO_SUMMON_FRIEND) || this.isInsideZone(ZoneId.JAIL) || this.isFlyingMounted()) {
            this.sendPacket(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING);
            return false;
        }
        if (!(this.getInstanceId() <= 0 || Configuration.general().allowSummonInInstance() && InstanceManager.getInstance().getInstance(this.getInstanceId()).isSummonAllowed())) {
            this.sendPacket(SystemMessageId.YOU_MAY_NOT_SUMMON_FROM_YOUR_CURRENT_LOCATION);
            return false;
        }
        if (this.isIn7sDungeon()) {
            int targetCabal = SevenSigns.getInstance().getPlayerCabal(target.getObjectId());
            if (SevenSigns.getInstance().isSealValidationPeriod()) {
                if (targetCabal != SevenSigns.getInstance().getCabalHighestScore()) {
                    this.sendPacket(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING);
                    return false;
                }
            } else if (targetCabal == 0) {
                this.sendPacket(SystemMessageId.YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING);
                return false;
            }
        }
        return true;
    }

    public Map<Integer, TeleportBookmark> getTpbookmarks() {
        return this._tpbookmarks;
    }

    public long getOnlineTime() {
        return this._onlineTime;
    }

    public void setOnlineTime(long time) {
        this._onlineTime = time;
        this._onlineBeginTime = System.currentTimeMillis();
    }

    public void setHenna(L2Henna[] henna) {
        this._henna = henna;
    }

    public long getOnlineBeginTime() {
        return this._onlineBeginTime;
    }

    public int getControlItemId() {
        return this._controlItemId;
    }

    public void setControlItemId(int controlItemId) {
        this._controlItemId = controlItemId;
    }

    public void getDwarvenRecipeBookClear() {
        this._dwarvenRecipeBook.clear();
    }

    public void debugFeature(String feature, String msg) {
        msg = feature + " (" + this.getName() + ") " + (String)msg;
        LOG.debug((String)msg);
        this.sendDebugMessage((String)msg);
    }

    public void debugFeature(String feature, String msg, Object arg) {
        msg = feature + " (" + this.getName() + ") " + (String)msg;
        FormattingTuple formatted = MessageFormatter.format((String)msg, arg);
        LOG.debug(formatted.getMessage());
        this.sendDebugMessage(formatted.getMessage());
    }

    public void debugFeature(String feature, String msg, Object ... args) {
        msg = feature + " (" + this.getName() + ") " + (String)msg;
        FormattingTuple formatted = MessageFormatter.format((String)msg, args);
        LOG.debug(formatted.getMessage());
        this.sendDebugMessage(formatted.getMessage());
    }
}

