/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.data.sql.impl.CharSummonTable;
import com.l2jserver.gameserver.data.sql.impl.SummonEffectsTable;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.PartyDistributionType;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PetStat;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExChangeNpcState;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2PetInstance
extends L2Summon {
    private static final Logger LOG = LoggerFactory.getLogger(L2PetInstance.class);
    private int _curFed;
    private final PetInventory _inventory;
    private final int _controlObjectId;
    private boolean _respawned;
    private final boolean _mountable;
    private Future<?> _feedTask;
    private L2PetData _data;
    private L2PetLevelData _leveldata;
    private long _expBeforeDeath = 0L;
    private int _curWeightPenalty = 0;
    protected boolean _bufferMode = true;

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        this(objectId, template, owner, control, (byte)(template.getDisplayId() == 12564 ? owner.getLevel() : (int)template.getLevel()));
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control, byte level) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2PetInstance);
        this._controlObjectId = control.getObjectId();
        this.getStat().setLevel(Math.max(level, this.getMinLevel()));
        this._inventory = new PetInventory(this);
        this._inventory.restore();
        int npcId = template.getId();
        this._mountable = PetDataTable.isMountable(npcId);
        this.getPetData();
        this.getPetLevelData();
    }

    public final L2PetLevelData getPetLevelData() {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetLevelData(this.getTemplate().getId(), this.getStat().getLevel());
        }
        return this._leveldata;
    }

    public final L2PetData getPetData() {
        if (this._data == null) {
            this._data = PetDataTable.getInstance().getPetData(this.getTemplate().getId());
        }
        return this._data;
    }

    public final void setPetData(L2PetLevelData value) {
        this._leveldata = value;
    }

    public static synchronized L2PetInstance spawnPet(L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        if (L2World.getInstance().getPet(owner.getObjectId()) != null) {
            return null;
        }
        L2PetData data = PetDataTable.getInstance().getPetData(template.getId());
        L2PetInstance pet = DAOFactory.getInstance().getPetDAO().load(control, template, owner);
        if (pet != null) {
            pet.setTitle(owner.getName());
            if (data.isSyncLevel() && pet.getLevel() != owner.getLevel()) {
                pet.getStat().setLevel(owner.getLevel());
                pet.getStat().setExp(pet.getStat().getExpForLevel(owner.getLevel()));
            }
            L2World.getInstance().addPet(owner.getObjectId(), pet);
        }
        return pet;
    }

    @Override
    public PetStat getStat() {
        return (PetStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PetStat(this));
    }

    public boolean isRespawned() {
        return this._respawned;
    }

    public void setRespawned(boolean respawned) {
        this._respawned = respawned;
    }

    @Override
    public int getSummonType() {
        return 2;
    }

    @Override
    public int getControlObjectId() {
        return this._controlObjectId;
    }

    public L2ItemInstance getControlItem() {
        return this.getOwner().getInventory().getItemByObjectId(this._controlObjectId);
    }

    public int getCurrentFed() {
        return this._curFed;
    }

    public void setCurrentFed(int num) {
        if (num <= 0) {
            this.sendPacket(new ExChangeNpcState(this.getObjectId(), 100));
        } else if (this._curFed <= 0) {
            this.sendPacket(new ExChangeNpcState(this.getObjectId(), 101));
        }
        this._curFed = Math.min(num, this.getMaxFed());
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        for (L2ItemInstance item : this.getInventory().getItems()) {
            if (item.getItemLocation() != ItemLocation.PET_EQUIP || item.getItem().getBodyPart() != 128) continue;
            return item;
        }
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return null;
        }
        return (L2Weapon)weapon.getItem();
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public PetInventory getInventory() {
        return this._inventory;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItem(process, objectId, count, this.getOwner(), (Object)reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getId());
                sm.addLong(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getId());
                this.sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItemByItemId(process, itemId, count, this.getOwner(), reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getId());
                sm.addLong(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getId());
                this.sendPacket(sm);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPickupItem(L2Object object) {
        if (this.isDead()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this.broadcastPacket(new StopMove(this));
        if (!(object instanceof L2ItemInstance)) {
            LOG.warn("{} trying to pickup wrong target. {}", (Object)this, (Object)object);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        boolean follow = this.getFollowStatus();
        L2ItemInstance target = (L2ItemInstance)object;
        if (CursedWeaponsManager.getInstance().isCursed(target.getId())) {
            SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
            smsg.addItemName(target.getId());
            this.sendPacket(smsg);
            return;
        }
        if (FortSiegeManager.getInstance().isCombat(target.getId())) {
            return;
        }
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!target.getDropProtection().tryPickUp(this)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                sm.addItemName(target);
                this.sendPacket(sm);
                return;
            }
            if ((this.isInParty() && this.getParty().getDistributionType() == PartyDistributionType.FINDERS_KEEPERS || !this.isInParty()) && !this._inventory.validateCapacity(target)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS);
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getOwner().getObjectId() && !this.getOwner().isInLooterParty(target.getOwnerId())) {
                SystemMessage sm;
                if (target.getId() == 57) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    sm.addLong(target.getCount());
                } else if (target.getCount() > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    sm.addItemName(target);
                    sm.addLong(target.getCount());
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    sm.addItemName(target);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(sm);
                return;
            }
            if (target.getItemLootSchedule() != null && (target.getOwnerId() == this.getOwner().getObjectId() || this.getOwner().isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Configuration.general().saveDroppedItem()) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItem().hasExImmediateEffect()) {
            IItemHandler handler = ItemHandler.getInstance().getHandler(target.getEtcItem());
            if (handler == null) {
                LOG.warn("No item handler registered for item ID: {}.", (Object)target.getId());
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this.getOwner(), null);
            this.broadcastStatusUpdate();
        } else {
            if (target.getId() == 57) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_ADENA);
                sm.addLong(target.getCount());
                this.sendPacket(sm);
            } else if (target.getEnchantLevel() > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_S2);
                sm.addInt(target.getEnchantLevel());
                sm.addItemName(target);
                this.sendPacket(sm);
            } else if (target.getCount() > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S2_S1_S);
                sm.addLong(target.getCount());
                sm.addItemName(target);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1);
                sm.addItemName(target);
                this.sendPacket(sm);
            }
            if (this.getOwner().isInParty() && this.getOwner().getParty().getDistributionType() != PartyDistributionType.FINDERS_KEEPERS) {
                this.getOwner().getParty().distributeItem(this.getOwner(), target);
            } else {
                L2ItemInstance item = this.getInventory().addItem("Pickup", target, this.getOwner(), (Object)this);
                this.sendPacket(new PetInventoryUpdate(item));
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (follow) {
            this.followOwner();
        }
    }

    @Override
    public void deleteMe(L2PcInstance owner) {
        this.getInventory().transferItemsToOwner();
        super.deleteMe(owner);
        this.destroyControlItem(owner, false);
        CharSummonTable.getInstance().getPets().remove(this.getOwner().getObjectId());
    }

    @Override
    public boolean doDie(L2Character killer) {
        L2PcInstance owner = this.getOwner();
        if (!(owner == null || owner.isInDuel() || this.isInsideZone(ZoneId.PVP) && !this.isInsideZone(ZoneId.SIEGE))) {
            this.deathPenalty();
        }
        if (!super.doDie(killer, true)) {
            return false;
        }
        this.stopFeed();
        this.sendPacket(SystemMessageId.MAKE_SURE_YOU_RESSURECT_YOUR_PET_WITHIN_24_HOURS);
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    @Override
    public void doRevive() {
        this.getOwner().removeReviving();
        super.doRevive();
        DecayTaskManager.getInstance().cancel(this);
        this.startFeed();
        if (!this.isHungry()) {
            this.setRunning();
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
    }

    @Override
    public void doRevive(double revivePower) {
        this.restoreExp(revivePower);
        this.doRevive();
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2PcInstance actor, L2Object reference) {
        L2ItemInstance oldItem = this.getInventory().getItemByObjectId(objectId);
        L2ItemInstance playerOldItem = target.getItemByItemId(oldItem.getId());
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, actor, reference);
        if (newItem == null) {
            return null;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        if (oldItem.getCount() > 0L && oldItem != newItem) {
            petIU.addModifiedItem(oldItem);
        } else {
            petIU.addRemovedItem(oldItem);
        }
        this.sendPacket(petIU);
        if (!newItem.isStackable()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addNewItem(newItem);
            this.sendPacket(iu);
        } else if (playerOldItem != null) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(newItem);
            this.sendPacket(iu);
        }
        return newItem;
    }

    public void destroyControlItem(L2PcInstance owner, boolean evolve) {
        L2World.getInstance().removePet(owner.getObjectId());
        try {
            L2ItemInstance removedItem;
            if (evolve) {
                removedItem = owner.getInventory().destroyItem("Evolve", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
            } else {
                removedItem = owner.getInventory().destroyItem("PetDestroy", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
                if (removedItem != null) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(removedItem);
                    owner.sendPacket(sm);
                }
            }
            if (removedItem == null) {
                LOG.warn("Couldn't destroy pet control item for {} pet: {} evolve: {}", owner, this, evolve);
            } else {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(removedItem);
                owner.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(owner);
                su.addAttribute(14, owner.getCurrentLoad());
                owner.sendPacket(su);
                owner.broadcastUserInfo();
                L2World.getInstance().removeObject(removedItem);
            }
        }
        catch (Exception ex) {
            LOG.error("Error destroying control item for pet {} and player {}!", this, owner, ex);
        }
        DAOFactory.getInstance().getPetDAO().delete(this);
    }

    public void dropAllItems() {
        try {
            for (L2ItemInstance item : this.getInventory().getItems()) {
                this.dropItemHere(item);
            }
        }
        catch (Exception ex) {
            LOG.warn("Error dropping all items for pet {}!", (Object)this, (Object)ex);
        }
    }

    public void dropItemHere(L2ItemInstance dropit, boolean protect) {
        dropit = this.getInventory().dropItem("Drop", dropit.getObjectId(), dropit.getCount(), this.getOwner(), this);
        if (dropit != null) {
            if (protect) {
                dropit.getDropProtection().protect(this.getOwner());
            }
            LOG.info("Item id to drop: {} amount: {}", (Object)dropit.getId(), (Object)dropit.getCount());
            dropit.dropMe(this, this.getX(), this.getY(), this.getZ() + 100);
        }
    }

    public void dropItemHere(L2ItemInstance dropit) {
        this.dropItemHere(dropit, false);
    }

    @Override
    public boolean isMountable() {
        return this._mountable;
    }

    @Override
    public final void stopSkillEffects(boolean removed, int skillId) {
        super.stopSkillEffects(removed, skillId);
        SummonEffectsTable.getInstance().removePetEffects(this.getControlObjectId(), skillId);
    }

    @Override
    public void storeMe() {
        if (this.getControlObjectId() == 0) {
            return;
        }
        if (!Configuration.character().restorePetOnReconnect()) {
            this.setRestoreSummon(false);
        }
        if (!this.isRespawned()) {
            DAOFactory.getInstance().getPetDAO().insert(this);
        } else {
            DAOFactory.getInstance().getPetDAO().update(this);
        }
        this.setRespawned(true);
        if (this.isRestoreSummon()) {
            CharSummonTable.getInstance().getPets().put(this.getOwner().getObjectId(), this.getControlObjectId());
        } else {
            CharSummonTable.getInstance().getPets().remove(this.getOwner().getObjectId());
        }
        L2ItemInstance itemInst = this.getControlItem();
        if (itemInst != null && itemInst.getEnchantLevel() != this.getStat().getLevel()) {
            itemInst.setEnchantLevel(this.getStat().getLevel());
            itemInst.updateDatabase();
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        if (!Configuration.character().summonStoreSkillCooltime()) {
            return;
        }
        SummonEffectsTable.getInstance().clearPetEffects(this.getControlObjectId());
        DAOFactory.getInstance().getPetSkillSaveDAO().insert(this, storeEffects);
    }

    @Override
    public void restoreEffects() {
        DAOFactory.getInstance().getPetSkillSaveDAO().load(this);
        SummonEffectsTable.getInstance().applyPetEffects(this, this.getControlObjectId());
    }

    public synchronized void stopFeed() {
        if (this._feedTask != null) {
            this._feedTask.cancel(false);
            this._feedTask = null;
        }
    }

    public synchronized void startFeed() {
        this.stopFeed();
        if (!this.isDead() && this.getOwner().getSummon() == this) {
            this._feedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FeedTask(), 10000L, 10000L);
        }
    }

    @Override
    public int getMaxLoad() {
        return (int)this.calcStat(Stats.WEIGHT_LIMIT, Math.floor(BaseStats.CON.calcBonus(this) * 34500.0 * (double)Configuration.character().getWeightLimit()), this, null);
    }

    @Override
    public int getBonusWeightPenalty() {
        return (int)this.calcStat(Stats.WEIGHT_PENALTY, 1.0, this, null);
    }

    @Override
    public int getCurrentLoad() {
        return this.getInventory().getTotalWeight();
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopFeed();
        this.stopHpMpRegeneration();
        super.unSummon(owner);
        if (!this.isDead()) {
            if (this.getInventory() != null) {
                this.getInventory().deleteMe();
            }
            L2World.getInstance().removePet(owner.getObjectId());
        }
    }

    public void restoreExp(double restorePercent) {
        if (this._expBeforeDeath > 0L) {
            this.getStat().addExp(Math.round((double)(this._expBeforeDeath - this.getStat().getExp()) * restorePercent / 100.0));
            this._expBeforeDeath = 0L;
        }
    }

    private void deathPenalty() {
        int lvl = this.getStat().getLevel();
        double percentLost = -0.07 * (double)lvl + 6.5;
        long lostExp = Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0);
        this._expBeforeDeath = this.getStat().getExp();
        this.getStat().removeExp(lostExp);
    }

    public void addExp(long exp) {
        this.getStat().addExp(exp);
    }

    public long getExpForLevel(int level) {
        return this.getStat().getExpForLevel(level);
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        this.getStat().addExpAndSp(Math.round((double)addToExp * (this.isSinEater() ? Configuration.rates().getSinEaterXpRate() : Configuration.rates().getPetXpRate())), addToSp);
    }

    public boolean isSinEater() {
        return this.getId() == 12564;
    }

    @Override
    public long getExpForThisLevel() {
        return this.getStat().getExpForLevel(this.getLevel());
    }

    @Override
    public long getExpForNextLevel() {
        return this.getStat().getExpForLevel(this.getLevel() + 1);
    }

    @Override
    public final boolean addLevel(int value) {
        if (this.getLevel() + value > this.getStat().getMaxLevel()) {
            return false;
        }
        boolean levelIncreased = this.getStat().addLevel(value);
        this.onLevelChange(levelIncreased);
        return levelIncreased;
    }

    @Override
    public long getExp() {
        return this.getStat().getExp();
    }

    public void setExp(long exp) {
        this.getStat().setExp(exp);
    }

    public void setSp(int sp) {
        this.getStat().setSp(sp);
    }

    @Override
    public void onLevelChange(boolean levelIncreased) {
        StatusUpdate su = new StatusUpdate(this.getStat().getActiveChar());
        su.addAttribute(1, this.getLevel());
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(12, this.getMaxMp());
        this.getStat().getActiveChar().broadcastPacket(su);
        if (levelIncreased) {
            this.getStat().getActiveChar().broadcastPacket(new SocialAction(this.getObjectId(), 2122));
        }
        this.getStat().getActiveChar().updateAndBroadcastStatus(1);
        if (this.getStat().getActiveChar().getControlItem() != null) {
            this.getStat().getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
    }

    @Override
    public final int getLevel() {
        return this.getStat().getLevel();
    }

    @Override
    public int getMinLevel() {
        return PetDataTable.getInstance().getPetMinLevel(this.getTemplate().getId());
    }

    public int getMaxFed() {
        return this.getStat().getMaxFeed();
    }

    @Override
    public int getCriticalHit(L2Character target, Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    public void updateRefOwner(L2PcInstance owner) {
        int oldOwnerId = this.getOwner().getObjectId();
        this.setOwner(owner);
        L2World.getInstance().removePet(oldOwnerId);
        L2World.getInstance().addPet(oldOwnerId, this);
    }

    public int getInventoryLimit() {
        return Configuration.npc().getMaximumSlotsForPet();
    }

    public void refreshOverloaded() {
        long weightproc;
        int newWeightPenalty;
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0 && this._curWeightPenalty != (newWeightPenalty = (weightproc = (long)(this.getCurrentLoad() - this.getBonusWeightPenalty()) * 1000L / (long)maxLoad) < 500L || this.getOwner().getDietMode() ? 0 : (weightproc < 666L ? 1 : (weightproc < 800L ? 2 : (weightproc < 1000L ? 3 : 4))))) {
            this._curWeightPenalty = newWeightPenalty;
            if (newWeightPenalty > 0) {
                this.addSkill(SkillData.getInstance().getSkill(4270, newWeightPenalty));
                this.setIsOverloaded(this.getCurrentLoad() >= maxLoad);
            } else {
                this.removeSkill(this.getKnownSkill(4270), true);
                this.setIsOverloaded(false);
            }
        }
    }

    @Override
    public void updateAndBroadcastStatus(int val) {
        this.refreshOverloaded();
        super.updateAndBroadcastStatus(val);
    }

    @Override
    public final boolean isHungry() {
        return (float)this.getCurrentFed() < (float)this.getPetData().getHungryLimit() / 100.0f * (float)this.getPetLevelData().getPetMaxFeed();
    }

    public boolean isUncontrollable() {
        return this.getCurrentFed() <= 0;
    }

    @Override
    public final int getWeapon() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(5);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    @Override
    public final int getArmor() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(6);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    public final int getJewel() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(4);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    @Override
    public short getSoulShotsPerHit() {
        return this.getPetLevelData().getPetSoulShot();
    }

    @Override
    public short getSpiritShotsPerHit() {
        return this.getPetLevelData().getPetSpiritShot();
    }

    @Override
    public void setName(String name) {
        L2ItemInstance controlItem = this.getControlItem();
        if (controlItem != null) {
            if (controlItem.getCustomType2() == (name == null ? 1 : 0)) {
                controlItem.setCustomType2(name != null ? 1 : 0);
                controlItem.updateDatabase();
                InventoryUpdate iu = new InventoryUpdate();
                iu.addModifiedItem(controlItem);
                this.sendPacket(iu);
            }
        } else {
            LOG.warn("Pet control item null, for pet: {}", (Object)this.toString());
        }
        super.setName(name);
    }

    public boolean canEatFoodId(int itemId) {
        return this._data.getFood().contains(itemId);
    }

    @Override
    public boolean isPet() {
        return true;
    }

    @Override
    public final double getRunSpeed() {
        return super.getRunSpeed() * (this.isUncontrollable() ? 0.5 : 1.0);
    }

    @Override
    public final double getWalkSpeed() {
        return super.getWalkSpeed() * (this.isUncontrollable() ? 0.5 : 1.0);
    }

    @Override
    public final double getMovementSpeedMultiplier() {
        return super.getMovementSpeedMultiplier() * (this.isUncontrollable() ? 0.5 : 1.0);
    }

    @Override
    public final double getMoveSpeed() {
        if (this.isInsideZone(ZoneId.WATER)) {
            return this.isRunning() ? this.getSwimRunSpeed() : this.getSwimWalkSpeed();
        }
        return this.isRunning() ? this.getRunSpeed() : this.getWalkSpeed();
    }

    public boolean isInSupportMode() {
        return this._bufferMode;
    }

    class FeedTask
    implements Runnable {
        private final Logger LOG = LoggerFactory.getLogger(FeedTask.class);

        FeedTask() {
        }

        @Override
        public void run() {
            try {
                IItemHandler handler;
                if (L2PetInstance.this.getOwner() == null || !L2PetInstance.this.getOwner().hasSummon() || L2PetInstance.this.getOwner().getSummon().getObjectId() != L2PetInstance.this.getObjectId()) {
                    L2PetInstance.this.stopFeed();
                    return;
                }
                if (L2PetInstance.this.getCurrentFed() > this.getFeedConsume()) {
                    L2PetInstance.this.setCurrentFed(L2PetInstance.this.getCurrentFed() - this.getFeedConsume());
                } else {
                    L2PetInstance.this.setCurrentFed(0);
                }
                L2PetInstance.this.broadcastStatusUpdate();
                List<Integer> foodIds = L2PetInstance.this.getPetData().getFood();
                if (foodIds.isEmpty()) {
                    if (L2PetInstance.this.isUncontrollable()) {
                        if (L2PetInstance.this.getTemplate().getId() == 16050 && L2PetInstance.this.getOwner() != null) {
                            L2PetInstance.this.getOwner().setPkKills(Math.max(0, L2PetInstance.this.getOwner().getPkKills() - Rnd.get((int)1, (int)6)));
                        }
                        L2PetInstance.this.sendPacket(SystemMessageId.THE_HELPER_PET_LEAVING);
                        L2PetInstance.this.deleteMe(L2PetInstance.this.getOwner());
                    } else if (L2PetInstance.this.isHungry()) {
                        L2PetInstance.this.sendPacket(SystemMessageId.THERE_NOT_MUCH_TIME_REMAINING_UNTIL_HELPER_LEAVES);
                    }
                    return;
                }
                L2ItemInstance food = null;
                for (int id : foodIds) {
                    food = L2PetInstance.this.getInventory().getItemByItemId(id);
                    if (food == null) continue;
                    break;
                }
                if (food != null && L2PetInstance.this.isHungry() && (handler = ItemHandler.getInstance().getHandler(food.getEtcItem())) != null) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY);
                    sm.addItemName(food.getId());
                    L2PetInstance.this.sendPacket(sm);
                    handler.useItem(L2PetInstance.this, food, false);
                }
                if (L2PetInstance.this.isUncontrollable()) {
                    L2PetInstance.this.sendPacket(SystemMessageId.YOUR_PET_IS_STARVING_AND_WILL_NOT_OBEY_UNTIL_IT_GETS_ITS_FOOD_FEED_YOUR_PET);
                }
            }
            catch (Exception e) {
                this.LOG.error("Pet [ObjectId: {}] a feed task error has occurred", (Object)L2PetInstance.this.getObjectId(), (Object)e);
            }
        }

        private int getFeedConsume() {
            if (L2PetInstance.this.isAttackingNow()) {
                return L2PetInstance.this.getPetLevelData().getPetFeedBattle();
            }
            return L2PetInstance.this.getPetLevelData().getPetFeedNormal();
        }
    }
}

