/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.TeleportLocationTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2TeleporterInstance
extends L2Npc {
    private static final Logger LOG = LoggerFactory.getLogger(L2TeleporterInstance.class);
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_OWNER = 2;
    private static final int COND_REGULAR = 3;

    public L2TeleporterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2TeleporterInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        int condition = this.validateCondition(player);
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (player.isAffectedBySkill(6201) || player.isAffectedBySkill(6202) || player.isAffectedBySkill(6203)) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            String filename = "data/html/teleporter/epictransformed.htm";
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace("%objectId%", String.valueOf(this.getObjectId()));
            html.replace("%npcname%", this.getName());
            player.sendPacket(html);
            return;
        }
        if (actualCommand.equalsIgnoreCase("goto")) {
            int npcId = this.getId();
            switch (npcId) {
                case 32534: 
                case 32539: {
                    if (!player.isFlyingMounted()) break;
                    player.sendPacket(SystemMessageId.YOU_CANNOT_ENTER_SEED_IN_FLYING_TRANSFORM);
                    return;
                }
            }
            if (st.countTokens() <= 0) {
                return;
            }
            int whereTo = Integer.parseInt(st.nextToken());
            if (condition == 3) {
                this.doTeleport(player, whereTo);
                return;
            }
            if (condition == 2) {
                int minPrivilegeLevel = 0;
                if (st.countTokens() >= 1) {
                    minPrivilegeLevel = Integer.parseInt(st.nextToken());
                }
                if (10 >= minPrivilegeLevel) {
                    this.doTeleport(player, whereTo);
                } else {
                    player.sendMessage("You don't have the sufficient access level to teleport there.");
                }
                return;
            }
        } else if (command.startsWith("Chat")) {
            Calendar cal = Calendar.getInstance();
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (val == 1 && player.getLevel() < 41) {
                this.showNewbieHtml(player);
                return;
            }
            if (val == 1 && cal.get(11) >= 20 && (cal.get(7) == 1 || cal.get(7) == 7)) {
                this.showHalfPriceHtml(player);
                return;
            }
            this.showChatWindow(player, val);
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        String pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/teleporter/" + pom + ".htm";
    }

    private void showNewbieHtml(L2PcInstance player) {
        if (player == null) {
            return;
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = "data/html/teleporter/free/" + this.getTemplate().getId() + ".htm";
        if (!HtmCache.getInstance().isLoadable(filename)) {
            filename = "data/html/teleporter/" + this.getTemplate().getId() + "-1.htm";
        }
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void showHalfPriceHtml(L2PcInstance player) {
        if (player == null) {
            return;
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = "data/html/teleporter/half/" + this.getId() + ".htm";
        if (!HtmCache.getInstance().isLoadable(filename)) {
            filename = "data/html/teleporter/" + this.getId() + "-1.htm";
        }
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/teleporter/castleteleporter-no.htm";
        int condition = this.validateCondition(player);
        if (condition == 3) {
            super.showChatWindow(player);
            return;
        }
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/teleporter/castleteleporter-busy.htm";
            } else if (condition == 2) {
                filename = this.getHtmlPath(this.getId(), 0);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        html.replace("%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(val);
        if (list != null) {
            Calendar cal;
            if (SiegeManager.getInstance().getSiege(list.getLocX(), list.getLocY(), list.getLocZ()) != null) {
                player.sendPacket(SystemMessageId.NO_PORT_THAT_IS_IN_SIGE);
                return;
            }
            if (TownManager.townHasCastleInSiege(list.getLocX(), list.getLocY()) && this.isInsideZone(ZoneId.TOWN)) {
                player.sendPacket(SystemMessageId.NO_PORT_THAT_IS_IN_SIGE);
                return;
            }
            if (!Configuration.character().karmaPlayerCanUseGK() && player.getKarma() > 0) {
                player.sendMessage("Go away, you're not welcome here.");
                return;
            }
            if (player.isCombatFlagEquipped()) {
                player.sendPacket(SystemMessageId.YOU_CANNOT_TELEPORT_WHILE_IN_POSSESSION_OF_A_WARD);
                return;
            }
            if (list.getIsForNoble() && !player.isNoble()) {
                String filename = "data/html/teleporter/nobleteleporter-no.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace("%objectId%", String.valueOf(this.getObjectId()));
                html.replace("%npcname%", this.getName());
                player.sendPacket(html);
                return;
            }
            if (player.isAlikeDead()) {
                return;
            }
            int price = list.getPrice();
            if (player.getLevel() < 41) {
                price = 0;
            } else if (!(list.getIsForNoble() || (cal = Calendar.getInstance()).get(11) < 20 || cal.get(7) != 1 && cal.get(7) != 7)) {
                price /= 2;
            }
            if (Configuration.character().freeTeleporting() || player.destroyItemByItemId("Teleport " + (list.getIsForNoble() ? " nobless" : ""), list.getItemId(), price, this, true)) {
                LOG.debug("Teleporting {} to new location: {}, {}, {}", player, list.getLocX(), list.getLocY(), list.getLocZ());
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), player.getHeading(), -1);
            }
        } else {
            LOG.warn("No teleport destination with Id {}!", (Object)val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private int validateCondition(L2PcInstance player) {
        if (CastleManager.getInstance().getCastleIndex(this) < 0) {
            return 3;
        }
        if (this.getCastle().getSiege().isInProgress()) {
            return 1;
        }
        if (player.getClan() != null && this.getCastle().getOwnerId() == player.getClanId()) {
            return 2;
        }
        return 0;
    }
}

