/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import java.util.Arrays;

public class CharStat {
    private final L2Character _activeChar;
    private int _level = 1;
    private final float[] _attackTraits = new float[TraitType.values().length];
    private final int[] _attackTraitsCount = new int[TraitType.values().length];
    private final float[] _defenceTraits = new float[TraitType.values().length];
    private final int[] _defenceTraitsCount = new int[TraitType.values().length];
    private final int[] _traitsInvul = new int[TraitType.values().length];

    public CharStat(L2Character activeChar) {
        this._activeChar = activeChar;
        Arrays.fill(this._attackTraits, 1.0f);
        Arrays.fill(this._defenceTraits, 1.0f);
    }

    public final double calcStat(Stats stat, double init) {
        return this.calcStat(stat, init, null, null);
    }

    public final double calcStat(Stats stat, double initVal, L2Character target, Skill skill) {
        double val;
        double value = initVal;
        if (stat == null) {
            return value;
        }
        int id = stat.ordinal();
        Calculator c = this._activeChar.getCalculators()[id];
        if (c == null || c.size() == 0) {
            return value;
        }
        if (this.getActiveChar().isPlayer() && this.getActiveChar().isTransformed() && (val = this.getActiveChar().getTransformation().getStat(this.getActiveChar().getActingPlayer(), stat)) > 0.0) {
            value = val;
        }
        if ((value = c.calc(this._activeChar, target, skill, value)) <= 0.0) {
            switch (stat) {
                case MAX_HP: 
                case MAX_MP: 
                case MAX_CP: 
                case MAGIC_DEFENCE: 
                case POWER_DEFENCE: 
                case POWER_ATTACK: 
                case MAGIC_ATTACK: 
                case POWER_ATTACK_SPEED: 
                case MAGIC_ATTACK_SPEED: 
                case SHIELD_DEFENCE: 
                case STAT_CON: 
                case STAT_DEX: 
                case STAT_INT: 
                case STAT_MEN: 
                case STAT_STR: 
                case STAT_WIT: {
                    value = 1.0;
                }
            }
        }
        return value;
    }

    public int getAccuracy() {
        return (int)Math.round(this.calcStat(Stats.ACCURACY_COMBAT, 0.0, null, null));
    }

    public L2Character getActiveChar() {
        return this._activeChar;
    }

    public final float getAttackSpeedMultiplier() {
        return (float)(1.1 * this.getPAtkSpd() / (double)this._activeChar.getTemplate().getBasePAtkSpd());
    }

    public final int getCON() {
        return (int)this.calcStat(Stats.STAT_CON, this._activeChar.getTemplate().getBaseCON());
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.calcStat(Stats.CRITICAL_DAMAGE, init, target, null);
    }

    public int getCriticalHit(L2Character target, Skill skill) {
        double val = (int)this.calcStat(Stats.CRITICAL_RATE, this._activeChar.getTemplate().getBaseCritRate(), target, skill);
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, (double)Configuration.character().getMaxPCritRate());
        }
        return (int)(val + 0.5);
    }

    public int getCriticalHitPos(int base) {
        return (int)this.calcStat(Stats.CRITICAL_RATE_POS, base);
    }

    public final int getDEX() {
        return (int)this.calcStat(Stats.STAT_DEX, this._activeChar.getTemplate().getBaseDEX());
    }

    public int getEvasionRate(L2Character target) {
        int val = (int)Math.round(this.calcStat(Stats.EVASION_RATE, 0.0, target, null));
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, Configuration.character().getMaxEvasion());
        }
        return val;
    }

    public int getINT() {
        return (int)this.calcStat(Stats.STAT_INT, this._activeChar.getTemplate().getBaseINT());
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int value) {
        this._level = value;
    }

    public final int getMagicalAttackRange(Skill skill) {
        if (skill != null) {
            return (int)this.calcStat(Stats.MAGIC_ATTACK_RANGE, skill.getCastRange(), null, skill);
        }
        return this._activeChar.getTemplate().getBaseAttackRange();
    }

    public int getMaxCp() {
        return (int)this.calcStat(Stats.MAX_CP, this._activeChar.getTemplate().getBaseCpMax());
    }

    public int getMaxRecoverableCp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_CP, this.getMaxCp());
    }

    public int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this._activeChar.getTemplate().getBaseHpMax());
    }

    public int getMaxRecoverableHp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_HP, this.getMaxHp());
    }

    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this._activeChar.getTemplate().getBaseMpMax());
    }

    public int getMaxRecoverableMp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_MP, this.getMaxMp());
    }

    public double getMAtk(L2Character target, Skill skill) {
        float bonusAtk = 1.0f;
        if (Configuration.customs().championEnable() && this._activeChar.isChampion()) {
            bonusAtk = Configuration.customs().getChampionAtk();
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Configuration.npc().getRaidMAttackMultiplier());
        }
        return this.calcStat(Stats.MAGIC_ATTACK, (float)this._activeChar.getTemplate().getBaseMAtk() * bonusAtk, target, skill);
    }

    public int getMAtkSpd() {
        float bonusSpdAtk = 1.0f;
        if (Configuration.customs().championEnable() && this._activeChar.isChampion()) {
            bonusSpdAtk = Configuration.customs().getChampionSpdAtk();
        }
        double val = this.calcStat(Stats.MAGIC_ATTACK_SPEED, (float)this._activeChar.getTemplate().getBaseMAtkSpd() * bonusSpdAtk);
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, (double)Configuration.character().getMaxMAtkSpeed());
        }
        return (int)val;
    }

    public final int getMCriticalHit(L2Character target, Skill skill) {
        int val = (int)this.calcStat(Stats.MCRITICAL_RATE, 1.0, target, skill) * 10;
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, Configuration.character().getMaxMCritRate());
        }
        return val;
    }

    public double getMDef(L2Character target, Skill skill) {
        double defence = this._activeChar.getTemplate().getBaseMDef();
        if (this._activeChar.isRaid()) {
            defence *= Configuration.npc().getRaidMDefenceMultiplier();
        }
        return this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    public final int getMEN() {
        return (int)this.calcStat(Stats.STAT_MEN, this._activeChar.getTemplate().getBaseMEN());
    }

    public double getMovementSpeedMultiplier() {
        double baseSpeed = this._activeChar.isInsideZone(ZoneId.WATER) ? this.getBaseMoveSpeed(this._activeChar.isRunning() ? MoveType.FAST_SWIM : MoveType.SLOW_SWIM) : this.getBaseMoveSpeed(this._activeChar.isRunning() ? MoveType.RUN : MoveType.WALK);
        return this.getMoveSpeed() * (1.0 / baseSpeed);
    }

    public double getRunSpeed() {
        double baseRunSpd;
        double d = baseRunSpd = this._activeChar.isInsideZone(ZoneId.WATER) ? this.getSwimRunSpeed() : this.getBaseMoveSpeed(MoveType.RUN);
        if (baseRunSpd <= 0.0) {
            return 0.0;
        }
        return this.calcStat(Stats.MOVE_SPEED, baseRunSpd, null, null);
    }

    public double getWalkSpeed() {
        double baseWalkSpd;
        double d = baseWalkSpd = this._activeChar.isInsideZone(ZoneId.WATER) ? this.getSwimWalkSpeed() : this.getBaseMoveSpeed(MoveType.WALK);
        if (baseWalkSpd <= 0.0) {
            return 0.0;
        }
        return this.calcStat(Stats.MOVE_SPEED, baseWalkSpd);
    }

    public double getSwimRunSpeed() {
        double baseRunSpd = this.getBaseMoveSpeed(MoveType.FAST_SWIM);
        if (baseRunSpd <= 0.0) {
            return 0.0;
        }
        return this.calcStat(Stats.MOVE_SPEED, baseRunSpd, null, null);
    }

    public double getSwimWalkSpeed() {
        double baseWalkSpd = this.getBaseMoveSpeed(MoveType.SLOW_SWIM);
        if (baseWalkSpd <= 0.0) {
            return 0.0;
        }
        return this.calcStat(Stats.MOVE_SPEED, baseWalkSpd);
    }

    public double getBaseMoveSpeed(MoveType type) {
        return this._activeChar.getTemplate().getBaseMoveSpeed(type);
    }

    public double getMoveSpeed() {
        if (this._activeChar.isInsideZone(ZoneId.WATER)) {
            return this._activeChar.isRunning() ? this.getSwimRunSpeed() : this.getSwimWalkSpeed();
        }
        return this._activeChar.isRunning() ? this.getRunSpeed() : this.getWalkSpeed();
    }

    public final double getMReuseRate(Skill skill) {
        return this.calcStat(Stats.MAGIC_REUSE_RATE, 1.0, null, skill);
    }

    public double getPAtk(L2Character target) {
        float bonusAtk = 1.0f;
        if (Configuration.customs().championEnable() && this._activeChar.isChampion()) {
            bonusAtk = Configuration.customs().getChampionAtk();
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Configuration.npc().getRaidPAttackMultiplier());
        }
        return this.calcStat(Stats.POWER_ATTACK, (float)this._activeChar.getTemplate().getBasePAtk() * bonusAtk, target, null);
    }

    public double getPAtkSpd() {
        float bonusAtk = 1.0f;
        if (Configuration.customs().championEnable() && this._activeChar.isChampion()) {
            bonusAtk = Configuration.customs().getChampionSpdAtk();
        }
        return Math.round(this.calcStat(Stats.POWER_ATTACK_SPEED, (float)this._activeChar.getTemplate().getBasePAtkSpd() * bonusAtk, null, null));
    }

    public double getPDef(L2Character target) {
        return this.calcStat(Stats.POWER_DEFENCE, this._activeChar.isRaid() ? (double)this._activeChar.getTemplate().getBasePDef() * Configuration.npc().getRaidPDefenceMultiplier() : (double)this._activeChar.getTemplate().getBasePDef(), target, null);
    }

    public final int getPhysicalAttackRange() {
        L2Weapon weapon = this._activeChar.getActiveWeaponItem();
        int baseAttackRange = this._activeChar.isTransformed() && this._activeChar.isPlayer() ? this._activeChar.getTransformation().getBaseAttackRange(this._activeChar.getActingPlayer()) : (weapon != null ? weapon.getBaseAttackRange() : this._activeChar.getTemplate().getBaseAttackRange());
        return (int)this.calcStat(Stats.POWER_ATTACK_RANGE, baseAttackRange, null, null);
    }

    public int getPhysicalAttackAngle() {
        L2Weapon weapon = this._activeChar.getActiveWeaponItem();
        int baseAttackAngle = weapon != null ? weapon.getBaseAttackAngle() : 120;
        return baseAttackAngle;
    }

    public final double getWeaponReuseModifier(L2Character target) {
        return this.calcStat(Stats.ATK_REUSE, 1.0, target, null);
    }

    public final int getShldDef() {
        return (int)this.calcStat(Stats.SHIELD_DEFENCE, 0.0);
    }

    public final int getSTR() {
        return (int)this.calcStat(Stats.STAT_STR, this._activeChar.getTemplate().getBaseSTR());
    }

    public final int getWIT() {
        return (int)this.calcStat(Stats.STAT_WIT, this._activeChar.getTemplate().getBaseWIT());
    }

    public final int getMpConsume2(Skill skill) {
        if (skill == null) {
            return 1;
        }
        double mpConsume2 = skill.getMpConsume2();
        double nextDanceMpCost = Math.ceil((double)skill.getMpConsume2() / 2.0);
        if (skill.isDance() && Configuration.character().danceConsumeAdditionalMP() && this._activeChar != null && this._activeChar.getDanceCount() > 0) {
            mpConsume2 += (double)this._activeChar.getDanceCount() * nextDanceMpCost;
        }
        mpConsume2 = this.calcStat(Stats.MP_CONSUME, mpConsume2, null, skill);
        if (skill.isDance()) {
            return (int)this.calcStat(Stats.DANCE_MP_CONSUME_RATE, mpConsume2);
        }
        if (skill.isMagic()) {
            return (int)this.calcStat(Stats.MAGICAL_MP_CONSUME_RATE, mpConsume2);
        }
        return (int)this.calcStat(Stats.PHYSICAL_MP_CONSUME_RATE, mpConsume2);
    }

    public final int getMpConsume1(Skill skill) {
        if (skill == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.MP_CONSUME, skill.getMpConsume1(), null, skill);
    }

    public byte getAttackElement() {
        L2ItemInstance weaponInstance = this._activeChar.getActiveWeaponInstance();
        if (weaponInstance != null && weaponInstance.getAttackElementType() >= 0) {
            return weaponInstance.getAttackElementType();
        }
        int tempVal = 0;
        int[] stats = new int[]{0, 0, 0, 0, 0, 0};
        int returnVal = -2;
        stats[0] = (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().getBaseFire());
        stats[1] = (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().getBaseWater());
        stats[2] = (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().getBaseWind());
        stats[3] = (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().getBaseEarth());
        stats[4] = (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().getBaseHoly());
        stats[5] = (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().getBaseDark());
        for (int x = 0; x < 6; x = (int)((byte)(x + 1))) {
            if (stats[x] <= tempVal) continue;
            returnVal = x;
            tempVal = stats[x];
        }
        return (byte)returnVal;
    }

    public int getAttackElementValue(byte attackAttribute) {
        return switch (attackAttribute) {
            case 0 -> (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().getBaseFire());
            case 1 -> (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().getBaseWater());
            case 2 -> (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().getBaseWind());
            case 3 -> (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().getBaseEarth());
            case 4 -> (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().getBaseHoly());
            case 5 -> (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().getBaseDark());
            default -> 0;
        };
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        return switch (defenseAttribute) {
            case 0 -> (int)this.calcStat(Stats.FIRE_RES, this._activeChar.getTemplate().getBaseFireRes());
            case 1 -> (int)this.calcStat(Stats.WATER_RES, this._activeChar.getTemplate().getBaseWaterRes());
            case 2 -> (int)this.calcStat(Stats.WIND_RES, this._activeChar.getTemplate().getBaseWindRes());
            case 3 -> (int)this.calcStat(Stats.EARTH_RES, this._activeChar.getTemplate().getBaseEarthRes());
            case 4 -> (int)this.calcStat(Stats.HOLY_RES, this._activeChar.getTemplate().getBaseHolyRes());
            case 5 -> (int)this.calcStat(Stats.DARK_RES, this._activeChar.getTemplate().getBaseDarkRes());
            default -> (int)this._activeChar.getTemplate().getBaseElementRes();
        };
    }

    public float getAttackTrait(TraitType traitType) {
        return this._attackTraits[traitType.getId()];
    }

    public float[] getAttackTraits() {
        return this._attackTraits;
    }

    public boolean hasAttackTrait(TraitType traitType) {
        return this._attackTraitsCount[traitType.getId()] > 0;
    }

    public int[] getAttackTraitsCount() {
        return this._attackTraitsCount;
    }

    public float getDefenceTrait(TraitType traitType) {
        return this._defenceTraits[traitType.getId()];
    }

    public float[] getDefenceTraits() {
        return this._defenceTraits;
    }

    public boolean hasDefenceTrait(TraitType traitType) {
        return this._defenceTraitsCount[traitType.getId()] > 0;
    }

    public int[] getDefenceTraitsCount() {
        return this._defenceTraitsCount;
    }

    public boolean isTraitInvul(TraitType traitType) {
        return this._traitsInvul[traitType.getId()] > 0;
    }

    public int[] getTraitsInvul() {
        return this._traitsInvul;
    }

    public int getMaxBuffCount() {
        return (int)this.calcStat(Stats.ENLARGE_ABNORMAL_SLOT, Configuration.character().getMaxBuffAmount());
    }
}

