/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.PetDataTable;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PlayableStat;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventPointInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExVitalityPointInfo;
import java.util.concurrent.atomic.AtomicInteger;

public class PcStat
extends PlayableStat {
    private int _oldMaxHp;
    private int _oldMaxMp;
    private int _oldMaxCp;
    private float _vitalityPoints = 1.0f;
    private int _nevitPoints = 0;
    private int _huntingBonusTime = 0;
    private int _nevitBlessingTime = 0;
    private byte _vitalityLevel = 0;
    private long _startingXp;
    private int _maxCubicCount = 1;
    private final AtomicInteger _talismanSlots = new AtomicInteger();
    private boolean _cloakSlot = false;
    public static final int[] VITALITY_LEVELS = new int[]{240, 2000, 13000, 17000, 20000};
    public static final int MAX_VITALITY_POINTS = VITALITY_LEVELS[4];
    public static final int MIN_VITALITY_POINTS = 1;

    public PcStat(L2PcInstance activeChar) {
        super(activeChar);
    }

    public void setStartingExp(long value) {
        if (Configuration.general().enableBotReportButton()) {
            this._startingXp = value;
        }
    }

    public long getStartingExp() {
        return this._startingXp;
    }

    public int getMaxCubicCount() {
        return this._maxCubicCount;
    }

    public void setMaxCubicCount(int cubicCount) {
        this._maxCubicCount = cubicCount;
    }

    public int getTalismanSlots() {
        return this._talismanSlots.get();
    }

    public void addTalismanSlots(int count) {
        this._talismanSlots.addAndGet(count);
    }

    public boolean canEquipCloak() {
        return this._cloakSlot;
    }

    public void setCloakSlotStatus(boolean cloakSlot) {
        this._cloakSlot = cloakSlot;
    }

    @Override
    public final int getMaxCp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_CP, this.getActiveChar().getTemplate().getBaseCpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxCp) {
            this._oldMaxCp = val;
            if (this.getActiveChar().getStatus().getCurrentCp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentCp(this.getActiveChar().getStatus().getCurrentCp());
            }
        }
        return val;
    }

    @Override
    public final int getMaxHp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getTemplate().getBaseHpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxHp) {
            this._oldMaxHp = val;
            if (this.getActiveChar().getStatus().getCurrentHp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentHp(this.getActiveChar().getStatus().getCurrentHp());
            }
        }
        return val;
    }

    @Override
    public final int getMaxMp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_MP, this.getActiveChar().getTemplate().getBaseMpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxMp) {
            this._oldMaxMp = val;
            if (this.getActiveChar().getStatus().getCurrentMp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentMp(this.getActiveChar().getStatus().getCurrentMp());
            }
        }
        return val;
    }

    @Override
    public double getBaseMoveSpeed(MoveType type) {
        L2PetLevelData data;
        L2PcInstance player = this.getActiveChar();
        if (player.isTransformed()) {
            TransformTemplate template = player.getTransformation().getTemplate(player);
            if (template != null) {
                return template.getBaseMoveSpeed(type);
            }
        } else if (player.isMounted() && (data = PetDataTable.getInstance().getPetLevelData(player.getMountNpcId(), player.getMountLevel())) != null) {
            return data.getSpeedOnRide(type);
        }
        return super.getBaseMoveSpeed(type);
    }

    @Override
    public double getRunSpeed() {
        double val = super.getRunSpeed() + (double)Configuration.character().getRunSpeedBoost();
        if (val > (double)Configuration.character().getMaxRunSpeed() && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Configuration.character().getMaxRunSpeed();
        }
        if (this.getActiveChar().isMounted()) {
            if (this.getActiveChar().getMountLevel() - this.getActiveChar().getLevel() >= 10) {
                val /= 2.0;
            }
            if (this.getActiveChar().isHungry()) {
                val /= 2.0;
            }
        }
        return val;
    }

    @Override
    public double getWalkSpeed() {
        double val = super.getWalkSpeed() + (double)Configuration.character().getRunSpeedBoost();
        if (val > (double)Configuration.character().getMaxRunSpeed() && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Configuration.character().getMaxRunSpeed();
        }
        if (this.getActiveChar().isMounted()) {
            if (this.getActiveChar().getMountLevel() - this.getActiveChar().getLevel() >= 10) {
                val /= 2.0;
            }
            if (this.getActiveChar().isHungry()) {
                val /= 2.0;
            }
        }
        return val;
    }

    @Override
    public double getPAtkSpd() {
        double val = super.getPAtkSpd();
        if (val > (double)Configuration.character().getMaxPAtkSpeed() && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Configuration.character().getMaxPAtkSpeed();
        }
        return val;
    }

    private void updateVitalityLevel(boolean quiet) {
        byte level = this._vitalityPoints <= (float)VITALITY_LEVELS[0] ? (byte)0 : (this._vitalityPoints <= (float)VITALITY_LEVELS[1] ? (byte)1 : (this._vitalityPoints <= (float)VITALITY_LEVELS[2] ? (byte)2 : (this._vitalityPoints <= (float)VITALITY_LEVELS[3] ? (byte)3 : 4)));
        if (!quiet && level != this._vitalityLevel) {
            if (level < this._vitalityLevel) {
                this.getActiveChar().getHuntingSystem().addPoints(Configuration.hunting().getNevitDecreaseVitalityAcquirePoints());
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_HAS_DECREASED);
            } else {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_HAS_INCREASED);
            }
            if (level == 0) {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_IS_EXHAUSTED);
            } else if (level == 4) {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_IS_AT_MAXIMUM);
            }
        }
        this._vitalityLevel = level;
    }

    public int getVitalityPoints() {
        return (int)this._vitalityPoints;
    }

    public void setVitalityPoints(int points, boolean quiet) {
        if ((float)(points = Math.min(Math.max(points, 1), MAX_VITALITY_POINTS)) == this._vitalityPoints) {
            return;
        }
        this._vitalityPoints = points;
        this.updateVitalityLevel(quiet);
        this.getActiveChar().sendPacket(new ExVitalityPointInfo(this.getVitalityPoints()));
    }

    public synchronized void updateVitalityPoints(float points, boolean useRates, boolean quiet) {
        if (points == 0.0f || !Configuration.vitality().enabled()) {
            return;
        }
        if (useRates) {
            if (this.getActiveChar().isLucky()) {
                return;
            }
            if (points < 0.0f) {
                int stat = (int)this.calcStat(Stats.VITALITY_CONSUME_RATE, 1.0, this.getActiveChar(), null);
                if (this.getActiveChar().getHuntingSystem().isNevitBlessingActive()) {
                    stat = -10;
                }
                if (stat == 0) {
                    return;
                }
                if (stat < 0) {
                    points = -points;
                }
            }
            points = points > 0.0f ? (points *= Configuration.vitality().getRateVitalityGain()) : (points *= Configuration.vitality().getRateVitalityLost());
        }
        if ((double)Math.abs((points = points > 0.0f ? Math.min(this._vitalityPoints + points, (float)MAX_VITALITY_POINTS) : Math.max(this._vitalityPoints + points, 1.0f)) - this._vitalityPoints) <= 1.0E-6) {
            return;
        }
        this._vitalityPoints = points;
        this.updateVitalityLevel(quiet);
    }

    public double getVitalityMultiplier() {
        double vitality = 1.0;
        if (Configuration.vitality().enabled()) {
            switch (this.getVitalityLevel()) {
                case 1: {
                    vitality = Configuration.vitality().getRateVitalityLevel1();
                    break;
                }
                case 2: {
                    vitality = Configuration.vitality().getRateVitalityLevel2();
                    break;
                }
                case 3: {
                    vitality = Configuration.vitality().getRateVitalityLevel3();
                    break;
                }
                case 4: {
                    vitality = Configuration.vitality().getRateVitalityLevel4();
                }
            }
        }
        return vitality;
    }

    public byte getVitalityLevel() {
        if (this.getActiveChar().getHuntingSystem().isNevitBlessingActive()) {
            return 4;
        }
        return this._vitalityLevel;
    }

    public int getNevitBlessingPoints() {
        return this._nevitPoints;
    }

    public void setNevitBlessingPoints(int points) {
        this._nevitPoints = points;
        this.getActiveChar().sendPacket(new ExNevitAdventPointInfoPacket(this.getNevitBlessingPoints()));
    }

    public int getHuntingBonusTime() {
        return this._huntingBonusTime;
    }

    public void setHuntingBonusTime(int time) {
        this._huntingBonusTime = time;
    }

    public int getNevitBlessingTime() {
        return this._nevitBlessingTime;
    }

    public void setNevitBlessingTime(int time) {
        this._nevitBlessingTime = time;
    }

    public double getExpBonusMultiplier() {
        double bonus = 1.0;
        double hunting = 1.0;
        double vitality = this.getVitalityMultiplier();
        double nevits = this.getActiveChar().getHuntingSystem().getNevitHourglassMultiplier();
        double bonusExp = 1.0 + this.calcStat(Stats.BONUS_EXP, 0.0, null, null) / 100.0;
        if (vitality > 1.0) {
            bonus += vitality - 1.0;
        }
        if (nevits > 1.0) {
            bonus += nevits - 1.0;
        }
        if (hunting > 1.0) {
            bonus += hunting - 1.0;
        }
        if (bonusExp > 1.0) {
            bonus += bonusExp - 1.0;
        }
        bonus = Math.max(bonus, 1.0);
        bonus = Math.min(bonus, Configuration.character().getMaxExpBonus());
        return bonus;
    }

    public double getSpBonusMultiplier() {
        double bonus = 1.0;
        double hunting = 1.0;
        double vitality = this.getVitalityMultiplier();
        double nevits = this.getActiveChar().getHuntingSystem().getNevitHourglassMultiplier();
        double bonusSp = 1.0 + this.calcStat(Stats.BONUS_SP, 0.0, null, null) / 100.0;
        if (vitality > 1.0) {
            bonus += vitality - 1.0;
        }
        if (nevits > 1.0) {
            bonus += nevits - 1.0;
        }
        if (hunting > 1.0) {
            bonus += hunting - 1.0;
        }
        if (bonusSp > 1.0) {
            bonus += bonusSp - 1.0;
        }
        bonus = Math.max(bonus, 1.0);
        bonus = Math.min(bonus, Configuration.character().getMaxSpBonus());
        return bonus;
    }

    @Override
    public int getMaxLevel() {
        return this.getActiveChar().isSubClassActive() ? Configuration.character().getMaxSubclassLevel() : Configuration.character().getMaxPlayerLevel();
    }

    @Override
    public int getMaxExpLevel() {
        return this.getActiveChar().isSubClassActive() ? Configuration.character().getMaxSubclassLevel() + 1 : Configuration.character().getMaxPlayerLevel() + 1;
    }

    @Override
    public final L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }
}

