/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.player;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IllegalPlayerActionTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger("audit");
    private final String _message;
    private final IllegalActionPunishmentType _punishment;
    private final L2PcInstance _actor;

    public IllegalPlayerActionTask(L2PcInstance actor, String message, IllegalActionPunishmentType punishment) {
        this._message = message;
        this._punishment = punishment;
        this._actor = actor;
        switch (punishment) {
            case KICK: {
                this._actor.sendMessage("You will be kicked for illegal action, GM informed.");
                break;
            }
            case KICK_BAN: {
                if (!this._actor.isGM()) {
                    this._actor.setAccessLevel(-1);
                    this._actor.setAccountAccesslevel(-1);
                }
                this._actor.sendMessage("You are banned for illegal action, GM informed.");
                break;
            }
            case JAIL: {
                this._actor.sendMessage("Illegal action performed!");
                this._actor.sendMessage("You will be teleported to GM Consultation Service area and jailed.");
            }
        }
    }

    @Override
    public void run() {
        LOG.info("Illegal action [{}] by player {}, action taken {}!", new Object[]{this._message, this._actor, this._punishment});
        AdminData.getInstance().broadcastMessageToGMs(this._message);
        if (!this._actor.isGM()) {
            switch (this._punishment) {
                case BROADCAST: {
                    break;
                }
                case KICK: {
                    this._actor.logout(false);
                    break;
                }
                case KICK_BAN: {
                    PunishmentManager.getInstance().startPunishment(new PunishmentTask(this._actor.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.BAN, System.currentTimeMillis() + Configuration.general().getDefaultPunishParam(), this._message, this.getClass().getSimpleName()));
                    break;
                }
                case JAIL: {
                    PunishmentManager.getInstance().startPunishment(new PunishmentTask(this._actor.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.JAIL, System.currentTimeMillis() + Configuration.general().getDefaultPunishParam(), this._message, this.getClass().getSimpleName()));
                }
            }
        }
    }
}

