/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.templates;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import java.util.HashMap;
import java.util.Map;

public class L2PcTemplate
extends L2CharTemplate {
    private final ClassId _classId;
    private final float[] _baseHp;
    private final float[] _baseMp;
    private final float[] _baseCp;
    private final double[] _baseHpReg;
    private final double[] _baseMpReg;
    private final double[] _baseCpReg;
    private final double _fCollisionHeightFemale;
    private final double _fCollisionRadiusFemale;
    private final int _baseSafeFallHeight;
    private final Map<Integer, Integer> _baseSlotDef;

    public L2PcTemplate(StatsSet set) {
        super(set);
        this._classId = ClassId.getClassId(set.getInt("classId"));
        this.setRace(this._classId.getRace());
        this._baseHp = new float[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseMp = new float[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseCp = new float[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseHpReg = new double[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseMpReg = new double[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseCpReg = new double[Configuration.character().getMaxPlayerLevel() + 1];
        this._baseSlotDef = new HashMap<Integer, Integer>(12);
        this._baseSlotDef.put(6, set.getInt("basePDefchest", 0));
        this._baseSlotDef.put(11, set.getInt("basePDeflegs", 0));
        this._baseSlotDef.put(1, set.getInt("basePDefhead", 0));
        this._baseSlotDef.put(12, set.getInt("basePDeffeet", 0));
        this._baseSlotDef.put(10, set.getInt("basePDefgloves", 0));
        this._baseSlotDef.put(0, set.getInt("basePDefunderwear", 0));
        this._baseSlotDef.put(23, set.getInt("basePDefcloak", 0));
        this._baseSlotDef.put(8, set.getInt("baseMDefrear", 0));
        this._baseSlotDef.put(9, set.getInt("baseMDeflear", 0));
        this._baseSlotDef.put(13, set.getInt("baseMDefrfinger", 0));
        this._baseSlotDef.put(14, set.getInt("baseMDefrfinger", 0));
        this._baseSlotDef.put(4, set.getInt("baseMDefneck", 0));
        this._fCollisionRadiusFemale = set.getDouble("collisionFemaleradius");
        this._fCollisionHeightFemale = set.getDouble("collisionFemaleheight");
        this._baseSafeFallHeight = set.getInt("baseSafeFall", 333);
    }

    public ClassId getClassId() {
        return this._classId;
    }

    public void setUpgainValue(String paramName, int level, double val) {
        switch (paramName) {
            case "hp": {
                this._baseHp[level] = (float)val;
                break;
            }
            case "mp": {
                this._baseMp[level] = (float)val;
                break;
            }
            case "cp": {
                this._baseCp[level] = (float)val;
                break;
            }
            case "hpRegen": {
                this._baseHpReg[level] = val;
                break;
            }
            case "mpRegen": {
                this._baseMpReg[level] = val;
                break;
            }
            case "cpRegen": {
                this._baseCpReg[level] = val;
            }
        }
    }

    public float getBaseHpMax(int level) {
        return this._baseHp[level];
    }

    public float getBaseMpMax(int level) {
        return this._baseMp[level];
    }

    public float getBaseCpMax(int level) {
        return this._baseCp[level];
    }

    public double getBaseHpRegen(int level) {
        return this._baseHpReg[level];
    }

    public double getBaseMpRegen(int level) {
        return this._baseMpReg[level];
    }

    public double getBaseCpRegen(int level) {
        return this._baseCpReg[level];
    }

    public int getBaseDefBySlot(int slotId) {
        return this._baseSlotDef.getOrDefault(slotId, 0);
    }

    public double getFCollisionHeightFemale() {
        return this._fCollisionHeightFemale;
    }

    public double getFCollisionRadiusFemale() {
        return this._fCollisionRadiusFemale;
    }

    public int getSafeFallHeight() {
        return this._baseSafeFallHeight;
    }
}

