/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.announce;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.announce.AnnouncementType;
import com.l2jserver.gameserver.model.announce.IAnnouncement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Announcement
implements IAnnouncement {
    private static final Logger LOG = LoggerFactory.getLogger(Announcement.class);
    private static final String INSERT_QUERY = "INSERT INTO announcements (type, content, author) VALUES (?, ?, ?)";
    private static final String UPDATE_QUERY = "UPDATE announcements SET type = ?, content = ?, author = ? WHERE id = ?";
    private static final String DELETE_QUERY = "DELETE FROM announcements WHERE id = ?";
    protected int _id;
    private AnnouncementType _type;
    private String _content;
    private String _author;

    public Announcement(AnnouncementType type, String content, String author) {
        this._type = type;
        this._content = content;
        this._author = author;
    }

    public Announcement(int id, AnnouncementType type, String content, String author) {
        this(type, content, author);
        this._id = id;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public AnnouncementType getType() {
        return this._type;
    }

    @Override
    public void setType(AnnouncementType type) {
        this._type = type;
    }

    @Override
    public String getContent() {
        return this._content;
    }

    @Override
    public void setContent(String content) {
        this._content = content;
    }

    @Override
    public String getAuthor() {
        return this._author;
    }

    @Override
    public void setAuthor(String author) {
        this._author = author;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean storeMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_QUERY, 1);){
            ps.setInt(1, this._type.ordinal());
            ps.setString(2, this._content);
            ps.setString(3, this._author);
            ps.execute();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    this._id = rs.getInt(1);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't store announcement: ", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_QUERY);){
            ps.setInt(1, this._type.ordinal());
            ps.setString(2, this._content);
            ps.setString(3, this._author);
            ps.setInt(4, this._id);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Couldn't store announcement: ", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_QUERY);){
            ps.setInt(1, this._id);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Couldn't remove announcement: ", e);
            return false;
        }
        return true;
    }
}

