/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.cleft;

import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.cleft.CleftCombatAerialTarget;
import com.l2jserver.gameserver.model.cleft.CleftParticipant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class CleftTeam {
    private final Team _team;
    private final Map<Integer, CleftParticipant> _participants;
    private final AtomicInteger _points;
    private CleftCombatAerialTarget _combatAerialTarget;

    public CleftTeam(Team team) {
        Objects.requireNonNull(team);
        if (team == Team.NONE) {
            throw new IllegalArgumentException("Team.NONE not allowed!");
        }
        this._team = team;
        this._participants = Collections.synchronizedMap(new LinkedHashMap());
        this._points = new AtomicInteger(0);
    }

    public CleftTeam(Team team, Map<Integer, CleftParticipant> participants, int points) {
        this(team);
        this._participants.putAll(participants);
        this._points.set(points);
    }

    public void addPoints(int points) {
        this._points.addAndGet(points);
    }

    public void addParticipant(L2PcInstance player) {
        this._participants.put(player.getObjectId(), new CleftParticipant(player, this));
    }

    public CleftParticipant removeParticipant(L2PcInstance player) {
        return this._participants.remove(player.getObjectId());
    }

    public void setCombarAerialTarget(int id, String name) {
        this._combatAerialTarget = new CleftCombatAerialTarget(id, name);
    }

    public Team getTeam() {
        return this._team;
    }

    public Map<Integer, CleftParticipant> getParticipants() {
        return Collections.unmodifiableMap(this._participants);
    }

    public int getPoints() {
        return this._points.get();
    }

    public CleftCombatAerialTarget getCombatAerialTarget() {
        return this._combatAerialTarget;
    }
}

