/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.ConditionListener;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;

public abstract class Condition
implements ConditionListener {
    private ConditionListener _listener;
    private String _msg;
    private int _msgId;
    private boolean _addName = false;
    private boolean _result;

    public final void setMessage(String msg) {
        this._msg = msg;
    }

    public final String getMessage() {
        return this._msg;
    }

    public final void setMessageId(int msgId) {
        this._msgId = msgId;
    }

    public final int getMessageId() {
        return this._msgId;
    }

    public final void addName() {
        this._addName = true;
    }

    public final boolean isAddName() {
        return this._addName;
    }

    void setListener(ConditionListener listener) {
        this._listener = listener;
        this.notifyChanged();
    }

    final ConditionListener getListener() {
        return this._listener;
    }

    public final boolean test(L2Character caster, L2Character target, Skill skill) {
        return this.test(caster, target, skill, null);
    }

    public final boolean test(L2Character caster, L2Character target, L2Item item) {
        return this.test(caster, target, null, null);
    }

    public final boolean test(L2Character caster, L2Character target, Skill skill, L2Item item) {
        boolean res = this.testImpl(caster, target, skill, item);
        if (this._listener != null && res != this._result) {
            this._result = res;
            this.notifyChanged();
        }
        return res;
    }

    public abstract boolean testImpl(L2Character var1, L2Character var2, Skill var3, L2Item var4);

    @Override
    public void notifyChanged() {
        if (this._listener != null) {
            this._listener.notifyChanged();
        }
    }
}

