/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.Set;

public class ConditionOpExistNpc
extends Condition {
    private final Set<Integer> npcIds;
    private final int radius;
    private final boolean present;

    public ConditionOpExistNpc(Set<Integer> npcIds, int radius, boolean present) {
        this.npcIds = npcIds;
        this.radius = radius;
        this.present = present;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        boolean isPresent = false;
        for (L2Object obj : L2World.getInstance().getVisibleObjects(effector, this.radius)) {
            if (!obj.isNpc() || !this.npcIds.contains(obj.getId())) continue;
            isPresent = true;
            break;
        }
        return isPresent == this.present;
    }
}

