/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.agathion.Agathion;
import com.l2jserver.gameserver.agathion.repository.AgathionRepository;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;

public class ConditionPlayerAgathionEnergy
extends Condition {
    private final int energy;

    public ConditionPlayerAgathionEnergy(int energy) {
        this.energy = energy;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        if (!effector.isPlayer()) {
            return false;
        }
        L2PcInstance player = effector.getActingPlayer();
        Agathion agathionInfo = AgathionRepository.getInstance().getByNpcId(player.getAgathionId());
        if (agathionInfo == null || agathionInfo.getMaxEnergy() <= 0) {
            return false;
        }
        L2ItemInstance agathionItem = player.getInventory().getPaperdollItem(15);
        if (agathionItem == null || agathionInfo.getItemId() != agathionItem.getId()) {
            return false;
        }
        return agathionItem.getAgathionRemainingEnergy() >= this.energy;
    }
}

