/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharSummonTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanSummon
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanSummon(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(L2Character effector, L2Character effected, Skill skill, L2Item item) {
        L2PcInstance player = effector.getActingPlayer();
        if (player == null) {
            return false;
        }
        boolean canSummon = true;
        if (Configuration.character().restoreServitorOnReconnect() && CharSummonTable.getInstance().getServitors().containsKey(player.getObjectId())) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (Configuration.character().restorePetOnReconnect() && CharSummonTable.getInstance().getPets().containsKey(player.getObjectId())) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (player.hasSummon()) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (player.isFlyingMounted() || player.isMounted()) {
            canSummon = false;
        }
        return this._val == canSummon;
    }
}

