/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops.strategy;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.drops.strategy.INonGroupedKillerChanceModifierStrategy;
import com.l2jserver.gameserver.util.Util;

public interface IKillerChanceModifierStrategy
extends INonGroupedKillerChanceModifierStrategy {
    public static final IKillerChanceModifierStrategy DEFAULT_STRATEGY = (item, victim, killer) -> {
        int levelDifference = victim.getLevel() - killer.getLevel();
        if (victim.isRaid() && Configuration.npc().useDeepBlueDropRulesRaid()) {
            return Math.max(0.0, Math.min(1.0, (double)levelDifference * 0.15 + 1.0));
        }
        if (Configuration.npc().useDeepBlueDropRules()) {
            return Util.map((double)levelDifference, (double)(-Configuration.npc().getDropItemMaxLevelDifference()), (double)(-Configuration.npc().getDropItemMinLevelDifference()), (double)Configuration.npc().getDropItemMinLevelGapChance(), 100.0) / 100.0;
        }
        return 1.0;
    };
    public static final INonGroupedKillerChanceModifierStrategy DEFAULT_NONGROUP_STRATEGY = (item, victim, killer) -> {
        if (!victim.isRaid() && Configuration.npc().useDeepBlueDropRules() || victim.isRaid() && Configuration.npc().useDeepBlueDropRulesRaid()) {
            int levelDifference = victim.getLevel() - killer.getLevel();
            if (item.getItemId() == 57) {
                return Util.map((double)levelDifference, (double)(-Configuration.npc().getDropAdenaMaxLevelDifference()), (double)(-Configuration.npc().getDropAdenaMinLevelDifference()), (double)Configuration.npc().getDropAdenaMinLevelGapChance(), 100.0) / 100.0;
            }
            return Util.map((double)levelDifference, (double)(-Configuration.npc().getDropItemMaxLevelDifference()), (double)(-Configuration.npc().getDropItemMinLevelDifference()), (double)Configuration.npc().getDropItemMinLevelGapChance(), 100.0) / 100.0;
        }
        return 1.0;
    };
    public static final IKillerChanceModifierStrategy NO_RULES = (item, victim, killer) -> 1.0;

    public double getKillerChanceModifier(IDropItem var1, L2Character var2, L2Character var3);

    @Override
    default public double getKillerChanceModifier(GeneralDropItem item, L2Character victim, L2Character killer) {
        return this.getKillerChanceModifier((IDropItem)item, victim, killer);
    }
}

