/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.effects;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.handler.EffectHandler;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEffect {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEffect.class);
    private final Condition _attachCond;
    private List<FuncTemplate> _funcTemplates;
    private final String _name;
    private int _ticks;

    protected AbstractEffect(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params) {
        this._attachCond = attachCond;
        this._name = set.getString("name");
    }

    public static AbstractEffect createEffect(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params) {
        String name = set.getString("name");
        Class<? extends AbstractEffect> handler = EffectHandler.getInstance().getHandler(name);
        if (handler == null) {
            LOG.warn("Requested unexistent effect handler {} in skill Id {}!", (Object)name, (Object)set.getInt("id"));
            return null;
        }
        try {
            Constructor<? extends AbstractEffect> constructor = handler.getConstructor(Condition.class, Condition.class, StatsSet.class, StatsSet.class);
            return constructor.newInstance(attachCond, applyCond, set, params);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LOG.warn("Requested unexistent constructor for effect handler {} in skill Id {}!", name, set.getInt("id"), ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            LOG.warn("Unable to initialize effect handler {} in skill Id {}!", name, set.getInt("id"), ex);
        }
        return null;
    }

    public boolean testConditions(L2Character caster, L2Character target, Skill skill) {
        return this._attachCond == null || this._attachCond.test(caster, target, skill);
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new ArrayList<FuncTemplate>(1);
        }
        this._funcTemplates.add(f);
    }

    public String getName() {
        return this._name;
    }

    public int getTicks() {
        return this._ticks;
    }

    protected void setTicks(int ticks) {
        this._ticks = ticks;
    }

    public double getTicksMultiplier() {
        return (float)(this.getTicks() * Configuration.character().getEffectTickRatio()) / 1000.0f;
    }

    public List<FuncTemplate> getFuncTemplates() {
        return this._funcTemplates;
    }

    public boolean calcSuccess(BuffInfo info) {
        return true;
    }

    public L2EffectType getEffectType() {
        return L2EffectType.NONE;
    }

    public boolean canStart(BuffInfo info) {
        return true;
    }

    public void onStart(BuffInfo info) {
    }

    public boolean onActionTime(BuffInfo info) {
        return false;
    }

    public void onExit(BuffInfo info) {
    }

    public List<AbstractFunction> getStatFuncs(L2Character caster, L2Character target, Skill skill) {
        if (this.getFuncTemplates() == null) {
            return List.of();
        }
        ArrayList<AbstractFunction> functions = new ArrayList<AbstractFunction>(this.getFuncTemplates().size());
        for (FuncTemplate functionTemplate : this.getFuncTemplates()) {
            AbstractFunction function = functionTemplate.getFunc(caster, target, skill, (Object)this);
            if (function == null) continue;
            functions.add(function);
        }
        return functions;
    }

    public int getEffectFlags() {
        return EffectFlag.NONE.getMask();
    }

    public String toString() {
        return "Effect " + this._name;
    }

    public void decreaseForce() {
    }

    public void increaseEffect() {
    }

    public boolean checkCondition(Object obj) {
        return true;
    }

    public boolean isInstant() {
        return false;
    }
}

