/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.enums.AuctionItemType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auction {
    protected static final Logger LOG = LoggerFactory.getLogger(Auction.class);
    private final int _id;
    private long _endDate;
    private int _highestBidderId = 0;
    private String _highestBidderName = "";
    private long _highestBidderMaxBid = 0L;
    private int _itemId = 0;
    private String _itemName = "";
    private int _itemObjectId = 0;
    private final long _itemQuantity = 0L;
    private String _itemType = "";
    private int _sellerId = 0;
    private String _sellerClanName = "";
    private String _sellerName = "";
    private long _currentBid = 0L;
    private long _startingBid = 0L;
    private final Map<Integer, Bidder> _bidders = new ConcurrentHashMap<Integer, Bidder>();
    private static final String[] ItemTypeName = new String[]{"ClanHall"};

    public Auction(int auctionId) {
        this._id = auctionId;
        this.load();
        this.startAutoTask();
    }

    public Auction(int itemId, L2Clan Clan, long delay, long bid, String name) {
        this._id = itemId;
        this._endDate = System.currentTimeMillis() + delay;
        this._itemId = itemId;
        this._itemName = name;
        this._itemType = "ClanHall";
        this._sellerId = Clan.getLeaderId();
        this._sellerName = Clan.getLeaderName();
        this._sellerClanName = Clan.getName();
        this._startingBid = bid;
    }

    private void load() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("Select * from auction where id = ?");){
            ps.setInt(1, this.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._currentBid = rs.getLong("currentBid");
                    this._endDate = rs.getLong("endDate");
                    this._itemId = rs.getInt("itemId");
                    this._itemName = rs.getString("itemName");
                    this._itemObjectId = rs.getInt("itemObjectId");
                    this._itemType = rs.getString("itemType");
                    this._sellerId = rs.getInt("sellerId");
                    this._sellerClanName = rs.getString("sellerClanName");
                    this._sellerName = rs.getString("sellerName");
                    this._startingBid = rs.getLong("startingBid");
                }
            }
            this.loadBid();
        }
        catch (Exception e) {
            LOG.warn("Exception: Auction.load(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadBid() {
        this._highestBidderId = 0;
        this._highestBidderName = "";
        this._highestBidderMaxBid = 0L;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT bidderId, bidderName, maxBid, clan_name, time_bid FROM auction_bid WHERE auctionId = ? ORDER BY maxBid DESC");){
            ps.setInt(1, this.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (rs.isFirst()) {
                        this._highestBidderId = rs.getInt("bidderId");
                        this._highestBidderName = rs.getString("bidderName");
                        this._highestBidderMaxBid = rs.getLong("maxBid");
                    }
                    this._bidders.put(rs.getInt("bidderId"), new Bidder(rs.getString("bidderName"), rs.getString("clan_name"), rs.getLong("maxBid"), rs.getLong("time_bid")));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: Auction.loadBid(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void startAutoTask() {
        long currentTime = System.currentTimeMillis();
        long taskDelay = 0L;
        if (this._endDate <= currentTime) {
            this._endDate = currentTime + 604800000L;
            this.saveAuctionDate();
        } else {
            taskDelay = this._endDate - currentTime;
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new AutoEndTask(), taskDelay);
    }

    public static String getItemTypeName(AuctionItemType value) {
        return ItemTypeName[value.ordinal()];
    }

    private void saveAuctionDate() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("Update auction set endDate = ? where id = ?");){
            ps.setLong(1, this._endDate);
            ps.setInt(2, this._id);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: saveAuctionDate(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public synchronized void setBid(L2PcInstance bidder, long bid) {
        long requiredAdena = bid;
        if (this.getHighestBidderName().equals(bidder.getClan().getLeaderName())) {
            requiredAdena = bid - this.getHighestBidderMaxBid();
        }
        if ((this.getHighestBidderId() > 0 && bid > this.getHighestBidderMaxBid() || this.getHighestBidderId() == 0 && bid >= this.getStartingBid()) && this.takeItem(bidder, requiredAdena)) {
            this.updateInDB(bidder, bid);
            bidder.getClan().setAuctionBidAt(this._id, true);
            return;
        }
        if (bid < this.getStartingBid() || bid <= this.getHighestBidderMaxBid()) {
            bidder.sendPacket(SystemMessageId.BID_PRICE_MUST_BE_HIGHER);
        }
    }

    private void returnItem(String clanName, long quantity, boolean penalty) {
        L2Clan clan;
        if (penalty) {
            quantity = (long)((double)quantity * 0.9);
        }
        if ((clan = ClanTable.getInstance().getClanByName(clanName)) == null) {
            LOG.warn("Clan {} doesn't exist!", (Object)clanName);
            return;
        }
        ItemContainer cwh = clan.getWarehouse();
        if (cwh == null) {
            LOG.warn("There has been a problem with {}'s clan warehouse!", (Object)clanName);
            return;
        }
        long limit = Configuration.character().getMaxAdena() - cwh.getAdena();
        quantity = Math.min(quantity, limit);
        cwh.addItem("Outbidded", 57, quantity, null, null);
    }

    private boolean takeItem(L2PcInstance bidder, long quantity) {
        if (bidder.getClan() != null && bidder.getClan().getWarehouse().getAdena() >= quantity) {
            bidder.getClan().getWarehouse().destroyItemByItemId("Buy", 57, quantity, bidder, bidder);
            return true;
        }
        bidder.sendPacket(SystemMessageId.NOT_ENOUGH_ADENA_IN_CWH);
        return false;
    }

    private void updateInDB(L2PcInstance bidder, long bid) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            if (this._bidders.get(bidder.getClanId()) != null) {
                try (PreparedStatement ps = con.prepareStatement("UPDATE auction_bid SET bidderId=?, bidderName=?, maxBid=?, time_bid=? WHERE auctionId=? AND bidderId=?");){
                    ps.setInt(1, bidder.getClanId());
                    ps.setString(2, bidder.getClan().getLeaderName());
                    ps.setLong(3, bid);
                    ps.setLong(4, System.currentTimeMillis());
                    ps.setInt(5, this.getId());
                    ps.setInt(6, bidder.getClanId());
                    ps.execute();
                }
            }
            try (PreparedStatement ps = con.prepareStatement("INSERT INTO auction_bid (id, auctionId, bidderId, bidderName, maxBid, clan_name, time_bid) VALUES (?, ?, ?, ?, ?, ?, ?)");){
                ps.setInt(1, IdFactory.getInstance().getNextId());
                ps.setInt(2, this.getId());
                ps.setInt(3, bidder.getClanId());
                ps.setString(4, bidder.getName());
                ps.setLong(5, bid);
                ps.setString(6, bidder.getClan().getName());
                ps.setLong(7, System.currentTimeMillis());
                ps.execute();
            }
            if (L2World.getInstance().getPlayer(this._highestBidderName) != null) {
                L2World.getInstance().getPlayer(this._highestBidderName).sendMessage("You have been out bidded");
            }
            this._highestBidderId = bidder.getClanId();
            this._highestBidderMaxBid = bid;
            this._highestBidderName = bidder.getClan().getLeaderName();
            if (this._bidders.get(this._highestBidderId) == null) {
                this._bidders.put(this._highestBidderId, new Bidder(this._highestBidderName, bidder.getClan().getName(), bid, Calendar.getInstance().getTimeInMillis()));
            } else {
                this._bidders.get(this._highestBidderId).setBid(bid);
                this._bidders.get(this._highestBidderId).setTimeBid(Calendar.getInstance().getTimeInMillis());
            }
            bidder.sendPacket(SystemMessageId.BID_IN_CLANHALL_AUCTION);
        }
        catch (Exception e) {
            LOG.error("Exception: Auction.updateInDB(L2PcInstance bidder, int bid): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void removeBids() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM auction_bid WHERE auctionId=?");){
            ps.setInt(1, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: Auction.deleteFromDB(): {}", (Object)e.getMessage(), (Object)e);
        }
        for (Bidder b : this._bidders.values()) {
            if (ClanTable.getInstance().getClanByName(b.getClanName()).getHideoutId() == 0) {
                this.returnItem(b.getClanName(), b.getBid(), true);
            } else if (L2World.getInstance().getPlayer(b.getName()) != null) {
                L2World.getInstance().getPlayer(b.getName()).sendMessage("Congratulation you have won ClanHall!");
            }
            ClanTable.getInstance().getClanByName(b.getClanName()).setAuctionBidAt(0, true);
        }
        this._bidders.clear();
    }

    public void deleteAuctionFromDB() {
        AuctionManager.getInstance().getAuctions().remove(this);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM auction WHERE itemId=?");){
            ps.setInt(1, this._itemId);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: Auction.deleteFromDB(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void endAuction() {
        if (ClanHallManager.getInstance().loaded()) {
            if (this._highestBidderId == 0 && this._sellerId == 0) {
                this.startAutoTask();
                return;
            }
            if (this._highestBidderId == 0 && this._sellerId > 0) {
                int aucId = AuctionManager.getInstance().getAuctionIndex(this._id);
                AuctionManager.getInstance().getAuctions().remove(aucId);
                return;
            }
            if (this._sellerId > 0) {
                this.returnItem(this._sellerClanName, this._highestBidderMaxBid, true);
                this.returnItem(this._sellerClanName, ClanHallManager.getInstance().getAuctionableHallById(this._itemId).getLease(), false);
            }
            this.deleteAuctionFromDB();
            L2Clan Clan = ClanTable.getInstance().getClanByName(this._bidders.get(this._highestBidderId).getClanName());
            this._bidders.remove(this._highestBidderId);
            Clan.setAuctionBidAt(0, true);
            this.removeBids();
            ClanHallManager.getInstance().setOwner(this._itemId, Clan);
        } else {
            ThreadPoolManager.getInstance().scheduleGeneral(new AutoEndTask(), 3000L);
        }
    }

    public synchronized void cancelBid(int bidder) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM auction_bid WHERE auctionId=? AND bidderId=?");){
            ps.setInt(1, this.getId());
            ps.setInt(2, bidder);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: Auction.cancelBid(String bidder): {}", (Object)e.getMessage(), (Object)e);
        }
        this.returnItem(this._bidders.get(bidder).getClanName(), this._bidders.get(bidder).getBid(), true);
        ClanTable.getInstance().getClanByName(this._bidders.get(bidder).getClanName()).setAuctionBidAt(0, true);
        this._bidders.clear();
        this.loadBid();
    }

    public void cancelAuction() {
        this.deleteAuctionFromDB();
        this.removeBids();
    }

    public void confirmAuction() {
        AuctionManager.getInstance().getAuctions().add(this);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO auction (id, sellerId, sellerName, sellerClanName, itemType, itemId, itemObjectId, itemName, itemQuantity, startingBid, currentBid, endDate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");){
            ps.setInt(1, this.getId());
            ps.setInt(2, this._sellerId);
            ps.setString(3, this._sellerName);
            ps.setString(4, this._sellerClanName);
            ps.setString(5, this._itemType);
            ps.setInt(6, this._itemId);
            ps.setInt(7, this._itemObjectId);
            ps.setString(8, this._itemName);
            ps.setLong(9, 0L);
            ps.setLong(10, this._startingBid);
            ps.setLong(11, this._currentBid);
            ps.setLong(12, this._endDate);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: Auction.load(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public final int getId() {
        return this._id;
    }

    public final long getCurrentBid() {
        return this._currentBid;
    }

    public final long getEndDate() {
        return this._endDate;
    }

    public final int getHighestBidderId() {
        return this._highestBidderId;
    }

    public final String getHighestBidderName() {
        return this._highestBidderName;
    }

    public final long getHighestBidderMaxBid() {
        return this._highestBidderMaxBid;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public final String getItemName() {
        return this._itemName;
    }

    public final int getItemObjectId() {
        return this._itemObjectId;
    }

    public final long getItemQuantity() {
        return 0L;
    }

    public final String getItemType() {
        return this._itemType;
    }

    public final int getSellerId() {
        return this._sellerId;
    }

    public final String getSellerName() {
        return this._sellerName;
    }

    public final String getSellerClanName() {
        return this._sellerClanName;
    }

    public final long getStartingBid() {
        return this._startingBid;
    }

    public final Map<Integer, Bidder> getBidders() {
        return this._bidders;
    }

    public static class Bidder {
        private final String _name;
        private final String _clanName;
        private long _bid;
        private final Calendar _timeBid;

        public Bidder(String name, String clanName, long bid, long timeBid) {
            this._name = name;
            this._clanName = clanName;
            this._bid = bid;
            this._timeBid = Calendar.getInstance();
            this._timeBid.setTimeInMillis(timeBid);
        }

        public String getName() {
            return this._name;
        }

        public String getClanName() {
            return this._clanName;
        }

        public long getBid() {
            return this._bid;
        }

        public Calendar getTimeBid() {
            return this._timeBid;
        }

        public void setTimeBid(long timeBid) {
            this._timeBid.setTimeInMillis(timeBid);
        }

        public void setBid(long bid) {
            this._bid = bid;
        }
    }

    public class AutoEndTask
    implements Runnable {
        @Override
        public void run() {
            try {
                Auction.this.endAuction();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

