/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClanHall {
    private static final Logger LOG = LoggerFactory.getLogger(ClanHall.class);
    private final int _clanHallId;
    private ArrayList<L2DoorInstance> _doors;
    private final String _name;
    private int _ownerId;
    private final String _desc;
    private final String _location;
    private L2ClanHallZone _zone;
    protected boolean _isFree = true;
    private final Map<Integer, ClanHallFunction> _functions;
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_ITEM_CREATE = 2;
    public static final int FUNC_RESTORE_HP = 3;
    public static final int FUNC_RESTORE_MP = 4;
    public static final int FUNC_RESTORE_EXP = 5;
    public static final int FUNC_SUPPORT = 6;
    public static final int FUNC_DECO_FRONTPLATEFORM = 7;
    public static final int FUNC_DECO_CURTAINS = 8;

    public ClanHall(StatsSet set) {
        this._clanHallId = set.getInt("id");
        this._name = set.getString("name");
        this._ownerId = set.getInt("ownerId");
        this._desc = set.getString("desc");
        this._location = set.getString("location");
        this._functions = new ConcurrentHashMap<Integer, ClanHallFunction>();
        if (this._ownerId > 0) {
            L2Clan clan = ClanTable.getInstance().getClan(this._ownerId);
            if (clan != null) {
                clan.setHideoutId(this.getId());
            } else {
                this.free();
            }
        }
    }

    public final int getId() {
        return this._clanHallId;
    }

    public final String getName() {
        return this._name;
    }

    public final int getOwnerId() {
        return this._ownerId;
    }

    public final String getDesc() {
        return this._desc;
    }

    public final String getLocation() {
        return this._location;
    }

    public final ArrayList<L2DoorInstance> getDoors() {
        if (this._doors == null) {
            this._doors = new ArrayList();
        }
        return this._doors;
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getId() != doorId) continue;
            return door;
        }
        return null;
    }

    public ClanHallFunction getFunction(int type) {
        return this._functions.get(type);
    }

    public void setZone(L2ClanHallZone zone) {
        this._zone = zone;
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2ClanHallZone getZone() {
        return this._zone;
    }

    public void free() {
        this._ownerId = 0;
        this._isFree = true;
        for (Integer fc : this._functions.keySet()) {
            this.removeFunction(fc);
        }
        this._functions.clear();
        this.updateDb();
    }

    public void setOwner(L2Clan clan) {
        if (this._ownerId > 0 || clan == null) {
            return;
        }
        this._ownerId = clan.getId();
        this._isFree = false;
        clan.setHideoutId(this.getId());
        clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
        this.updateDb();
    }

    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoor(doorId, open);
        }
    }

    public void openCloseDoor(int doorId, boolean open) {
        this.openCloseDoor(this.getDoor(doorId), open);
    }

    public void openCloseDoor(L2DoorInstance door, boolean open) {
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    public void openCloseDoors(L2PcInstance activeChar, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoors(open);
        }
    }

    public void openCloseDoors(boolean open) {
        for (L2DoorInstance door : this.getDoors()) {
            if (door == null) continue;
            if (open) {
                door.openMe();
                continue;
            }
            door.closeMe();
        }
    }

    public void banishForeigners() {
        if (this._zone != null) {
            this._zone.banishForeigners(this.getOwnerId());
        } else {
            LOG.warn("Zone is null for clan hall: {} {}", (Object)this.getId(), (Object)this.getName());
        }
    }

    protected void loadFunctions() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM clanhall_functions WHERE hall_id = ?");){
            ps.setInt(1, this.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._functions.put(rs.getInt("type"), new ClanHallFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception: ClanHall.loadFunctions(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void removeFunction(int functionType) {
        this._functions.remove(functionType);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM clanhall_functions WHERE hall_id=? AND type=?");){
            ps.setInt(1, this.getId());
            ps.setInt(2, functionType);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Exception: ClanHall.removeFunctions(int functionType): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - this._functions.get(type).getLease();
            if (diffLease > 0) {
                this._functions.remove(type);
                this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                this._functions.get(type).setLease(lease);
                this._functions.get(type).setLvl(lvl);
                this._functions.get(type).dbSave();
            }
        }
        return true;
    }

    public int getGrade() {
        return 0;
    }

    public long getPaidUntil() {
        return 0L;
    }

    public int getLease() {
        return 0;
    }

    public boolean isSiegableHall() {
        return false;
    }

    public boolean isFree() {
        return this._isFree;
    }

    public abstract void updateDb();

    public class ClanHallFunction {
        private final int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private final long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public ClanHallFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (ClanHall.this._isFree) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        public void dbSave() {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement("REPLACE INTO clanhall_functions (hall_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");){
                ps.setInt(1, ClanHall.this.getId());
                ps.setInt(2, this.getType());
                ps.setInt(3, this.getLvl());
                ps.setInt(4, this.getLease());
                ps.setLong(5, this.getRate());
                ps.setLong(6, this.getEndTime());
                ps.execute();
            }
            catch (Exception e) {
                LOG.error("Exception: ClanHall.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): {}", (Object)e.getMessage(), (Object)e);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                ClanHallFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (ClanHall.this._isFree) {
                        return;
                    }
                    if (ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().getAdena() >= (long)ClanHallFunction.this._fee || !ClanHallFunction.this._cwh) {
                        int fee = ClanHallFunction.this._fee;
                        if (ClanHallFunction.this.getEndTime() == -1L) {
                            fee = ClanHallFunction.this._tempFee;
                        }
                        ClanHallFunction.this.setEndTime(System.currentTimeMillis() + ClanHallFunction.this.getRate());
                        ClanHallFunction.this.dbSave();
                        if (ClanHallFunction.this._cwh) {
                            ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().destroyItemByItemId("CH_function_fee", 57, fee, null, null);
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), ClanHallFunction.this.getRate());
                    } else {
                        ClanHall.this.removeFunction(ClanHallFunction.this.getType());
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
    }
}

