/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.DuelResult;
import com.l2jserver.gameserver.enums.DuelState;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.enums.audio.Music;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExDuelEnd;
import com.l2jserver.gameserver.network.serverpackets.ExDuelReady;
import com.l2jserver.gameserver.network.serverpackets.ExDuelStart;
import com.l2jserver.gameserver.network.serverpackets.ExDuelUpdateUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Duel {
    protected static final Logger LOG = LoggerFactory.getLogger(Duel.class);
    private static final PlaySound B04_S01 = Music.B04_S01.getPacket();
    private static final int PARTY_DUEL_DURATION = 300;
    private static final int PARTY_DUEL_PREPARE_TIME = 30;
    private static final int PARTY_DUEL_TELEPORT_BACK_TIME = 10000;
    private static final int PLAYER_DUEL_DURATION = 120;
    private static final int DUEL_PREPARE_TIME = 5;
    private final int _duelId;
    private final List<L2PcInstance> _teamA;
    private final L2PcInstance _leaderA;
    private final List<L2PcInstance> _teamB;
    private final L2PcInstance _leaderB;
    private final boolean _partyDuel;
    private final Calendar _duelEndTime;
    private int _surrenderRequest = 0;
    private int _countdown;
    private final Map<Integer, PlayerCondition> _playerConditions = new ConcurrentHashMap<Integer, PlayerCondition>();
    private int _duelInstanceId;

    public Duel(L2PcInstance playerA, L2PcInstance playerB, boolean partyDuel, int duelId) {
        this._duelId = duelId;
        if (partyDuel) {
            this._leaderA = playerA;
            this._leaderB = playerB;
            this._teamA = new ArrayList<L2PcInstance>(playerA.getParty().getMembers());
            this._teamB = new ArrayList<L2PcInstance>(playerB.getParty().getMembers());
        } else {
            this._leaderA = playerA;
            this._leaderB = playerB;
            this._teamA = new ArrayList<L2PcInstance>();
            this._teamB = new ArrayList<L2PcInstance>();
            this._teamA.add(playerA);
            this._teamB.add(playerB);
        }
        this._partyDuel = partyDuel;
        this._duelEndTime = Calendar.getInstance();
        this._duelEndTime.add(13, this._partyDuel ? 300 : 120);
        this.savePlayerConditions();
        if (this._partyDuel) {
            this._countdown = 30;
            this.teleportPlayers();
        } else {
            this._countdown = 5;
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new DuelPreparationTask(this), this._countdown - 3);
    }

    public void startDuel() {
        this.broadcastToTeam1(ExDuelReady.PARTY_DUEL);
        this.broadcastToTeam2(ExDuelReady.PARTY_DUEL);
        this.broadcastToTeam1(ExDuelStart.PARTY_DUEL);
        this.broadcastToTeam2(ExDuelStart.PARTY_DUEL);
        for (L2PcInstance temp : this._teamA) {
            temp.cancelActiveTrade();
            temp.setIsInDuel(this._duelId);
            temp.setTeam(Team.BLUE);
            temp.broadcastUserInfo();
            this.broadcastToTeam2(new ExDuelUpdateUserInfo(temp));
        }
        for (L2PcInstance temp : this._teamB) {
            temp.cancelActiveTrade();
            temp.setIsInDuel(this._duelId);
            temp.setTeam(Team.RED);
            temp.broadcastUserInfo();
            this.broadcastToTeam1(new ExDuelUpdateUserInfo(temp));
        }
        if (this._partyDuel) {
            for (L2DoorInstance door : InstanceManager.getInstance().getInstance(this.getDuelInstanceId()).getDoors()) {
                if (door == null || !door.getOpen()) continue;
                door.closeMe();
            }
        }
        this.broadcastToTeam1(B04_S01);
        this.broadcastToTeam2(B04_S01);
        ThreadPoolManager.getInstance().scheduleGeneral(new DuelClockTask(this), 1000L);
    }

    private void stopFighting() {
        for (L2PcInstance temp : this._teamA) {
            temp.abortCast();
            temp.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            temp.setTarget(null);
            temp.sendPacket(ActionFailed.STATIC_PACKET);
        }
        for (L2PcInstance temp : this._teamB) {
            temp.abortCast();
            temp.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            temp.setTarget(null);
            temp.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public void savePlayerConditions() {
        for (L2PcInstance player : this._teamA) {
            this._playerConditions.put(player.getObjectId(), new PlayerCondition(player, this._partyDuel));
        }
        for (L2PcInstance player : this._teamB) {
            this._playerConditions.put(player.getObjectId(), new PlayerCondition(player, this._partyDuel));
        }
    }

    public void restorePlayerConditions() {
        ThreadPoolManager.getInstance().scheduleGeneral(() -> this._playerConditions.values().forEach(PlayerCondition::restoreCondition), this._partyDuel ? 10000L : 1000L);
        ThreadPoolManager.getInstance().scheduleGeneral(this::clear, this._partyDuel ? 10000L : 1000L);
    }

    public int getId() {
        return this._duelId;
    }

    public int getDuelInstanceId() {
        return this._duelInstanceId;
    }

    public int getRemainingTime() {
        return (int)(this._duelEndTime.getTimeInMillis() - Calendar.getInstance().getTimeInMillis());
    }

    public List<L2PcInstance> getTeamA() {
        return this._teamA;
    }

    public List<L2PcInstance> getTeamB() {
        return this._teamB;
    }

    public L2PcInstance getTeamLeaderA() {
        return this._leaderA;
    }

    public L2PcInstance getTeamLeaderB() {
        return this._leaderB;
    }

    public List<L2PcInstance> getLooser() {
        if (this._leaderA == null || this._leaderB == null) {
            return null;
        }
        if (this._leaderA.getDuelState() == DuelState.WINNER) {
            return this._teamB;
        }
        if (this._leaderB.getDuelState() == DuelState.WINNER) {
            return this._teamA;
        }
        return null;
    }

    public boolean isPartyDuel() {
        return this._partyDuel;
    }

    public void teleportPlayers() {
        Location loc;
        if (!this._partyDuel) {
            return;
        }
        this._duelInstanceId = InstanceManager.getInstance().createDynamicInstance("PartyDuel.xml");
        Instance instance = InstanceManager.getInstance().getInstance(this._duelInstanceId);
        int i = 0;
        for (L2PcInstance player : this._teamA) {
            loc = instance.getEnterLocs().get(i++);
            player.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), 0, this._duelInstanceId, 0);
        }
        i = 9;
        for (L2PcInstance player : this._teamB) {
            loc = instance.getEnterLocs().get(i++);
            player.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), 0, this._duelInstanceId, 0);
        }
    }

    public void broadcastToTeam1(L2GameServerPacket packet) {
        if (this._teamA == null || this._teamA.isEmpty()) {
            return;
        }
        for (L2PcInstance temp : this._teamA) {
            temp.sendPacket(packet);
        }
    }

    public void broadcastToTeam2(L2GameServerPacket packet) {
        if (this._teamB == null || this._teamB.isEmpty()) {
            return;
        }
        for (L2PcInstance temp : this._teamB) {
            temp.sendPacket(packet);
        }
    }

    private void playKneelAnimation() {
        List<L2PcInstance> looser = this.getLooser();
        if (looser == null) {
            return;
        }
        for (L2PcInstance temp : looser) {
            temp.broadcastPacket(new SocialAction(temp.getObjectId(), 7));
        }
    }

    int countdown() {
        if (--this._countdown > 3) {
            return this._countdown;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_DUEL_WILL_BEGIN_IN_S1_SECONDS);
        if (this._countdown > 0) {
            sm.addInt(this._countdown);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.LET_THE_DUEL_BEGIN);
        }
        this.broadcastToTeam1(sm);
        this.broadcastToTeam2(sm);
        return this._countdown;
    }

    void endDuel() {
        ExDuelEnd duelEnd = this._partyDuel ? ExDuelEnd.PARTY_DUEL : ExDuelEnd.PLAYER_DUEL;
        this.broadcastToTeam1(duelEnd);
        this.broadcastToTeam2(duelEnd);
        this.playKneelAnimation();
        this.sendEndMessages();
        this.restorePlayerConditions();
    }

    private void clear() {
        InstanceManager.getInstance().destroyInstance(this.getDuelInstanceId());
        DuelManager.getInstance().removeDuel(this);
    }

    private void sendEndMessages() {
        SystemMessage sm = null;
        switch (this.checkEndDuelCondition()) {
            case TEAM_1_WIN: 
            case TEAM_2_SURRENDER: {
                sm = this._partyDuel ? SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_WON_THE_DUEL) : SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_DUEL);
                sm.addString(this._leaderA.getName());
                break;
            }
            case TEAM_1_SURRENDER: 
            case TEAM_2_WIN: {
                sm = this._partyDuel ? SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_WON_THE_DUEL) : SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_DUEL);
                sm.addString(this._leaderB.getName());
                break;
            }
            case CANCELED: 
            case TIMEOUT: {
                this.stopFighting();
                sm = SystemMessage.getSystemMessage(SystemMessageId.THE_DUEL_HAS_ENDED_IN_A_TIE);
            }
        }
        this.broadcastToTeam1(sm);
        this.broadcastToTeam2(sm);
    }

    DuelResult checkEndDuelCondition() {
        if (this._teamA == null || this._teamB == null) {
            return DuelResult.CANCELED;
        }
        if (this._surrenderRequest != 0) {
            if (this._surrenderRequest == 1) {
                return DuelResult.TEAM_1_SURRENDER;
            }
            return DuelResult.TEAM_2_SURRENDER;
        }
        if (this.getRemainingTime() <= 0) {
            return DuelResult.TIMEOUT;
        }
        if (this._leaderA.getDuelState() == DuelState.WINNER) {
            this.stopFighting();
            return DuelResult.TEAM_1_WIN;
        }
        if (this._leaderB.getDuelState() == DuelState.WINNER) {
            this.stopFighting();
            return DuelResult.TEAM_2_WIN;
        }
        if (!this._partyDuel) {
            if (this._leaderA.getDuelState() == DuelState.INTERRUPTED || this._leaderB.getDuelState() == DuelState.INTERRUPTED) {
                return DuelResult.CANCELED;
            }
            if (!this._leaderA.isInsideRadius(this._leaderB, 2000, false, false)) {
                return DuelResult.CANCELED;
            }
            if (this._leaderA.isInsideZone(ZoneId.PEACE) || this._leaderB.isInsideZone(ZoneId.PEACE) || this._leaderA.isInsideZone(ZoneId.SIEGE) || this._leaderB.isInsideZone(ZoneId.SIEGE) || this._leaderA.isInsideZone(ZoneId.PVP) || this._leaderB.isInsideZone(ZoneId.PVP)) {
                return DuelResult.CANCELED;
            }
        }
        return DuelResult.CONTINUE;
    }

    public void doSurrender(L2PcInstance player) {
        if (this._surrenderRequest != 0 || this._partyDuel) {
            return;
        }
        this.stopFighting();
        if (player == this._leaderA) {
            this._surrenderRequest = 1;
            this._leaderA.setDuelState(DuelState.DEAD);
            this._leaderB.setDuelState(DuelState.WINNER);
        } else if (player == this._leaderB) {
            this._surrenderRequest = 2;
            this._leaderB.setDuelState(DuelState.DEAD);
            this._leaderA.setDuelState(DuelState.WINNER);
        }
    }

    public void onPlayerDefeat(L2PcInstance player) {
        player.setDuelState(DuelState.DEAD);
        player.setTeam(Team.NONE);
        if (this._partyDuel) {
            boolean teamDefeated = true;
            boolean isInTeamA = true;
            if (this._teamA.contains(player)) {
                for (L2PcInstance temp : this._teamA) {
                    if (temp.getDuelState() != DuelState.DUELLING) continue;
                    teamDefeated = false;
                    break;
                }
            } else if (this._teamB.contains(player)) {
                isInTeamA = false;
                for (L2PcInstance temp : this._teamB) {
                    if (temp.getDuelState() != DuelState.DUELLING) continue;
                    teamDefeated = false;
                    break;
                }
            }
            if (teamDefeated) {
                List<L2PcInstance> winners = isInTeamA ? this._teamB : this._teamA;
                for (L2PcInstance temp : winners) {
                    temp.setDuelState(DuelState.WINNER);
                }
            }
        } else {
            if (player != this._leaderA && player != this._leaderB) {
                LOG.warn("Error in onPlayerDefeat(): player is not part of this 1vs1 duel!");
            }
            if (this._leaderA == player) {
                this._leaderB.setDuelState(DuelState.WINNER);
            } else {
                this._leaderA.setDuelState(DuelState.WINNER);
            }
        }
    }

    public static class DuelPreparationTask
    implements Runnable {
        private final Duel _duel;

        public DuelPreparationTask(Duel duel) {
            this._duel = duel;
        }

        @Override
        public void run() {
            try {
                if (this._duel.countdown() > 0) {
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
                } else {
                    this._duel.startDuel();
                }
            }
            catch (Exception e) {
                LOG.error("There has been a problem while running a duel start task!", e);
            }
        }
    }

    public class DuelClockTask
    implements Runnable {
        private final Duel _duel;

        public DuelClockTask(Duel duel) {
            this._duel = duel;
        }

        @Override
        public void run() {
            try {
                if (this._duel.checkEndDuelCondition() == DuelResult.CONTINUE) {
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
                } else {
                    Duel.this.endDuel();
                }
            }
            catch (Exception e) {
                LOG.error("There has been a problem while running a duel task!", e);
            }
        }
    }

    public static class PlayerCondition {
        private final L2PcInstance _player;
        private L2Summon _summon;
        private final double _hp;
        private final double _mp;
        private final double _cp;
        private final boolean _paDuel;
        private Location _loc;
        private final List<BuffInfo> _playerEffects;
        private List<BuffInfo> _petEffects;

        public PlayerCondition(L2PcInstance player, boolean partyDuel) {
            this._player = player;
            this._hp = this._player.getCurrentHp();
            this._mp = this._player.getCurrentMp();
            this._cp = this._player.getCurrentCp();
            this._paDuel = partyDuel;
            this._playerEffects = new ArrayList<BuffInfo>(player.getEffectList().getEffects());
            if (this._paDuel) {
                this._loc = this._player.getLocation();
            }
            if (player.hasSummon()) {
                this._summon = player.getSummon();
                this._petEffects = new ArrayList<BuffInfo>(player.getSummon().getEffectList().getEffects());
            }
        }

        public void restoreCondition() {
            if (this._player == null) {
                return;
            }
            this._player.setCurrentHp(this._hp);
            this._player.setCurrentMp(this._mp);
            this._player.setCurrentCp(this._cp);
            this._player.setIsInDuel(0);
            this._player.setTeam(Team.NONE);
            this._player.broadcastUserInfo();
            if (this._paDuel) {
                this.teleportBack();
            }
            this._player.getEffectList().stopAllEffects();
            for (BuffInfo skill : this._playerEffects) {
                if (skill == null || skill.getTime() <= 0) continue;
                skill.getSkill().applyEffects(this._player, this._player, true, skill.getTime());
            }
            if (this._player.hasSummon()) {
                this._player.getSummon().getEffectList().stopAllEffects();
                if (this._summon != null && this._summon == this._player.getSummon()) {
                    for (BuffInfo skill : this._petEffects) {
                        if (skill == null || skill.getTime() <= 0) continue;
                        skill.getSkill().applyEffects(this._summon, this._summon, true, skill.getTime());
                    }
                }
            }
        }

        public void teleportBack() {
            this._player.teleToLocation(this._loc);
        }

        public L2PcInstance getPlayer() {
            return this._player;
        }
    }
}

