/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.enums.InstanceReenterType;
import com.l2jserver.gameserver.enums.InstanceRemoveBuffType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2DoorTemplate;
import com.l2jserver.gameserver.model.holders.InstanceReenterTimeHolder;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.io.File;
import java.io.IOException;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Instance {
    private static final Logger LOG = LoggerFactory.getLogger(Instance.class);
    private final int _id;
    private String _name;
    private int _ejectTime = (int)Configuration.general().getEjectDeadPlayerTime();
    private boolean _allowRandomWalk = true;
    private final List<Integer> _players = new CopyOnWriteArrayList<Integer>();
    private final List<L2Npc> _npcs = new CopyOnWriteArrayList<L2Npc>();
    private final Map<Integer, L2DoorInstance> _doors = new ConcurrentHashMap<Integer, L2DoorInstance>();
    private final Map<String, List<L2Spawn>> _manualSpawn = new HashMap<String, List<L2Spawn>>();
    private List<Location> _enterLocations = null;
    private Location _exitLocation = null;
    private boolean _allowSummon = true;
    private long _emptyDestroyTime = -1L;
    private long _lastLeft = -1L;
    private final long _instanceStartTime;
    private long _instanceEndTime = -1L;
    private boolean _isPvPInstance = false;
    private boolean _showTimer = false;
    private boolean _isTimerIncrease = true;
    private String _timerText = "";
    private InstanceReenterType _type = InstanceReenterType.NONE;
    private final List<InstanceReenterTimeHolder> _resetData = new ArrayList<InstanceReenterTimeHolder>();
    private InstanceRemoveBuffType _removeBuffType = InstanceRemoveBuffType.NONE;
    private final List<Integer> _exceptionList = new ArrayList<Integer>();
    private ScheduledFuture<?> _checkTimeUpTask = null;
    private final Map<Integer, ScheduledFuture<?>> _ejectDeadTasks = new ConcurrentHashMap();

    public Instance(int id) {
        this._id = id;
        this._instanceStartTime = System.currentTimeMillis();
    }

    public Instance(int id, String name) {
        this._id = id;
        this._name = name;
        this._instanceStartTime = System.currentTimeMillis();
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getEjectTime() {
        return this._ejectTime;
    }

    public void setEjectTime(int ejectTime) {
        this._ejectTime = ejectTime;
    }

    public boolean isSummonAllowed() {
        return this._allowSummon;
    }

    public void setAllowSummon(boolean b) {
        this._allowSummon = b;
    }

    public boolean isPvPInstance() {
        return this._isPvPInstance;
    }

    public void setPvPInstance(boolean b) {
        this._isPvPInstance = b;
    }

    public void setDuration(long duration) {
        if (this._checkTimeUpTask != null) {
            this._checkTimeUpTask.cancel(true);
        }
        this._checkTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(duration), 500L);
        this._instanceEndTime = System.currentTimeMillis() + duration + 500L;
    }

    public void setEmptyDestroyTime(long time) {
        this._emptyDestroyTime = time;
    }

    public boolean containsPlayer(int objectId) {
        return this._players.contains(objectId);
    }

    public void addPlayer(int objectId) {
        this._players.add(objectId);
    }

    public void removePlayer(Integer objectId) {
        this._players.remove(objectId);
        if (this._players.isEmpty() && this._emptyDestroyTime >= 0L) {
            this._lastLeft = System.currentTimeMillis();
            this.setDuration((int)(this._instanceEndTime - System.currentTimeMillis() - 500L));
        }
    }

    public void addNpc(L2Npc npc) {
        this._npcs.add(npc);
    }

    public void removeNpc(L2Npc npc) {
        if (npc.getSpawn() != null) {
            npc.getSpawn().stopRespawn();
        }
        this._npcs.remove(npc);
    }

    public void addDoor(int doorId, StatsSet set) {
        if (this._doors.containsKey(doorId)) {
            LOG.warn("Door ID {} already exists in instance {}", (Object)doorId, (Object)this.getId());
            return;
        }
        int objectId = IdFactory.getInstance().getNextId();
        L2DoorTemplate template = new L2DoorTemplate(set);
        L2DoorInstance door = new L2DoorInstance(objectId, template);
        door.setInstanceId(this.getId());
        door.setCurrentHp(door.getMaxHp());
        door.spawnMe(door.getTemplate().getX(), door.getTemplate().getY(), door.getTemplate().getZ());
        this._doors.put(doorId, door);
    }

    public List<Integer> getPlayers() {
        return this._players;
    }

    public List<L2Npc> getNpcs() {
        return this._npcs;
    }

    public Collection<L2DoorInstance> getDoors() {
        return this._doors.values();
    }

    public L2DoorInstance getDoor(int id) {
        return this._doors.get(id);
    }

    public long getInstanceEndTime() {
        return this._instanceEndTime;
    }

    public long getInstanceStartTime() {
        return this._instanceStartTime;
    }

    public boolean isShowTimer() {
        return this._showTimer;
    }

    public boolean isTimerIncrease() {
        return this._isTimerIncrease;
    }

    public String getTimerText() {
        return this._timerText;
    }

    public List<Location> getEnterLocs() {
        return this._enterLocations;
    }

    public void addEnterLoc(Location loc) {
        this._enterLocations.add(loc);
    }

    public Location getExitLoc() {
        return this._exitLocation;
    }

    public void setExitLoc(Location loc) {
        this._exitLocation = loc;
    }

    public void removePlayers() {
        for (Integer objectId : this._players) {
            L2PcInstance player = L2World.getInstance().getPlayer(objectId);
            if (player == null || player.getInstanceId() != this.getId()) continue;
            player.setInstanceId(0);
            if (this.getExitLoc() != null) {
                player.teleToLocation((ILocational)this.getExitLoc(), true);
                continue;
            }
            player.teleToLocation(TeleportWhereType.TOWN);
        }
        this._players.clear();
    }

    public void removeNpcs() {
        for (L2Npc mob : this._npcs) {
            if (mob == null) continue;
            if (mob.getSpawn() != null) {
                mob.getSpawn().stopRespawn();
            }
            mob.deleteMe();
        }
        this._npcs.clear();
        this._manualSpawn.clear();
    }

    public void removeDoors() {
        for (L2DoorInstance door : this._doors.values()) {
            if (door == null) continue;
            L2WorldRegion region = door.getWorldRegion();
            door.decayMe();
            if (region != null) {
                region.removeVisibleObject(door);
            }
            door.getKnownList().removeAllKnownObjects();
            L2World.getInstance().removeObject(door);
        }
        this._doors.clear();
    }

    public List<L2Npc> spawnGroup(String groupName) {
        ArrayList<L2Npc> ret = null;
        if (this._manualSpawn.containsKey(groupName)) {
            List<L2Spawn> manualSpawn = this._manualSpawn.get(groupName);
            ret = new ArrayList<L2Npc>(manualSpawn.size());
            for (L2Spawn spawnDat : manualSpawn) {
                ret.add(spawnDat.doSpawn());
            }
        } else {
            LOG.warn("{}: cannot spawn NPCs, wrong group name: {}", (Object)this.getName(), (Object)groupName);
        }
        return ret;
    }

    public void loadInstanceTemplate(String filename) {
        File xml = new File(Configuration.server().getDatapackRoot(), "data/instances/" + filename);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            Document doc = factory.newDocumentBuilder().parse(xml);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"instance".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseInstance(n);
            }
        }
        catch (IOException e) {
            LOG.warn("Can not find {}! {}", xml.getAbsolutePath(), e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.warn("Error while loading {} ! {}", xml.getAbsolutePath(), e.getMessage(), e);
        }
    }

    private void parseInstance(Node n) throws Exception {
        Node first;
        this._name = n.getAttributes().getNamedItem("name").getNodeValue();
        Node a = n.getAttributes().getNamedItem("ejectTime");
        if (a != null) {
            this._ejectTime = 1000 * Integer.parseInt(a.getNodeValue());
        }
        if ((a = n.getAttributes().getNamedItem("allowRandomWalk")) != null) {
            this._allowRandomWalk = Boolean.parseBoolean(a.getNodeValue());
        }
        block28: for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeName().toLowerCase()) {
                case "activitytime": {
                    a = n.getAttributes().getNamedItem("val");
                    if (a == null) continue block28;
                    this._checkTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Integer.parseInt(a.getNodeValue()) * 60000), 15000L);
                    this._instanceEndTime = System.currentTimeMillis() + Long.parseLong(a.getNodeValue()) * 60000L + 15000L;
                    continue block28;
                }
                case "allowsummon": {
                    a = n.getAttributes().getNamedItem("val");
                    if (a == null) continue block28;
                    this.setAllowSummon(Boolean.parseBoolean(a.getNodeValue()));
                    continue block28;
                }
                case "emptydestroytime": {
                    a = n.getAttributes().getNamedItem("val");
                    if (a == null) continue block28;
                    this._emptyDestroyTime = Long.parseLong(a.getNodeValue()) * 1000L;
                    continue block28;
                }
                case "showtimer": {
                    a = n.getAttributes().getNamedItem("val");
                    if (a != null) {
                        this._showTimer = Boolean.parseBoolean(a.getNodeValue());
                    }
                    if ((a = n.getAttributes().getNamedItem("increase")) != null) {
                        this._isTimerIncrease = Boolean.parseBoolean(a.getNodeValue());
                    }
                    if ((a = n.getAttributes().getNamedItem("text")) == null) continue block28;
                    this._timerText = a.getNodeValue();
                    continue block28;
                }
                case "pvpinstance": {
                    a = n.getAttributes().getNamedItem("val");
                    if (a == null) continue block28;
                    this.setPvPInstance(Boolean.parseBoolean(a.getNodeValue()));
                    continue block28;
                }
                case "doorlist": {
                    for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!"door".equalsIgnoreCase(d.getNodeName())) continue;
                        int doorId = Integer.parseInt(d.getAttributes().getNamedItem("doorId").getNodeValue());
                        StatsSet set = new StatsSet();
                        set.add(DoorData.getInstance().getDoorTemplate(doorId));
                        for (Node bean = d.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                            if (!"set".equalsIgnoreCase(bean.getNodeName())) continue;
                            NamedNodeMap attrs = bean.getAttributes();
                            String setname = attrs.getNamedItem("name").getNodeValue();
                            String value = attrs.getNamedItem("val").getNodeValue();
                            set.set(setname, value);
                        }
                        this.addDoor(doorId, set);
                    }
                    continue block28;
                }
                case "spawnlist": {
                    for (Node group = n.getFirstChild(); group != null; group = group.getNextSibling()) {
                        if (!"group".equalsIgnoreCase(group.getNodeName())) continue;
                        String spawnGroup = group.getAttributes().getNamedItem("name").getNodeValue();
                        ArrayList<L2Spawn> manualSpawn = new ArrayList<L2Spawn>();
                        for (Node d = group.getFirstChild(); d != null; d = d.getNextSibling()) {
                            int respawnRandom = 0;
                            int delay = -1;
                            Boolean allowRandomWalk = null;
                            String areaName = null;
                            int globalMapId = 0;
                            if (!"spawn".equalsIgnoreCase(d.getNodeName())) continue;
                            int npcId = Integer.parseInt(d.getAttributes().getNamedItem("npcId").getNodeValue());
                            int x = Integer.parseInt(d.getAttributes().getNamedItem("x").getNodeValue());
                            int y = Integer.parseInt(d.getAttributes().getNamedItem("y").getNodeValue());
                            int z = Integer.parseInt(d.getAttributes().getNamedItem("z").getNodeValue());
                            int heading = Integer.parseInt(d.getAttributes().getNamedItem("heading").getNodeValue());
                            int respawn = Integer.parseInt(d.getAttributes().getNamedItem("respawn").getNodeValue());
                            Node node = d.getAttributes().getNamedItem("onKillDelay");
                            if (node != null) {
                                delay = Integer.parseInt(node.getNodeValue());
                            }
                            if ((node = d.getAttributes().getNamedItem("respawnRandom")) != null) {
                                respawnRandom = Integer.parseInt(node.getNodeValue());
                            }
                            node = d.getAttributes().getNamedItem("allowRandomWalk");
                            if (d.getAttributes().getNamedItem("allowRandomWalk") != null) {
                                allowRandomWalk = Boolean.valueOf(node.getNodeValue());
                            }
                            node = d.getAttributes().getNamedItem("areaName");
                            if (d.getAttributes().getNamedItem("areaName") != null) {
                                areaName = node.getNodeValue();
                            }
                            if ((node = d.getAttributes().getNamedItem("globalMapId")) != null) {
                                globalMapId = Integer.parseInt(node.getNodeValue());
                            }
                            L2Spawn spawnDat = new L2Spawn(npcId);
                            spawnDat.setX(x);
                            spawnDat.setY(y);
                            spawnDat.setZ(z);
                            spawnDat.setAmount(1);
                            spawnDat.setHeading(heading);
                            spawnDat.setRespawnDelay(respawn, respawnRandom);
                            if (respawn == 0) {
                                spawnDat.stopRespawn();
                            } else {
                                spawnDat.startRespawn();
                            }
                            spawnDat.setInstanceId(this.getId());
                            if (allowRandomWalk == null) {
                                spawnDat.setIsNoRndWalk(!this._allowRandomWalk);
                            } else {
                                spawnDat.setIsNoRndWalk(allowRandomWalk == false);
                            }
                            spawnDat.setAreaName(areaName);
                            spawnDat.setGlobalMapId(globalMapId);
                            if (spawnGroup.equals("general")) {
                                L2Npc spawned = spawnDat.doSpawn();
                                if (delay < 0 || !(spawned instanceof L2Attackable)) continue;
                                ((L2Attackable)spawned).setOnKillDelay(delay);
                                continue;
                            }
                            manualSpawn.add(spawnDat);
                        }
                        if (manualSpawn.isEmpty()) continue;
                        this._manualSpawn.put(spawnGroup, manualSpawn);
                    }
                    continue block28;
                }
                case "exitpoint": {
                    int x = Integer.parseInt(n.getAttributes().getNamedItem("x").getNodeValue());
                    int y = Integer.parseInt(n.getAttributes().getNamedItem("y").getNodeValue());
                    int z = Integer.parseInt(n.getAttributes().getNamedItem("z").getNodeValue());
                    this._exitLocation = new Location(x, y, z);
                    continue block28;
                }
                case "spawnpoints": {
                    this._enterLocations = new ArrayList<Location>();
                    for (Node loc = n.getFirstChild(); loc != null; loc = loc.getNextSibling()) {
                        if (!loc.getNodeName().equals("Location")) continue;
                        try {
                            int x = Integer.parseInt(loc.getAttributes().getNamedItem("x").getNodeValue());
                            int y = Integer.parseInt(loc.getAttributes().getNamedItem("y").getNodeValue());
                            int z = Integer.parseInt(loc.getAttributes().getNamedItem("z").getNodeValue());
                            this._enterLocations.add(new Location(x, y, z));
                            continue;
                        }
                        catch (Exception e) {
                            LOG.warn("Error parsing instance xml: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    continue block28;
                }
                case "reenter": {
                    a = n.getAttributes().getNamedItem("additionStyle");
                    if (a != null) {
                        this._type = InstanceReenterType.valueOf(a.getNodeValue());
                    }
                    for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        DayOfWeek day = null;
                        int hour = -1;
                        int minute = -1;
                        if (!"reset".equalsIgnoreCase(d.getNodeName())) continue;
                        a = d.getAttributes().getNamedItem("time");
                        if (a != null) {
                            long time = Long.parseLong(a.getNodeValue());
                            if (time <= 0L) continue;
                            this._resetData.add(new InstanceReenterTimeHolder(time));
                            continue block28;
                        }
                        a = d.getAttributes().getNamedItem("day");
                        if (a != null) {
                            day = DayOfWeek.valueOf(a.getNodeValue().toUpperCase());
                        }
                        if ((a = d.getAttributes().getNamedItem("hour")) != null) {
                            hour = Integer.parseInt(a.getNodeValue());
                        }
                        if ((a = d.getAttributes().getNamedItem("minute")) != null) {
                            minute = Integer.parseInt(a.getNodeValue());
                        }
                        this._resetData.add(new InstanceReenterTimeHolder(day, hour, minute));
                    }
                    continue block28;
                }
                case "removebuffs": {
                    a = n.getAttributes().getNamedItem("type");
                    if (a != null) {
                        this._removeBuffType = InstanceRemoveBuffType.valueOf(a.getNodeValue().toUpperCase());
                    }
                    for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!"skill".equalsIgnoreCase(d.getNodeName()) || (a = d.getAttributes().getNamedItem("id")) == null) continue;
                        this._exceptionList.add(Integer.parseInt(a.getNodeValue()));
                    }
                    continue block28;
                }
            }
        }
    }

    private void doCheckTimeUp(long remaining) {
        int interval;
        CreatureSay cs = null;
        if (this._players.isEmpty() && this._emptyDestroyTime == 0L) {
            remaining = 0L;
            interval = 500;
        } else if (this._players.isEmpty() && this._emptyDestroyTime > 0L) {
            long emptyTimeLeft = this._lastLeft + this._emptyDestroyTime - System.currentTimeMillis();
            if (emptyTimeLeft <= 0L) {
                interval = 0;
                remaining = 0L;
            } else if (remaining > 300000L && emptyTimeLeft > 300000L) {
                interval = 300000;
                remaining -= 300000L;
            } else if (remaining > 60000L && emptyTimeLeft > 60000L) {
                interval = 60000;
                remaining -= 60000L;
            } else if (remaining > 30000L && emptyTimeLeft > 30000L) {
                interval = 30000;
                remaining -= 30000L;
            } else {
                interval = 10000;
                remaining -= 10000L;
            }
        } else if (remaining > 300000L) {
            timeLeft = remaining / 60000L;
            interval = 300000;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Long.toString(timeLeft));
            Broadcast.toPlayersInInstance(sm, this.getId());
            remaining -= 300000L;
        } else if (remaining > 60000L) {
            timeLeft = remaining / 60000L;
            interval = 60000;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Long.toString(timeLeft));
            Broadcast.toPlayersInInstance(sm, this.getId());
            remaining -= 60000L;
        } else if (remaining > 30000L) {
            timeLeft = remaining / 1000L;
            interval = 30000;
            cs = new CreatureSay(0, 9, "Notice", timeLeft + " seconds left.");
            remaining -= 30000L;
        } else {
            timeLeft = remaining / 1000L;
            interval = 10000;
            cs = new CreatureSay(0, 9, "Notice", timeLeft + " seconds left.");
            remaining -= 10000L;
        }
        if (cs != null) {
            for (Integer objectId : this._players) {
                L2PcInstance player = L2World.getInstance().getPlayer(objectId);
                if (player == null || player.getInstanceId() != this.getId()) continue;
                player.sendPacket(cs);
            }
        }
        this.cancelTimer();
        this._checkTimeUpTask = remaining >= 10000L ? ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining), interval) : ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), interval);
    }

    public void cancelTimer() {
        if (this._checkTimeUpTask != null) {
            this._checkTimeUpTask.cancel(true);
        }
    }

    public void cancelEjectDeadPlayer(L2PcInstance player) {
        ScheduledFuture<?> task = this._ejectDeadTasks.remove(player.getObjectId());
        if (task != null) {
            task.cancel(true);
        }
    }

    public void addEjectDeadTask(L2PcInstance player) {
        if (player != null) {
            this._ejectDeadTasks.put(player.getObjectId(), ThreadPoolManager.getInstance().scheduleGeneral(() -> {
                if (player.isDead() && player.getInstanceId() == this.getId()) {
                    player.setInstanceId(0);
                    if (this.getExitLoc() != null) {
                        player.teleToLocation((ILocational)this.getExitLoc(), true);
                    } else {
                        player.teleToLocation(TeleportWhereType.TOWN);
                    }
                }
            }, this._ejectTime));
        }
    }

    public void notifyDeath(L2Character killer, L2Character victim) {
        InstanceWorld instance = InstanceManager.getInstance().getPlayerWorld(victim.getActingPlayer());
        if (instance != null) {
            instance.onDeath(killer, victim);
        }
    }

    public InstanceReenterType getReenterType() {
        return this._type;
    }

    public void setReenterType(InstanceReenterType type) {
        this._type = type;
    }

    public List<InstanceReenterTimeHolder> getReenterData() {
        return this._resetData;
    }

    public boolean isRemoveBuffEnabled() {
        return this.getRemoveBuffType() != InstanceRemoveBuffType.NONE;
    }

    public InstanceRemoveBuffType getRemoveBuffType() {
        return this._removeBuffType;
    }

    public List<Integer> getBuffExceptionList() {
        return this._exceptionList;
    }

    public class CheckTimeUp
    implements Runnable {
        private final long _remaining;

        public CheckTimeUp(long remaining) {
            this._remaining = remaining;
        }

        @Override
        public void run() {
            Instance.this.doCheckTimeUp(this._remaining);
        }
    }

    public class TimeUp
    implements Runnable {
        @Override
        public void run() {
            InstanceManager.getInstance().destroyInstance(Instance.this.getId());
        }
    }
}

