/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.PlayerEventHolder;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Event {
    private static final Logger LOG = LoggerFactory.getLogger(L2Event.class);
    public static EventState eventState = EventState.OFF;
    public static String _eventName = "";
    public static String _eventCreator = "";
    public static String _eventInfo = "";
    public static int _teamsNumber = 0;
    public static final Map<Integer, String> _teamNames = new ConcurrentHashMap<Integer, String>();
    public static final List<L2PcInstance> _registeredPlayers = new CopyOnWriteArrayList<L2PcInstance>();
    public static final Map<Integer, List<L2PcInstance>> _teams = new ConcurrentHashMap<Integer, List<L2PcInstance>>();
    public static int _npcId = 0;
    private static final Map<L2PcInstance, PlayerEventHolder> _connectionLossData = new ConcurrentHashMap<L2PcInstance, PlayerEventHolder>();

    public static int getPlayerTeamId(L2PcInstance player) {
        if (player == null) {
            return -1;
        }
        for (Map.Entry<Integer, List<L2PcInstance>> team : _teams.entrySet()) {
            if (!team.getValue().contains(player)) continue;
            return team.getKey();
        }
        return -1;
    }

    public static List<L2PcInstance> getTopNKillers(int n) {
        HashMap<L2PcInstance, Integer> tmp = new HashMap<L2PcInstance, Integer>();
        for (List<L2PcInstance> teamList : _teams.values()) {
            for (L2PcInstance player : teamList) {
                if (player.getEventStatus() == null) continue;
                tmp.put(player, player.getEventStatus().getKills().size());
            }
        }
        L2Event.sortByValue(tmp);
        if (tmp.size() <= n) {
            return new ArrayList<L2PcInstance>(tmp.keySet());
        }
        ArrayList toReturn = new ArrayList(tmp.keySet());
        return toReturn.subList(1, n);
    }

    public static void showEventHtml(L2PcInstance player, String objectid) {
        if (eventState == EventState.STANDBY) {
            try {
                NpcHtmlMessage html = new NpcHtmlMessage(Integer.parseInt(objectid));
                String htmContent = _registeredPlayers.contains(player) ? HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participating.htm") : HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participation.htm");
                if (htmContent != null) {
                    html.setHtml(htmContent);
                }
                html.replace("%objectId%", objectid);
                html.replace("%eventName%", _eventName);
                html.replace("%eventCreator%", _eventCreator);
                html.replace("%eventInfo%", _eventInfo);
                player.sendPacket(html);
            }
            catch (Exception e) {
                LOG.warn("Exception on showEventHtml(): {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void spawnEventNpc(L2PcInstance target) {
        try {
            L2Spawn spawn = new L2Spawn(_npcId);
            spawn.setX(target.getX() + 50);
            spawn.setY(target.getY() + 50);
            spawn.setZ(target.getZ());
            spawn.setAmount(1);
            spawn.setHeading(target.getHeading());
            spawn.stopRespawn();
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            spawn.init();
            spawn.getLastSpawn().setCurrentHp(9.99999999E8);
            spawn.getLastSpawn().setTitle(_eventName);
            spawn.getLastSpawn().setEventMob(true);
            spawn.getLastSpawn().broadcastPacket(new MagicSkillUse(spawn.getLastSpawn(), spawn.getLastSpawn(), 1034, 1, 1, 1));
        }
        catch (Exception e) {
            LOG.warn("Exception on spawn(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void unspawnEventNpcs() {
        SpawnTable.getInstance().forEachSpawn(spawn -> {
            L2Npc npc = spawn.getLastSpawn();
            if (npc != null && npc.isEventMob()) {
                npc.deleteMe();
                spawn.stopRespawn();
                SpawnTable.getInstance().deleteSpawn((L2Spawn)spawn, false);
            }
            return true;
        });
    }

    public static boolean isParticipant(L2PcInstance player) {
        if (player == null || player.getEventStatus() == null) {
            return false;
        }
        switch (eventState.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return _registeredPlayers.contains(player);
            }
            case 2: {
                for (List<L2PcInstance> teamList : _teams.values()) {
                    if (!teamList.contains(player)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static void registerPlayer(L2PcInstance player) {
        if (eventState != EventState.STANDBY) {
            player.sendMessage("The registration period for this event is over.");
            return;
        }
        if (Configuration.customs().getDualboxCheckMaxL2EventParticipantsPerIP() == 0 || AntiFeedManager.getInstance().tryAddPlayer(3, player, Configuration.customs().getDualboxCheckMaxL2EventParticipantsPerIP())) {
            _registeredPlayers.add(player);
        } else {
            player.sendMessage("You have reached the maximum allowed participants per IP.");
        }
    }

    public static void removeAndResetPlayer(L2PcInstance player) {
        try {
            if (L2Event.isParticipant(player)) {
                if (player.isDead()) {
                    player.restoreExp(100.0);
                    player.doRevive();
                    player.setCurrentHpMp(player.getMaxHp(), player.getMaxMp());
                    player.setCurrentCp(player.getMaxCp());
                }
                player.getPoly().setPolyInfo(null, "1");
                player.decayMe();
                player.spawnMe(player.getX(), player.getY(), player.getZ());
                CharInfo info1 = new CharInfo(player);
                player.broadcastPacket(info1);
                UserInfo info2 = new UserInfo(player);
                player.sendPacket(info2);
                player.broadcastPacket(new ExBrExtraUserInfo(player));
                player.stopTransformation(true);
            }
            if (player.getEventStatus() != null) {
                player.getEventStatus().restorePlayerStats();
            }
            player.setEventStatus(null);
            _registeredPlayers.remove(player);
            int teamId = L2Event.getPlayerTeamId(player);
            if (_teams.containsKey(teamId)) {
                _teams.get(teamId).remove(player);
            }
        }
        catch (Exception e) {
            LOG.warn("Error at unregisterAndResetPlayer in the event:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void savePlayerEventStatus(L2PcInstance player) {
        _connectionLossData.put(player, player.getEventStatus());
    }

    public static void restorePlayerEventStatus(L2PcInstance player) {
        if (_connectionLossData.containsKey(player)) {
            player.setEventStatus(_connectionLossData.get(player));
            _connectionLossData.remove(player);
        }
    }

    public static String startEventParticipation() {
        try {
            switch (eventState.ordinal()) {
                case 2: {
                    return "Cannot start event, it is already on.";
                }
                case 1: {
                    return "Cannot start event, it is on standby mode.";
                }
                case 0: {
                    eventState = EventState.STANDBY;
                }
            }
            AntiFeedManager.getInstance().registerEvent(3);
            AntiFeedManager.getInstance().clear(3);
            L2Event.unspawnEventNpcs();
            _registeredPlayers.clear();
            if (NpcData.getInstance().getTemplate(_npcId) == null) {
                return "Cannot start event, invalid npc id.";
            }
            try (FileReader fr = new FileReader(String.valueOf(Configuration.server().getDatapackRoot()) + "/data/events/" + _eventName);
                 BufferedReader br = new BufferedReader(fr);){
                _eventCreator = br.readLine();
                _eventInfo = br.readLine();
            }
            LinkedList<L2PcInstance> temp = new LinkedList<L2PcInstance>();
            for (L2PcInstance player : L2World.getInstance().getPlayers()) {
                if (!player.isOnline()) continue;
                if (!temp.contains(player)) {
                    L2Event.spawnEventNpc(player);
                    temp.add(player);
                }
                for (L2PcInstance playertemp : player.getKnownList().getKnownPlayers().values()) {
                    if (Math.abs(playertemp.getX() - player.getX()) >= 1000 || Math.abs(playertemp.getY() - player.getY()) >= 1000 || Math.abs(playertemp.getZ() - player.getZ()) >= 1000) continue;
                    temp.add(playertemp);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return "Cannot start event participation, an error has occurred.";
        }
        return "The event participation has been successfully started.";
    }

    public static String startEvent() {
        try {
            int i;
            switch (eventState.ordinal()) {
                case 2: {
                    return "Cannot start event, it is already on.";
                }
                case 1: {
                    eventState = EventState.ON;
                    break;
                }
                case 0: {
                    return "Cannot start event, it is off. Participation start is required.";
                }
            }
            L2Event.unspawnEventNpcs();
            _teams.clear();
            _connectionLossData.clear();
            for (i = 0; i < _teamsNumber; ++i) {
                _teams.put(i + 1, new CopyOnWriteArrayList());
            }
            i = 0;
            while (!_registeredPlayers.isEmpty()) {
                int max = 0;
                L2PcInstance biggestLvlPlayer = null;
                for (L2PcInstance player : _registeredPlayers) {
                    if (player == null || max >= player.getLevel()) continue;
                    max = player.getLevel();
                    biggestLvlPlayer = player;
                }
                if (biggestLvlPlayer == null) continue;
                _registeredPlayers.remove(biggestLvlPlayer);
                _teams.get(i + 1).add(biggestLvlPlayer);
                biggestLvlPlayer.setEventStatus();
                i = (i + 1) % _teamsNumber;
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return "Cannot start event, an error has occurred.";
        }
        return "The event has been successfully started.";
    }

    public static String finishEvent() {
        switch (eventState.ordinal()) {
            case 0: {
                return "Cannot finish event, it is already off.";
            }
            case 1: {
                for (L2PcInstance player : _registeredPlayers) {
                    L2Event.removeAndResetPlayer(player);
                }
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                eventState = EventState.OFF;
                return "The event has been stopped at STANDBY mode, all players unregistered and all event npcs unspawned.";
            }
            case 2: {
                for (List<L2PcInstance> teamList : _teams.values()) {
                    for (L2PcInstance player : teamList) {
                        L2Event.removeAndResetPlayer(player);
                    }
                }
                eventState = EventState.OFF;
                AntiFeedManager.getInstance().clear(2);
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                _npcId = 0;
                _eventCreator = "";
                _eventInfo = "";
                return "The event has been stopped, all players unregistered and all event npcs unspawned.";
            }
        }
        return "The event has been successfully finished.";
    }

    private static Map<L2PcInstance, Integer> sortByValue(Map<L2PcInstance, Integer> unsortMap) {
        LinkedList<Map.Entry<L2PcInstance, Integer>> list = new LinkedList<Map.Entry<L2PcInstance, Integer>>(unsortMap.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap<L2PcInstance, Integer> sortedMap = new LinkedHashMap<L2PcInstance, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((L2PcInstance)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public static enum EventState {
        OFF,
        STANDBY,
        ON;

    }
}

