/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.player.RecoBonusTask;
import com.l2jserver.gameserver.model.actor.tasks.player.RecoGiveTask;
import com.l2jserver.gameserver.model.entity.RecoBonus;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RecommendationSystem {
    private final L2PcInstance _player;
    private int _recoBonusTime;
    private int _recomHave;
    private int _recomLeft;
    private ScheduledFuture<?> _recoGiveTask;
    private boolean _recoTwoHoursGiven = false;
    private ScheduledFuture<?> _recoBonusTask;
    private boolean _recoBonusPeacePause = true;
    private final AtomicInteger _recoBonusOtherPause = new AtomicInteger(0);

    public RecommendationSystem(L2PcInstance player) {
        Objects.requireNonNull(player);
        this._player = player;
    }

    public void store() {
        DAOFactory.getInstance().getRecommendationBonusDAO().insert(this._player, this.getBonusTime());
    }

    public void startGiveTask() {
        if (this._recoGiveTask == null) {
            this._recoGiveTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RecoGiveTask(this._player), 0x6DDD00L, 3600000L);
        }
    }

    public void stopGiveTask() {
        if (this._recoGiveTask != null) {
            this._recoGiveTask.cancel(false);
            this._recoGiveTask = null;
        }
    }

    public void startBonusTask(boolean xpSpGain) {
        if (xpSpGain) {
            this._player.debugFeature("RecBonus", "Set peace pause flag to false.");
            this._recoBonusPeacePause = false;
        } else {
            int newCount = this._recoBonusOtherPause.updateAndGet(i -> i > 0 ? i - 1 : 0);
            this._player.debugFeature("RecBonus", "Decrement count of other pauses to {}", (Object)newCount);
        }
        if (this.getBonusTime() <= 0) {
            this._player.debugFeature("RecBonus", "Not scheduling task because bonus time is {}.", (Object)this.getBonusTime());
            this._player.sendPacket(new ExVoteSystemInfo(this._player));
            return;
        }
        if (this._recoBonusPeacePause) {
            this._player.debugFeature("RecBonus", "Not scheduling task because it was paused by peace.");
            return;
        }
        if (this._recoBonusOtherPause.get() > 0) {
            this._player.debugFeature("RecBonus", "Not scheduling task because it was paused by other mechanisms than peace.");
            return;
        }
        if (this.isBonusTaskActive()) {
            this._player.debugFeature("RecBonus", "Not scheduling task because it was already scheduled.");
            return;
        }
        this.scheduleBonusTask(this.getBonusTime());
        this._player.debugFeature("RecBonus", "Starting task.");
        this._player.sendPacket(new ExVoteSystemInfo(this._player));
    }

    public void stopBonusTask(boolean peaceZone) {
        if (peaceZone) {
            this._player.debugFeature("RecBonus", "Set peace pause flag to true.");
            this._recoBonusPeacePause = true;
        } else {
            int newCount = this._recoBonusOtherPause.incrementAndGet();
            this._player.debugFeature("RecBonus", "Increment count of other pauses to {}", (Object)newCount);
        }
        if (!this.isBonusTaskActive()) {
            this._player.debugFeature("RecBonus", "Not stopping task because it is not started.");
            this._player.sendPacket(new ExVoteSystemInfo(this._player));
            return;
        }
        int remainingTime = this.getBonusTime();
        this.cancelBonusTask();
        this.setBonusTime(remainingTime);
        this._player.debugFeature("RecBonus", "Stopping task.");
        this._player.sendPacket(new ExVoteSystemInfo(this._player));
    }

    public void finishBonusTask() {
        this.cancelBonusTask();
        this.setBonusTime(0);
        this._player.debugFeature("RecBonus", "Finishing task.");
        this._player.sendPacket(new ExVoteSystemInfo(this._player));
    }

    public void give(L2PcInstance target) {
        target.getRecSystem().incHave();
        this.decLeft();
    }

    protected void incHave() {
        if (this._recomHave < 255) {
            ++this._recomHave;
        }
    }

    protected void decLeft() {
        if (this._recomLeft > 0) {
            --this._recomLeft;
        }
    }

    public void setHave(int value) {
        this._recomHave = Math.min(Math.max(value, 0), 255);
    }

    public void setLeft(int value) {
        this._recomLeft = Math.min(Math.max(value, 0), 255);
    }

    public void setTwoHoursGiven(boolean val) {
        this._recoTwoHoursGiven = val;
    }

    public void setBonusTime(int time) {
        if (this.isBonusTaskActive()) {
            this.cancelBonusTask();
            this.scheduleBonusTask(time);
        }
        this._recoBonusTime = time;
    }

    public int getBonusTime() {
        if (this.isBonusTaskActive()) {
            return (int)Math.max(0L, this._recoBonusTask.getDelay(TimeUnit.SECONDS));
        }
        return this._recoBonusTime;
    }

    public int getBonus() {
        return this.getBonusTime() > 0 || this._player.hasAbnormalTypeVote() ? RecoBonus.getRecoBonus(this._player) : 0;
    }

    public int getHave() {
        return this._recomHave;
    }

    public int getLeft() {
        return this._recomLeft;
    }

    public boolean isBonusPaused() {
        return this.getBonusTime() > 0 && this._recoBonusPeacePause || this._recoBonusOtherPause.get() > 0;
    }

    public boolean isBonusTaskActive() {
        return this._recoBonusTask != null && !this._recoBonusTask.isCancelled() && !this._recoBonusTask.isDone();
    }

    public boolean isTwoHoursGiven() {
        return this._recoTwoHoursGiven;
    }

    private void scheduleBonusTask(int delay) {
        this._recoBonusTask = ThreadPoolManager.getInstance().scheduleGeneral(new RecoBonusTask(this._player), delay * 1000);
    }

    private void cancelBonusTask() {
        this._recoBonusTask.cancel(true);
        this._recoBonusTask = null;
    }
}

