/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.TvTEventListener;
import com.l2jserver.gameserver.model.entity.TvTEventTeam;
import com.l2jserver.gameserver.model.entity.TvTEventTeleporter;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventFinish;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventKill;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventRegistrationStart;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventStart;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TvTEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TvTEvent.class);
    private static final String HTML_PATH = "com/l2jserver/datapack/custom/events/TvT/TvTManager/";
    private static final TvTEventTeam[] _teams = new TvTEventTeam[2];
    private static EventState _state = EventState.INACTIVE;
    private static L2Spawn _npcSpawn = null;
    private static L2Npc _lastNpcSpawn = null;
    private static int _TvTEventInstance = 0;

    private TvTEvent() {
    }

    public static void init() {
        AntiFeedManager.getInstance().registerEvent(2);
        TvTEvent._teams[0] = new TvTEventTeam(Configuration.tvt().getTeam1Name(), Configuration.tvt().getTeam1Loc());
        TvTEvent._teams[1] = new TvTEventTeam(Configuration.tvt().getTeam2Name(), Configuration.tvt().getTeam2Loc());
    }

    public static boolean startParticipation() {
        try {
            _npcSpawn = new L2Spawn(Configuration.tvt().getParticipationNpcId());
            _npcSpawn.setLocation(Configuration.tvt().getParticipationNpcLoc());
            _npcSpawn.setAmount(1);
            _npcSpawn.setRespawnDelay(1);
            SpawnTable.getInstance().addNewSpawn(_npcSpawn, false);
            _npcSpawn.init();
            _lastNpcSpawn = _npcSpawn.getLastSpawn();
            _lastNpcSpawn.setCurrentHp(_lastNpcSpawn.getMaxHp());
            _lastNpcSpawn.setTitle("TvT Event Participation");
            _lastNpcSpawn.isAggressive();
            _lastNpcSpawn.decayMe();
            _lastNpcSpawn.spawnMe(_npcSpawn.getLastSpawn().getX(), _npcSpawn.getLastSpawn().getY(), _npcSpawn.getLastSpawn().getZ());
            _lastNpcSpawn.broadcastPacket(new MagicSkillUse(_lastNpcSpawn, _lastNpcSpawn, 1034, 1, 1, 1));
        }
        catch (Exception e) {
            LOG.warn("TvTEventEngine[TvTEvent.startParticipation()]: exception: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        TvTEvent.setState(EventState.PARTICIPATING);
        EventDispatcher.getInstance().notifyEventAsync(new TvTEventRegistrationStart(), new ListenersContainer[0]);
        return true;
    }

    private static int highestLevelPcInstanceOf(Map<Integer, L2PcInstance> players) {
        int maxLevel = Integer.MIN_VALUE;
        int maxLevelId = -1;
        for (L2PcInstance player : players.values()) {
            if (player.getLevel() < maxLevel) continue;
            maxLevel = player.getLevel();
            maxLevelId = player.getObjectId();
        }
        return maxLevelId;
    }

    public static boolean startFight() {
        L2PcInstance player;
        Iterator<Object> iter;
        TvTEvent.setState(EventState.STARTING);
        HashMap<Integer, L2PcInstance> allParticipants = new HashMap<Integer, L2PcInstance>();
        allParticipants.putAll(_teams[0].getParticipatedPlayers());
        allParticipants.putAll(_teams[1].getParticipatedPlayers());
        _teams[0].cleanMe();
        _teams[1].cleanMe();
        if (TvTEvent.needParticipationFee()) {
            iter = allParticipants.values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.hasParticipationFee(player)) continue;
                iter.remove();
            }
        }
        int[] balance = new int[]{0, 0};
        int priority = 0;
        while (!allParticipants.isEmpty()) {
            int highestLevelPlayerId = TvTEvent.highestLevelPcInstanceOf(allParticipants);
            L2PcInstance highestLevelPlayer = (L2PcInstance)allParticipants.get(highestLevelPlayerId);
            allParticipants.remove(highestLevelPlayerId);
            _teams[priority].addPlayer(highestLevelPlayer);
            int n = priority;
            balance[n] = balance[n] + highestLevelPlayer.getLevel();
            if (allParticipants.isEmpty()) break;
            priority = 1 - priority;
            highestLevelPlayerId = TvTEvent.highestLevelPcInstanceOf(allParticipants);
            highestLevelPlayer = (L2PcInstance)allParticipants.get(highestLevelPlayerId);
            allParticipants.remove(highestLevelPlayerId);
            _teams[priority].addPlayer(highestLevelPlayer);
            int n2 = priority;
            balance[n2] = balance[n2] + highestLevelPlayer.getLevel();
            priority = balance[0] > balance[1] ? 1 : 0;
        }
        if (_teams[0].getParticipatedPlayerCount() < Configuration.tvt().getMinPlayersInTeams() || _teams[1].getParticipatedPlayerCount() < Configuration.tvt().getMinPlayersInTeams()) {
            TvTEvent.setState(EventState.INACTIVE);
            _teams[0].cleanMe();
            _teams[1].cleanMe();
            TvTEvent.unSpawnNpc();
            AntiFeedManager.getInstance().clear(2);
            return false;
        }
        if (TvTEvent.needParticipationFee()) {
            iter = _teams[0].getParticipatedPlayers().values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.payParticipationFee(player)) continue;
                iter.remove();
            }
            iter = _teams[1].getParticipatedPlayers().values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.payParticipationFee(player)) continue;
                iter.remove();
            }
        }
        if (Configuration.tvt().instanced()) {
            try {
                _TvTEventInstance = InstanceManager.getInstance().createDynamicInstance(Configuration.tvt().getInstanceFile());
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setAllowSummon(false);
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setPvPInstance(true);
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setEmptyDestroyTime(Configuration.tvt().getStartLeaveTeleportDelay() + 60000L);
            }
            catch (Exception e) {
                _TvTEventInstance = 0;
                LOG.warn("TvTEventEngine[TvTEvent.createDynamicInstance]: exception: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        TvTEvent.openDoors(Configuration.tvt().getDoorsToOpen());
        TvTEvent.closeDoors(Configuration.tvt().getDoorsToClose());
        TvTEvent.setState(EventState.STARTED);
        for (TvTEventTeam team : _teams) {
            for (L2PcInstance playerInstance : team.getParticipatedPlayers().values()) {
                if (playerInstance == null) continue;
                playerInstance.setCanRevive(false);
                new TvTEventTeleporter(playerInstance, team.getLocation(), false, false);
            }
        }
        EventDispatcher.getInstance().notifyEventAsync(new TvTEventStart(), new ListenersContainer[0]);
        return true;
    }

    public static String calculateRewards() {
        if (_teams[0].getPoints() == _teams[1].getPoints()) {
            if (_teams[0].getParticipatedPlayerCount() == 0 || _teams[1].getParticipatedPlayerCount() == 0) {
                TvTEvent.setState(EventState.REWARDING);
                return "TvT Event: Event has ended. No team won due to inactivity!";
            }
            TvTEvent.sysMsgToAllParticipants("TvT Event: Event has ended, both teams have tied.");
            if (Configuration.tvt().rewardTeamTie()) {
                TvTEvent.rewardTeam(_teams[0]);
                TvTEvent.rewardTeam(_teams[1]);
                return "TvT Event: Event has ended with both teams tying.";
            }
            return "TvT Event: Event has ended with both teams tying.";
        }
        TvTEvent.setState(EventState.REWARDING);
        TvTEventTeam team = _teams[_teams[0].getPoints() > _teams[1].getPoints() ? 0 : 1];
        TvTEvent.rewardTeam(team);
        EventDispatcher.getInstance().notifyEventAsync(new TvTEventFinish(), new ListenersContainer[0]);
        return "TvT Event: Event finish. Team " + team.getName() + " won with " + team.getPoints() + " kills.";
    }

    private static void rewardTeam(TvTEventTeam team) {
        for (L2PcInstance player : team.getParticipatedPlayers().values()) {
            if (player == null) continue;
            for (ItemHolder item : Configuration.tvt().getReward()) {
                player.addItem("TvT Reward", item, null, true);
            }
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage();
            npcHtmlMessage.setHtml(HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "com/l2jserver/datapack/custom/events/TvT/TvTManager/Reward.html"));
            player.sendPacket(npcHtmlMessage);
        }
    }

    public static void stopFight() {
        TvTEvent.setState(EventState.INACTIVATING);
        TvTEvent.unSpawnNpc();
        TvTEvent.openDoors(Configuration.tvt().getDoorsToClose());
        TvTEvent.closeDoors(Configuration.tvt().getDoorsToOpen());
        for (TvTEventTeam team : _teams) {
            for (L2PcInstance player : team.getParticipatedPlayers().values()) {
                if (player == null) continue;
                player.setCanRevive(true);
                new TvTEventTeleporter(player, Configuration.tvt().getParticipationNpcLoc(), false, false);
            }
        }
        _teams[0].cleanMe();
        _teams[1].cleanMe();
        TvTEvent.setState(EventState.INACTIVE);
        AntiFeedManager.getInstance().clear(2);
    }

    public static synchronized boolean addParticipant(L2PcInstance playerInstance) {
        if (playerInstance == null) {
            return false;
        }
        byte teamId = _teams[0].getParticipatedPlayerCount() == _teams[1].getParticipatedPlayerCount() ? (byte)Rnd.get((int)2) : (byte)(_teams[0].getParticipatedPlayerCount() > _teams[1].getParticipatedPlayerCount() ? 1 : 0);
        playerInstance.addEventListener(new TvTEventListener(playerInstance));
        return _teams[teamId].addPlayer(playerInstance);
    }

    public static boolean removeParticipant(int playerObjectId) {
        byte teamId = TvTEvent.getParticipantTeamId(playerObjectId);
        if (teamId != -1) {
            _teams[teamId].removePlayer(playerObjectId);
            L2PcInstance player = L2World.getInstance().getPlayer(playerObjectId);
            if (player != null) {
                player.removeEventListener(TvTEventListener.class);
            }
            return true;
        }
        return false;
    }

    public static boolean needParticipationFee() {
        return Configuration.tvt().getParticipationFee() != null && Configuration.tvt().getParticipationFee().getId() > 0;
    }

    public static boolean hasParticipationFee(L2PcInstance player) {
        return player.getInventory().getInventoryItemCount(Configuration.tvt().getParticipationFee().getId(), -1) >= Configuration.tvt().getParticipationFee().getCount();
    }

    public static boolean payParticipationFee(L2PcInstance playerInstance) {
        return playerInstance.destroyItemByItemId("TvT Participation Fee", Configuration.tvt().getParticipationFee().getId(), Configuration.tvt().getParticipationFee().getCount(), _lastNpcSpawn, true);
    }

    public static String getParticipationFee() {
        int itemId = Configuration.tvt().getParticipationFee().getId();
        long itemNum = Configuration.tvt().getParticipationFee().getCount();
        if (itemId == 0 || itemNum == 0L) {
            return "-";
        }
        return StringUtil.concat(String.valueOf(itemNum), " ", ItemTable.getInstance().getTemplate(itemId).getName());
    }

    public static void sysMsgToAllParticipants(String message) {
        for (L2PcInstance playerInstance : _teams[0].getParticipatedPlayers().values()) {
            if (playerInstance == null) continue;
            playerInstance.sendMessage(message);
        }
        for (L2PcInstance playerInstance : _teams[1].getParticipatedPlayers().values()) {
            if (playerInstance == null) continue;
            playerInstance.sendMessage(message);
        }
    }

    private static L2DoorInstance getDoor(int doorId) {
        L2DoorInstance door = null;
        if (_TvTEventInstance <= 0) {
            door = DoorData.getInstance().getDoor(doorId);
        } else {
            Instance inst = InstanceManager.getInstance().getInstance(_TvTEventInstance);
            if (inst != null) {
                door = inst.getDoor(doorId);
            }
        }
        return door;
    }

    private static void closeDoors(List<Integer> doors) {
        for (int doorId : doors) {
            L2DoorInstance doorInstance = TvTEvent.getDoor(doorId);
            if (doorInstance == null) continue;
            doorInstance.closeMe();
        }
    }

    private static void openDoors(List<Integer> doors) {
        for (int doorId : doors) {
            L2DoorInstance doorInstance = TvTEvent.getDoor(doorId);
            if (doorInstance == null) continue;
            doorInstance.openMe();
        }
    }

    private static void unSpawnNpc() {
        _lastNpcSpawn.deleteMe();
        SpawnTable.getInstance().deleteSpawn(_lastNpcSpawn.getSpawn(), false);
        _npcSpawn.stopRespawn();
        _npcSpawn = null;
        _lastNpcSpawn = null;
    }

    public static void onLogin(L2PcInstance playerInstance) {
        if (playerInstance == null || !TvTEvent.isStarting() && !TvTEvent.isStarted()) {
            return;
        }
        byte teamId = TvTEvent.getParticipantTeamId(playerInstance.getObjectId());
        if (teamId == -1) {
            return;
        }
        _teams[teamId].addPlayer(playerInstance);
        new TvTEventTeleporter(playerInstance, _teams[teamId].getLocation(), true, false);
    }

    public static void onLogout(L2PcInstance playerInstance) {
        if (playerInstance != null && (TvTEvent.isStarting() || TvTEvent.isStarted() || TvTEvent.isParticipating()) && TvTEvent.removeParticipant(playerInstance.getObjectId())) {
            Location loc = Configuration.tvt().getParticipationNpcLoc();
            playerInstance.setXYZInvisible(loc.getX() + Rnd.get((int)101) - 50, loc.getY() + Rnd.get((int)101) - 50, loc.getZ());
        }
    }

    public static boolean onAction(L2PcInstance playerInstance, int targetedPlayerObjectId) {
        if (playerInstance == null || !TvTEvent.isStarted()) {
            return true;
        }
        if (playerInstance.isGM()) {
            return true;
        }
        byte playerTeamId = TvTEvent.getParticipantTeamId(playerInstance.getObjectId());
        byte targetedPlayerTeamId = TvTEvent.getParticipantTeamId(targetedPlayerObjectId);
        if (playerTeamId != -1 && targetedPlayerTeamId == -1 || playerTeamId == -1 && targetedPlayerTeamId != -1) {
            return false;
        }
        return targetedPlayerTeamId == -1 || playerTeamId != targetedPlayerTeamId || playerInstance.getObjectId() == targetedPlayerObjectId || Configuration.tvt().allowTargetTeamMember();
    }

    public static boolean onScrollUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Configuration.tvt().allowScroll();
    }

    public static boolean onPotionUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Configuration.tvt().allowPotion();
    }

    public static boolean onEscapeUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId);
    }

    public static boolean onItemSummon(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Configuration.tvt().allowTargetTeamMember();
    }

    public static void onKill(L2Character killerCharacter, L2PcInstance killedPlayerInstance) {
        byte killerTeamId;
        L2PcInstance killerPlayerInstance;
        if (killedPlayerInstance == null || !TvTEvent.isStarted()) {
            return;
        }
        byte killedTeamId = TvTEvent.getParticipantTeamId(killedPlayerInstance.getObjectId());
        if (killedTeamId == -1) {
            return;
        }
        new TvTEventTeleporter(killedPlayerInstance, _teams[killedTeamId].getLocation(), false, false);
        if (killerCharacter == null) {
            return;
        }
        if (killerCharacter instanceof L2PetInstance || killerCharacter instanceof L2ServitorInstance) {
            killerPlayerInstance = ((L2Summon)killerCharacter).getOwner();
            if (killerPlayerInstance == null) {
                return;
            }
        } else if (killerCharacter instanceof L2PcInstance) {
            killerPlayerInstance = (L2PcInstance)killerCharacter;
        } else {
            return;
        }
        if ((killerTeamId = TvTEvent.getParticipantTeamId(killerPlayerInstance.getObjectId())) != -1 && killerTeamId != killedTeamId) {
            TvTEventTeam killerTeam = _teams[killerTeamId];
            killerTeam.increasePoints();
            CreatureSay cs = new CreatureSay(killerPlayerInstance.getObjectId(), 2, killerPlayerInstance.getName(), "I have killed " + killedPlayerInstance.getName() + "!");
            for (L2PcInstance playerInstance : _teams[killerTeamId].getParticipatedPlayers().values()) {
                if (playerInstance == null) continue;
                playerInstance.sendPacket(cs);
            }
            EventDispatcher.getInstance().notifyEventAsync(new TvTEventKill(killerPlayerInstance, killedPlayerInstance, killerTeam), new ListenersContainer[0]);
        }
    }

    public static void onTeleported(L2PcInstance playerInstance) {
        if (!TvTEvent.isStarted() || playerInstance == null || !TvTEvent.isPlayerParticipant(playerInstance.getObjectId())) {
            return;
        }
        if (playerInstance.isMageClass()) {
            for (SkillHolder skillHolder : Configuration.tvt().getMageBuffs()) {
                Skill skill = skillHolder.getSkill();
                if (skill == null) continue;
                skill.applyEffects(playerInstance, playerInstance);
            }
        } else {
            for (SkillHolder skillHolder : Configuration.tvt().getFighterBuffs()) {
                Skill skill = skillHolder.getSkill();
                if (skill == null) continue;
                skill.applyEffects(playerInstance, playerInstance);
            }
        }
    }

    public static boolean checkForTvTSkill(L2PcInstance source, L2PcInstance target, Skill skill) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        int sourcePlayerId = source.getObjectId();
        int targetPlayerId = target.getObjectId();
        boolean isSourceParticipant = TvTEvent.isPlayerParticipant(sourcePlayerId);
        boolean isTargetParticipant = TvTEvent.isPlayerParticipant(targetPlayerId);
        if (!isSourceParticipant && !isTargetParticipant) {
            return true;
        }
        if (!isSourceParticipant || !isTargetParticipant) {
            return false;
        }
        if (TvTEvent.getParticipantTeamId(sourcePlayerId) != TvTEvent.getParticipantTeamId(targetPlayerId)) {
            return skill.isBad();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setState(EventState state) {
        EventState eventState = _state;
        synchronized (eventState) {
            _state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInactive() {
        boolean isInactive;
        EventState eventState = _state;
        synchronized (eventState) {
            isInactive = _state == EventState.INACTIVE;
        }
        return isInactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInactivating() {
        boolean isInactivating;
        EventState eventState = _state;
        synchronized (eventState) {
            isInactivating = _state == EventState.INACTIVATING;
        }
        return isInactivating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isParticipating() {
        boolean isParticipating;
        EventState eventState = _state;
        synchronized (eventState) {
            isParticipating = _state == EventState.PARTICIPATING;
        }
        return isParticipating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStarting() {
        boolean isStarting;
        EventState eventState = _state;
        synchronized (eventState) {
            isStarting = _state == EventState.STARTING;
        }
        return isStarting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStarted() {
        boolean isStarted;
        EventState eventState = _state;
        synchronized (eventState) {
            isStarted = _state == EventState.STARTED;
        }
        return isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRewarding() {
        boolean isRewarding;
        EventState eventState = _state;
        synchronized (eventState) {
            isRewarding = _state == EventState.REWARDING;
        }
        return isRewarding;
    }

    public static byte getParticipantTeamId(int playerObjectId) {
        return (byte)(_teams[0].containsPlayer(playerObjectId) ? 0 : (_teams[1].containsPlayer(playerObjectId) ? 1 : -1));
    }

    public static TvTEventTeam getParticipantTeam(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[0] : (_teams[1].containsPlayer(playerObjectId) ? _teams[1] : null);
    }

    public static TvTEventTeam getParticipantEnemyTeam(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[1] : (_teams[1].containsPlayer(playerObjectId) ? _teams[0] : null);
    }

    public static Location getParticipantTeamCoordinates(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[0].getLocation() : (_teams[1].containsPlayer(playerObjectId) ? _teams[1].getLocation() : null);
    }

    public static boolean isPlayerParticipant(int playerObjectId) {
        if (!(TvTEvent.isParticipating() || TvTEvent.isStarting() || TvTEvent.isStarted())) {
            return false;
        }
        return _teams[0].containsPlayer(playerObjectId) || _teams[1].containsPlayer(playerObjectId);
    }

    public static int getParticipatedPlayersCount() {
        if (!(TvTEvent.isParticipating() || TvTEvent.isStarting() || TvTEvent.isStarted())) {
            return 0;
        }
        return _teams[0].getParticipatedPlayerCount() + _teams[1].getParticipatedPlayerCount();
    }

    public static String[] getTeamNames() {
        return new String[]{_teams[0].getName(), _teams[1].getName()};
    }

    public static int[] getTeamsPlayerCounts() {
        return new int[]{_teams[0].getParticipatedPlayerCount(), _teams[1].getParticipatedPlayerCount()};
    }

    public static int[] getTeamsPoints() {
        return new int[]{_teams[0].getPoints(), _teams[1].getPoints()};
    }

    public static int getTvTEventInstance() {
        return _TvTEventInstance;
    }

    static enum EventState {
        INACTIVE,
        INACTIVATING,
        PARTICIPATING,
        STARTING,
        STARTED,
        REWARDING;

    }
}

