/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.DuelState;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.interfaces.ILocational;

public class TvTEventTeleporter
implements Runnable {
    private final L2PcInstance _playerInstance;
    private final Location _loc;
    private final boolean _adminRemove;

    public TvTEventTeleporter(L2PcInstance playerInstance, Location loc, boolean fastSchedule, boolean adminRemove) {
        this._playerInstance = playerInstance;
        this._loc = loc;
        this._adminRemove = adminRemove;
        long delay = TvTEvent.isStarted() ? Configuration.tvt().getRespawnTeleportDelay() : Configuration.tvt().getStartLeaveTeleportDelay();
        ThreadPoolManager.getInstance().scheduleGeneral(this, fastSchedule ? 0L : delay);
    }

    @Override
    public void run() {
        int TvTInstance;
        int effectRemoval;
        if (this._playerInstance == null) {
            return;
        }
        L2Summon summon = this._playerInstance.getSummon();
        if (summon != null) {
            summon.unSummon(this._playerInstance);
        }
        if ((effectRemoval = Configuration.tvt().getEffectsRemoval()) == 0 || effectRemoval == 1 && (this._playerInstance.getTeam() == Team.NONE || this._playerInstance.isInDuel() && this._playerInstance.getDuelState() != DuelState.INTERRUPTED)) {
            this._playerInstance.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if (this._playerInstance.isInDuel()) {
            this._playerInstance.setDuelState(DuelState.INTERRUPTED);
        }
        if ((TvTInstance = TvTEvent.getTvTEventInstance()) != 0) {
            if (TvTEvent.isStarted() && !this._adminRemove) {
                this._playerInstance.setInstanceId(TvTInstance);
            } else {
                this._playerInstance.setInstanceId(0);
            }
        } else {
            this._playerInstance.setInstanceId(0);
        }
        this._playerInstance.doRevive();
        this._playerInstance.teleToLocation((ILocational)this._loc, true);
        if (TvTEvent.isStarted() && !this._adminRemove) {
            int teamId = TvTEvent.getParticipantTeamId(this._playerInstance.getObjectId()) + 1;
            switch (teamId) {
                case 0: {
                    this._playerInstance.setTeam(Team.NONE);
                    break;
                }
                case 1: {
                    this._playerInstance.setTeam(Team.BLUE);
                    break;
                }
                case 2: {
                    this._playerInstance.setTeam(Team.RED);
                }
            }
        } else {
            this._playerInstance.setTeam(Team.NONE);
        }
        this._playerInstance.setCurrentCp(this._playerInstance.getMaxCp());
        this._playerInstance.setCurrentHp(this._playerInstance.getMaxHp());
        this._playerInstance.setCurrentMp(this._playerInstance.getMaxMp());
        this._playerInstance.broadcastStatusUpdate();
        this._playerInstance.broadcastUserInfo();
    }
}

