/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity.clanhall;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuctionableHall
extends ClanHall {
    private static final Logger LOG = LoggerFactory.getLogger(AuctionableHall.class);
    private long _paidUntil;
    private final int _grade;
    private boolean _paid;
    private final int _lease;
    private final int _chRate = 604800000;

    public AuctionableHall(StatsSet set) {
        super(set);
        this._paidUntil = set.getLong("paidUntil");
        this._grade = set.getInt("grade");
        this._paid = set.getBoolean("paid");
        this._lease = set.getInt("lease");
        if (this.getOwnerId() != 0) {
            this._isFree = false;
            this.initializeTask(false);
            this.loadFunctions();
        }
    }

    public boolean getPaid() {
        return this._paid;
    }

    @Override
    public int getLease() {
        return this._lease;
    }

    @Override
    public long getPaidUntil() {
        return this._paidUntil;
    }

    @Override
    public int getGrade() {
        return this._grade;
    }

    @Override
    public void free() {
        super.free();
        this._paidUntil = 0L;
        this._paid = false;
    }

    @Override
    public void setOwner(L2Clan clan) {
        super.setOwner(clan);
        this._paidUntil = System.currentTimeMillis();
        this.initializeTask(true);
    }

    private void initializeTask(boolean forced) {
        long currentTime = System.currentTimeMillis();
        if (this._paidUntil > currentTime) {
            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), this._paidUntil - currentTime);
        } else if (!this._paid && !forced) {
            if (System.currentTimeMillis() + 86400000L <= this._paidUntil + 604800000L) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), System.currentTimeMillis() + 86400000L);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), this._paidUntil + 604800000L - System.currentTimeMillis());
            }
        } else {
            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), 0L);
        }
    }

    @Override
    public void updateDb() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clanhall SET ownerId=?, paidUntil=?, paid=? WHERE id=?");){
            ps.setInt(1, this.getOwnerId());
            ps.setLong(2, this.getPaidUntil());
            ps.setInt(3, this.getPaid() ? 1 : 0);
            ps.setInt(4, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception: updateOwnerInDB(L2Clan clan): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected class FeeTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(FeeTask.class);

        protected FeeTask() {
        }

        @Override
        public void run() {
            try {
                long _time = System.currentTimeMillis();
                if (AuctionableHall.this.isFree()) {
                    return;
                }
                if (AuctionableHall.this._paidUntil > _time) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), AuctionableHall.this._paidUntil - _time);
                    return;
                }
                L2Clan Clan = ClanTable.getInstance().getClan(AuctionableHall.this.getOwnerId());
                if (ClanTable.getInstance().getClan(AuctionableHall.this.getOwnerId()).getWarehouse().getAdena() >= (long)AuctionableHall.this.getLease()) {
                    if (AuctionableHall.this._paidUntil != 0L) {
                        while (AuctionableHall.this._paidUntil <= _time) {
                            AuctionableHall.this._paidUntil += 604800000L;
                        }
                    } else {
                        AuctionableHall.this._paidUntil = _time + 604800000L;
                    }
                    ClanTable.getInstance().getClan(AuctionableHall.this.getOwnerId()).getWarehouse().destroyItemByItemId("CH_rental_fee", 57, AuctionableHall.this.getLease(), null, null);
                    ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), AuctionableHall.this._paidUntil - _time);
                    AuctionableHall.this._paid = true;
                    AuctionableHall.this.updateDb();
                } else {
                    AuctionableHall.this._paid = false;
                    if (_time > AuctionableHall.this._paidUntil + 604800000L) {
                        if (ClanHallManager.getInstance().loaded()) {
                            AuctionManager.getInstance().initNPC(AuctionableHall.this.getId());
                            ClanHallManager.getInstance().setFree(AuctionableHall.this.getId());
                            Clan.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.THE_CLAN_HALL_FEE_IS_ONE_WEEK_OVERDUE_THEREFORE_THE_CLAN_HALL_OWNERSHIP_HAS_BEEN_REVOKED));
                        } else {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), 3000L);
                        }
                    } else {
                        AuctionableHall.this.updateDb();
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW);
                        sm.addInt(AuctionableHall.this.getLease());
                        Clan.broadcastToOnlineMembers(sm);
                        if (_time + 86400000L <= AuctionableHall.this._paidUntil + 604800000L) {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), _time + 86400000L);
                        } else {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), AuctionableHall.this._paidUntil + 604800000L - _time);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }
}

