/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.audio.IAudio;
import com.l2jserver.gameserver.enums.audio.Sound;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenerRegisterType;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.annotations.Id;
import com.l2jserver.gameserver.model.events.annotations.Ids;
import com.l2jserver.gameserver.model.events.annotations.NpcLevelRange;
import com.l2jserver.gameserver.model.events.annotations.NpcLevelRanges;
import com.l2jserver.gameserver.model.events.annotations.Priority;
import com.l2jserver.gameserver.model.events.annotations.Range;
import com.l2jserver.gameserver.model.events.annotations.Ranges;
import com.l2jserver.gameserver.model.events.annotations.RegisterEvent;
import com.l2jserver.gameserver.model.events.annotations.RegisterType;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.CreatureKill;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcCanBeSeen;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcFirstTalk;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLogout;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionCancel;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionChange;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonSpawn;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonTalk;
import com.l2jserver.gameserver.model.events.impl.item.ItemTalk;
import com.l2jserver.gameserver.model.events.impl.olympiad.OlympiadMatchResult;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeOwnerChange;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeStart;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.listeners.AnnotationEventListener;
import com.l2jserver.gameserver.model.events.listeners.ConsumerEventListener;
import com.l2jserver.gameserver.model.events.listeners.DummyEventListener;
import com.l2jserver.gameserver.model.events.listeners.FunctionEventListener;
import com.l2jserver.gameserver.model.events.listeners.RunnableEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.QuestItemChanceHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.quest.QuestDroplist;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.gameserver.util.MinionList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScript
implements INamable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractScript.class);
    private final Map<ListenerRegisterType, Set<Integer>> _registeredIds = new ConcurrentHashMap<ListenerRegisterType, Set<Integer>>();
    private final List<AbstractEventListener> _listeners = new CopyOnWriteArrayList<AbstractEventListener>();
    private boolean _isActive;

    public AbstractScript() {
        this.initializeAnnotationListeners();
    }

    private void initializeAnnotationListeners() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Method method : this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(RegisterEvent.class) || !method.isAnnotationPresent(RegisterType.class)) continue;
            RegisterEvent listener = method.getAnnotation(RegisterEvent.class);
            RegisterType regType = method.getAnnotation(RegisterType.class);
            ListenerRegisterType type = regType.value();
            EventType eventType = listener.value();
            if (method.getParameterCount() != 1) {
                LOG.warn("Non properly defined annotation listener on method {} expected parameter count is 1 but found {}!", (Object)method.getName(), (Object)method.getParameterCount());
                continue;
            }
            if (!eventType.isEventClass(method.getParameterTypes()[0])) {
                LOG.warn("Non properly defined annotation listener on method {} expected parameter to be type of {} but found {}!", method.getName(), eventType.getEventClass().getSimpleName(), method.getParameterTypes()[0].getSimpleName());
                continue;
            }
            if (!eventType.isReturnClass(method.getReturnType())) {
                LOG.warn("Non properly defined annotation listener on method {} expected return type to be one of {} but found {}", method.getName(), Arrays.toString(eventType.getReturnClasses()), method.getReturnType().getSimpleName());
                continue;
            }
            int priority = 0;
            ids.clear();
            for (Annotation annotation : method.getAnnotations()) {
                if (annotation instanceof Id) {
                    Id npc = (Id)annotation;
                    for (int id : npc.value()) {
                        ids.add(id);
                    }
                    continue;
                }
                if (annotation instanceof Ids) {
                    Ids npcs = (Ids)annotation;
                    for (Id npc : npcs.value()) {
                        for (int id : npc.value()) {
                            ids.add(id);
                        }
                    }
                    continue;
                }
                if (annotation instanceof Range) {
                    Range range = (Range)annotation;
                    if (range.from() > range.to()) {
                        LOG.warn("Wrong {} from is higher then to!", (Object)annotation.getClass().getSimpleName());
                        continue;
                    }
                    for (int id = range.from(); id <= range.to(); ++id) {
                        ids.add(id);
                    }
                    continue;
                }
                if (annotation instanceof Ranges) {
                    Ranges ranges = (Ranges)annotation;
                    for (Range range : ranges.value()) {
                        if (range.from() > range.to()) {
                            LOG.warn("Wrong {} from is higher then to!", (Object)annotation.getClass().getSimpleName());
                            continue;
                        }
                        for (int id = range.from(); id <= range.to(); ++id) {
                            ids.add(id);
                        }
                    }
                    continue;
                }
                if (annotation instanceof NpcLevelRange) {
                    NpcLevelRange range = (NpcLevelRange)annotation;
                    if (range.from() > range.to()) {
                        LOG.warn("Wrong {} from is higher then to!", (Object)annotation.getClass().getSimpleName());
                        continue;
                    }
                    if (type != ListenerRegisterType.NPC) {
                        LOG.warn("ListenerRegisterType {} for {} NPC is expected!", (Object)type, (Object)annotation.getClass().getSimpleName());
                        continue;
                    }
                    int level = range.from();
                    while (level <= range.to()) {
                        List<L2NpcTemplate> templates = NpcData.getInstance().getAllOfLevel(level++);
                        templates.forEach(template -> ids.add(template.getId()));
                    }
                    continue;
                }
                if (annotation instanceof NpcLevelRanges) {
                    NpcLevelRanges ranges = (NpcLevelRanges)annotation;
                    for (NpcLevelRange range : ranges.value()) {
                        if (range.from() > range.to()) {
                            LOG.warn("Wrong {} from is higher then to!", (Object)annotation.getClass().getSimpleName());
                            continue;
                        }
                        if (type != ListenerRegisterType.NPC) {
                            LOG.warn("ListenerRegisterType {} for {} NPC is expected!", (Object)type, (Object)annotation.getClass().getSimpleName());
                            continue;
                        }
                        int level = range.from();
                        while (level <= range.to()) {
                            List<L2NpcTemplate> templates = NpcData.getInstance().getAllOfLevel(level++);
                            templates.forEach(template -> ids.add(template.getId()));
                        }
                    }
                    continue;
                }
                if (!(annotation instanceof Priority)) continue;
                Priority p = (Priority)annotation;
                priority = p.value();
            }
            if (!ids.isEmpty()) {
                this._registeredIds.putIfAbsent(type, ConcurrentHashMap.newKeySet(ids.size()));
                this._registeredIds.get((Object)type).addAll(ids);
            }
            this.registerAnnotation(method, eventType, type, priority, ids);
        }
    }

    public void setActive(boolean status) {
        this._isActive = status;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public abstract boolean reload();

    public boolean unload() {
        this._listeners.forEach(AbstractEventListener::unregisterMe);
        this._listeners.clear();
        return true;
    }

    public abstract ScriptManager<?> getManager();

    protected final List<AbstractEventListener> addCreatureKillId(Function<CreatureKill, ? extends AbstractEventReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureKillId(Consumer<CreatureKill> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureKillId(Consumer<CreatureKill> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcFirstTalkId(Consumer<NpcFirstTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.NPC_FIRST_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcFirstTalkId(Consumer<NpcFirstTalk> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.NPC_FIRST_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTalkId(Collection<Integer> npcIds) {
        return this.registerDummy(EventType.NPC_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTalkId(int ... npcIds) {
        return this.registerDummy(EventType.NPC_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcQuestStartId(int ... npcIds) {
        return this.registerDummy(EventType.NPC_QUEST_START, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcQuestStartId(Collection<Integer> npcIds) {
        return this.registerDummy(EventType.NPC_QUEST_START, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcEventReceivedId(Consumer<NpcEventReceived> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.NPC_EVENT_RECEIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcEventReceivedId(Consumer<NpcEventReceived> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.NPC_EVENT_RECEIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcHateId(Consumer<AttackableHate> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcHateId(Consumer<AttackableHate> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> addNpcHateId(Function<AttackableHate, TerminateReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> addNpcHateId(Function<AttackableHate, TerminateReturn> callback, Collection<Integer> npcIds) {
        return this.registerFunction(callback, EventType.NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Consumer<NpcCanBeSeen> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Consumer<NpcCanBeSeen> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Function<NpcCanBeSeen, TerminateReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Function<NpcCanBeSeen, TerminateReturn> callback, Collection<Integer> npcIds) {
        return this.registerFunction(callback, EventType.NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonSpawnId(Consumer<PlayerSummonSpawn> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.PLAYER_SUMMON_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonSpawnId(Consumer<PlayerSummonSpawn> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.PLAYER_SUMMON_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonTalkId(Consumer<PlayerSummonTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.PLAYER_SUMMON_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonTalkId(Consumer<PlayerSummonSpawn> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.PLAYER_SUMMON_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerLogoutId(Consumer<PlayerLogout> callback) {
        return this.registerConsumer(callback, EventType.PLAYER_LOGOUT, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> setItemTalkId(Consumer<ItemTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ITEM_TALK, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setItemTalkId(Consumer<ItemTalk> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ITEM_TALK, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setOlympiadMatchResult(Consumer<OlympiadMatchResult> callback) {
        return this.registerConsumer(callback, EventType.OLYMPIAD_MATCH_RESULT, ListenerRegisterType.OLYMPIAD, new int[0]);
    }

    protected final List<AbstractEventListener> setCastleSiegeStartId(Consumer<CastleSiegeStart> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_START, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeStartId(Consumer<CastleSiegeStart> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_START, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeOwnerChangeId(Consumer<CastleSiegeOwnerChange> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_OWNER_CHANGE, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeOwnerChangeId(Consumer<CastleSiegeOwnerChange> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_OWNER_CHANGE, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeFinishId(Consumer<CastleSiegeFinish> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_FINISH, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeFinishId(Consumer<CastleSiegeFinish> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.CASTLE_SIEGE_FINISH, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setPlayerProfessionChangeId(Consumer<PlayerProfessionChange> callback) {
        return this.registerConsumer(callback, EventType.PLAYER_PROFESSION_CHANGE, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> setPlayerProfessionCancelId(Consumer<PlayerProfessionCancel> callback) {
        return this.registerConsumer(callback, EventType.PLAYER_PROFESSION_CANCEL, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> registerConsumer(Consumer<? extends BaseEvent> callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new ConsumerEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerConsumer(Consumer<? extends BaseEvent> callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new ConsumerEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerFunction(Function<? extends BaseEvent, ? extends AbstractEventReturn> callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new FunctionEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerFunction(Function<? extends BaseEvent, ? extends AbstractEventReturn> callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new FunctionEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerRunnable(Runnable callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new RunnableEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerRunnable(Runnable callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new RunnableEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerAnnotation(Method callback, EventType type, ListenerRegisterType registerType, int priority, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new AnnotationEventListener((ListenersContainer)container, type, callback, this, priority), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerAnnotation(Method callback, EventType type, ListenerRegisterType registerType, int priority, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new AnnotationEventListener((ListenersContainer)container, type, callback, this, priority), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerDummy(EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new DummyEventListener((ListenersContainer)container, type, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerDummy(EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new DummyEventListener((ListenersContainer)container, type, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerListener(Function<ListenersContainer, AbstractEventListener> action, ListenerRegisterType registerType, int ... ids) {
        ArrayList<AbstractEventListener> listeners = new ArrayList<AbstractEventListener>(ids.length > 0 ? ids.length : 1);
        if (ids.length > 0) {
            for (int id : ids) {
                switch (registerType) {
                    case NPC: {
                        ListenersContainer template = NpcData.getInstance().getTemplate(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ZONE: {
                        ListenersContainer template = ZoneManager.getInstance().getZoneById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ITEM: {
                        ListenersContainer template = ItemTable.getInstance().getTemplate(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case CASTLE: {
                        ListenersContainer template = CastleManager.getInstance().getCastleById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case FORTRESS: {
                        ListenersContainer template = FortManager.getInstance().getFortById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    default: {
                        LOG.warn("Unhandled register type {}", (Object)registerType);
                    }
                }
                this._registeredIds.putIfAbsent(registerType, ConcurrentHashMap.newKeySet(1));
                this._registeredIds.get((Object)registerType).add(id);
            }
        } else {
            switch (registerType) {
                case OLYMPIAD: {
                    Olympiad template = Olympiad.getInstance();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL: {
                    ListenersContainer template = Containers.Global();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_NPCS: {
                    ListenersContainer template = Containers.Npcs();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_MONSTERS: {
                    ListenersContainer template = Containers.Monsters();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_PLAYERS: {
                    ListenersContainer template = Containers.Players();
                    listeners.add(template.addListener(action.apply(template)));
                }
            }
        }
        this._listeners.addAll(listeners);
        return listeners;
    }

    protected final List<AbstractEventListener> registerListener(Function<ListenersContainer, AbstractEventListener> action, ListenerRegisterType registerType, Collection<Integer> ids) {
        ArrayList<AbstractEventListener> listeners = new ArrayList<AbstractEventListener>(!ids.isEmpty() ? ids.size() : 1);
        if (!ids.isEmpty()) {
            block14: for (int id : ids) {
                switch (registerType) {
                    case NPC: {
                        ListenersContainer template = NpcData.getInstance().getTemplate(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ZONE: {
                        ListenersContainer template = ZoneManager.getInstance().getZoneById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ITEM: {
                        ListenersContainer template = ItemTable.getInstance().getTemplate(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case CASTLE: {
                        ListenersContainer template = CastleManager.getInstance().getCastleById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case FORTRESS: {
                        ListenersContainer template = FortManager.getInstance().getFortById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    default: {
                        LOG.warn("Unhandled register type {}", (Object)registerType);
                    }
                }
            }
            this._registeredIds.putIfAbsent(registerType, ConcurrentHashMap.newKeySet(ids.size()));
            this._registeredIds.get((Object)registerType).addAll(ids);
        } else {
            switch (registerType) {
                case OLYMPIAD: {
                    Olympiad template = Olympiad.getInstance();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL: {
                    ListenersContainer template = Containers.Global();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_NPCS: {
                    ListenersContainer template = Containers.Npcs();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_MONSTERS: {
                    ListenersContainer template = Containers.Monsters();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_PLAYERS: {
                    ListenersContainer template = Containers.Players();
                    listeners.add(template.addListener(action.apply(template)));
                }
            }
        }
        this._listeners.addAll(listeners);
        return listeners;
    }

    public Set<Integer> getRegisteredIds(ListenerRegisterType type) {
        return this._registeredIds.getOrDefault((Object)type, Collections.emptySet());
    }

    public List<AbstractEventListener> getListeners() {
        return this._listeners;
    }

    public static void showOnScreenMsg(L2PcInstance player, String text, int time) {
        player.sendPacket(new ExShowScreenMessage(text, time));
    }

    public static void showOnScreenMsg(L2PcInstance player, NpcStringId npcString, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(npcString, position, time, params));
    }

    public static void showOnScreenMsg(L2PcInstance player, SystemMessageId systemMsg, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(systemMsg, position, time, params));
    }

    public static void showOnScreenMsgFStr(L2PcInstance player, int msgPosType, int unk1, int fontSize, int unk2, int unk3, boolean showEffect, int time, boolean fade, NpcStringId npcStringId, String ... params) {
        player.sendPacket(new ExShowScreenMessage(2, -1, msgPosType, unk1, fontSize, unk2, unk3, showEffect, time, fade, null, npcStringId, params));
    }

    public static L2Npc addSpawn(int npcId, IPositionable pos) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, false, 0);
    }

    public static L2Npc addSpawn(L2Npc summoner, int npcId, IPositionable pos, boolean randomOffset, long despawnDelay) {
        return AbstractScript.addSpawn(summoner, npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, IPositionable pos, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, IPositionable pos, boolean randomOffset, long despawnDelay) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, IPositionable pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, IPositionable pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, instanceId);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay) {
        return AbstractScript.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        return AbstractScript.addSpawn(null, npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn, instanceId);
    }

    public static L2Npc addSpawn(L2Npc summoner, int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        try {
            if (x == 0 && y == 0) {
                LOG.error("addSpawn(): invalid spawn coordinates for NPC #{}!", (Object)npcId);
                return null;
            }
            if (randomOffset) {
                int offset = Rnd.get((int)50, (int)100);
                if (Rnd.nextBoolean()) {
                    offset *= -1;
                }
                x += offset;
                offset = Rnd.get((int)50, (int)100);
                if (Rnd.nextBoolean()) {
                    offset *= -1;
                }
                y += offset;
            }
            L2Spawn spawn = new L2Spawn(npcId);
            spawn.setInstanceId(instanceId);
            spawn.setHeading(heading);
            spawn.setX(x);
            spawn.setY(y);
            spawn.setZ(z);
            spawn.stopRespawn();
            L2Npc npc = spawn.spawnOne(isSummonSpawn);
            if (despawnDelay > 0L) {
                npc.scheduleDespawn(despawnDelay);
            }
            if (summoner != null) {
                summoner.addSummonedNpc(npc);
            }
            return npc;
        }
        catch (Exception ex) {
            LOG.warn("Could not spawn NPC #{}", (Object)npcId, (Object)ex);
            return null;
        }
    }

    public L2TrapInstance addTrap(int trapId, int x, int y, int z, int heading, Skill skill, int instanceId) {
        L2NpcTemplate template = NpcData.getInstance().getTemplate(trapId);
        int objectId = IdFactory.getInstance().getNextId();
        L2TrapInstance trap = new L2TrapInstance(objectId, template, instanceId, -1);
        trap.setCurrentHp(trap.getMaxHp());
        trap.setCurrentMp(trap.getMaxMp());
        trap.setIsMortal(false);
        trap.setHeading(heading);
        trap.spawnMe(x, y, z);
        return trap;
    }

    public L2Npc addMinion(L2MonsterInstance master, int minionId) {
        return MinionList.spawnMinion(master, minionId);
    }

    public static long getQuestItemsCount(L2PcInstance player, int itemId) {
        return player.getInventory().getInventoryItemCount(itemId, -1);
    }

    public long getQuestItemsCount(L2PcInstance player, int ... itemIds) {
        long count = 0L;
        block2: for (L2ItemInstance item : player.getInventory().getItems()) {
            if (item == null) continue;
            for (int itemId : itemIds) {
                if (item.getId() != itemId) continue;
                try {
                    count = Math.addExact(count, item.getCount());
                }
                catch (ArithmeticException ae) {
                    count = Long.MAX_VALUE;
                    continue block2;
                }
            }
        }
        return count;
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item) {
        return AbstractScript.hasItem(player, item, true);
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item, boolean checkCount) {
        if (item == null) {
            return false;
        }
        if (checkCount) {
            return AbstractScript.getQuestItemsCount(player, item.getId()) >= item.getCount();
        }
        return AbstractScript.hasQuestItems(player, item.getId());
    }

    protected static boolean hasItemsAtLimit(L2PcInstance player, QuestItemChanceHolder ... items) {
        if (items == null) {
            return false;
        }
        return Arrays.stream(items).allMatch(item -> AbstractScript.getQuestItemsCount(player, item.getId()) >= item.getLimit());
    }

    protected static boolean hasAllItems(L2PcInstance player, boolean checkCount, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (AbstractScript.hasItem(player, item, checkCount)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasQuestItems(L2PcInstance player, int itemId) {
        return player.getInventory().getItemByItemId(itemId) != null;
    }

    public static boolean hasQuestItems(L2PcInstance player, int ... itemIds) {
        if (itemIds == null || itemIds.length == 0) {
            return false;
        }
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasAtLeastOneQuestItem(L2PcInstance player, int ... itemIds) {
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) == null) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantLevel(L2PcInstance player, int itemId) {
        L2ItemInstance enchantedItem = player.getInventory().getItemByItemId(itemId);
        if (enchantedItem == null) {
            return 0;
        }
        return enchantedItem.getEnchantLevel();
    }

    public static void giveAdena(L2PcInstance player, long count, boolean applyRates) {
        if (applyRates) {
            AbstractScript.rewardItems(player, 57, count);
        } else {
            AbstractScript.giveItems(player, 57, count);
        }
    }

    public static void rewardItems(L2PcInstance player, ItemHolder holder) {
        AbstractScript.rewardItems(player, holder.getId(), holder.getCount());
    }

    public static void rewardItems(L2PcInstance player, int itemId, long count) {
        if (count <= 0L) {
            return;
        }
        L2Item item = ItemTable.getInstance().getTemplate(itemId);
        if (item == null) {
            return;
        }
        try {
            if (itemId == 57) {
                count = (long)((float)count * Configuration.rates().getRateQuestRewardAdena());
            } else if (Configuration.rates().useQuestRewardMultipliers()) {
                if (item instanceof L2EtcItem) {
                    L2EtcItem etc = (L2EtcItem)item;
                    switch (etc.getItemType()) {
                        case POTION: {
                            count = (long)((float)count * Configuration.rates().getRateQuestRewardPotion());
                            break;
                        }
                        case SCRL_ENCHANT_WP: 
                        case SCRL_ENCHANT_AM: 
                        case SCROLL: {
                            count = (long)((float)count * Configuration.rates().getRateQuestRewardScroll());
                            break;
                        }
                        case RECIPE: {
                            count = (long)((float)count * Configuration.rates().getRateQuestRewardRecipe());
                            break;
                        }
                        case MATERIAL: {
                            count = (long)((float)count * Configuration.rates().getRateQuestRewardMaterial());
                            break;
                        }
                        default: {
                            count = (long)((float)count * Configuration.rates().getRateQuestReward());
                        }
                    }
                }
            } else {
                count = (long)((float)count * Configuration.rates().getRateQuestReward());
            }
        }
        catch (Exception e) {
            count = Long.MAX_VALUE;
        }
        L2ItemInstance itemInstance = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (itemInstance == null) {
            return;
        }
        AbstractScript.sendItemGetMessage(player, itemInstance, count);
    }

    private static void sendItemGetMessage(L2PcInstance player, L2ItemInstance item, long count) {
        if (item.getId() == 57) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            smsg.addLong(count);
            player.sendPacket(smsg);
        } else if (count > 1L) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addLong(count);
            player.sendPacket(smsg);
        } else {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
            smsg.addItemName(item);
            player.sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count) {
        AbstractScript.giveItems(player, itemId, count, 0);
    }

    protected static void giveItems(L2PcInstance player, ItemHolder holder) {
        AbstractScript.giveItems(player, holder.getId(), holder.getCount());
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, int enchantlevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (enchantlevel > 0 && itemId != 57) {
            item.setEnchantLevel(enchantlevel);
        }
        AbstractScript.sendItemGetMessage(player, item, count);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, byte attributeId, int attributeLevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (attributeId >= 0 && attributeLevel > 0) {
            item.setElementAttr(attributeId, attributeLevel);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(player);
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            player.sendPacket(iu);
        }
        AbstractScript.sendItemGetMessage(player, item, count);
    }

    @Deprecated
    public static boolean giveItemRandomly(L2PcInstance player, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, null, player, QuestDroplist.singleDropItem(itemId, amountToGive, amountToGive, dropChance * 100.0), limit, playSound);
    }

    @Deprecated
    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, player, QuestDroplist.singleDropItem(itemId, amountToGive, amountToGive, dropChance * 100.0), limit, playSound);
    }

    @Deprecated
    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long minAmount, long maxAmount, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, player, QuestDroplist.singleDropItem(itemId, minAmount, maxAmount, dropChance * 100.0), limit, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, player, QuestDroplist.singleDropItem(itemId, 1L, 1L, 100.0), 0L, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, QuestItemChanceHolder questItem, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, player, QuestDroplist.singleDropItem(questItem), questItem.getLimit(), playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, QuestDroplist.QuestDropInfo dropInfo, boolean playSound) {
        if (dropInfo == null) {
            return false;
        }
        return AbstractScript.giveItemRandomly(player, npc, player, dropInfo.drop(), dropInfo.getLimit(), playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, IDropItem dropItem, long limit, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, player, dropItem, limit, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, L2PcInstance killer, IDropItem dropItem, long limit, boolean playSound) {
        if (dropItem == null) {
            return false;
        }
        List<ItemHolder> drops = dropItem.calculateDrops(npc, killer);
        if (drops == null || drops.isEmpty()) {
            return false;
        }
        ItemHolder drop = drops.get(0);
        long currentCount = AbstractScript.getQuestItemsCount(player, drop.getId());
        if (limit > 0L && currentCount >= limit) {
            return true;
        }
        long amountToGive = drop.getCount();
        if (amountToGive > 0L && player.getInventory().validateCapacityByItemId(drop.getId())) {
            L2ItemInstance item;
            if (limit > 0L && currentCount + amountToGive > limit) {
                amountToGive = limit - currentCount;
            }
            if ((item = player.addItem("Quest", drop.getId(), amountToGive, npc, true)) != null) {
                if (currentCount + amountToGive == limit) {
                    if (playSound) {
                        AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_MIDDLE);
                    }
                    return true;
                }
                if (playSound) {
                    AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
                }
                return limit <= 0L;
            }
        }
        return false;
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim) {
        List<ItemHolder> items = item.calculateDrops(victim, player);
        if (items == null || items.isEmpty()) {
            return false;
        }
        AbstractScript.giveItems(player, items);
        return true;
    }

    protected static void giveItems(L2PcInstance player, List<ItemHolder> items) {
        for (ItemHolder item : items) {
            AbstractScript.giveItems(player, item);
        }
    }

    protected static boolean giveItems(L2PcInstance player, ItemHolder item, long limit) {
        long maxToGive = limit - player.getInventory().getInventoryItemCount(item.getId(), -1);
        if (maxToGive <= 0L) {
            return false;
        }
        AbstractScript.giveItems(player, item.getId(), Math.min(maxToGive, item.getCount()));
        return true;
    }

    protected static boolean giveItems(L2PcInstance player, ItemHolder item, long limit, boolean playSound) {
        boolean drop = AbstractScript.giveItems(player, item, limit);
        if (drop && playSound) {
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
        return drop;
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, long limit) {
        boolean b = false;
        for (ItemHolder item : items) {
            b |= AbstractScript.giveItems(player, item, limit);
        }
        return b;
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, long limit, boolean playSound) {
        boolean drop = AbstractScript.giveItems(player, items, limit);
        if (drop && playSound) {
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
        return drop;
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, Map<Integer, Long> limit) {
        return AbstractScript.giveItems(player, items, Util.mapToFunction(limit));
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, Function<Integer, Long> limit) {
        boolean b = false;
        for (ItemHolder item : items) {
            Long longLimit;
            if (limit != null && (longLimit = limit.apply(item.getId())) != null) {
                b |= AbstractScript.giveItems(player, item, (long)longLimit);
                continue;
            }
            b = true;
            AbstractScript.giveItems(player, item);
        }
        return b;
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, Function<Integer, Long> limit, boolean playSound) {
        boolean drop = AbstractScript.giveItems(player, items, limit);
        if (drop && playSound) {
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
        return drop;
    }

    protected static boolean giveItems(L2PcInstance player, List<ItemHolder> items, Map<Integer, Long> limit, boolean playSound) {
        return AbstractScript.giveItems(player, items, Util.mapToFunction(limit), playSound);
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, int limit) {
        return AbstractScript.giveItems(player, item.calculateDrops(victim, player), (long)limit);
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, int limit, boolean playSound) {
        boolean drop = AbstractScript.giveItems(player, item, victim, limit);
        if (drop && playSound) {
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
        return drop;
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, Map<Integer, Long> limit) {
        return AbstractScript.giveItems(player, item.calculateDrops(victim, player), limit);
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, Function<Integer, Long> limit) {
        return AbstractScript.giveItems(player, item.calculateDrops(victim, player), limit);
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, Map<Integer, Long> limit, boolean playSound) {
        return AbstractScript.giveItems(player, item, victim, Util.mapToFunction(limit), playSound);
    }

    protected static boolean giveItems(L2PcInstance player, IDropItem item, L2Character victim, Function<Integer, Long> limit, boolean playSound) {
        boolean drop = AbstractScript.giveItems(player, item, victim, limit);
        if (drop && playSound) {
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
        return drop;
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, Collection<ItemHolder> items, Function<Integer, Long> limit, boolean playSound) {
        Map<L2PcInstance, Map<Integer, Long>> rewardedCounts = AbstractScript.calculateDistribution(players, items, limit);
        AbstractScript.giveItems(rewardedCounts, playSound);
        return rewardedCounts;
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, Collection<ItemHolder> items, Map<Integer, Long> limit, boolean playSound) {
        return AbstractScript.distributeItems(players, items, Util.mapToFunction(limit), playSound);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, Collection<ItemHolder> items, long limit, boolean playSound) {
        return AbstractScript.distributeItems(players, items, (Integer t) -> limit, playSound);
    }

    protected static Map<L2PcInstance, Long> distributeItems(Collection<L2PcInstance> players, ItemHolder item, long limit, boolean playSound) {
        Map<L2PcInstance, Map<Integer, Long>> distribution = AbstractScript.distributeItems(players, Collections.singletonList(item), limit, playSound);
        HashMap<L2PcInstance, Long> returnMap = new HashMap<L2PcInstance, Long>();
        for (Map.Entry<L2PcInstance, Map<Integer, Long>> entry : distribution.entrySet()) {
            for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                returnMap.put(entry.getKey(), entry2.getValue());
            }
        }
        return returnMap;
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, IDropItem items, L2Character killer, L2Character victim, Function<Integer, Long> limit, boolean playSound) {
        return AbstractScript.distributeItems(players, items.calculateDrops(victim, killer), limit, playSound);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, IDropItem items, L2Character killer, L2Character victim, Map<Integer, Long> limit, boolean playSound) {
        return AbstractScript.distributeItems(players, items.calculateDrops(victim, killer), limit, playSound);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, IDropItem items, L2Character killer, L2Character victim, long limit, boolean playSound) {
        return AbstractScript.distributeItems(players, items.calculateDrops(victim, killer), limit, playSound);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, GroupedGeneralDropItem items, L2Character killer, L2Character victim, Function<Integer, Long> limit, boolean playSound, boolean smartDrop) {
        GroupedGeneralDropItem toDrop;
        if (smartDrop) {
            toDrop = new GroupedGeneralDropItem(items.getChance(), items.getDropCalculationStrategy(), items.getKillerChanceModifierStrategy(), items.getPreciseStrategy());
            LinkedList<GeneralDropItem> dropItems = new LinkedList<GeneralDropItem>(items.getItems());
            Iterator it = dropItems.iterator();
            block0: while (it.hasNext()) {
                GeneralDropItem item = (GeneralDropItem)it.next();
                for (L2PcInstance player : players) {
                    int itemId = item.getItemId();
                    if (player.getInventory().getInventoryItemCount(itemId, -1, true) >= AbstractScript.avoidNull(limit, itemId)) continue;
                    continue block0;
                }
                it.remove();
            }
            toDrop.setItems(dropItems);
            toDrop = toDrop.normalizeMe(victim, killer);
        } else {
            toDrop = items;
        }
        return AbstractScript.distributeItems(players, (IDropItem)toDrop, killer, victim, limit, playSound);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, GroupedGeneralDropItem items, L2Character killer, L2Character victim, Map<Integer, Long> limit, boolean playSound, boolean smartDrop) {
        return AbstractScript.distributeItems(players, items, killer, victim, Util.mapToFunction(limit), playSound, smartDrop);
    }

    protected static Map<L2PcInstance, Map<Integer, Long>> distributeItems(Collection<L2PcInstance> players, GroupedGeneralDropItem items, L2Character killer, L2Character victim, long limit, boolean playSound, boolean smartDrop) {
        return AbstractScript.distributeItems(players, items, killer, victim, (Integer t) -> limit, playSound, smartDrop);
    }

    private static Map<L2PcInstance, Map<Integer, Long>> calculateDistribution(Collection<L2PcInstance> players, Collection<ItemHolder> items, Function<Integer, Long> limit) {
        HashMap<L2PcInstance, Map<Integer, Long>> rewardedCounts = new HashMap<L2PcInstance, Map<Integer, Long>>();
        for (L2PcInstance player : players) {
            rewardedCounts.put(player, new HashMap());
        }
        block1: for (ItemHolder item : items) {
            long equaldist = item.getCount() / (long)players.size();
            long randomdist = item.getCount() % (long)players.size();
            ArrayList<L2PcInstance> toDist = new ArrayList<L2PcInstance>(players);
            do {
                Iterator it = toDist.iterator();
                while (it.hasNext()) {
                    L2PcInstance player = (L2PcInstance)it.next();
                    if (!((Map)rewardedCounts.get(player)).containsKey(item.getId())) {
                        ((Map)rewardedCounts.get(player)).put(item.getId(), 0L);
                    }
                    long maxGive = AbstractScript.avoidNull(limit, item.getId()) - player.getInventory().getInventoryItemCount(item.getId(), -1, true) - (Long)((Map)rewardedCounts.get(player)).get(item.getId());
                    long toGive = equaldist;
                    if (equaldist >= maxGive) {
                        toGive = maxGive;
                        randomdist += equaldist - maxGive;
                        it.remove();
                    }
                    ((Map)rewardedCounts.get(player)).put(item.getId(), (Long)((Map)rewardedCounts.get(player)).get(item.getId()) + toGive);
                }
                if (toDist.isEmpty()) continue block1;
                equaldist = randomdist / (long)toDist.size();
                randomdist %= (long)toDist.size();
            } while (equaldist > 0L);
            while (randomdist > 0L && !toDist.isEmpty()) {
                L2PcInstance player = (L2PcInstance)toDist.get(AbstractScript.getRandom(toDist.size()));
                long maxGive = AbstractScript.avoidNull(limit, item.getId()) - limit.apply(item.getId()) - player.getInventory().getInventoryItemCount(item.getId(), -1, true) - (Long)((Map)rewardedCounts.get(player)).get(item.getId());
                if (maxGive > 0L) {
                    ((Map)rewardedCounts.get(player)).put(item.getId(), (Long)((Map)rewardedCounts.get(player)).get(item.getId()) + 1L);
                    --randomdist;
                }
                toDist.remove(player);
            }
        }
        return rewardedCounts;
    }

    private static <T> long avoidNull(Function<T, Long> function, T arg) {
        Long longLimit = function.apply(arg);
        return longLimit == null ? Long.MAX_VALUE : longLimit;
    }

    private static void giveItems(Map<L2PcInstance, Map<Integer, Long>> rewardedCounts, boolean playSound) {
        for (Map.Entry<L2PcInstance, Map<Integer, Long>> entry : rewardedCounts.entrySet()) {
            L2PcInstance player = entry.getKey();
            boolean playPlayerSound = false;
            for (Map.Entry<Integer, Long> item : entry.getValue().entrySet()) {
                if (item.getValue() < 0L) continue;
                playPlayerSound = true;
                AbstractScript.giveItems(player, item.getKey(), (long)item.getValue());
            }
            if (!playSound || !playPlayerSound) continue;
            AbstractScript.playSound(player, Sound.ITEMSOUND_QUEST_ITEMGET);
        }
    }

    public static boolean takeItems(L2PcInstance player, int itemId, long amount) {
        List<L2ItemInstance> items = player.getInventory().getItemsByItemId(itemId);
        if (amount < 0L) {
            items.forEach(i -> AbstractScript.takeItem(player, i, i.getCount()));
        } else {
            long currentCount = 0L;
            for (L2ItemInstance i2 : items) {
                long toDelete = i2.getCount();
                if (currentCount + toDelete > amount) {
                    toDelete = amount - currentCount;
                }
                AbstractScript.takeItem(player, i2, toDelete);
                currentCount += toDelete;
            }
        }
        return true;
    }

    private static boolean takeItem(L2PcInstance player, L2ItemInstance item, long toDelete) {
        if (item.isEquipped()) {
            L2ItemInstance[] unequiped = player.getInventory().unEquipItemInBodySlotAndRecord(item.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            player.sendPacket(iu);
            player.broadcastUserInfo();
        }
        return player.destroyItemByItemId("Quest", item.getId(), toDelete, player, true);
    }

    protected static boolean takeItem(L2PcInstance player, ItemHolder holder) {
        if (holder == null) {
            return false;
        }
        return AbstractScript.takeItems(player, holder.getId(), holder.getCount());
    }

    protected static boolean takeAllItems(L2PcInstance player, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        if (!AbstractScript.hasAllItems(player, true, itemList)) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (AbstractScript.takeItem(player, item)) continue;
            return false;
        }
        return true;
    }

    public static boolean takeItems(L2PcInstance player, int amount, int ... itemIds) {
        boolean check = true;
        if (itemIds != null) {
            for (int item : itemIds) {
                check &= AbstractScript.takeItems(player, item, (long)amount);
            }
        }
        return check;
    }

    public static void playSound(L2PcInstance player, IAudio sound) {
        player.sendPacket(sound.getPacket());
    }

    public static void addExpAndSp(L2PcInstance player, long exp, int sp) {
        player.addExpAndSpQuest((long)((float)exp * Configuration.rates().getRateQuestRewardXP()), (int)((float)sp * Configuration.rates().getRateQuestRewardSP()));
    }

    public static double getRandom() {
        return Rnd.get();
    }

    public static int getRandom(int max) {
        return Rnd.get((int)max);
    }

    public static int getRandom(int min, int max) {
        return Rnd.get((int)min, (int)max);
    }

    public static boolean getRandomBoolean() {
        return Rnd.nextBoolean();
    }

    public static int getItemEquipped(L2PcInstance player, int slot) {
        return player.getInventory().getPaperdollItemId(slot);
    }

    public static int getGameTicks() {
        return GameTimeController.getInstance().getGameTicks();
    }

    public final void executeForEachPlayer(L2PcInstance player, L2Npc npc, boolean isSummon, boolean includeParty, boolean includeCommandChannel) {
        if ((includeParty || includeCommandChannel) && player.isInParty()) {
            if (includeCommandChannel && player.getParty().isInCommandChannel()) {
                player.getParty().getCommandChannel().forEachMember(member -> {
                    this.actionForEachPlayer((L2PcInstance)member, npc, isSummon);
                    return true;
                });
            } else if (includeParty) {
                player.getParty().forEachMember(member -> {
                    this.actionForEachPlayer((L2PcInstance)member, npc, isSummon);
                    return true;
                });
            }
        } else {
            this.actionForEachPlayer(player, npc, isSummon);
        }
    }

    public void actionForEachPlayer(L2PcInstance player, L2Npc npc, boolean isSummon) {
    }

    public void openDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            LOG.warn("Called openDoor({}, {}); but door wasn't found!", (Object)doorId, (Object)instanceId);
        } else if (!door.getOpen()) {
            door.openMe();
        }
    }

    public void closeDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            LOG.warn("Called closeDoor({}, {}); but door wasn't found!", (Object)doorId, (Object)instanceId);
        } else if (door.getOpen()) {
            door.closeMe();
        }
    }

    public L2DoorInstance getDoor(int doorId, int instanceId) {
        L2DoorInstance door = null;
        if (instanceId <= 0) {
            door = DoorData.getInstance().getDoor(doorId);
        } else {
            Instance inst = InstanceManager.getInstance().getInstance(instanceId);
            if (inst != null) {
                door = inst.getDoor(doorId);
            }
        }
        return door;
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId) {
        this.teleportPlayer(player, loc, instanceId, true);
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId, boolean allowRandomOffset) {
        player.teleToLocation(loc, instanceId, allowRandomOffset ? Configuration.character().getMaxOffsetOnTeleport() : 0);
    }

    protected void addAttackDesire(L2Npc npc, L2Character creature) {
        this.addAttackDesire(npc, creature, 999L);
    }

    protected void addAttackDesire(L2Npc npc, L2Character creature, long desire) {
        if (npc instanceof L2Attackable) {
            L2Attackable attackable = (L2Attackable)npc;
            attackable.addDamageHate(creature, 0, desire);
        }
        npc.setIsRunning(true);
        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, creature);
    }

    protected void addMoveToDesire(L2Npc npc, Location loc, int desire) {
        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc);
    }

    protected void castSkill(L2Npc npc, L2Playable target, SkillHolder skill) {
        npc.setTarget(target);
        npc.doCast(skill.getSkill());
    }

    protected void castSkill(L2Npc npc, L2Playable target, Skill skill) {
        npc.setTarget(target);
        npc.doCast(skill);
    }

    protected void addSkillCastDesire(L2Npc npc, L2Character target, SkillHolder skill, long desire) {
        this.addSkillCastDesire(npc, target, skill.getSkill(), desire);
    }

    protected void addSkillCastDesire(L2Npc npc, L2Character target, Skill skill, long desire) {
        if (npc instanceof L2Attackable) {
            L2Attackable attackable = (L2Attackable)npc;
            attackable.addDamageHate(target, 0, desire);
        }
        npc.setTarget(target);
        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
    }

    public static void specialCamera(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int range, int duration, int relYaw, int relPitch, int isWide, int relAngle) {
        player.sendPacket(new SpecialCamera(creature, force, angle1, angle2, time, range, duration, relYaw, relPitch, isWide, relAngle));
    }

    public static void specialCameraEx(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int duration, int relYaw, int relPitch, int isWide, int relAngle) {
        player.sendPacket(new SpecialCamera(creature, player, force, angle1, angle2, time, duration, relYaw, relPitch, isWide, relAngle));
    }

    public static void specialCamera3(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int range, int duration, int relYaw, int relPitch, int isWide, int relAngle, int unk) {
        player.sendPacket(new SpecialCamera(creature, force, angle1, angle2, time, range, duration, relYaw, relPitch, isWide, relAngle, unk));
    }

    public static void addRadar(L2PcInstance player, int x, int y, int z) {
        player.getRadar().addMarker(x, y, z);
    }

    public void removeRadar(L2PcInstance player, int x, int y, int z) {
        player.getRadar().removeMarker(x, y, z);
    }

    public void clearRadar(L2PcInstance player) {
        player.getRadar().removeAllMarkers();
    }
}

