/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttack;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttackAvoid;
import com.l2jserver.gameserver.model.events.impl.character.CreatureAttacked;
import com.l2jserver.gameserver.model.events.impl.character.CreatureDamageDealt;
import com.l2jserver.gameserver.model.events.impl.character.CreatureDamageReceived;
import com.l2jserver.gameserver.model.events.impl.character.CreatureKill;
import com.l2jserver.gameserver.model.events.impl.character.CreatureSkillUse;
import com.l2jserver.gameserver.model.events.impl.character.CreatureTeleported;
import com.l2jserver.gameserver.model.events.impl.character.CreatureZoneEnter;
import com.l2jserver.gameserver.model.events.impl.character.CreatureZoneExit;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcCanBeSeen;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcCreatureSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcFirstTalk;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcManorBypass;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcMoveFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcMoveNodeArrived;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcMoveRouteFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSpawn;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcTeleport;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableAttack;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableKill;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.FactionCall;
import com.l2jserver.gameserver.model.events.impl.character.playable.PlayableExpChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerAugment;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerBypass;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerChat;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerCreate;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerDelete;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerDlgAnswer;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerEquipItem;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerFameChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerHennaAdd;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerHennaRemove;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerKarmaChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLearnSkillRequested;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLevelChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLogin;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerLogout;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerMenuSelected;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerOneSkillSelected;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPKChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionCancel;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerProfessionChange;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPvPChanged;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerPvPKill;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerQuestAccepted;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerRestore;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSelect;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSit;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSkillLearned;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonSpawn;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSummonTalk;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTransform;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTutorial;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTutorialClientEvent;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTutorialCmd;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerTutorialQuestionMark;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanCreate;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanDestroy;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanJoin;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLeaderChange;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLeave;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLevelUp;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.PlayerClanWHItemAdd;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.PlayerClanWHItemDestroy;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.PlayerClanWHItemTransfer;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemAdd;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemDestroy;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemDrop;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemPickup;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemTransfer;
import com.l2jserver.gameserver.model.events.impl.character.trap.OnTrapAction;
import com.l2jserver.gameserver.model.events.impl.clan.ClanWarFinish;
import com.l2jserver.gameserver.model.events.impl.clan.ClanWarStart;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventFinish;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventKill;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventRegistrationStart;
import com.l2jserver.gameserver.model.events.impl.events.TvTEventStart;
import com.l2jserver.gameserver.model.events.impl.item.ItemBypass;
import com.l2jserver.gameserver.model.events.impl.item.ItemCreate;
import com.l2jserver.gameserver.model.events.impl.item.ItemTalk;
import com.l2jserver.gameserver.model.events.impl.olympiad.OlympiadMatchResult;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeOwnerChange;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.CastleSiegeStart;
import com.l2jserver.gameserver.model.events.impl.sieges.fort.FortSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.fort.FortSiegeStart;
import com.l2jserver.gameserver.model.events.returns.ChatFilterReturn;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.util.Util;

public enum EventType {
    ATTACKABLE_AGGRO_RANGE_ENTER(AttackableAggroRangeEnter.class, Void.TYPE),
    ATTACKABLE_ATTACK(AttackableAttack.class, Void.TYPE),
    FACTION_CALL(FactionCall.class, Void.TYPE),
    ATTACKABLE_KILL(AttackableKill.class, Void.TYPE),
    CASTLE_SIEGE_FINISH(CastleSiegeFinish.class, Void.TYPE),
    CASTLE_SIEGE_OWNER_CHANGE(CastleSiegeOwnerChange.class, Void.TYPE),
    CASTLE_SIEGE_START(CastleSiegeStart.class, Void.TYPE),
    CLAN_WAR_FINISH(ClanWarFinish.class, Void.TYPE),
    CLAN_WAR_START(ClanWarStart.class, Void.TYPE),
    CREATURE_ATTACK(CreatureAttack.class, Void.TYPE, TerminateReturn.class),
    CREATURE_ATTACK_AVOID(CreatureAttackAvoid.class, Void.TYPE, Void.TYPE),
    CREATURE_ATTACKED(CreatureAttacked.class, Void.TYPE, TerminateReturn.class),
    CREATURE_DAMAGE_RECEIVED(CreatureDamageReceived.class, Void.TYPE),
    CREATURE_DAMAGE_DEALT(CreatureDamageDealt.class, Void.TYPE),
    CREATURE_KILL(CreatureKill.class, Void.TYPE, TerminateReturn.class),
    CREATURE_SKILL_USE(CreatureSkillUse.class, Void.TYPE, TerminateReturn.class),
    CREATURE_TELEPORTED(CreatureTeleported.class, Void.TYPE),
    CREATURE_ZONE_ENTER(CreatureZoneEnter.class, Void.TYPE),
    CREATURE_ZONE_EXIT(CreatureZoneExit.class, Void.TYPE),
    FORT_SIEGE_FINISH(FortSiegeFinish.class, Void.TYPE),
    FORT_SIEGE_START(FortSiegeStart.class, Void.TYPE),
    ITEM_BYPASS(ItemBypass.class, Void.TYPE),
    ITEM_CREATE(ItemCreate.class, Void.TYPE),
    ITEM_TALK(ItemTalk.class, Void.TYPE),
    NPC_CAN_BE_SEEN(NpcCanBeSeen.class, Void.TYPE, TerminateReturn.class),
    NPC_CREATURE_SEE(NpcCreatureSee.class, Void.TYPE),
    NPC_EVENT_RECEIVED(NpcEventReceived.class, Void.TYPE),
    NPC_FIRST_TALK(NpcFirstTalk.class, Void.TYPE),
    NPC_HATE(AttackableHate.class, Void.TYPE, TerminateReturn.class),
    NPC_MOVE_FINISHED(NpcMoveFinished.class, Void.TYPE),
    NPC_MOVE_NODE_ARRIVED(NpcMoveNodeArrived.class, Void.TYPE),
    NPC_MOVE_ROUTE_FINISHED(NpcMoveRouteFinished.class, Void.TYPE),
    NPC_QUEST_START(null, Void.TYPE),
    NPC_SKILL_FINISHED(NpcSkillFinished.class, Void.TYPE),
    NPC_SKILL_SEE(NpcSkillSee.class, Void.TYPE),
    NPC_SPAWN(NpcSpawn.class, Void.TYPE),
    NPC_TALK(null, Void.TYPE),
    NPC_TELEPORT(NpcTeleport.class, Void.TYPE),
    NPC_MANOR_BYPASS(NpcManorBypass.class, Void.TYPE),
    OLYMPIAD_MATCH_RESULT(OlympiadMatchResult.class, Void.TYPE),
    PLAYABLE_EXP_CHANGED(PlayableExpChanged.class, Void.TYPE, TerminateReturn.class),
    PLAYER_AUGMENT(PlayerAugment.class, Void.TYPE),
    PLAYER_BYPASS(PlayerBypass.class, Void.TYPE),
    PLAYER_CHAT(PlayerChat.class, Void.TYPE, ChatFilterReturn.class),
    PLAYER_TUTORIAL(PlayerTutorial.class, Void.TYPE, Void.TYPE),
    PLAYER_TUTORIAL_CMD(PlayerTutorialCmd.class, Void.TYPE, Void.TYPE),
    PLAYER_TUTORIAL_CLIENT_EVENT(PlayerTutorialClientEvent.class, Void.TYPE, Void.TYPE),
    PLAYER_TUTORIAL_QUESTION_MARK(PlayerTutorialQuestionMark.class, Void.TYPE, Void.TYPE),
    PLAYER_CLAN_CREATE(PlayerClanCreate.class, Void.TYPE),
    PLAYER_CLAN_DESTROY(PlayerClanDestroy.class, Void.TYPE),
    PLAYER_CLAN_JOIN(PlayerClanJoin.class, Void.TYPE),
    PLAYER_CLAN_LEADER_CHANGE(PlayerClanLeaderChange.class, Void.TYPE),
    PLAYER_CLAN_LEAVE(PlayerClanLeave.class, Void.TYPE),
    PLAYER_CLAN_LEVEL_UP(PlayerClanLevelUp.class, Void.TYPE),
    PLAYER_CLAN_WH_ITEM_ADD(PlayerClanWHItemAdd.class, Void.TYPE),
    PLAYER_CLAN_WH_ITEM_DESTROY(PlayerClanWHItemDestroy.class, Void.TYPE),
    PLAYER_CLAN_WH_ITEM_TRANSFER(PlayerClanWHItemTransfer.class, Void.TYPE),
    PLAYER_CREATE(PlayerCreate.class, Void.TYPE),
    PLAYER_DELETE(PlayerDelete.class, Void.TYPE),
    PLAYER_DLG_ANSWER(PlayerDlgAnswer.class, Void.TYPE, TerminateReturn.class),
    PLAYER_EQUIP_ITEM(PlayerEquipItem.class, Void.TYPE),
    PLAYER_FAME_CHANGED(PlayerFameChanged.class, Void.TYPE),
    PLAYER_HENNA_ADD(PlayerHennaAdd.class, Void.TYPE),
    PLAYER_HENNA_REMOVE(PlayerHennaRemove.class, Void.TYPE),
    PLAYER_ITEM_ADD(PlayerItemAdd.class, Void.TYPE),
    PLAYER_ITEM_DESTROY(PlayerItemDestroy.class, Void.TYPE),
    PLAYER_ITEM_DROP(PlayerItemDrop.class, Void.TYPE),
    PLAYER_ITEM_PICKUP(PlayerItemPickup.class, Void.TYPE),
    PLAYER_ITEM_TRANSFER(PlayerItemTransfer.class, Void.TYPE),
    PLAYER_KARMA_CHANGED(PlayerKarmaChanged.class, Void.TYPE),
    PLAYER_LEVEL_CHANGED(PlayerLevelChanged.class, Void.TYPE),
    PLAYER_LOGIN(PlayerLogin.class, Void.TYPE),
    PLAYER_LOGOUT(PlayerLogout.class, Void.TYPE),
    PLAYER_PK_CHANGED(PlayerPKChanged.class, Void.TYPE),
    PLAYER_PROFESSION_CHANGE(PlayerProfessionChange.class, Void.TYPE),
    PLAYER_PROFESSION_CANCEL(PlayerProfessionCancel.class, Void.TYPE),
    PLAYER_PVP_CHANGED(PlayerPvPChanged.class, Void.TYPE),
    PLAYER_PVP_KILL(PlayerPvPKill.class, Void.TYPE),
    PLAYER_RESTORE(PlayerRestore.class, Void.TYPE),
    PLAYER_SELECT(PlayerSelect.class, Void.TYPE, TerminateReturn.class),
    PLAYER_SIT(PlayerSit.class, TerminateReturn.class),
    PLAYER_LEARN_SKILL_REQUESTED(PlayerLearnSkillRequested.class, Void.TYPE),
    PLAYER_ONE_SKILL_SELECTED(PlayerOneSkillSelected.class, Void.TYPE),
    PLAYER_SKILL_LEARNED(PlayerSkillLearned.class, Void.TYPE),
    PLAYER_MENU_SELECTED(PlayerMenuSelected.class, Void.TYPE),
    PLAYER_QUEST_ACCEPTED(PlayerQuestAccepted.class, Void.TYPE),
    PLAYER_STAND(PlayerSit.class, TerminateReturn.class),
    PLAYER_SUMMON_SPAWN(PlayerSummonSpawn.class, Void.TYPE),
    PLAYER_SUMMON_TALK(PlayerSummonTalk.class, Void.TYPE),
    PLAYER_TRANSFORM(PlayerTransform.class, Void.TYPE),
    TRAP_ACTION(OnTrapAction.class, Void.TYPE),
    TVT_EVENT_FINISH(TvTEventFinish.class, Void.TYPE),
    TVT_EVENT_KILL(TvTEventKill.class, Void.TYPE),
    TVT_EVENT_REGISTRATION_START(TvTEventRegistrationStart.class, Void.TYPE),
    TVT_EVENT_START(TvTEventStart.class, Void.TYPE);

    private final Class<? extends BaseEvent> eventClass;
    private final Class<?>[] returnClass;

    private EventType(Class<? extends BaseEvent> eventClass, Class<?> ... returnClass) {
        this.eventClass = eventClass;
        this.returnClass = returnClass;
    }

    public Class<? extends BaseEvent> getEventClass() {
        return this.eventClass;
    }

    public Class<?>[] getReturnClasses() {
        return this.returnClass;
    }

    public boolean isEventClass(Class<?> clazz) {
        return this.eventClass == clazz;
    }

    public boolean isReturnClass(Class<?> clazz) {
        return Util.contains(this.returnClass, clazz);
    }
}

