/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events.listeners;

import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationEventListener
extends AbstractEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationEventListener.class);
    private final Method _callback;

    public AnnotationEventListener(ListenersContainer container, EventType type, Method callback, Object owner, int priority) {
        super(container, type, owner);
        this._callback = callback;
        this.setPriority(priority);
    }

    @Override
    public <R extends AbstractEventReturn> R executeEvent(BaseEvent event, Class<R> returnBackClass) {
        try {
            Object result = this._callback.invoke(this.getOwner(), event);
            if (this._callback.getReturnType() == returnBackClass) {
                return (R)((AbstractEventReturn)returnBackClass.cast(result));
            }
        }
        catch (Exception e) {
            LOG.warn("Error while invoking {} on {}", this._callback.getName(), this.getOwner(), e);
        }
        return null;
    }
}

