/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.fishing;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.data.xml.impl.FishingMonstersData;
import com.l2jserver.gameserver.enums.audio.Music;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.AbstractScript;
import com.l2jserver.gameserver.model.fishing.L2Fish;
import com.l2jserver.gameserver.model.fishing.L2FishingMonster;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExFishingHpRegen;
import com.l2jserver.gameserver.network.serverpackets.ExFishingStartCombat;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.concurrent.Future;

public class L2Fishing
implements Runnable {
    private L2PcInstance _fisher;
    private int _time;
    private int _stop = 0;
    private int _goodUse = 0;
    private int _anim = 0;
    private int _mode;
    private int _deceptiveMode;
    private Future<?> _fishAiTask;
    private boolean _thinking;
    private final int _fishId;
    private final int _fishMaxHp;
    private int _fishCurHp;
    private final double _regenHp;
    private final boolean _isUpperGrade;

    @Override
    public void run() {
        if (this._fisher == null) {
            return;
        }
        if (this._fishCurHp >= this._fishMaxHp * 2) {
            this._fisher.sendPacket(SystemMessageId.BAIT_STOLEN_BY_FISH);
            this.doDie(false);
        } else if (this._time <= 0) {
            this._fisher.sendPacket(SystemMessageId.FISH_SPIT_THE_HOOK);
            this.doDie(false);
        } else {
            this.aiTask();
        }
    }

    public L2Fishing(L2PcInstance Fisher, L2Fish fish, boolean isNoob, boolean isUpperGrade) {
        int lureType;
        this._fisher = Fisher;
        this._fishCurHp = this._fishMaxHp = fish.getFishHp();
        this._regenHp = fish.getHpRegen();
        this._fishId = fish.getItemId();
        this._time = fish.getCombatDuration();
        this._isUpperGrade = isUpperGrade;
        if (isUpperGrade) {
            this._deceptiveMode = Rnd.get((int)100) >= 90 ? 1 : 0;
            lureType = 2;
        } else {
            this._deceptiveMode = 0;
            lureType = isNoob ? 0 : 1;
        }
        this._mode = Rnd.get((int)100) >= 80 ? 1 : 0;
        this._fisher.broadcastPacket(new ExFishingStartCombat(this._fisher, this._time, this._fishMaxHp, this._mode, lureType, this._deceptiveMode));
        this._fisher.sendPacket(Music.SF_S_01.getPacket());
        this._fisher.sendPacket(SystemMessageId.GOT_A_BITE);
        if (this._fishAiTask == null) {
            this._fishAiTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(this, 1000L, 1000L);
        }
    }

    public void changeHp(int hp, int pen) {
        this._fishCurHp -= hp;
        if (this._fishCurHp < 0) {
            this._fishCurHp = 0;
        }
        this._fisher.broadcastPacket(new ExFishingHpRegen(this._fisher, this._time, this._fishCurHp, this._mode, this._goodUse, this._anim, pen, this._deceptiveMode));
        this._anim = 0;
        if (this._fishCurHp > this._fishMaxHp * 2) {
            this._fishCurHp = this._fishMaxHp * 2;
            this.doDie(false);
        } else if (this._fishCurHp == 0) {
            this.doDie(true);
        }
    }

    public synchronized void doDie(boolean win) {
        L2FishingMonster fishingMonster;
        if (this._fishAiTask != null) {
            this._fishAiTask.cancel(false);
            this._fishAiTask = null;
        }
        if (this._fisher == null) {
            return;
        }
        if (win && (fishingMonster = FishingMonstersData.getInstance().getFishingMonster(this._fisher.getLevel())) != null) {
            if (Rnd.get((int)100) <= fishingMonster.getProbability()) {
                this._fisher.sendPacket(SystemMessageId.YOU_CAUGHT_SOMETHING_SMELLY_THROW_IT_BACK);
                L2Npc monster = AbstractScript.addSpawn(fishingMonster.getFishingMonsterId(), this._fisher);
                monster.setTarget(this._fisher);
            } else {
                this._fisher.sendPacket(SystemMessageId.YOU_CAUGHT_SOMETHING);
                this._fisher.addItem("Fishing", this._fishId, 1L, null, true);
            }
        }
        this._fisher.endFishing(win);
        this._fisher = null;
    }

    protected void aiTask() {
        if (this._thinking) {
            return;
        }
        this._thinking = true;
        --this._time;
        try {
            if (this._mode == 1) {
                if (this._deceptiveMode == 0) {
                    this._fishCurHp += (int)this._regenHp;
                }
            } else if (this._deceptiveMode == 1) {
                this._fishCurHp += (int)this._regenHp;
            }
            if (this._stop == 0) {
                this._stop = 1;
                int check = Rnd.get((int)100);
                if (check >= 70) {
                    int n = this._mode = this._mode == 0 ? 1 : 0;
                }
                if (this._isUpperGrade && (check = Rnd.get((int)100)) >= 90) {
                    this._deceptiveMode = this._deceptiveMode == 0 ? 1 : 0;
                }
            } else {
                --this._stop;
            }
        }
        finally {
            this._thinking = false;
            ExFishingHpRegen exFishingHpRegen = new ExFishingHpRegen(this._fisher, this._time, this._fishCurHp, this._mode, 0, this._anim, 0, this._deceptiveMode);
            if (this._anim != 0) {
                this._fisher.broadcastPacket(exFishingHpRegen);
            } else {
                this._fisher.sendPacket(exFishingHpRegen);
            }
        }
    }

    public void useReeling(int dmg, int pen) {
        this._anim = 2;
        if (Rnd.get((int)100) > 90) {
            this._fisher.sendPacket(SystemMessageId.FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN);
            this._goodUse = 0;
            this.changeHp(0, pen);
            return;
        }
        if (this._fisher == null) {
            return;
        }
        if (this._mode == 1) {
            if (this._deceptiveMode == 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REELING_SUCCESFUL_S1_DAMAGE);
                sm.addInt(dmg);
                this._fisher.sendPacket(sm);
                if (pen > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.REELING_SUCCESSFUL_PENALTY_S1);
                    sm.addInt(pen);
                    this._fisher.sendPacket(sm);
                }
                this._goodUse = 1;
                this.changeHp(dmg, pen);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FISH_RESISTED_REELING_S1_HP_REGAINED);
                sm.addInt(dmg);
                this._fisher.sendPacket(sm);
                this._goodUse = 2;
                this.changeHp(-dmg, pen);
            }
        } else if (this._deceptiveMode == 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FISH_RESISTED_REELING_S1_HP_REGAINED);
            sm.addInt(dmg);
            this._fisher.sendPacket(sm);
            this._goodUse = 2;
            this.changeHp(-dmg, pen);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REELING_SUCCESFUL_S1_DAMAGE);
            sm.addInt(dmg);
            this._fisher.sendPacket(sm);
            if (pen > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.REELING_SUCCESSFUL_PENALTY_S1);
                sm.addInt(pen);
                this._fisher.sendPacket(sm);
            }
            this._goodUse = 1;
            this.changeHp(dmg, pen);
        }
    }

    public void usePumping(int dmg, int pen) {
        this._anim = 1;
        if (Rnd.get((int)100) > 90) {
            this._fisher.sendPacket(SystemMessageId.FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN);
            this._goodUse = 0;
            this.changeHp(0, pen);
            return;
        }
        if (this._fisher == null) {
            return;
        }
        if (this._mode == 0) {
            if (this._deceptiveMode == 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PUMPING_SUCCESFUL_S1_DAMAGE);
                sm.addInt(dmg);
                this._fisher.sendPacket(sm);
                if (pen > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.PUMPING_SUCCESSFUL_PENALTY_S1);
                    sm.addInt(pen);
                    this._fisher.sendPacket(sm);
                }
                this._goodUse = 1;
                this.changeHp(dmg, pen);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FISH_RESISTED_PUMPING_S1_HP_REGAINED);
                sm.addInt(dmg);
                this._fisher.sendPacket(sm);
                this._goodUse = 2;
                this.changeHp(-dmg, pen);
            }
        } else if (this._deceptiveMode == 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FISH_RESISTED_PUMPING_S1_HP_REGAINED);
            sm.addInt(dmg);
            this._fisher.sendPacket(sm);
            this._goodUse = 2;
            this.changeHp(-dmg, pen);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PUMPING_SUCCESFUL_S1_DAMAGE);
            sm.addInt(dmg);
            this._fisher.sendPacket(sm);
            if (pen > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.PUMPING_SUCCESSFUL_PENALTY_S1);
                sm.addInt(pen);
                this._fisher.sendPacket(sm);
            }
            this._goodUse = 1;
            this.changeHp(dmg, pen);
        }
    }
}

