/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.model.L2ExtractableProduct;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType1;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2EtcItem
extends L2Item {
    private static final Logger LOG = LoggerFactory.getLogger(L2EtcItem.class);
    private String _handler;
    private EtcItemType _type;
    private final boolean _isBlessed;
    private final List<L2ExtractableProduct> _extractableItems;

    public L2EtcItem(StatsSet set) {
        super(set);
        this._type = set.getEnum("etcitem_type", EtcItemType.class, EtcItemType.NONE);
        switch (this.getDefaultAction()) {
            case SOULSHOT: 
            case SUMMON_SOULSHOT: 
            case SUMMON_SPIRITSHOT: 
            case SPIRITSHOT: {
                this._type = EtcItemType.SHOT;
            }
        }
        this._type1 = ItemType1.ITEM_QUESTITEM_ADENA;
        this._type2 = ItemType2.OTHER;
        if (this.isQuestItem()) {
            this._type2 = ItemType2.QUEST;
        } else if (this.getId() == 57 || this.getId() == 5575) {
            this._type2 = ItemType2.MONEY;
        }
        this._handler = set.getString("handler", null);
        this._isBlessed = set.getBoolean("blessed", false);
        String capsuled_items = set.getString("capsuled_items", null);
        if (capsuled_items != null) {
            String[] split = capsuled_items.split(";");
            this._extractableItems = new ArrayList<L2ExtractableProduct>(split.length);
            for (String part : split) {
                if (part.trim().isEmpty()) continue;
                String[] data = part.split(",");
                if (data.length != 4) {
                    LOG.warn("Couldn't parse {} in capsuled_items! item {}!", (Object)part, (Object)this);
                    continue;
                }
                int itemId = Integer.parseInt(data[0]);
                int min = Integer.parseInt(data[1]);
                int max = Integer.parseInt(data[2]);
                double chance = Double.parseDouble(data[3]);
                if (max < min) {
                    LOG.warn("Max amount < Min amount in {}, item {}!", (Object)part, (Object)this);
                    continue;
                }
                L2ExtractableProduct product = new L2ExtractableProduct(itemId, min, max, chance);
                this._extractableItems.add(product);
            }
            ((ArrayList)this._extractableItems).trimToSize();
            if (this._handler == null) {
                LOG.warn("Item {} define capsuled_items but missing handler!", (Object)this);
                this._handler = "ExtractableItems";
            }
        } else {
            this._extractableItems = null;
        }
    }

    @Override
    public EtcItemType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    public String getHandlerName() {
        return this._handler;
    }

    public boolean isBlessed() {
        return this._isBlessed;
    }

    public List<L2ExtractableProduct> getExtractableItems() {
        return this._extractableItems;
    }
}

