/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.conditions.ConditionGameChance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcSkillSee;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.ItemType1;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2Weapon
extends L2Item {
    private static final Logger LOG = LoggerFactory.getLogger(L2Weapon.class);
    private final WeaponType _type;
    private final boolean _isMagicWeapon;
    private final int _rndDam;
    private final int _soulShotCount;
    private final int _spiritShotCount;
    private final int _mpConsume;
    private final int _baseAttackRange;
    private final int _baseAttackAngle;
    private SkillHolder _enchant4Skill = null;
    private final int _changeWeaponId;
    private SkillHolder _skillsOnMagic;
    private Condition _skillsOnMagicCondition = null;
    private SkillHolder _skillsOnCrit;
    private Condition _skillsOnCritCondition = null;
    private final int _reducedSoulshot;
    private final int _reducedSoulshotChance;
    private final int _reducedMpConsume;
    private final int _reducedMpConsumeChance;
    private final boolean _isForceEquip;
    private final boolean _isAttackWeapon;
    private final boolean _useWeaponSkillsOnly;

    public L2Weapon(StatsSet set) {
        super(set);
        int id;
        int chance;
        String[] info;
        this._type = WeaponType.valueOf(set.getString("weapon_type", "none").toUpperCase());
        this._type1 = ItemType1.WEAPON_RING_EARRING_NECKLACE;
        this._type2 = ItemType2.WEAPON;
        this._isMagicWeapon = set.getBoolean("is_magic_weapon", false);
        this._soulShotCount = set.getInt("soulshots", 0);
        this._spiritShotCount = set.getInt("spiritshots", 0);
        this._rndDam = set.getInt("random_damage", 0);
        this._mpConsume = set.getInt("mp_consume", 0);
        this._baseAttackRange = set.getInt("attack_range", 40);
        String[] damgeRange = set.getString("damage_range", "").split(";");
        this._baseAttackAngle = damgeRange.length > 1 && Util.isDigit(damgeRange[3]) ? Integer.parseInt(damgeRange[3]) : 120;
        String[] reduced_soulshots = set.getString("reduced_soulshot", "").split(",");
        this._reducedSoulshotChance = reduced_soulshots.length == 2 ? Integer.parseInt(reduced_soulshots[0]) : 0;
        this._reducedSoulshot = reduced_soulshots.length == 2 ? Integer.parseInt(reduced_soulshots[1]) : 0;
        String[] reduced_mpconsume = set.getString("reduced_mp_consume", "").split(",");
        this._reducedMpConsumeChance = reduced_mpconsume.length == 2 ? Integer.parseInt(reduced_mpconsume[0]) : 0;
        this._reducedMpConsume = reduced_mpconsume.length == 2 ? Integer.parseInt(reduced_mpconsume[1]) : 0;
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")).length == 2) {
            int id2 = 0;
            int level = 0;
            try {
                id2 = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                LOG.warn("Couldn't parse {} in weapon enchant skills! item {}!", (Object)skill, (Object)this);
            }
            if (id2 > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id2, level);
            }
        }
        if ((skill = set.getString("onmagic_skill", null)) != null) {
            info = skill.split("-");
            chance = set.getInt("onmagic_chance", 100);
            if (info.length == 2) {
                id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                }
                catch (Exception nfe) {
                    LOG.warn("Couldn't parse {} in weapon onmagic skills! item {}!", (Object)skill, (Object)this);
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnMagic = new SkillHolder(id, level);
                    this._skillsOnMagicCondition = new ConditionGameChance(chance);
                }
            }
        }
        if ((skill = set.getString("oncrit_skill", null)) != null) {
            info = skill.split("-");
            chance = set.getInt("oncrit_chance", 100);
            if (info.length == 2) {
                id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                }
                catch (Exception nfe) {
                    LOG.warn("Couldn't parse {} in weapon oncrit skills! item {}!", (Object)skill, (Object)this);
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnCrit = new SkillHolder(id, level);
                    this._skillsOnCritCondition = new ConditionGameChance(chance);
                }
            }
        }
        this._changeWeaponId = set.getInt("change_weaponId", 0);
        this._isForceEquip = set.getBoolean("isForceEquip", false);
        this._isAttackWeapon = set.getBoolean("isAttackWeapon", true);
        this._useWeaponSkillsOnly = set.getBoolean("useWeaponSkillsOnly", false);
    }

    @Override
    public WeaponType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    @Override
    public boolean isMagicWeapon() {
        return this._isMagicWeapon;
    }

    public int getSoulShotCount() {
        return this._soulShotCount;
    }

    public int getSpiritShotCount() {
        return this._spiritShotCount;
    }

    public int getReducedSoulShot() {
        return this._reducedSoulshot;
    }

    public int getReducedSoulShotChance() {
        return this._reducedSoulshotChance;
    }

    public int getRandomDamage() {
        return this._rndDam;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public int getBaseAttackRange() {
        return this._baseAttackRange;
    }

    public int getBaseAttackAngle() {
        return this._baseAttackAngle;
    }

    public int getReducedMpConsume() {
        return this._reducedMpConsume;
    }

    public int getReducedMpConsumeChance() {
        return this._reducedMpConsumeChance;
    }

    @Override
    public Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }

    public int getChangeWeaponId() {
        return this._changeWeaponId;
    }

    public boolean isForceEquip() {
        return this._isForceEquip;
    }

    public boolean isAttackWeapon() {
        return this._isAttackWeapon;
    }

    public boolean useWeaponSkillsOnly() {
        return this._useWeaponSkillsOnly;
    }

    public void castOnCriticalSkill(L2Character caster, L2Character target) {
        if (this._skillsOnCrit == null) {
            return;
        }
        Skill onCritSkill = this._skillsOnCrit.getSkill();
        if (this._skillsOnCritCondition != null && !this._skillsOnCritCondition.test(caster, target, onCritSkill)) {
            return;
        }
        if (!onCritSkill.checkCondition(caster, target, false)) {
            return;
        }
        onCritSkill.activateSkill(caster, target);
    }

    public void castOnMagicSkill(L2Character caster, L2Character target, Skill trigger) {
        if (this._skillsOnMagic == null) {
            return;
        }
        Skill onMagicSkill = this._skillsOnMagic.getSkill();
        if (trigger.isBad() != onMagicSkill.isBad()) {
            return;
        }
        if (trigger.isMagic() != onMagicSkill.isMagic()) {
            return;
        }
        if (trigger.isToggle()) {
            return;
        }
        if (caster.getAI().getCastTarget() != target) {
            return;
        }
        if (this._skillsOnMagicCondition != null && !this._skillsOnMagicCondition.test(caster, target, onMagicSkill)) {
            return;
        }
        if (!onMagicSkill.checkCondition(caster, target, false)) {
            return;
        }
        if (onMagicSkill.isBad() && Formulas.calcShldUse(caster, target, onMagicSkill) == 2) {
            return;
        }
        onMagicSkill.activateSkill(caster, target);
        if (caster instanceof L2PcInstance) {
            caster.getKnownList().getKnownObjects().values().stream().filter(Objects::nonNull).filter(L2Object::isNpc).filter(npc -> Util.checkIfInRange(1000, npc, caster, false)).forEach(npc -> EventDispatcher.getInstance().notifyEventAsync(new NpcSkillSee((L2Npc)npc, caster.getActingPlayer(), onMagicSkill, List.of(target), false), (ListenersContainer)npc));
        }
        if (caster.isPlayer()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_BEEN_ACTIVATED);
            sm.addSkillName(onMagicSkill);
            caster.sendPacket(sm);
        }
    }

    public boolean isRange() {
        return this.isBow() || this.isCrossBow();
    }

    public boolean isBow() {
        return this._type == WeaponType.BOW;
    }

    public boolean isCrossBow() {
        return this._type == WeaponType.CROSSBOW;
    }
}

