/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items.enchant;

import com.l2jserver.gameserver.model.holders.RangeChanceHolder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnchantItemGroup {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantItemGroup.class);
    private final List<RangeChanceHolder> _chances = new ArrayList<RangeChanceHolder>();
    private final String _name;

    public EnchantItemGroup(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void addChance(RangeChanceHolder holder) {
        this._chances.add(holder);
    }

    public double getChance(int index) {
        if (!this._chances.isEmpty()) {
            for (RangeChanceHolder holder : this._chances) {
                if (holder.getMin() > index || holder.getMax() < index) continue;
                return holder.getChance();
            }
            LOG.warn("Couldn't match proper chance for item group: {}", (Object)this._name, (Object)new IllegalStateException());
            return this._chances.getLast().getChance();
        }
        LOG.warn("Item group: {} doesn't have any chances!", (Object)this._name);
        return -1.0;
    }
}

