/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.olympiad.OlympiadAnnouncer;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Olympiad
extends ListenersContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Olympiad.class);
    private static final Logger LOG_OLYMPIAD = LoggerFactory.getLogger("olympiad");
    private static final Map<Integer, StatsSet> NOBLES = new ConcurrentHashMap<Integer, StatsSet>();
    private static final List<StatsSet> HEROES_TO_BE = new ArrayList<StatsSet>();
    private static final Map<Integer, Integer> NOBLES_RANK = new HashMap<Integer, Integer>();
    public static final String OLYMPIAD_HTML_PATH = "data/html/olympiad/";
    private static final String OLYMPIAD_LOAD_DATA = "SELECT current_cycle, period, olympiad_end, validation_end, next_weekly_change FROM olympiad_data WHERE id = 0";
    private static final String OLYMPIAD_SAVE_DATA = "INSERT INTO olympiad_data (id, current_cycle, period, olympiad_end, validation_end, next_weekly_change) VALUES (0,?,?,?,?,?) ON DUPLICATE KEY UPDATE current_cycle=?, period=?, olympiad_end=?, validation_end=?, next_weekly_change=?";
    private static final String OLYMPIAD_LOAD_NOBLES = "SELECT olympiad_nobles.charId, olympiad_nobles.class_id, characters.char_name, olympiad_nobles.olympiad_points, olympiad_nobles.competitions_done, olympiad_nobles.competitions_won, olympiad_nobles.competitions_lost, olympiad_nobles.competitions_drawn, olympiad_nobles.competitions_done_week, olympiad_nobles.competitions_done_week_classed, olympiad_nobles.competitions_done_week_non_classed, olympiad_nobles.competitions_done_week_team FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId";
    private static final String OLYMPIAD_SAVE_NOBLES = "INSERT INTO olympiad_nobles (`charId`, `class_id`, `olympiad_points`, `competitions_done`, `competitions_won`, `competitions_lost`, `competitions_drawn`, `competitions_done_week`, `competitions_done_week_classed`, `competitions_done_week_non_classed`, `competitions_done_week_team`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String OLYMPIAD_UPDATE_NOBLES = "UPDATE olympiad_nobles SET olympiad_points = ?, competitions_done = ?, competitions_won = ?, competitions_lost = ?, competitions_drawn = ?, competitions_done_week = ?, competitions_done_week_classed = ?, competitions_done_week_non_classed = ?, competitions_done_week_team = ? WHERE charId = ?";
    private static final String OLYMPIAD_GET_HEROES = "SELECT olympiad_nobles.charId, characters.char_name FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " AND olympiad_nobles.competitions_won > 0 ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC";
    private static final String GET_ALL_CLASSIFIED_NOBLESS = "SELECT charId from olympiad_nobles_eom WHERE competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " ORDER BY olympiad_points DESC, competitions_done DESC, competitions_won DESC";
    private static final String GET_EACH_CLASS_LEADER = "SELECT characters.char_name from olympiad_nobles_eom, characters WHERE characters.charId = olympiad_nobles_eom.charId AND olympiad_nobles_eom.class_id = ? AND olympiad_nobles_eom.competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " ORDER BY olympiad_nobles_eom.olympiad_points DESC, olympiad_nobles_eom.competitions_done DESC, olympiad_nobles_eom.competitions_won DESC LIMIT 10";
    private static final String GET_EACH_CLASS_LEADER_CURRENT = "SELECT characters.char_name from olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC LIMIT 10";
    private static final String GET_EACH_CLASS_LEADER_SOULHOUND = "SELECT characters.char_name from olympiad_nobles_eom, characters WHERE characters.charId = olympiad_nobles_eom.charId AND (olympiad_nobles_eom.class_id = ? OR olympiad_nobles_eom.class_id = 133) AND olympiad_nobles_eom.competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " ORDER BY olympiad_nobles_eom.olympiad_points DESC, olympiad_nobles_eom.competitions_done DESC, olympiad_nobles_eom.competitions_won DESC LIMIT 10";
    private static final String GET_EACH_CLASS_LEADER_CURRENT_SOULHOUND = "SELECT characters.char_name from olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND (olympiad_nobles.class_id = ? OR olympiad_nobles.class_id = 133) AND olympiad_nobles.competitions_done >= " + Configuration.olympiad().getMinMatchesForPoints() + " ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC LIMIT 10";
    private static final String OLYMPIAD_DELETE_ALL = "TRUNCATE olympiad_nobles";
    private static final String OLYMPIAD_MONTH_CLEAR = "TRUNCATE olympiad_nobles_eom";
    private static final String OLYMPIAD_MONTH_CREATE = "INSERT INTO olympiad_nobles_eom SELECT charId, class_id, olympiad_points, competitions_done, competitions_won, competitions_lost, competitions_drawn FROM olympiad_nobles";
    private static final int[] HERO_IDS = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 131, 132, 133, 134};
    public static final String CHAR_ID = "charId";
    public static final String CLASS_ID = "class_id";
    public static final String CHAR_NAME = "char_name";
    public static final String POINTS = "olympiad_points";
    public static final String COMP_DONE = "competitions_done";
    public static final String COMP_WON = "competitions_won";
    public static final String COMP_LOST = "competitions_lost";
    public static final String COMP_DRAWN = "competitions_drawn";
    public static final String COMP_DONE_WEEK = "competitions_done_week";
    public static final String COMP_DONE_WEEK_CLASSED = "competitions_done_week_classed";
    public static final String COMP_DONE_WEEK_NON_CLASSED = "competitions_done_week_non_classed";
    public static final String COMP_DONE_WEEK_TEAM = "competitions_done_week_team";
    private long _olympiadEnd;
    private long _validationEnd;
    private int _period;
    private long _nextWeeklyChange;
    private int _currentCycle;
    private long _compEnd;
    private Calendar _compStart;
    private static boolean _inCompPeriod;
    private ScheduledFuture<?> _scheduledOlympiadEnd;
    private ScheduledFuture<?> _scheduledWeeklyTask;
    private ScheduledFuture<?> _gameManager = null;
    private ScheduledFuture<?> _gameAnnouncer = null;

    protected Olympiad() {
        this.load();
        AntiFeedManager.getInstance().registerEvent(1);
        if (this._period == 0) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ResultSet rs;
        Statement s;
        Connection con;
        NOBLES.clear();
        boolean loaded = false;
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                s = con.createStatement();
                try {
                    rs = s.executeQuery(OLYMPIAD_LOAD_DATA);
                    try {
                        while (rs.next()) {
                            this._currentCycle = rs.getInt("current_cycle");
                            this._period = rs.getInt("period");
                            this._olympiadEnd = rs.getLong("olympiad_end");
                            this._validationEnd = rs.getLong("validation_end");
                            this._nextWeeklyChange = rs.getLong("next_weekly_change");
                            loaded = true;
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading olympiad data from database: ", e);
        }
        if (!loaded) {
            LOG.info("Failed to load data from database, trying to load from file.");
            if (Configuration.olympiad().getCurrentCycle() != null) {
                this._currentCycle = Configuration.olympiad().getCurrentCycle();
                this._period = Configuration.olympiad().getPeriod();
                this._olympiadEnd = Configuration.olympiad().getOlympiadEnd();
                this._validationEnd = Configuration.olympiad().getValidationEnd();
                this._nextWeeklyChange = Configuration.olympiad().getNextWeeklyChange();
            }
        }
        switch (this._period) {
            case 0: {
                if (this._olympiadEnd == 0L || this._olympiadEnd < Calendar.getInstance().getTimeInMillis()) {
                    this.setNewOlympiadEnd();
                    break;
                }
                this.scheduleWeeklyChange();
                break;
            }
            case 1: {
                if (this._validationEnd > Calendar.getInstance().getTimeInMillis()) {
                    this.loadNoblesRank();
                    ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), this.getMillisToValidationEnd());
                    break;
                }
                ++this._currentCycle;
                this._period = 0;
                this.deleteNobles();
                this.setNewOlympiadEnd();
                break;
            }
            default: {
                LOG.warn("Omg something went wrong in loading!! Period = {}", (Object)this._period);
                return;
            }
        }
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                s = con.createStatement();
                try {
                    rs = s.executeQuery(OLYMPIAD_LOAD_NOBLES);
                    try {
                        while (rs.next()) {
                            StatsSet statData = new StatsSet();
                            statData.set(CLASS_ID, rs.getInt(CLASS_ID));
                            statData.set(CHAR_NAME, rs.getString(CHAR_NAME));
                            statData.set(POINTS, rs.getInt(POINTS));
                            statData.set(COMP_DONE, rs.getInt(COMP_DONE));
                            statData.set(COMP_WON, rs.getInt(COMP_WON));
                            statData.set(COMP_LOST, rs.getInt(COMP_LOST));
                            statData.set(COMP_DRAWN, rs.getInt(COMP_DRAWN));
                            statData.set(COMP_DONE_WEEK, rs.getInt(COMP_DONE_WEEK));
                            statData.set(COMP_DONE_WEEK_CLASSED, rs.getInt(COMP_DONE_WEEK_CLASSED));
                            statData.set(COMP_DONE_WEEK_NON_CLASSED, rs.getInt(COMP_DONE_WEEK_NON_CLASSED));
                            statData.set(COMP_DONE_WEEK_TEAM, rs.getInt(COMP_DONE_WEEK_TEAM));
                            statData.set("to_save", false);
                            Olympiad.addNobleStats(rs.getInt(CHAR_ID), statData);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading noblesse data from database: ", e);
        }
        Olympiad olympiad = this;
        synchronized (olympiad) {
            LOG.info("Loading Olympiad System....");
            if (this._period == 0) {
                LOG.info("Currently in Olympiad Period");
            } else {
                LOG.info("Currently in Validation Period");
            }
            long milliToEnd = this._period == 0 ? this.getMillisToOlympiadEnd() : this.getMillisToValidationEnd();
            LOG.info("{} minutes until period ends", (Object)(milliToEnd / 60000L));
            if (this._period == 0) {
                milliToEnd = this.getMillisToWeekChange();
                LOG.info("Next weekly change is in {} minutes", (Object)(milliToEnd / 60000L));
            }
        }
        LOG.info("Loaded {} Nobles", (Object)NOBLES.size());
    }

    private void loadNoblesRank() {
        NOBLES_RANK.clear();
        HashMap<Integer, Integer> tmpPlace = new HashMap<Integer, Integer>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(GET_ALL_CLASSIFIED_NOBLESS);){
            int place = 1;
            while (rs.next()) {
                tmpPlace.put(rs.getInt(CHAR_ID), place++);
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading noblesse data from database for Ranking: ", e);
        }
        int rank1 = (int)Math.round((double)tmpPlace.size() * 0.01);
        int rank2 = (int)Math.round((double)tmpPlace.size() * 0.1);
        int rank3 = (int)Math.round((double)tmpPlace.size() * 0.25);
        int rank4 = (int)Math.round((double)tmpPlace.size() * 0.5);
        if (rank1 == 0) {
            rank1 = 1;
            ++rank2;
            ++rank3;
            ++rank4;
        }
        for (Map.Entry chr : tmpPlace.entrySet()) {
            if ((Integer)chr.getValue() <= rank1) {
                NOBLES_RANK.put((Integer)chr.getKey(), 1);
                continue;
            }
            if ((Integer)tmpPlace.get(chr.getKey()) <= rank2) {
                NOBLES_RANK.put((Integer)chr.getKey(), 2);
                continue;
            }
            if ((Integer)tmpPlace.get(chr.getKey()) <= rank3) {
                NOBLES_RANK.put((Integer)chr.getKey(), 3);
                continue;
            }
            if ((Integer)tmpPlace.get(chr.getKey()) <= rank4) {
                NOBLES_RANK.put((Integer)chr.getKey(), 4);
                continue;
            }
            NOBLES_RANK.put((Integer)chr.getKey(), 5);
        }
    }

    protected void init() {
        if (this._period == 1) {
            return;
        }
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, Configuration.olympiad().getStartHour());
        this._compStart.set(12, Configuration.olympiad().getStartMinute());
        this._compEnd = this._compStart.getTimeInMillis() + (long)Configuration.olympiad().getCompetitionPeriod();
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(HEROES_TO_BE), this.getMillisToOlympiadEnd());
        this.updateCompStatus();
    }

    protected static int getNobleCount() {
        return NOBLES.size();
    }

    protected static StatsSet getNobleStats(int playerId) {
        return NOBLES.get(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompStatus() {
        Olympiad olympiad = this;
        synchronized (olympiad) {
            long milliToStart = this.getMillisToCompBegin();
            double numSecs = (double)milliToStart / 1000.0 % 60.0;
            double countDown = ((double)milliToStart / 1000.0 - numSecs) / 60.0;
            int numMins = (int)Math.floor(countDown % 60.0);
            countDown = (countDown - (double)numMins) / 60.0;
            int numHours = (int)Math.floor(countDown % 24.0);
            int numDays = (int)Math.floor((countDown - (double)numHours) / 24.0);
            LOG.info("Competition Period Starts in {} days, {} hours and {} mins.", numDays, numHours, numMins);
            LOG.info("Event starts/started : {}", (Object)this._compStart.getTime());
        }
        ThreadPoolManager.getInstance().scheduleGeneral(() -> {
            long regEnd;
            if (this.isOlympiadEnd()) {
                return;
            }
            _inCompPeriod = true;
            Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_STARTED));
            LOG.info("Olympiad Game Started");
            if (Configuration.olympiad().logFights()) {
                LOG_OLYMPIAD.info("Result,Player1,Player2,Player1 HP,Player2 HP,Player1 Damage,Player2 Damage,Points,Classed");
            }
            this._gameManager = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(OlympiadGameManager.getInstance(), 30000L, 30000L);
            if (Configuration.olympiad().announceGames()) {
                this._gameAnnouncer = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new OlympiadAnnouncer(), 30000L, 500L);
            }
            if ((regEnd = this.getMillisToCompEnd() - 600000L) > 0L) {
                ThreadPoolManager.getInstance().scheduleGeneral(() -> Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_REGISTRATION_PERIOD_ENDED)), regEnd);
            }
            ThreadPoolManager.getInstance().scheduleGeneral(() -> {
                if (this.isOlympiadEnd()) {
                    return;
                }
                _inCompPeriod = false;
                Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_ENDED));
                LOG.info("Olympiad Game Ended");
                while (OlympiadGameManager.getInstance().isBattleStarted()) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._gameManager != null) {
                    this._gameManager.cancel(false);
                    this._gameManager = null;
                }
                if (this._gameAnnouncer != null) {
                    this._gameAnnouncer.cancel(false);
                    this._gameAnnouncer = null;
                }
                this.saveOlympiadStatus();
                this.init();
            }, this.getMillisToCompEnd());
        }, this.getMillisToCompBegin());
    }

    private long getMillisToOlympiadEnd() {
        return this._olympiadEnd - Calendar.getInstance().getTimeInMillis();
    }

    public void manualSelectHeroes() {
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(HEROES_TO_BE), 0L);
    }

    private long getMillisToValidationEnd() {
        if (this._validationEnd > Calendar.getInstance().getTimeInMillis()) {
            return this._validationEnd - Calendar.getInstance().getTimeInMillis();
        }
        return 10L;
    }

    public boolean isOlympiadEnd() {
        return this._period != 0;
    }

    private void setNewOlympiadEnd() {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_STARTED);
        sm.addInt(this._currentCycle);
        Broadcast.toAllOnlinePlayers(sm);
        Calendar currentTime = Calendar.getInstance();
        currentTime.add(2, 1);
        currentTime.set(5, 1);
        currentTime.set(9, 0);
        currentTime.set(10, 12);
        currentTime.set(12, 0);
        currentTime.set(13, 0);
        this._olympiadEnd = currentTime.getTimeInMillis();
        Calendar nextChange = Calendar.getInstance();
        this._nextWeeklyChange = nextChange.getTimeInMillis() + (long)Configuration.olympiad().getWeeklyPeriod();
        this.scheduleWeeklyChange();
    }

    public boolean inCompPeriod() {
        return _inCompPeriod;
    }

    private long getMillisToCompBegin() {
        if (this._compStart.getTimeInMillis() < Calendar.getInstance().getTimeInMillis() && this._compEnd > Calendar.getInstance().getTimeInMillis()) {
            return 10L;
        }
        if (this._compStart.getTimeInMillis() > Calendar.getInstance().getTimeInMillis()) {
            return this._compStart.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        }
        return this.setNewCompBegin();
    }

    private long setNewCompBegin() {
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, Configuration.olympiad().getStartHour());
        this._compStart.set(12, Configuration.olympiad().getStartMinute());
        this._compStart.add(11, 24);
        this._compEnd = this._compStart.getTimeInMillis() + (long)Configuration.olympiad().getCompetitionPeriod();
        LOG.info("New Schedule @ " + String.valueOf(this._compStart.getTime()));
        return this._compStart.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
    }

    protected long getMillisToCompEnd() {
        return this._compEnd - Calendar.getInstance().getTimeInMillis();
    }

    private long getMillisToWeekChange() {
        if (this._nextWeeklyChange > Calendar.getInstance().getTimeInMillis()) {
            return this._nextWeeklyChange - Calendar.getInstance().getTimeInMillis();
        }
        return 10L;
    }

    private void scheduleWeeklyChange() {
        this._scheduledWeeklyTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(() -> {
            this.addWeeklyPoints();
            LOG.info("Added weekly points to nobles");
            this.resetWeeklyMatches();
            LOG.info("Reset weekly matches to nobles");
            Calendar nextChange = Calendar.getInstance();
            this._nextWeeklyChange = nextChange.getTimeInMillis() + (long)Configuration.olympiad().getWeeklyPeriod();
        }, this.getMillisToWeekChange(), Configuration.olympiad().getWeeklyPeriod());
    }

    private synchronized void addWeeklyPoints() {
        if (this._period == 1) {
            return;
        }
        for (StatsSet nobleInfo : NOBLES.values()) {
            int currentPoints = nobleInfo.getInt(POINTS);
            nobleInfo.set(POINTS, currentPoints += Configuration.olympiad().getWeeklyPoints());
        }
    }

    private synchronized void resetWeeklyMatches() {
        if (this._period == 1) {
            return;
        }
        for (StatsSet nobleInfo : NOBLES.values()) {
            nobleInfo.set(COMP_DONE_WEEK, 0);
            nobleInfo.set(COMP_DONE_WEEK_CLASSED, 0);
            nobleInfo.set(COMP_DONE_WEEK_NON_CLASSED, 0);
            nobleInfo.set(COMP_DONE_WEEK_TEAM, 0);
        }
    }

    public int getCurrentCycle() {
        return this._currentCycle;
    }

    public int getPeriod() {
        return this._period;
    }

    public boolean playerInStadia(L2PcInstance player) {
        return ZoneManager.getInstance().getOlympiadStadium(player) != null;
    }

    private synchronized void saveNobleData() {
        if (NOBLES.isEmpty()) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            for (Map.Entry<Integer, StatsSet> entry : NOBLES.entrySet()) {
                StatsSet nobleInfo = entry.getValue();
                if (nobleInfo == null) continue;
                int charId = entry.getKey();
                int classId = nobleInfo.getInt(CLASS_ID);
                int points = nobleInfo.getInt(POINTS);
                int compDone = nobleInfo.getInt(COMP_DONE);
                int compWon = nobleInfo.getInt(COMP_WON);
                int compLost = nobleInfo.getInt(COMP_LOST);
                int compDrawn = nobleInfo.getInt(COMP_DRAWN);
                int compDoneWeek = nobleInfo.getInt(COMP_DONE_WEEK);
                int compDoneWeekClassed = nobleInfo.getInt(COMP_DONE_WEEK_CLASSED);
                int compDoneWeekNonClassed = nobleInfo.getInt(COMP_DONE_WEEK_NON_CLASSED);
                int compDoneWeekTeam = nobleInfo.getInt(COMP_DONE_WEEK_TEAM);
                boolean toSave = nobleInfo.getBoolean("to_save");
                PreparedStatement ps = con.prepareStatement(toSave ? OLYMPIAD_SAVE_NOBLES : OLYMPIAD_UPDATE_NOBLES);
                try {
                    if (toSave) {
                        ps.setInt(1, charId);
                        ps.setInt(2, classId);
                        ps.setInt(3, points);
                        ps.setInt(4, compDone);
                        ps.setInt(5, compWon);
                        ps.setInt(6, compLost);
                        ps.setInt(7, compDrawn);
                        ps.setInt(8, compDoneWeek);
                        ps.setInt(9, compDoneWeekClassed);
                        ps.setInt(10, compDoneWeekNonClassed);
                        ps.setInt(11, compDoneWeekTeam);
                        nobleInfo.set("to_save", false);
                    } else {
                        ps.setInt(1, points);
                        ps.setInt(2, compDone);
                        ps.setInt(3, compWon);
                        ps.setInt(4, compLost);
                        ps.setInt(5, compDrawn);
                        ps.setInt(6, compDoneWeek);
                        ps.setInt(7, compDoneWeekClassed);
                        ps.setInt(8, compDoneWeekNonClassed);
                        ps.setInt(9, compDoneWeekTeam);
                        ps.setInt(10, charId);
                    }
                    ps.execute();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to save noblesse data to database: ", e);
        }
    }

    public void saveOlympiadStatus() {
        this.saveNobleData();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(OLYMPIAD_SAVE_DATA);){
            ps.setInt(1, this._currentCycle);
            ps.setInt(2, this._period);
            ps.setLong(3, this._olympiadEnd);
            ps.setLong(4, this._validationEnd);
            ps.setLong(5, this._nextWeeklyChange);
            ps.setInt(6, this._currentCycle);
            ps.setInt(7, this._period);
            ps.setLong(8, this._olympiadEnd);
            ps.setLong(9, this._validationEnd);
            ps.setLong(10, this._nextWeeklyChange);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Failed to save olympiad data to database: ", e);
        }
    }

    private void updateMonthlyData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s1 = con.createStatement();
             Statement s2 = con.createStatement();){
            s1.executeUpdate(OLYMPIAD_MONTH_CLEAR);
            s2.executeUpdate(OLYMPIAD_MONTH_CREATE);
        }
        catch (Exception e) {
            LOG.error("Failed to update monthly noblesse data: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sortHeroesToBe() {
        if (this._period != 1) {
            return;
        }
        LOG_OLYMPIAD.info("Noble,charid,classid,compDone,points");
        for (Map.Entry<Integer, StatsSet> entry : NOBLES.entrySet()) {
            StatsSet nobleInfo = entry.getValue();
            if (nobleInfo == null) continue;
            LOG_OLYMPIAD.info("{}, {}, {}, {}, {}", nobleInfo.getString(CHAR_NAME), entry.getKey(), nobleInfo.getInt(CLASS_ID), nobleInfo.getInt(COMP_DONE), nobleInfo.getInt(POINTS));
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(OLYMPIAD_GET_HEROES);){
            StatsSet hero;
            ArrayList<StatsSet> soulHounds = new ArrayList<StatsSet>();
            for (int element : HERO_IDS) {
                ps.setInt(1, element);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) continue;
                    hero = new StatsSet();
                    hero.set(CLASS_ID, element);
                    hero.set(CHAR_ID, rs.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, rs.getString(CHAR_NAME));
                    if (element == 132 || element == 133) {
                        hero = NOBLES.get(hero.getInt(CHAR_ID));
                        hero.set(CHAR_ID, rs.getInt(CHAR_ID));
                        soulHounds.add(hero);
                        continue;
                    }
                    LOG_OLYMPIAD.info("Hero {} {} {}", hero.getString(CHAR_NAME), hero.getInt(CHAR_ID), hero.getInt(CLASS_ID));
                    HEROES_TO_BE.add(hero);
                }
            }
            switch (soulHounds.size()) {
                case 1: {
                    hero = new StatsSet();
                    StatsSet winner = (StatsSet)soulHounds.getFirst();
                    hero.set(CLASS_ID, winner.getInt(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    LOG_OLYMPIAD.info("Hero {} {} {}", hero.getString(CHAR_NAME), hero.getInt(CHAR_ID), hero.getInt(CLASS_ID));
                    HEROES_TO_BE.add(hero);
                    return;
                }
                case 2: {
                    hero = new StatsSet();
                    StatsSet hero1 = (StatsSet)soulHounds.get(0);
                    StatsSet hero2 = (StatsSet)soulHounds.get(1);
                    int hero1Points = hero1.getInt(POINTS);
                    int hero2Points = hero2.getInt(POINTS);
                    int hero1Comps = hero1.getInt(COMP_DONE);
                    int hero2Comps = hero2.getInt(COMP_DONE);
                    int hero1Wins = hero1.getInt(COMP_WON);
                    int hero2Wins = hero2.getInt(COMP_WON);
                    StatsSet winner = hero1Points > hero2Points ? hero1 : (hero2Points > hero1Points ? hero2 : (hero1Comps > hero2Comps ? hero1 : (hero2Comps > hero1Comps ? hero2 : (hero1Wins > hero2Wins ? hero1 : hero2))));
                    hero.set(CLASS_ID, winner.getInt(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    LOG_OLYMPIAD.info("Hero {} {} {}", hero.getString(CHAR_NAME), hero.getInt(CHAR_ID), hero.getInt(CLASS_ID));
                    HEROES_TO_BE.add(hero);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOG.warn("Couldn't load heroes from DB");
        }
    }

    public List<String> getClassLeaderBoard(int classId) {
        ArrayList<String> names = new ArrayList<String>();
        String query = Configuration.olympiad().showMonthlyWinners() ? (classId == 132 ? GET_EACH_CLASS_LEADER_SOULHOUND : GET_EACH_CLASS_LEADER) : (classId == 132 ? GET_EACH_CLASS_LEADER_CURRENT_SOULHOUND : GET_EACH_CLASS_LEADER_CURRENT);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, classId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    names.add(rs.getString(CHAR_NAME));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't load olympiad leaders from DB!");
        }
        return names;
    }

    public int getNoblessePasses(L2PcInstance player, boolean clear) {
        if (player == null || this._period != 1 || NOBLES_RANK.isEmpty()) {
            return 0;
        }
        int objId = player.getObjectId();
        if (!NOBLES_RANK.containsKey(objId)) {
            return 0;
        }
        StatsSet noble = NOBLES.get(objId);
        if (noble == null || noble.getInt(POINTS) == 0) {
            return 0;
        }
        int rank = NOBLES_RANK.get(objId);
        int points = player.isHero() || Hero.getInstance().isUnclaimedHero(player.getObjectId()) ? Configuration.olympiad().getHeroPoints() : 0;
        switch (rank) {
            case 1: {
                points += Configuration.olympiad().getRank1Points();
                break;
            }
            case 2: {
                points += Configuration.olympiad().getRank2Points();
                break;
            }
            case 3: {
                points += Configuration.olympiad().getRank3Points();
                break;
            }
            case 4: {
                points += Configuration.olympiad().getRank4Points();
                break;
            }
            default: {
                points += Configuration.olympiad().getRank5Points();
            }
        }
        if (clear) {
            noble.set(POINTS, 0);
        }
        return points *= Configuration.olympiad().getGPPerPoint();
    }

    public int getNoblePoints(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(POINTS);
    }

    public int getLastNobleOlympiadPoints(int objId) {
        int result = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT olympiad_points FROM olympiad_nobles_eom WHERE charId = ?");){
            ps.setInt(1, objId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not load last olympiad points:", e);
        }
        return result;
    }

    public int getCompetitionDone(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_DONE);
    }

    public int getCompetitionWon(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_WON);
    }

    public int getCompetitionLost(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_LOST);
    }

    public int getCompetitionDoneWeek(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_DONE_WEEK);
    }

    public int getCompetitionDoneWeekClassed(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_DONE_WEEK_CLASSED);
    }

    public int getCompetitionDoneWeekNonClassed(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_DONE_WEEK_NON_CLASSED);
    }

    public int getCompetitionDoneWeekTeam(int objId) {
        if (!NOBLES.containsKey(objId)) {
            return 0;
        }
        return NOBLES.get(objId).getInt(COMP_DONE_WEEK_TEAM);
    }

    public int getRemainingWeeklyMatches(int objId) {
        return Math.max(Configuration.olympiad().getMaxWeeklyMatches() - this.getCompetitionDoneWeek(objId), 0);
    }

    public int getRemainingWeeklyMatchesClassed(int objId) {
        return Math.max(Configuration.olympiad().getMaxWeeklyMatchesClassed() - this.getCompetitionDoneWeekClassed(objId), 0);
    }

    public int getRemainingWeeklyMatchesNonClassed(int objId) {
        return Math.max(Configuration.olympiad().getMaxWeeklyMatchesNonClassed() - this.getCompetitionDoneWeekNonClassed(objId), 0);
    }

    public int getRemainingWeeklyMatchesTeam(int objId) {
        return Math.max(Configuration.olympiad().getMaxWeeklyMatchesTeam() - this.getCompetitionDoneWeekTeam(objId), 0);
    }

    private void deleteNobles() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate(OLYMPIAD_DELETE_ALL);
        }
        catch (Exception e) {
            LOG.warn("Couldn't delete nobles from DB!");
        }
        NOBLES.clear();
    }

    protected static StatsSet addNobleStats(int charId, StatsSet data) {
        return NOBLES.put(charId, data);
    }

    public static Olympiad getInstance() {
        return SingletonHolder.INSTANCE;
    }

    protected class ValidationEndTask
    implements Runnable {
        protected ValidationEndTask() {
        }

        @Override
        public void run() {
            Broadcast.toAllOnlinePlayers("Olympiad Validation Period has ended");
            Olympiad.this._period = 0;
            ++Olympiad.this._currentCycle;
            Olympiad.this.deleteNobles();
            Olympiad.this.setNewOlympiadEnd();
            Olympiad.this.init();
        }
    }

    protected class OlympiadEndTask
    implements Runnable {
        private final List<StatsSet> _heroesToBe;

        public OlympiadEndTask(List<StatsSet> heroesToBe) {
            this._heroesToBe = heroesToBe;
        }

        @Override
        public void run() {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_ENDED);
            sm.addInt(Olympiad.this._currentCycle);
            Broadcast.toAllOnlinePlayers(sm);
            Broadcast.toAllOnlinePlayers("Olympiad Validation Period has began");
            if (Olympiad.this._scheduledWeeklyTask != null) {
                Olympiad.this._scheduledWeeklyTask.cancel(true);
            }
            Olympiad.this.saveNobleData();
            Olympiad.this._period = 1;
            Olympiad.this.sortHeroesToBe();
            Hero.getInstance().resetData();
            Hero.getInstance().computeNewHeroes(this._heroesToBe);
            Olympiad.this.saveOlympiadStatus();
            Olympiad.this.updateMonthlyData();
            Calendar validationEnd = Calendar.getInstance();
            Olympiad.this._validationEnd = validationEnd.getTimeInMillis() + (long)Configuration.olympiad().getValidationPeriod();
            Olympiad.this.loadNoblesRank();
            ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), Olympiad.this.getMillisToValidationEnd());
        }
    }

    private static class SingletonHolder {
        protected static final Olympiad INSTANCE = new Olympiad();

        private SingletonHolder() {
        }
    }
}

