/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.enums.QuestType;
import com.l2jserver.gameserver.enums.audio.IAudio;
import com.l2jserver.gameserver.enums.audio.Sound;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.AbstractScript;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.network.serverpackets.ExShowQuestMark;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.TutorialCloseHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialEnableClientEvent;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowQuestionMark;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuestState {
    private static final Logger LOG = LoggerFactory.getLogger(QuestState.class);
    private final String _questName;
    private final L2PcInstance _player;
    private int _state;
    private Map<String, String> _vars;
    private boolean _isExitQuestOnCleanUp = false;

    public QuestState(Quest quest, L2PcInstance player, int state) {
        this._questName = quest.getName();
        this._player = player;
        this._state = state;
        player.setQuestState(this);
    }

    public String getQuestName() {
        return this._questName;
    }

    public Quest getQuest() {
        return QuestManager.getInstance().getQuest(this._questName);
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public int getState() {
        return this._state;
    }

    public boolean isCreated() {
        return this._state == 0;
    }

    public boolean isStarted() {
        return this._state == 1;
    }

    public boolean isCompleted() {
        return this._state == 2;
    }

    public boolean setState(int state) {
        return this.setState(state, true);
    }

    public boolean setState(int state, boolean saveInDb) {
        if (this._state == state) {
            return false;
        }
        boolean newQuest = this.isCreated();
        this._state = state;
        if (saveInDb) {
            if (newQuest) {
                Quest.createQuestInDb(this);
            } else {
                Quest.updateQuestInDb(this);
            }
        }
        this._player.sendPacket(new QuestList());
        return true;
    }

    public String setInternal(String var, String val) {
        if (this._vars == null) {
            this._vars = new HashMap<String, String>();
        }
        if (val == null) {
            val = "";
        }
        this._vars.put(var, val);
        return val;
    }

    public String set(String var, int val) {
        return this.set(var, Integer.toString(val));
    }

    public String set(String var, String val) {
        String old;
        if (this._vars == null) {
            this._vars = new HashMap<String, String>();
        }
        if (val == null) {
            val = "";
        }
        if ((old = this._vars.put(var, val)) != null) {
            Quest.updateQuestVarInDb(this, var, val);
        } else {
            Quest.createQuestVarInDb(this, var, val);
        }
        if ("cond".equals(var)) {
            try {
                int previousVal;
                try {
                    previousVal = Integer.parseInt(old);
                }
                catch (Exception ex) {
                    previousVal = 0;
                }
                this.setCond(Integer.parseInt(val), previousVal);
            }
            catch (Exception e) {
                LOG.warn("{}, {} cond [{}] is not an integer. Value stored, but no packet was sent: {}", this._player.getName(), this.getQuestName(), val, e.getMessage(), e);
            }
        }
        return val;
    }

    private void setCond(int cond, int old) {
        if (cond == old) {
            return;
        }
        int completedStateFlags = 0;
        if (cond < 3 || cond > 31) {
            this.unset("__compltdStateFlags");
        } else {
            completedStateFlags = this.getInt("__compltdStateFlags");
        }
        if (completedStateFlags == 0) {
            if (cond > old + 1) {
                completedStateFlags = -2147483647;
                completedStateFlags |= (1 << old) - 1;
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
            }
        } else if (cond < old) {
            if ((completedStateFlags &= (1 << cond) - 1) == (1 << cond) - 1) {
                this.unset("__compltdStateFlags");
            } else {
                this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 0x80000001));
            }
        } else {
            this.set("__compltdStateFlags", String.valueOf(completedStateFlags |= 1 << cond - 1));
        }
        this._player.sendPacket(new QuestList());
        Quest q = this.getQuest();
        if (!q.isCustomQuest() && cond > 0) {
            this._player.sendPacket(new ExShowQuestMark(q.getId()));
        }
    }

    public String unset(String var) {
        if (this._vars == null) {
            return null;
        }
        String old = this._vars.remove(var);
        if (old != null) {
            Quest.deleteQuestVarInDb(this, var);
        }
        return old;
    }

    public void saveGlobalQuestVar(String var, String value) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO character_quest_global_data (charId, var, value) VALUES (?, ?, ?)");){
            ps.setInt(1, this._player.getObjectId());
            ps.setString(2, var);
            ps.setString(3, value);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not insert player's global quest variable: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String getGlobalQuestVar(String var) {
        String result = "";
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT value FROM character_quest_global_data WHERE charId = ? AND var = ?");){
            ps.setInt(1, this._player.getObjectId());
            ps.setString(2, var);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not load player's global quest variable: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    public void deleteGlobalQuestVar(String var) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId = ? AND var = ?");){
            ps.setInt(1, this._player.getObjectId());
            ps.setString(2, var);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not delete player's global quest variable; charId = {}, variable name = {}. Exception: {}", this._player.getObjectId(), var, e.getMessage(), e);
        }
    }

    public String get(String var) {
        if (this._vars == null) {
            return null;
        }
        return this._vars.get(var);
    }

    public int getInt(String var) {
        if (this._vars == null) {
            return -1;
        }
        String variable = this._vars.get(var);
        if (variable == null || variable.isEmpty()) {
            return -1;
        }
        int varint = -1;
        try {
            varint = Integer.parseInt(variable);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Quest {}, method getInt({}), tried to parse a non-integer value ({}). Char Id: {}", this.getQuestName(), var, variable, this._player.getObjectId(), nfe);
        }
        return varint;
    }

    public boolean isCond(int condition) {
        return this.getInt("cond") == condition;
    }

    public QuestState setCond(int value) {
        if (this.isStarted()) {
            this.set("cond", Integer.toString(value));
        }
        return this;
    }

    public int getCond() {
        if (this.isStarted()) {
            return this.getInt("cond");
        }
        return 0;
    }

    public boolean isSet(String variable) {
        return this.get(variable) != null;
    }

    public QuestState setCond(int value, boolean playQuestMiddle) {
        if (!this.isStarted()) {
            return this;
        }
        this.set("cond", String.valueOf(value));
        if (playQuestMiddle) {
            AbstractScript.playSound(this._player, Sound.ITEMSOUND_QUEST_MIDDLE);
        }
        return this;
    }

    public QuestState setMemoState(int value) {
        this.set("memoState", String.valueOf(value));
        return this;
    }

    public int getMemoState() {
        if (this.isStarted()) {
            return this.getInt("memoState");
        }
        return -1;
    }

    public boolean hasMemoState() {
        return this.getMemoState() > 0;
    }

    public boolean isMemoState(int memoState) {
        return this.getInt("memoState") == memoState;
    }

    public String removeMemo() {
        return this.unset("memoState");
    }

    public int getMemoStateEx(int slot) {
        if (this.isStarted()) {
            return this.getInt("memoStateEx" + slot);
        }
        return 0;
    }

    public QuestState setMemoStateEx(int slot, long value) {
        this.set("memoStateEx" + slot, String.valueOf(value));
        return this;
    }

    public boolean isMemoStateEx(int slot, int memoStateEx) {
        return this.getMemoStateEx(slot) == memoStateEx;
    }

    public void addNotifyOfDeath(L2Character character) {
        if (!(character instanceof L2PcInstance)) {
            return;
        }
        ((L2PcInstance)character).addNotifyQuestOfDeath(this);
    }

    public long getQuestItemsCount(int itemId) {
        return AbstractScript.getQuestItemsCount(this._player, itemId);
    }

    public boolean hasQuestItems(int itemId) {
        return AbstractScript.hasQuestItems(this._player, itemId);
    }

    public boolean hasQuestItems(int ... itemIds) {
        return AbstractScript.hasQuestItems(this._player, itemIds);
    }

    public int getEnchantLevel(int itemId) {
        return AbstractScript.getEnchantLevel(this._player, itemId);
    }

    public void giveAdena(long count, boolean applyRates) {
        this.giveItems(57, count, applyRates ? 0 : 1);
    }

    public void rewardItems(ItemHolder item) {
        AbstractScript.rewardItems(this._player, item);
    }

    public void rewardItems(int itemId, long count) {
        AbstractScript.rewardItems(this._player, itemId, count);
    }

    public void giveItems(int itemId, long count) {
        AbstractScript.giveItems(this._player, itemId, count, 0);
    }

    public void giveItems(ItemHolder holder) {
        AbstractScript.giveItems(this._player, holder.getId(), holder.getCount(), 0);
    }

    public void giveItems(int itemId, long count, int enchantlevel) {
        AbstractScript.giveItems(this._player, itemId, count, enchantlevel);
    }

    public void giveItems(int itemId, long count, byte attributeId, int attributeLevel) {
        AbstractScript.giveItems(this._player, itemId, count, attributeId, attributeLevel);
    }

    @Deprecated
    public boolean giveItemRandomly(int itemId, long amount, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(this._player, null, itemId, amount, limit, dropChance, playSound);
    }

    @Deprecated
    public boolean giveItemRandomly(L2Npc npc, int itemId, long amount, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(this._player, npc, itemId, amount, limit, dropChance, playSound);
    }

    @Deprecated
    public boolean giveItemRandomly(L2Npc npc, int itemId, long minAmount, long maxAmount, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(this._player, npc, itemId, minAmount, maxAmount, limit, dropChance, playSound);
    }

    public void addRadar(int x, int y, int z) {
        this._player.getRadar().addMarker(x, y, z);
    }

    public void removeRadar(int x, int y, int z) {
        this._player.getRadar().removeMarker(x, y, z);
    }

    public void clearRadar() {
        this._player.getRadar().removeAllMarkers();
    }

    public void takeItems(int itemId, long count) {
        AbstractScript.takeItems(this._player, itemId, count);
    }

    public void playSound(IAudio audio) {
        AbstractScript.playSound(this._player, audio);
    }

    public void addExpAndSp(int exp, int sp) {
        AbstractScript.addExpAndSp(this._player, exp, sp);
    }

    public int getItemEquipped(int loc) {
        return AbstractScript.getItemEquipped(this._player, loc);
    }

    public boolean isExitQuestOnCleanUp() {
        return this._isExitQuestOnCleanUp;
    }

    public void setIsExitQuestOnCleanUp(boolean isExitQuestOnCleanUp) {
        this._isExitQuestOnCleanUp = isExitQuestOnCleanUp;
    }

    public void startQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this._player, false);
    }

    public void startQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this._player, false);
    }

    public void startRepeatingQuestTimer(String name, long time) {
        this.getQuest().startQuestTimer(name, time, null, this._player, true);
    }

    public void startRepeatingQuestTimer(String name, long time, L2Npc npc) {
        this.getQuest().startQuestTimer(name, time, npc, this._player, true);
    }

    public QuestTimer getQuestTimer(String name) {
        return this.getQuest().getQuestTimer(name, null, this._player);
    }

    public L2Npc addSpawn(int npcId) {
        return this.addSpawn(npcId, this._player.getX(), this._player.getY(), this._player.getZ(), 0, false, 0, false);
    }

    public L2Npc addSpawn(int npcId, int despawnDelay) {
        return this.addSpawn(npcId, this._player.getX(), this._player.getY(), this._player.getZ(), 0, false, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z) {
        return this.addSpawn(npcId, x, y, z, 0, false, 0, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int despawnDelay) {
        return this.addSpawn(npcId, x, y, z, 0, false, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), true, 0, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), true, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, L2Character cha, boolean randomOffset, int despawnDelay) {
        return this.addSpawn(npcId, cha.getX(), cha.getY(), cha.getZ(), cha.getHeading(), randomOffset, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay) {
        return this.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false);
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn);
    }

    public String showHtmlFile(String filename) {
        return this.showHtmlFile(filename, null);
    }

    public String showHtmlFile(String filename, L2Npc npc) {
        return this.getQuest().showHtmlFile(this._player, filename, npc);
    }

    public QuestState startQuest() {
        return this.startQuest(true);
    }

    public QuestState startQuest(boolean playSound) {
        return this.startQuest(playSound, 1);
    }

    public QuestState startQuest(boolean playSound, int cond) {
        if (this.isCreated() && !this.getQuest().isCustomQuest()) {
            this.set("cond", cond);
            this.setState(1);
            if (playSound) {
                this.playSound(Sound.ITEMSOUND_QUEST_ACCEPT);
            }
        }
        return this;
    }

    public QuestState exitQuest(QuestType type) {
        if (type == QuestType.DAILY) {
            this.exitQuest(false);
            this.setRestartTime();
        } else {
            this.exitQuest(type == QuestType.REPEATABLE);
        }
        return this;
    }

    public QuestState exitQuest(QuestType type, boolean playExitQuest) {
        this.exitQuest(type);
        if (playExitQuest) {
            this.playSound(Sound.ITEMSOUND_QUEST_FINISH);
        }
        return this;
    }

    public QuestState exitQuest(boolean repeatable) {
        this._player.removeNotifyQuestOfDeath(this);
        if (!this.isStarted()) {
            return this;
        }
        this.getQuest().removeRegisteredQuestItems(this._player);
        Quest.deleteQuestInDb(this, repeatable);
        if (repeatable) {
            this._player.delQuestState(this.getQuestName());
            this._player.sendPacket(new QuestList());
        } else {
            this.setState(2);
        }
        this._vars = null;
        return this;
    }

    public QuestState exitQuest(boolean repeatable, boolean playExitQuest) {
        this.exitQuest(repeatable);
        if (playExitQuest) {
            this.playSound(Sound.ITEMSOUND_QUEST_FINISH);
        }
        return this;
    }

    public void setRestartTime() {
        Calendar reDo = Calendar.getInstance();
        if (reDo.get(11) >= this.getQuest().getResetHour()) {
            reDo.add(5, 1);
        }
        reDo.set(11, this.getQuest().getResetHour());
        reDo.set(12, this.getQuest().getResetMinutes());
        this.set("restartTime", String.valueOf(reDo.getTimeInMillis()));
    }

    public boolean isNowAvailable() {
        String val = this.get("restartTime");
        return !Util.isDigit(val) || Long.parseLong(val) <= System.currentTimeMillis();
    }

    public void setNRMemo(L2PcInstance talker, int value) {
        this.set("NRmemo", String.valueOf(value));
    }

    public void removeNRMemo(L2PcInstance talker, int value) {
        this.unset("NRmemo");
    }

    public void setNRMemoState(L2PcInstance talker, int slot, int value) {
        this.set("NRmemoState" + slot, String.valueOf(value));
    }

    public int getNRMemoState(L2PcInstance talker, int slot) {
        return this.getInt("NRmemoState" + slot);
    }

    public void setNRMemoStateEx(L2PcInstance talker, int slot, int unknown, int value) {
        this.set("NRmemoStateEx" + slot, String.valueOf(value));
    }

    public int getNRMemoStateEx(L2PcInstance talker, int slot, int unknown) {
        return this.getInt("NRmemoStateEx" + slot);
    }

    public boolean haveNRMemo(L2PcInstance talker, int slot) {
        return this.getInt("NRmemo") == slot;
    }

    public void setNRFlagJournal(L2PcInstance talker, int questId, int flagId) {
        this.set("NRFlagJournal", String.valueOf(flagId));
    }

    public void setFlagJournal(int flagId) {
        this.set("FlagJournal", String.valueOf(flagId));
    }

    public void resetFlagJournal(int flagId) {
        this.unset("FlagJournal");
    }

    public int getDominionWarState(int castleId) {
        return TerritoryWarManager.getInstance().isTWInProgress() ? 5 : 0;
    }

    public void enableTutorialEvent(L2PcInstance talker, int state) {
        talker.sendPacket(new TutorialEnableClientEvent(state));
    }

    public int getDominionSiegeID(L2PcInstance talker) {
        return TerritoryWarManager.getInstance().getRegisteredTerritoryId(talker);
    }

    public void showQuestionMark(L2PcInstance talker, int number) {
        talker.sendPacket(new TutorialShowQuestionMark(number));
    }

    public void showQuestionMark(int number) {
        this._player.sendPacket(new TutorialShowQuestionMark(number));
    }

    public void closeTutorialHtml(L2PcInstance player) {
        player.sendPacket(TutorialCloseHtml.STATIC_PACKET);
    }
}

