/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.model.actor.L2Character;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SkillChannelized {
    private final Map<Integer, Map<Integer, L2Character>> _channelizers = new ConcurrentHashMap<Integer, Map<Integer, L2Character>>();

    public void addChannelizer(int skillId, L2Character channelizer) {
        this._channelizers.computeIfAbsent(skillId, k -> new ConcurrentHashMap()).put(channelizer.getObjectId(), channelizer);
    }

    public void removeChannelizer(int skillId, L2Character channelizer) {
        this.getChannelizers(skillId).remove(channelizer.getObjectId());
    }

    public int getChannerlizersSize(int skillId) {
        return this.getChannelizers(skillId).size();
    }

    public Map<Integer, L2Character> getChannelizers(int skillId) {
        return this._channelizers.getOrDefault(skillId, Collections.emptyMap());
    }

    public void abortChannelization() {
        for (Map<Integer, L2Character> map : this._channelizers.values()) {
            for (L2Character channelizer : map.values()) {
                channelizer.abortCast();
            }
        }
        this._channelizers.clear();
    }

    public boolean isChannelized() {
        for (Map<Integer, L2Character> map : this._channelizers.values()) {
            if (map.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

