/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.AffectScope;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.util.Util;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillChannelizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SkillChannelizer.class);
    private final L2Character _channelizer;
    private List<L2Character> _channelized;
    private L2Character _initialChannelized;
    private Skill _skill;
    private volatile ScheduledFuture<?> _task = null;

    public SkillChannelizer(L2Character channelizer) {
        this._channelizer = channelizer;
    }

    public L2Character getChannelizer() {
        return this._channelizer;
    }

    public List<L2Character> getChannelized() {
        return this._channelized;
    }

    public boolean hasChannelized() {
        return this._channelized != null;
    }

    public void startChanneling(Skill skill) {
        List<L2Object> creatures;
        if (this.isChanneling()) {
            LOG.warn("Character: {} is attempting to channel skill but he already does!", (Object)this._channelizer);
            return;
        }
        if (skill.getAffectScope() == AffectScope.SINGLE && !(creatures = skill.getTargets(this._channelizer)).isEmpty()) {
            L2Object creature = creatures.getFirst();
            this._initialChannelized = (L2Character)creature;
            this._initialChannelized.getSkillChannelized().addChannelizer(skill.getChannelingSkillId(), this.getChannelizer());
        }
        this._skill = skill;
        this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, skill.getChannelingTickInitialDelay(), skill.getChannelingTickInterval());
    }

    public void stopChanneling() {
        if (!this.isChanneling()) {
            LOG.warn("Character: {} is attempting to stop channel skill but he does not!", (Object)this._channelizer);
            return;
        }
        this._task.cancel(true);
        this._task = null;
        if (this._channelized != null) {
            for (L2Character chars : this._channelized) {
                this.cleanupChannelization(this._skill, chars);
            }
        }
        this._channelized = null;
        this._initialChannelized = null;
        this._skill = null;
    }

    public Skill getSkill() {
        return this._skill;
    }

    public boolean isChanneling() {
        return this._task != null;
    }

    @Override
    public void run() {
        if (!this.isChanneling()) {
            return;
        }
        if (this._skill == null) {
            return;
        }
        try {
            if (this._skill.getMpPerChanneling() > 0) {
                if (this._channelizer.getCurrentMp() < (double)this._skill.getMpPerChanneling()) {
                    if (this._channelizer.isPlayer()) {
                        this._channelizer.sendPacket(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP);
                    }
                    this._channelizer.abortCast();
                    return;
                }
                this._channelizer.reduceCurrentMp(this._skill.getMpPerChanneling());
            }
            if (this._skill.getChannelingSkillId() > 0) {
                Skill baseSkill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), 1);
                if (baseSkill == null) {
                    LOG.warn("Skill {} couldn't find effect id skill: {} !", (Object)this._skill, (Object)this._skill.getChannelingSkillId());
                    this._channelizer.abortCast();
                    return;
                }
                LinkedList<L2Character> targets = new LinkedList<L2Character>();
                if (this._initialChannelized != null) {
                    targets.add(this._initialChannelized);
                    this._initialChannelized.getSkillChannelized().addChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
                } else {
                    for (L2Object object : this._skill.getTargets(this._channelizer)) {
                        if (!object.isCharacter()) continue;
                        L2Character creature = (L2Character)object;
                        targets.add(creature);
                        creature.getSkillChannelized().addChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
                    }
                }
                if (targets.isEmpty()) {
                    return;
                }
                this._channelized = targets;
                for (L2Character character : this._channelized) {
                    if (!Util.checkIfInRange(this._skill.getEffectRange(), this._channelizer, character, true)) {
                        if (this._initialChannelized == null) continue;
                        this._channelizer.abortCast();
                        this._channelizer.sendPacket(SystemMessageId.TARGET_TOO_FAR);
                        continue;
                    }
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._channelizer, character)) {
                        if (this._initialChannelized == null) continue;
                        this._channelizer.abortCast();
                        this._channelizer.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                        continue;
                    }
                    int maxSkillLevel = SkillData.getInstance().getMaxLevel(this._skill.getChannelingSkillId());
                    int skillLevel = Math.min(character.getSkillChannelized().getChannerlizersSize(this._skill.getChannelingSkillId()), maxSkillLevel);
                    BuffInfo info = character.getEffectList().getBuffInfoBySkillId(this._skill.getChannelingSkillId());
                    if (info == null || info.getSkill().getLevel() < skillLevel) {
                        Skill skill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), skillLevel);
                        if (skill == null) {
                            LOG.warn("Non existent channeling skill requested: {}", (Object)this._skill);
                            this._channelizer.abortCast();
                            return;
                        }
                        if (character.isPlayable() && this.getChannelizer().isPlayer() && skill.isBad()) {
                            ((L2PcInstance)this.getChannelizer()).updatePvPStatus(character);
                        }
                        skill.applyEffects(this.getChannelizer(), character);
                        if (this._skill.useSpiritShot()) {
                            this._channelizer.setChargedShot(this._channelizer.isChargedShot(ShotType.BLESSED_SPIRITSHOTS) ? ShotType.BLESSED_SPIRITSHOTS : ShotType.SPIRITSHOTS, false);
                        } else {
                            this._channelizer.setChargedShot(ShotType.SOULSHOTS, false);
                        }
                        this._channelizer.rechargeShots(this._skill.useSoulShot(), this._skill.useSpiritShot());
                    }
                    this._channelizer.broadcastPacket(new MagicSkillLaunched(this._channelizer, this._skill.getId(), this._skill.getLevel(), character));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error while channelizing skill: {} channelizer: {} channelized: {}; {}", this._skill, this._channelizer, this._channelized, e.getMessage(), e);
        }
    }

    private void cleanupChannelization(Skill skill, L2Character character) {
        BuffInfo info = character.getEffectList().getBuffInfoBySkillId(skill.getChannelingSkillId());
        if (info != null) {
            int channerlizersSize = character.getSkillChannelized().getChannerlizersSize(skill.getChannelingSkillId());
            if (channerlizersSize == 1) {
                character.getEffectList().remove(false, info);
            } else if (channerlizersSize > 1) {
                int maxSkillLevel = SkillData.getInstance().getMaxLevel(skill.getChannelingSkillId());
                int skillLevel = Math.min(character.getSkillChannelized().getChannerlizersSize(skill.getChannelingSkillId()), maxSkillLevel);
                Skill currentSkill = SkillData.getInstance().getSkill(skill.getChannelingSkillId(), skillLevel);
                character.getEffectList().stopSkillEffects(true, currentSkill);
                Skill nextSkill = SkillData.getInstance().getSkill(skill.getChannelingSkillId(), skillLevel - 1);
                nextSkill.applyEffects(this.getChannelizer(), character);
            }
        }
        character.getSkillChannelized().removeChannelizer(skill.getChannelingSkillId(), this.getChannelizer());
    }
}

