/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.targets;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ArtefactInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ChestInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Duel;
import com.l2jserver.gameserver.model.holders.SkillUseHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.AffectObjectStaticImpl;
import com.l2jserver.gameserver.model.skills.targets.AffectScope;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TargetType {
    ADVANCE_BASE{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isNpc() || target.getId() != 36590 || ((L2Npc)target).isDead()) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    ARTILLERY{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isDoor() || ((L2DoorInstance)target).isDead() || !target.isAutoAttackable(caster)) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    DOOR_TREASURE{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isDoor() && !(target instanceof L2ChestInstance)) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    ENEMY{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || ((L2Character)target).isDead() || caster.getObjectId() == target.getObjectId() || !target.isCharacter()) {
                return null;
            }
            if (target.isNpc()) {
                L2TrapInstance trap;
                if (target.isAttackable()) {
                    return target;
                }
                if (target instanceof L2TrapInstance && (trap = (L2TrapInstance)target).isAutoAttackable(caster)) {
                    return target;
                }
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            L2PcInstance player = caster.getActingPlayer();
            if (player != null && player.doesSkillNeedCtrl((L2Character)target, skill) && !TargetType.getCurrentPlayableSkill(caster).isCtrlPressed()) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    ENEMY_NOT{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isCharacter() || ((L2Character)target).isDead() || target.isAutoAttackable(caster)) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    ENEMY_ONLY{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isCharacter() || caster.getObjectId() == target.getObjectId() || ((L2Character)target).isDead() || !target.isAutoAttackable(caster)) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (target.isNpc()) {
                if (target.isAttackable()) {
                    return target;
                }
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (!caster.isPlayable()) {
                return target;
            }
            L2PcInstance player = caster.getActingPlayer();
            if (player == null) {
                return null;
            }
            if (player.isInOlympiadMode()) {
                L2PcInstance targetPlayer = target.getActingPlayer();
                if (targetPlayer != null && player.getOlympiadSide() != targetPlayer.getOlympiadSide()) {
                    return target;
                }
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            L2Character targetCreature = (L2Character)target;
            if (player.isInDuelWith(targetCreature)) {
                L2PcInstance targetPlayer = target.getActingPlayer();
                Duel duel = DuelManager.getInstance().getDuel(player.getDuelId());
                List<L2PcInstance> teamA = duel.getTeamA();
                List<L2PcInstance> teamB = duel.getTeamB();
                if (teamA.contains(player) && teamB.contains(targetPlayer) || teamB.contains(player) && teamA.contains(targetPlayer)) {
                    return target;
                }
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isInPartyWith(targetCreature)) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isInsideZone(ZoneId.PVP)) {
                return target;
            }
            if (player.isInClanWith(targetCreature)) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isInAllyWith(targetCreature)) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isInCommandChannelWith(targetCreature)) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isOnSameSiegeSideWith(targetCreature)) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (player.isAtWarWith(targetCreature)) {
                return target;
            }
            if (!player.checkIfPvP(targetCreature) && target.isPlayable() && target.getActingPlayer().getKarma() == 0) {
                player.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    FORTRESS_FLAGPOLE{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (!(target instanceof L2StaticObjectInstance) || ((L2StaticObjectInstance)target).getType() != 3) {
                return null;
            }
            return target;
        }
    }
    ,
    GROUND{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            L2PcInstance player = caster.getActingPlayer();
            if (player == null) {
                return null;
            }
            Location worldPosition = player.getCurrentSkillWorldPosition();
            if (worldPosition == null || !GeoData.getInstance().canSeeTarget((L2Object)player, worldPosition)) {
                caster.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                return null;
            }
            if (skill.isBad() && caster.isInsideZone(ZoneId.PEACE)) {
                caster.sendPacket(SystemMessageId.A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE);
                return null;
            }
            return caster;
        }
    }
    ,
    HOLYTHING{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (!(target instanceof L2ArtefactInstance)) {
                return null;
            }
            return target;
        }
    }
    ,
    ITEM{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (!(target instanceof L2ItemInstance)) {
                return null;
            }
            return caster;
        }
    }
    ,
    NONE{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            return caster;
        }
    }
    ,
    NPC_BODY{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isNpc() || !((L2Character)target).isDead()) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            if (skill.hasEffectType(L2EffectType.SUMMON, new L2EffectType[0]) && target.isServitor() && target.getActingPlayer() != null && target.getActingPlayer().getObjectId() == caster.getObjectId()) {
                return null;
            }
            if (skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0]) && ((L2Attackable)target).isOldCorpse(caster.getActingPlayer(), Configuration.npc().getCorpseConsumeSkillAllowedTimeBeforeDecay(), true)) {
                return null;
            }
            return target;
        }
    }
    ,
    OTHERS{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || target == caster) {
                caster.sendPacket(SystemMessageId.CANNOT_USE_ON_YOURSELF);
                return null;
            }
            return target;
        }
    }
    ,
    PC_BODY{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (target == null || !target.isPlayer() && !target.isPet() || !((L2Character)target).isDead()) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    SELF{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            return caster;
        }
    }
    ,
    SUMMON{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (!caster.hasServitor()) {
                return null;
            }
            return caster.getSummon();
        }
    }
    ,
    TARGET{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            SkillUseHolder currentSkill;
            if (target == null) {
                return null;
            }
            L2PcInstance player = caster.getActingPlayer();
            if (player != null && target.isAutoAttackable(caster) && (currentSkill = TargetType.getCurrentPlayableSkill(caster)) != null && !currentSkill.isCtrlPressed()) {
                caster.sendPacket(SystemMessageId.INCORRECT_TARGET);
                return null;
            }
            return target;
        }
    }
    ,
    WYVERN_TARGET{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (caster.isPlayable()) {
                LOG.warn("Target type {} not implmented for skill {}!", (Object)skill.getTargetType(), (Object)skill);
            }
            return target;
        }
    }
    ,
    ONE{

        @Override
        public L2Object getTarget(Skill skill, L2Character caster, L2Object target) {
            if (caster.isPlayable()) {
                LOG.warn("Outdated {} with target type {} used on {} by {}!", new Object[]{skill, skill.getTargetType(), target, caster});
            }
            skill.updateTargetSystem(TARGET, AffectScope.SINGLE, AffectObjectStaticImpl.ALL);
            return TARGET.getTarget(skill, caster, target);
        }
    };

    public static final L2Object[] EMPTY_TARGET_LIST;
    private static final Logger LOG;
    private static final int OUTPOST = 36590;

    public abstract L2Object getTarget(Skill var1, L2Character var2, L2Object var3);

    public final List<L2Object> getTargets(Skill skill, L2Character caster, L2Object target) {
        L2Object actualTarget = this.getTarget(skill, caster, target);
        if (actualTarget == null) {
            return List.of();
        }
        return skill.getAffectScope().affectTargets(caster, actualTarget, skill);
    }

    private static final SkillUseHolder getCurrentPlayableSkill(L2Character caster) {
        if (caster.isSummon()) {
            return caster.getActingPlayer().getCurrentPetSkill();
        }
        return caster.getActingPlayer().getCurrentSkill();
    }

    static {
        EMPTY_TARGET_LIST = new L2Object[0];
        LOG = LoggerFactory.getLogger(TargetType.class);
    }
}

