/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.HitConditionBonusData;
import com.l2jserver.gameserver.data.xml.impl.KarmaData;
import com.l2jserver.gameserver.enums.DispelCategory;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.AttributeType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncArmorSet;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncAtkAccuracy;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncAtkCritical;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncAtkEvasion;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncGatesMDefMod;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncGatesPDefMod;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncHenna;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMAtkCritical;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMAtkMod;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMAtkSpeed;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMDefMod;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMaxCpMul;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMaxHpMul;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMaxMpMul;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncMoveSpeed;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncPAtkMod;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncPAtkSpeed;
import com.l2jserver.gameserver.model.stats.functions.formulas.FuncPDefMod;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2MotherTreeZone;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceZone;
import com.l2jserver.gameserver.network.Debug;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Formulas {
    private static final Logger LOG = LoggerFactory.getLogger(Formulas.class);
    private static final int HP_REGENERATE_PERIOD = 3000;
    public static final byte SHIELD_DEFENSE_FAILED = 0;
    public static final byte SHIELD_DEFENSE_SUCCEED = 1;
    public static final byte SHIELD_DEFENSE_PERFECT_BLOCK = 2;
    private static final byte MELEE_ATTACK_RANGE = 40;

    public static int getRegeneratePeriod(L2Character cha) {
        return cha.isDoor() ? 300000 : 3000;
    }

    public static Calculator[] getStdNPCCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.MAX_HP.ordinal()] = new Calculator();
        std[Stats.MAX_HP.ordinal()].addFunc(FuncMaxHpMul.getInstance());
        std[Stats.MAX_MP.ordinal()] = new Calculator();
        std[Stats.MAX_MP.ordinal()].addFunc(FuncMaxMpMul.getInstance());
        std[Stats.POWER_ATTACK.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK.ordinal()].addFunc(FuncPAtkMod.getInstance());
        std[Stats.MAGIC_ATTACK.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK.ordinal()].addFunc(FuncMAtkMod.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncMDefMod.getInstance());
        std[Stats.CRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.CRITICAL_RATE.ordinal()].addFunc(FuncAtkCritical.getInstance());
        std[Stats.MCRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.MCRITICAL_RATE.ordinal()].addFunc(FuncMAtkCritical.getInstance());
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK_SPEED.ordinal()].addFunc(FuncPAtkSpeed.getInstance());
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()].addFunc(FuncMAtkSpeed.getInstance());
        std[Stats.MOVE_SPEED.ordinal()] = new Calculator();
        std[Stats.MOVE_SPEED.ordinal()].addFunc(FuncMoveSpeed.getInstance());
        return std;
    }

    public static Calculator[] getStdDoorCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncGatesPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncGatesMDefMod.getInstance());
        return std;
    }

    public static void addFuncsToNewPlayer(L2PcInstance player) {
        player.addStatFuncs(List.of(FuncMaxHpMul.getInstance(), FuncMaxCpMul.getInstance(), FuncMaxMpMul.getInstance(), FuncPAtkMod.getInstance(), FuncMAtkMod.getInstance(), FuncPDefMod.getInstance(), FuncMDefMod.getInstance(), FuncAtkCritical.getInstance(), FuncMAtkCritical.getInstance(), FuncAtkAccuracy.getInstance(), FuncAtkEvasion.getInstance(), FuncPAtkSpeed.getInstance(), FuncMAtkSpeed.getInstance(), FuncMoveSpeed.getInstance(), FuncHenna.getInstance(Stats.STAT_STR), FuncHenna.getInstance(Stats.STAT_DEX), FuncHenna.getInstance(Stats.STAT_INT), FuncHenna.getInstance(Stats.STAT_MEN), FuncHenna.getInstance(Stats.STAT_CON), FuncHenna.getInstance(Stats.STAT_WIT), FuncArmorSet.getInstance(Stats.STAT_STR), FuncArmorSet.getInstance(Stats.STAT_DEX), FuncArmorSet.getInstance(Stats.STAT_INT), FuncArmorSet.getInstance(Stats.STAT_MEN), FuncArmorSet.getInstance(Stats.STAT_CON), FuncArmorSet.getInstance(Stats.STAT_WIT)));
    }

    public static void addFuncsToNewSummon(L2Summon summon) {
        summon.addStatFuncs(List.of(FuncMaxHpMul.getInstance(), FuncMaxMpMul.getInstance(), FuncPAtkMod.getInstance(), FuncMAtkMod.getInstance(), FuncPDefMod.getInstance(), FuncMDefMod.getInstance(), FuncAtkCritical.getInstance(), FuncMAtkCritical.getInstance(), FuncAtkAccuracy.getInstance(), FuncAtkEvasion.getInstance(), FuncMoveSpeed.getInstance(), FuncPAtkSpeed.getInstance(), FuncMAtkSpeed.getInstance()));
    }

    public static double calcHpRegen(L2Character cha) {
        double init = cha.isPlayer() ? cha.getActingPlayer().getTemplate().getBaseHpRegen(cha.getLevel()) : (double)cha.getTemplate().getBaseHpReg();
        double hpRegenMultiplier = cha.isRaid() ? Configuration.npc().getRaidHpRegenMultiplier() : Configuration.character().getHpRegenMultiplier();
        double hpRegenBonus = 0.0;
        if (Configuration.customs().championEnable() && cha.isChampion()) {
            hpRegenMultiplier *= Configuration.customs().getChampionHpRegen();
        }
        if (cha.isPlayer()) {
            L2PcInstance player = cha.getActingPlayer();
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                hpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            } else {
                double siegeModifier = Formulas.calcSiegeRegenModifier(player);
                if (siegeModifier > 0.0) {
                    hpRegenMultiplier *= siegeModifier;
                }
            }
            if (player.isInsideZone(ZoneId.CLAN_HALL) && player.getClan() != null && player.getClan().getHideoutId() > 0) {
                ClanHall clansHall;
                L2ClanHallZone zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : zone.getResidenceId();
                int clanHallIndex = player.getClan().getHideoutId();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(3) != null) {
                    hpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.CASTLE) && player.getClan() != null && player.getClan().getCastleId() > 0) {
                Castle castle;
                L2CastleZone zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : zone.getResidenceId();
                int castleIndex = player.getClan().getCastleId();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)castle.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.FORT) && player.getClan() != null && player.getClan().getFortId() > 0) {
                Fort fort;
                L2FortZone zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : zone.getResidenceId();
                int fortIndex = player.getClan().getFortId();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)fort.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.MOTHER_TREE)) {
                L2MotherTreeZone zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int hpBonus = zone == null ? 0 : zone.getHpRegenBonus();
                hpRegenBonus += (double)hpBonus;
            }
            if (player.isSitting()) {
                hpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                hpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                hpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.CON.calcBonus(cha);
        } else if (cha.isPet()) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenHP() * Configuration.npc().getPetHpRegenMultiplier();
        }
        return cha.calcStat(Stats.REGENERATE_HP_RATE, Math.max(1.0, init), null, null) * hpRegenMultiplier + hpRegenBonus;
    }

    public static double calcMpRegen(L2Character cha) {
        double init = cha.isPlayer() ? cha.getActingPlayer().getTemplate().getBaseMpRegen(cha.getLevel()) : (double)cha.getTemplate().getBaseMpReg();
        double mpRegenMultiplier = cha.isRaid() ? Configuration.npc().getRaidMpRegenMultiplier() : Configuration.character().getMpRegenMultiplier();
        double mpRegenBonus = 0.0;
        if (cha.isPlayer()) {
            L2ZoneType zone;
            L2PcInstance player = cha.getActingPlayer();
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                mpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            }
            if (player.isInsideZone(ZoneId.MOTHER_TREE)) {
                zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int mpBonus = zone == null ? 0 : ((L2MotherTreeZone)zone).getMpRegenBonus();
                mpRegenBonus += (double)mpBonus;
            }
            if (player.isInsideZone(ZoneId.CLAN_HALL) && player.getClan() != null && player.getClan().getHideoutId() > 0) {
                ClanHall clansHall;
                zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int clanHallIndex = player.getClan().getHideoutId();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(4) != null) {
                    mpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(4).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.CASTLE) && player.getClan() != null && player.getClan().getCastleId() > 0) {
                Castle castle;
                zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int castleIndex = player.getClan().getCastleId();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)castle.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone(ZoneId.FORT) && player.getClan() != null && player.getClan().getFortId() > 0) {
                Fort fort;
                zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : ((L2ResidenceZone)zone).getResidenceId();
                int fortIndex = player.getClan().getFortId();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)fort.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isSitting()) {
                mpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                mpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                mpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.MEN.calcBonus(cha);
        } else if (cha.isPet()) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenMP() * Configuration.npc().getPetMpRegenMultiplier();
        }
        return cha.calcStat(Stats.REGENERATE_MP_RATE, Math.max(1.0, init), null, null) * mpRegenMultiplier + mpRegenBonus;
    }

    public static double calcCpRegen(L2PcInstance player) {
        double init = player.getActingPlayer().getTemplate().getBaseCpRegen(player.getLevel()) * player.getLevelMod() * BaseStats.CON.calcBonus(player);
        double cpRegenMultiplier = Configuration.character().getCpRegenMultiplier();
        if (player.isSitting()) {
            cpRegenMultiplier *= 1.5;
        } else if (!player.isMoving()) {
            cpRegenMultiplier *= 1.1;
        } else if (player.isRunning()) {
            cpRegenMultiplier *= 0.7;
        }
        return player.calcStat(Stats.REGENERATE_CP_RATE, Math.max(1.0, init), null, null) * cpRegenMultiplier;
    }

    public static double calcFestivalRegenModifier(L2PcInstance activeChar) {
        int[] festivalInfo = SevenSignsFestival.getInstance().getFestivalForPlayer(activeChar);
        int oracle = festivalInfo[0];
        int festivalId = festivalInfo[1];
        if (festivalId < 0) {
            return 0.0;
        }
        int[] festivalCenter = oracle == 2 ? SevenSignsFestival.FESTIVAL_DAWN_PLAYER_SPAWNS[festivalId] : SevenSignsFestival.FESTIVAL_DUSK_PLAYER_SPAWNS[festivalId];
        double distToCenter = activeChar.calculateDistance(festivalCenter[0], festivalCenter[1], 0, false, false);
        if (Configuration.general().debug()) {
            LOG.info("Distance: {}, RegenMulti: {}", (Object)distToCenter, (Object)(distToCenter * 2.5 / 50.0));
        }
        return 1.0 - distToCenter * 5.0E-4;
    }

    public static double calcSiegeRegenModifier(L2PcInstance activeChar) {
        if (activeChar == null || activeChar.getClan() == null) {
            return 0.0;
        }
        Siege siege = SiegeManager.getInstance().getSiege(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        if (siege == null || !siege.isInProgress()) {
            return 0.0;
        }
        L2SiegeClan siegeClan = siege.getAttackerClan(activeChar.getClan().getId());
        if (siegeClan == null || siegeClan.getFlag().isEmpty() || !Util.checkIfInRange(200, activeChar, siegeClan.getFlag().get(0), true)) {
            return 0.0;
        }
        return 1.5;
    }

    public static double calcBlowDamage(L2Character attacker, L2Character target, Skill skill, byte shld, boolean ss, double power) {
        boolean isPvP;
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean bl = isPvP = attacker.isPlayable() && target.isPlayable();
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double ssboost = ss ? 1.458 : 1.0;
        double pvpBonus = 1.0;
        if (isPvP) {
            pvpBonus = attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null);
            defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        double baseMod = 77.0 * (power + attacker.getPAtk(target) * ssboost) / defence;
        double criticalMod = attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalModPos = (attacker.calcStat(Stats.CRITICAL_DAMAGE_POS, 1.0, target, skill) - 1.0) / 2.0 + 1.0;
        double criticalVulnMod = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalAddMod = attacker.getStat().calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0) * 6.1 * 77.0 / defence;
        double criticalAddVuln = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, skill);
        double weaponTraitMod = Formulas.calcWeaponTraitBonus(attacker, target);
        double generalTraitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double attributeMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double weaponMod = attacker.getRandomDamageMultiplier();
        double penaltyMod = 1.0;
        if (target instanceof L2Attackable && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            penaltyMod = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
        }
        double damage = baseMod * criticalMod * criticalModPos * criticalVulnMod * proximityBonus * pvpBonus + criticalAddMod + criticalAddVuln;
        damage *= weaponTraitMod;
        damage *= generalTraitMod;
        damage *= attributeMod;
        damage *= weaponMod;
        damage *= penaltyMod;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("skillPower", power);
            set.set("ssboost", ssboost);
            set.set("proximityBonus", proximityBonus);
            set.set("pvpBonus", pvpBonus);
            set.set("baseMod", baseMod);
            set.set("criticalMod", criticalMod);
            set.set("criticalModPos", criticalModPos);
            set.set("criticalVulnMod", criticalVulnMod);
            set.set("criticalAddMod", criticalAddMod);
            set.set("criticalAddVuln", criticalAddVuln);
            set.set("weaponTraitMod", weaponTraitMod);
            set.set("generalTraitMod", generalTraitMod);
            set.set("attributeMod", attributeMod);
            set.set("weaponMod", weaponMod);
            set.set("penaltyMod", penaltyMod);
            set.set("damage", (int)damage);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Math.max(damage, 1.0);
    }

    public static double calcBackstabDamage(L2Character attacker, L2Character target, Skill skill, byte shld, boolean ss, double power) {
        boolean isPvP;
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean bl = isPvP = attacker.isPlayable() && target.isPlayer();
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double ssboost = ss ? 1.458 : 1.0;
        double pvpBonus = 1.0;
        if (isPvP) {
            pvpBonus = attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null);
            defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        double baseMod = 77.0 * (power + attacker.getPAtk(target)) / defence * ssboost;
        double criticalMod = attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalModPos = (attacker.calcStat(Stats.CRITICAL_DAMAGE_POS, 1.0, target, skill) - 1.0) / 2.0 + 1.0;
        double criticalVulnMod = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, skill);
        double criticalAddMod = attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 6.1 * 77.0 / defence;
        double criticalAddVuln = target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, skill);
        double generalTraitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double attributeMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double weaponMod = attacker.getRandomDamageMultiplier();
        double penaltyMod = 1.0;
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            penaltyMod = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
        }
        double damage = baseMod * criticalMod * criticalModPos * criticalVulnMod * proximityBonus * pvpBonus + criticalAddMod + criticalAddVuln;
        damage *= generalTraitMod;
        damage *= attributeMod;
        damage *= weaponMod;
        damage *= penaltyMod;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("skillPower", power);
            set.set("ssboost", ssboost);
            set.set("proximityBonus", proximityBonus);
            set.set("pvpBonus", pvpBonus);
            set.set("baseMod", baseMod);
            set.set("criticalMod", criticalMod);
            set.set("criticalVulnMod", criticalVulnMod);
            set.set("criticalAddMod", criticalAddMod);
            set.set("criticalAddVuln", criticalAddVuln);
            set.set("generalTraitMod", generalTraitMod);
            set.set("attributeMod", attributeMod);
            set.set("weaponMod", weaponMod);
            set.set("penaltyMod", penaltyMod);
            set.set("damage", (int)damage);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Math.max(damage, 1.0);
    }

    public static double calcPhysDam(L2Character attacker, L2Character target, byte shld, boolean crit, boolean ss) {
        double ssboost;
        boolean isPvP;
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                if (Configuration.character().shieldBlocks()) break;
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean bl = isPvP = attacker.isPlayable() && target.isPlayable();
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double damage = attacker.getPAtk(target);
        double d = ssboost = ss ? 2.0 : 1.0;
        if (isPvP) {
            defence *= target.calcStat(Stats.PVP_PHYSICAL_DEF, 1.0, null, null);
        }
        damage *= ssboost;
        if (crit) {
            damage = 2.0 * attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, null) * attacker.calcStat(Stats.CRITICAL_DAMAGE_POS, 1.0, target, null) * target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE, 1.0, target, null) * (76.0 * damage * proximityBonus / defence);
            damage += attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, null) * 77.0 / defence;
            damage += target.calcStat(Stats.DEFENCE_CRITICAL_DAMAGE_ADD, 0.0, target, null);
        } else {
            damage = 76.0 * damage * proximityBonus / defence;
        }
        damage *= Formulas.calcAttackTraitBonus(attacker, target);
        damage *= attacker.getRandomDamageMultiplier();
        if (isPvP) {
            damage *= attacker.calcStat(Stats.PVP_PHYSICAL_DMG, 1.0, null, null);
        }
        damage *= Formulas.calcAttributeBonus(attacker, target, null);
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            damage = crit ? (lvlDiff >= Configuration.npc().getCritDmgPenaltyForLvLDifferences().size() ? (damage *= Configuration.npc().getCritDmgPenaltyForLvLDifferences().get(Configuration.npc().getCritDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (damage *= Configuration.npc().getCritDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue())) : (lvlDiff >= Configuration.npc().getDmgPenaltyForLvLDifferences().size() ? (damage *= Configuration.npc().getDmgPenaltyForLvLDifferences().get(Configuration.npc().getDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (damage *= Configuration.npc().getDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue()));
        }
        return Math.max(damage, 1.0);
    }

    public static double calcSkillPhysDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean crit, boolean ss, double power) {
        boolean isPvP;
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                if (Configuration.character().shieldBlocks()) break;
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        boolean bl = isPvP = attacker.isPlayable() && target.isPlayable();
        double proximityBonus = attacker.isBehindTarget() ? 1.2 : (attacker.isInFrontOfTarget() ? 1.0 : 1.1);
        double ssBoost = ss ? 2.0 : 1.0;
        double pvpBonus = 1.0;
        if (isPvP) {
            pvpBonus = attacker.getStat().calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0);
            defence *= target.getStat().calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0);
        }
        double baseMod = 77.0 * (power + attacker.getPAtk(target) * ssBoost) / defence;
        double penaltyMod = 1.0;
        if (target instanceof L2Attackable && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            penaltyMod = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (penaltyMod *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
            penaltyMod = crit ? (lvlDiff >= Configuration.npc().getCritDmgPenaltyForLvLDifferences().size() ? (penaltyMod *= Configuration.npc().getCritDmgPenaltyForLvLDifferences().get(Configuration.npc().getCritDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (penaltyMod *= Configuration.npc().getCritDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue())) : (lvlDiff >= Configuration.npc().getDmgPenaltyForLvLDifferences().size() ? (penaltyMod *= Configuration.npc().getDmgPenaltyForLvLDifferences().get(Configuration.npc().getDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (penaltyMod *= Configuration.npc().getDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue()));
        }
        double damage = baseMod * proximityBonus * pvpBonus;
        damage *= Formulas.calcAttackTraitBonus(attacker, target);
        damage *= Formulas.calcAttributeBonus(attacker, target, skill);
        damage *= attacker.getRandomDamageMultiplier();
        damage *= penaltyMod;
        damage = attacker.getStat().calcStat(Stats.PHYSICAL_SKILL_POWER, damage);
        return Math.max(damage, 1.0);
    }

    public static double calcMagicDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean sps, boolean bss, boolean mcrit, double power) {
        return Formulas.calcMagicDam(attacker, target, skill, shld, 0.0, sps, bss, mcrit, power);
    }

    public static double calcMagicDam(L2Character attacker, L2Character target, Skill skill, byte shld, double shieldDefensePercentage, boolean sps, boolean bss, boolean mcrit, double power) {
        boolean isPvP;
        double mDef = target.getMDef(attacker, skill);
        switch (shld) {
            case 1: {
                if (shieldDefensePercentage <= 0.0) {
                    mDef += (double)target.getShldDef();
                    break;
                }
                mDef += (double)target.getShldDef() * shieldDefensePercentage / 100.0;
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double mAtk = attacker.getMAtk(target, skill);
        boolean bl = isPvP = attacker.isPlayable() && target.isPlayable();
        if (isPvP) {
            mDef = skill.isMagic() ? (mDef *= target.calcStat(Stats.PVP_MAGICAL_DEF, 1.0, null, null)) : (mDef *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null));
        }
        double damage = 91.0 * Math.sqrt(mAtk *= bss ? 4.0 : (sps ? 2.0 : 1.0)) / mDef * power;
        if (Configuration.character().magicFailures() && !Formulas.calcMagicSuccess(attacker, target, skill)) {
            SystemMessage sm;
            if (attacker.isPlayer()) {
                if (Formulas.calcMagicSuccess(attacker, target, skill) && target.getLevel() - attacker.getLevel() <= 9) {
                    if (skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0])) {
                        attacker.sendPacket(SystemMessageId.DRAIN_HALF_SUCCESFUL);
                    } else {
                        attacker.sendPacket(SystemMessageId.ATTACK_FAILED);
                    }
                    damage /= 2.0;
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                    sm.addCharName(target);
                    sm.addSkillName(skill);
                    attacker.sendPacket(sm);
                    damage = 1.0;
                }
            }
            if (target.isPlayer()) {
                sm = skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0]) ? SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN) : SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                sm.addCharName(attacker);
                target.sendPacket(sm);
            }
        } else if (mcrit) {
            damage *= attacker.isPlayer() && target.isPlayer() ? 2.5 : 3.0;
            damage *= attacker.calcStat(Stats.MAGIC_CRIT_DMG, 1.0, null, null);
        }
        damage *= attacker.getRandomDamageMultiplier();
        if (isPvP) {
            Stats stat = skill.isMagic() ? Stats.PVP_MAGICAL_DMG : Stats.PVP_PHYS_SKILL_DMG;
            damage *= attacker.calcStat(stat, 1.0, null, null);
        }
        damage *= Formulas.calcAttributeBonus(attacker, target, skill);
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            damage = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
        }
        return damage;
    }

    public static double calcMagicDam(L2CubicInstance attacker, L2Character target, Skill skill, boolean mcrit, byte shld) {
        double mDef = target.getMDef(attacker.getOwner(), skill);
        switch (shld) {
            case 1: {
                mDef += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double damage = (double)(91 * attacker.getCubicPower()) / mDef;
        L2PcInstance owner = attacker.getOwner();
        if (Configuration.character().magicFailures() && !Formulas.calcMagicSuccess(owner, target, skill)) {
            SystemMessage sm;
            if (Formulas.calcMagicSuccess(owner, target, skill) && target.getLevel() - skill.getMagicLevel() <= 9) {
                if (skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0])) {
                    owner.sendPacket(SystemMessageId.DRAIN_HALF_SUCCESFUL);
                } else {
                    owner.sendPacket(SystemMessageId.ATTACK_FAILED);
                }
                damage /= 2.0;
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                sm.addCharName(target);
                sm.addSkillName(skill);
                owner.sendPacket(sm);
                damage = 1.0;
            }
            if (target.isPlayer()) {
                if (skill.hasEffectType(L2EffectType.HP_DRAIN, new L2EffectType[0])) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                }
            }
        } else if (mcrit) {
            damage *= 3.0;
        }
        damage *= Formulas.calcAttributeBonus(owner, target, skill);
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getOwner() != null && target.getLevel() - attacker.getOwner().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getOwner().getLevel() - 1;
            damage = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
        }
        return damage;
    }

    public static boolean calcCrit(L2Character attacker, L2Character target) {
        double rate = attacker.getStat().calcStat(Stats.CRITICAL_RATE_POS, attacker.getStat().getCriticalHit(target, null));
        return target.getStat().calcStat(Stats.DEFENCE_CRITICAL_RATE, rate, null, null) + target.getStat().calcStat(Stats.DEFENCE_CRITICAL_RATE_ADD, 0.0, null, null) > (double)Rnd.get((int)1000);
    }

    public static boolean calcSkillCrit(L2Character attacker, L2Character target, int criticalChance) {
        return BaseStats.STR.calcBonus(attacker) * (double)criticalChance > Rnd.nextDouble() * 100.0;
    }

    public static boolean calcMCrit(double mRate) {
        return mRate > (double)Rnd.get((int)1000);
    }

    public static boolean calcAtkBreak(L2Character target, double dmg) {
        L2Weapon wpn;
        if (target.isChanneling()) {
            return false;
        }
        double init = 0.0;
        if (Configuration.character().cancelCast() && target.isCastingNow()) {
            init = 15.0;
        }
        if (Configuration.character().cancelBow() && target.isAttackingNow() && (wpn = target.getActiveWeaponItem()) != null && wpn.getItemType() == WeaponType.BOW) {
            init = 15.0;
        }
        if (target.isRaid() || target.isInvul() || init <= 0.0) {
            return false;
        }
        init += Math.sqrt(13.0 * dmg);
        double rate = target.calcStat(Stats.ATTACK_CANCEL, init -= BaseStats.MEN.calcBonus(target) * 100.0 - 100.0, null, null);
        rate = Math.max(Math.min(rate, 99.0), 1.0);
        return (double)Rnd.get((int)100) < rate;
    }

    public static double calcCastTime(L2Character character, Skill skill) {
        double skillAnimTime = skill.getHitTime();
        if (!skill.isChanneling() || skill.getChannelingSkillId() == 0) {
            if (!skill.isStatic()) {
                double speed = skill.isMagic() ? (double)character.getMAtkSpd() : character.getPAtkSpd();
                skillAnimTime = skillAnimTime / speed * 333.0;
            }
            if (skill.isMagic() && (character.isChargedShot(ShotType.SPIRITSHOTS) || character.isChargedShot(ShotType.BLESSED_SPIRITSHOTS))) {
                skillAnimTime *= 0.6;
            }
            if (skillAnimTime < 500.0 && skill.getHitTime() > 500) {
                skillAnimTime = 500.0;
            }
        }
        return skillAnimTime;
    }

    public static boolean calcHitMiss(L2Character attacker, L2Character target) {
        int chance = (80 + 2 * (attacker.getAccuracy() - target.getEvasionRate(attacker))) * 10;
        chance = (int)((double)chance * HitConditionBonusData.getInstance().getConditionBonus(attacker, target));
        chance = Math.max(chance, 200);
        return (chance = Math.min(chance, 980)) < Rnd.get((int)1000);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, Skill skill, boolean sendSysMsg) {
        L2Item item = target.getSecondaryWeaponItem();
        if (!(item instanceof L2Armor) || ((L2Armor)item).getItemType() == ArmorType.SIGIL) {
            return 0;
        }
        double shldRate = target.calcStat(Stats.SHIELD_RATE, 0.0, attacker, null) * BaseStats.DEX.calcBonus(target);
        if (shldRate <= 1.0E-6) {
            return 0;
        }
        int degreeside = (int)target.calcStat(Stats.SHIELD_DEFENCE_ANGLE, 0.0, null, null) + 120;
        if (degreeside < 360 && !target.isFacing(attacker, degreeside)) {
            return 0;
        }
        byte shldSuccess = 0;
        L2Weapon at_weapon = attacker.getActiveWeaponItem();
        if (at_weapon != null && at_weapon.getItemType() == WeaponType.BOW) {
            shldRate *= 1.3;
        }
        if (shldRate > 0.0 && 100 - Configuration.character().getPerfectShieldBlockRate() < Rnd.get((int)100)) {
            shldSuccess = 2;
        } else if (shldRate > (double)Rnd.get((int)100)) {
            shldSuccess = 1;
        }
        if (sendSysMsg && target.isPlayer()) {
            L2PcInstance enemy = target.getActingPlayer();
            switch (shldSuccess) {
                case 1: {
                    enemy.sendPacket(SystemMessageId.SHIELD_DEFENCE_SUCCESSFULL);
                    break;
                }
                case 2: {
                    enemy.sendPacket(SystemMessageId.YOUR_EXCELLENT_SHIELD_DEFENSE_WAS_A_SUCCESS);
                }
            }
        }
        return shldSuccess;
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, Skill skill) {
        return Formulas.calcShldUse(attacker, target, skill, true);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target) {
        return Formulas.calcShldUse(attacker, target, null, true);
    }

    public static boolean calcMagicAffected(L2Character actor, L2Character target, Skill skill) {
        double defence = 0.0;
        if (skill.isActive() && skill.isBad()) {
            defence = target.getMDef(actor, skill);
        }
        double attack = 2.0 * actor.getMAtk(target, skill) * Formulas.calcGeneralTraitBonus(actor, target, skill.getTraitType(), false);
        double d = (attack - defence) / (attack + defence);
        if (skill.isDebuff() && target.isDebuffBlocked()) {
            return false;
        }
        return (d += 0.5 * Rnd.nextGaussian()) > 0.0;
    }

    public static double calcLvlBonusMod(L2Character attacker, L2Character target, Skill skill) {
        int attackerLvl = skill.getMagicLevel() > 0 ? skill.getMagicLevel() : attacker.getLevel();
        double skillLvlBonusRateMod = 1.0 + (double)skill.getLvlBonusRate() / 100.0;
        double lvlMod = 1.0 + (double)(attackerLvl - target.getLevel()) / 100.0;
        return skillLvlBonusRateMod * lvlMod;
    }

    public static boolean calcEffectSuccess(L2Character attacker, L2Character target, Skill skill) {
        double finalRate;
        if (target.isDoor() || target instanceof L2SiegeFlagInstance || target instanceof L2StaticObjectInstance) {
            return false;
        }
        if (skill.isDebuff() && target.isDebuffBlocked()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
            sm.addCharName(target);
            sm.addSkillName(skill);
            attacker.sendPacket(sm);
            return false;
        }
        int activateRate = skill.getActivateRate();
        if (activateRate == -1 || skill.getBasicProperty() == BaseStats.NONE) {
            return true;
        }
        int magicLevel = skill.getMagicLevel();
        if (magicLevel <= -1) {
            magicLevel = target.getLevel() + 3;
        }
        int targetBaseStat = switch (skill.getBasicProperty()) {
            case BaseStats.STR -> target.getSTR();
            case BaseStats.DEX -> target.getDEX();
            case BaseStats.CON -> target.getCON();
            case BaseStats.INT -> target.getINT();
            case BaseStats.MEN -> target.getMEN();
            case BaseStats.WIT -> target.getWIT();
            default -> 0;
        };
        double baseMod = (double)((magicLevel - target.getLevel() + 3) * skill.getLvlBonusRate() + activateRate) + 30.0 - (double)targetBaseStat;
        double elementMod = Formulas.calcAttributeBonus(attacker, target, skill);
        double traitMod = Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        double buffDebuffMod = 1.0 + target.calcStat(skill.isDebuff() ? Stats.DEBUFF_VULN : Stats.BUFF_VULN, 1.0, null, null) / 100.0;
        double mAtkMod = 1.0;
        if (skill.isMagic()) {
            double mAtk = attacker.getMAtk(null, null);
            double val = 0.0;
            if (attacker.isChargedShot(ShotType.BLESSED_SPIRITSHOTS)) {
                val = mAtk * 3.0;
            }
            val += mAtk;
            mAtkMod = val = Math.sqrt(val) / target.getMDef(null, null) * 11.0;
        }
        double rate = baseMod * elementMod * traitMod * mAtkMod * buffDebuffMod;
        double d = finalRate = traitMod > 0.0 ? Util.constrain(rate, (double)skill.getMinChance(), (double)skill.getMaxChance()) : 0.0;
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("baseMod", baseMod);
            set.set("elementMod", elementMod);
            set.set("traitMod", traitMod);
            set.set("mAtkMod", mAtkMod);
            set.set("buffDebuffMod", buffDebuffMod);
            set.set("rate", rate);
            set.set("finalRate", finalRate);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        if (finalRate <= (double)Rnd.get((int)100)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
            sm.addCharName(target);
            sm.addSkillName(skill);
            attacker.sendPacket(sm);
            return false;
        }
        return true;
    }

    public static boolean calcCubicSkillSuccess(L2CubicInstance attacker, L2Character target, Skill skill, byte shld) {
        if (skill.isDebuff() && target.isDebuffBlocked()) {
            return false;
        }
        if (shld == 2) {
            return false;
        }
        if (Formulas.calcBuffDebuffReflection(target, skill)) {
            return false;
        }
        double baseRate = skill.getActivateRate();
        double statMod = skill.getBasicProperty().calcBonus(target);
        double rate = baseRate / statMod;
        double resMod = Formulas.calcGeneralTraitBonus(attacker.getOwner(), target, skill.getTraitType(), false);
        rate *= resMod;
        double lvlBonusMod = Formulas.calcLvlBonusMod(attacker.getOwner(), target, skill);
        rate *= lvlBonusMod;
        double elementMod = Formulas.calcAttributeBonus(attacker.getOwner(), target, skill);
        double finalRate = Util.constrain(rate *= elementMod, (double)skill.getMinChance(), (double)skill.getMaxChance());
        if (attacker.getOwner().isDebug()) {
            StatsSet set = new StatsSet();
            set.set("baseMod", baseRate);
            set.set("resMod", resMod);
            set.set("statMod", statMod);
            set.set("elementMod", elementMod);
            set.set("lvlBonusMod", lvlBonusMod);
            set.set("rate", rate);
            set.set("finalRate", finalRate);
            Debug.sendSkillDebug(attacker.getOwner(), target, skill, set);
        }
        return (double)Rnd.get((int)100) < finalRate;
    }

    public static boolean calcMagicSuccess(L2Character attacker, L2Character target, Skill skill) {
        int lvlDifference = target.getLevel() - (skill.getMagicLevel() > 0 ? skill.getMagicLevel() : attacker.getLevel());
        double lvlModifier = Math.pow(1.3, lvlDifference);
        double targetModifier = 1.0;
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 3) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 2;
            targetModifier = lvlDiff >= Configuration.npc().getSkillChancePenaltyForLvLDifferences().size() ? Configuration.npc().getSkillChancePenaltyForLvLDifferences().get(Configuration.npc().getSkillChancePenaltyForLvLDifferences().size() - 1).doubleValue() : Configuration.npc().getSkillChancePenaltyForLvLDifferences().get(lvlDiff).doubleValue();
        }
        double resModifier = target.calcStat(Stats.MAGIC_SUCCESS_RES, 1.0, null, skill);
        int rate = 100 - Math.round((float)(lvlModifier * targetModifier * resModifier));
        if (attacker.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("lvlDifference", lvlDifference);
            set.set("lvlModifier", lvlModifier);
            set.set("resModifier", resModifier);
            set.set("targetModifier", targetModifier);
            set.set("rate", rate);
            Debug.sendSkillDebug(attacker, target, skill, set);
        }
        return Rnd.get((int)100) < rate;
    }

    public static double calcManaDam(L2Character attacker, L2Character target, Skill skill, byte shld, boolean sps, boolean bss, boolean mcrit, double power) {
        double mAtk = attacker.getMAtk(target, skill);
        double mDef = target.getMDef(attacker, skill);
        double mp = target.getMaxMp();
        switch (shld) {
            case 1: {
                mDef += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double damage = Math.sqrt(mAtk *= bss ? 4.0 : (sps ? 2.0 : 1.0)) * power * (mp / 97.0) / mDef;
        damage *= Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
        if (target.isAttackable() && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Configuration.npc().getMinNPCLevelForDmgPenalty() && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            damage = lvlDiff >= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() ? (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(Configuration.npc().getSkillDmgPenaltyForLvLDifferences().size() - 1).doubleValue()) : (damage *= Configuration.npc().getSkillDmgPenaltyForLvLDifferences().get(lvlDiff).doubleValue());
        }
        if (Configuration.character().magicFailures() && !Formulas.calcMagicSuccess(attacker, target, skill)) {
            if (attacker.isPlayer()) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DAMAGE_DECREASED_BECAUSE_C1_RESISTED_C2_MAGIC);
                sm.addCharName(target);
                sm.addCharName(attacker);
                attacker.sendPacket(sm);
                damage /= 2.0;
            }
            if (target.isPlayer()) {
                SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_WEAKLY_RESISTED_C2_MAGIC);
                sm2.addCharName(target);
                sm2.addCharName(attacker);
                target.sendPacket(sm2);
            }
        }
        if (mcrit) {
            damage *= 3.0;
            attacker.sendPacket(SystemMessageId.CRITICAL_HIT_MAGIC);
        }
        return damage;
    }

    public static double calculateSkillResurrectRestorePercent(double baseRestorePercent, L2Character caster) {
        if (baseRestorePercent == 0.0 || baseRestorePercent == 100.0) {
            return baseRestorePercent;
        }
        double restorePercent = baseRestorePercent * BaseStats.WIT.calcBonus(caster);
        if (restorePercent - baseRestorePercent > 20.0) {
            restorePercent += 20.0;
        }
        restorePercent = Math.max(restorePercent, baseRestorePercent);
        restorePercent = Math.min(restorePercent, 90.0);
        return restorePercent;
    }

    public static boolean calcPhysicalSkillEvasion(L2Character activeChar, L2Character target, Skill skill) {
        if (skill.isMagic() || skill.isDebuff()) {
            return false;
        }
        if ((double)Rnd.get((int)100) < target.calcStat(Stats.P_SKILL_EVASION, 0.0, null, skill)) {
            SystemMessage sm;
            if (activeChar.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DODGES_ATTACK);
                sm.addString(target.getName());
                activeChar.getActingPlayer().sendPacket(sm);
            }
            if (target.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.AVOIDED_C1_ATTACK2);
                sm.addString(activeChar.getName());
                target.getActingPlayer().sendPacket(sm);
            }
            return true;
        }
        return false;
    }

    public static boolean calcSkillMastery(L2Character actor, Skill sk) {
        if (sk.isStatic()) {
            return false;
        }
        int val = (int)actor.getStat().calcStat(Stats.SKILL_CRITICAL, 0.0, null, null);
        if (val == 0) {
            return false;
        }
        if (actor.isPlayer()) {
            double initVal = switch (val) {
                case 1 -> BaseStats.STR.calcBonus(actor);
                case 4 -> BaseStats.INT.calcBonus(actor);
                default -> 0.0;
            };
            return (double)Rnd.get((int)100) < (initVal *= actor.getStat().calcStat(Stats.SKILL_CRITICAL_PROBABILITY, 1.0, null, null));
        }
        return false;
    }

    public static double calcAttributeBonus(L2Character attacker, L2Character target, Skill skill) {
        double min;
        double max;
        double defence_attribute_mod;
        double attack_attribute_mod;
        int attack_attribute;
        if (skill != null) {
            if (skill.getAttributeType() == AttributeType.NONE || attacker.getAttackElement() != skill.getAttributeType().getId()) {
                return 1.0;
            }
            attack_attribute = attacker.getAttackElementValue(attacker.getAttackElement()) + skill.getAttributePower();
        } else {
            attack_attribute = attacker.getAttackElementValue(attacker.getAttackElement());
            if (attack_attribute == 0) {
                return 1.0;
            }
        }
        int defence_attribute = target.getDefenseElementValue(attacker.getAttackElement());
        if (attack_attribute <= defence_attribute) {
            return 1.0;
        }
        if (attack_attribute >= 450) {
            if (defence_attribute >= 450) {
                attack_attribute_mod = 0.06909;
                defence_attribute_mod = 0.078;
            } else if (defence_attribute >= 350) {
                attack_attribute_mod = 0.0887;
                defence_attribute_mod = 0.1007;
            } else {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            }
        } else if (attack_attribute >= 300) {
            if (defence_attribute >= 300) {
                attack_attribute_mod = 0.0887;
                defence_attribute_mod = 0.1007;
            } else if (defence_attribute >= 150) {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            } else {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            }
        } else if (attack_attribute >= 150) {
            if (defence_attribute >= 150) {
                attack_attribute_mod = 0.129;
                defence_attribute_mod = 0.1473;
            } else if (defence_attribute >= 0) {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            } else {
                attack_attribute_mod = 0.4;
                defence_attribute_mod = 0.55;
            }
        } else if (attack_attribute >= -99) {
            if (defence_attribute >= 0) {
                attack_attribute_mod = 0.25;
                defence_attribute_mod = 0.2894;
            } else {
                attack_attribute_mod = 0.4;
                defence_attribute_mod = 0.55;
            }
        } else if (defence_attribute >= 450) {
            attack_attribute_mod = 0.06909;
            defence_attribute_mod = 0.078;
        } else if (defence_attribute >= 350) {
            attack_attribute_mod = 0.0887;
            defence_attribute_mod = 0.1007;
        } else {
            attack_attribute_mod = 0.129;
            defence_attribute_mod = 0.1473;
        }
        int attribute_diff = attack_attribute - defence_attribute;
        if (attribute_diff >= 300) {
            max = 100.0;
            min = -50.0;
        } else if (attribute_diff >= 150) {
            max = 70.0;
            min = -50.0;
        } else if (attribute_diff >= -150) {
            max = 40.0;
            min = -50.0;
        } else if (attribute_diff >= -300) {
            max = 40.0;
            min = -60.0;
        } else {
            max = 40.0;
            min = -80.0;
        }
        attack_attribute += 100;
        attack_attribute *= attack_attribute;
        attack_attribute_mod = (double)attack_attribute / 144.0 * attack_attribute_mod;
        defence_attribute += 100;
        defence_attribute *= defence_attribute;
        defence_attribute_mod = (double)defence_attribute / 169.0 * defence_attribute_mod;
        double attribute_mod_diff = attack_attribute_mod - defence_attribute_mod;
        attribute_mod_diff = Util.constrain(attribute_mod_diff, min, max);
        double result = attribute_mod_diff / 100.0 + 1.0;
        if (attacker.isPlayer() && target.isPlayer() && result < 1.0) {
            result = 1.0;
        }
        return result;
    }

    public static void calcDamageReflected(L2Character attacker, L2Character target, Skill skill, boolean crit) {
        if (skill.isMagic() || skill.getCastRange() > 40) {
            return;
        }
        double chance = target.calcStat(Stats.VENGEANCE_SKILL_PHYSICAL_DAMAGE, 0.0, target, skill);
        if ((double)Rnd.get((int)100) < chance) {
            SystemMessage sm;
            if (target.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.COUNTERED_C1_ATTACK);
                sm.addCharName(attacker);
                target.sendPacket(sm);
            }
            if (attacker.isPlayer()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_PERFORMING_COUNTERATTACK);
                sm.addCharName(target);
                attacker.sendPacket(sm);
            }
            double counterdmg = target.getPAtk(attacker) * 10.0 * 70.0 / attacker.getPDef(target);
            counterdmg *= Formulas.calcWeaponTraitBonus(attacker, target);
            counterdmg *= Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
            attacker.reduceCurrentHp(counterdmg *= Formulas.calcAttributeBonus(attacker, target, skill), target, skill);
            if (crit) {
                attacker.reduceCurrentHp(counterdmg, target, skill);
            }
            target.notifyDamageReceived(counterdmg, attacker, skill, crit, false, true);
        }
    }

    public static boolean calcBuffDebuffReflection(L2Character target, Skill skill) {
        if (!skill.isDebuff() || skill.getActivateRate() == -1) {
            return false;
        }
        return target.calcStat(skill.isMagic() ? Stats.REFLECT_SKILL_MAGIC : Stats.REFLECT_SKILL_PHYSIC, 0.0, null, skill) > (double)Rnd.get((int)100);
    }

    public static double calcFallDam(L2Character cha, int fallHeight) {
        if (!Configuration.general().enableFallingDamage() || fallHeight < 0) {
            return 0.0;
        }
        return cha.calcStat(Stats.FALL, (double)(fallHeight * cha.getMaxHp()) / 1000.0, null, null);
    }

    public static boolean calcBlowSuccess(L2Character activeChar, L2Character target, Skill skill, int blowChance) {
        double dexMod = BaseStats.DEX.calcBonus(activeChar);
        double sideMod = activeChar.isInFrontOfTarget() ? 1.0 : (activeChar.isBehindTarget() ? 2.0 : 1.5);
        double baseRate = (double)blowChance * dexMod * sideMod;
        double rate = activeChar.calcStat(Stats.BLOW_RATE, baseRate, target, null);
        if (activeChar.isDebug()) {
            StatsSet set = new StatsSet();
            set.set("dexMod", dexMod);
            set.set("blowChance", blowChance);
            set.set("sideMod", sideMod);
            set.set("baseRate", baseRate);
            set.set("rate", rate);
            Debug.sendSkillDebug(activeChar, target, skill, set);
        }
        return (double)Rnd.get((int)100) < rate;
    }

    public static List<BuffInfo> calcCancelEffects(L2Character activeChar, L2Character target, Skill skill, DispelCategory slot, int rate, int max) {
        ArrayList<BuffInfo> canceled = new ArrayList<BuffInfo>(max);
        block0 : switch (slot) {
            case BUFF: {
                ArrayList<BuffInfo> buffs;
                int cancelMagicLvl = skill.getMagicLevel();
                double vuln = target.calcStat(Stats.CANCEL_VULN, 0.0, target, null);
                double prof = activeChar.calcStat(Stats.CANCEL_PROF, 0.0, target, null);
                double resMod = 1.0 + (vuln + prof) * -1.0 / 100.0;
                double finalRate = (double)rate / resMod;
                if (activeChar.isDebug()) {
                    StatsSet set = new StatsSet();
                    set.set("baseMod", rate);
                    set.set("magicLevel", cancelMagicLvl);
                    set.set("resMod", resMod);
                    set.set("rate", finalRate);
                    Debug.sendSkillDebug(activeChar, target, skill, set);
                }
                ArrayList<BuffInfo> arrayList = buffs = target.getEffectList().hasBuffs() ? new ArrayList<BuffInfo>(target.getEffectList().getBuffs()) : new ArrayList(1);
                if (target.getEffectList().hasDances()) {
                    buffs.addAll(target.getEffectList().getDances());
                }
                if (target.getEffectList().hasTriggered()) {
                    buffs.addAll(target.getEffectList().getTriggered());
                }
                for (int i = buffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)buffs.get(i);
                    if (!info.getSkill().canBeStolen() || !Formulas.calcCancelSuccess(info, cancelMagicLvl, (int)finalRate, skill)) continue;
                    canceled.add(info);
                    if (canceled.size() >= max) break block0;
                }
                break;
            }
            case DEBUFF: {
                ArrayList<BuffInfo> debuffs = new ArrayList<BuffInfo>(target.getEffectList().getDebuffs());
                for (int i = debuffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)debuffs.get(i);
                    if (!info.getSkill().isDebuff() || info.getSkill().isIrreplaceableBuff() || Rnd.get((int)100) > rate) continue;
                    canceled.add(info);
                    if (canceled.size() >= max) break block0;
                }
                break;
            }
        }
        return canceled;
    }

    public static List<BuffInfo> calcStealEffects(L2Character activeChar, L2Character target, Skill skill, DispelCategory slot, int rate, int max) {
        ArrayList<BuffInfo> canceled = new ArrayList<BuffInfo>(max);
        int cancelMagicLvl = skill.getMagicLevel();
        block0 : switch (slot) {
            case BUFF: {
                ArrayList<BuffInfo> buffs;
                ArrayList<BuffInfo> arrayList = buffs = target.getEffectList().hasBuffs() ? new ArrayList<BuffInfo>(target.getEffectList().getBuffs()) : new ArrayList(max);
                if (target.getEffectList().hasDances()) {
                    buffs.addAll(target.getEffectList().getDances());
                }
                if (target.getEffectList().hasTriggered()) {
                    buffs.addAll(target.getEffectList().getTriggered());
                }
                int pos = max;
                for (int i = buffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)buffs.get(i);
                    if (!info.getSkill().canBeStolen()) continue;
                    --pos;
                    if (Formulas.calcCancelSuccess(info, cancelMagicLvl, rate, skill)) {
                        canceled.add(info);
                    }
                    if (pos < 1) break block0;
                }
                break;
            }
            case DEBUFF: {
                ArrayList<BuffInfo> debuffs = new ArrayList<BuffInfo>(target.getEffectList().getDebuffs());
                for (int i = debuffs.size() - 1; i >= 0; --i) {
                    BuffInfo info = (BuffInfo)debuffs.get(i);
                    if (!info.getSkill().isDebuff() || info.getSkill().isIrreplaceableBuff() || Rnd.get((int)100) > rate) continue;
                    canceled.add(info);
                    if (canceled.size() >= max) break block0;
                }
                break;
            }
        }
        return canceled;
    }

    public static boolean calcCancelSuccess(BuffInfo info, int cancelMagicLvl, int rate, Skill skill) {
        rate = (int)((double)rate * (info.getSkill().getMagicLevel() > 0 ? 1.0 + (double)(cancelMagicLvl - info.getSkill().getMagicLevel()) / 100.0 : 1.0));
        return Rnd.get((int)100) < Util.constrain(rate, skill.getMinChance(), skill.getMaxChance());
    }

    public static int calcEffectAbnormalTime(L2Character caster, L2Character target, Skill skill) {
        int time;
        int n = time = skill.isPassive() || skill.isToggle() ? -1 : skill.getAbnormalTime();
        if (target != null && target.isServitor() && skill.isAbnormalInstant()) {
            time /= 2;
        }
        if (Formulas.calcSkillMastery(caster, skill)) {
            time *= 2;
        }
        if (caster != null && target != null && skill.isDebuff()) {
            double statMod = skill.getBasicProperty().calcBonus(target);
            double resMod = Formulas.calcGeneralTraitBonus(caster, target, skill.getTraitType(), false);
            double lvlBonusMod = Formulas.calcLvlBonusMod(caster, target, skill);
            double elementMod = Formulas.calcAttributeBonus(caster, target, skill);
            time = (int)Math.ceil(Util.constrain((double)time * resMod * lvlBonusMod * elementMod / statMod, (double)time * 0.5, (double)time));
        }
        return time;
    }

    public static boolean calcProbability(double baseChance, L2Character attacker, L2Character target, Skill skill) {
        return (double)Rnd.get((int)100) < ((double)skill.getMagicLevel() + baseChance - (double)target.getLevel() + 30.0 - (double)target.getINT()) * Formulas.calcAttributeBonus(attacker, target, skill) * Formulas.calcGeneralTraitBonus(attacker, target, skill.getTraitType(), false);
    }

    public static int calculateKarmaLost(L2PcInstance player, long exp) {
        double karmaLooseMul = KarmaData.getInstance().getMultiplier(player.getLevel());
        if (exp > 0L) {
            exp = (long)((double)exp / Configuration.rates().getRateKarmaLost());
        }
        return (int)((double)Math.abs(exp) / karmaLooseMul / 30.0);
    }

    public static int calculateKarmaGain(int pkCount, boolean isSummon) {
        int result = 43200;
        if (isSummon && (result = (int)(((double)pkCount * 0.375 + 1.0) * 60.0 * 4.0) - 150) > 10800) {
            return 10800;
        }
        if (pkCount < 99) {
            result = (int)(((double)pkCount * 0.5 + 1.0) * 60.0 * 12.0);
        } else if (pkCount < 180) {
            result = (int)(((double)pkCount * 0.125 + 37.75) * 60.0 * 12.0);
        }
        return result;
    }

    public static double calcGeneralTraitBonus(L2Character attacker, L2Character target, TraitType traitType, boolean ignoreResistance) {
        if (traitType == TraitType.NONE) {
            return 1.0;
        }
        if (target.getStat().isTraitInvul(traitType)) {
            return 0.0;
        }
        switch (traitType.getType()) {
            case 2: {
                if (attacker.getStat().hasAttackTrait(traitType) && target.getStat().hasDefenceTrait(traitType)) break;
                return 1.0;
            }
            case 3: {
                if (!ignoreResistance) break;
                return 1.0;
            }
            default: {
                return 1.0;
            }
        }
        double result = (double)(attacker.getStat().getAttackTrait(traitType) - target.getStat().getDefenceTrait(traitType)) + 1.0;
        return Util.constrain(result, 0.05, 2.0);
    }

    public static double calcWeaponTraitBonus(L2Character attacker, L2Character target) {
        TraitType type = attacker.getAttackType().getTraitType();
        double result = (double)target.getStat().getDefenceTraits()[type.getId()] - 1.0;
        return 1.0 - result;
    }

    public static double calcAttackTraitBonus(L2Character attacker, L2Character target) {
        double weaponTraitBonus = Formulas.calcWeaponTraitBonus(attacker, target);
        if (weaponTraitBonus == 0.0) {
            return 0.0;
        }
        double weaknessBonus = 1.0;
        for (TraitType traitType : TraitType.values()) {
            if (traitType.getType() != 2 || (weaknessBonus *= Formulas.calcGeneralTraitBonus(attacker, target, traitType, true)) != 0.0) continue;
            return 0.0;
        }
        return Util.constrain(weaponTraitBonus * weaknessBonus, 0.05, 2.0);
    }
}

