/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats.functions;

import com.l2jserver.gameserver.enums.StatFunction;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FuncTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(FuncTemplate.class);
    private final Condition _attachCond;
    private final Condition _applyCond;
    private final Constructor<?> _constructor;
    private final Stats _stat;
    private final int _order;
    private final double _value;

    public FuncTemplate(Condition attachCond, Condition applyCond, String functionName, int order, Stats stat, double value) {
        StatFunction function = StatFunction.valueOf(functionName.toUpperCase());
        this._order = order >= 0 ? order : function.getOrder();
        this._attachCond = attachCond;
        this._applyCond = applyCond;
        this._stat = stat;
        this._value = value;
        try {
            Class<?> functionClass = Class.forName("com.l2jserver.gameserver.model.stats.functions.Func" + function.getName());
            this._constructor = functionClass.getConstructor(Stats.class, Integer.TYPE, Object.class, Double.TYPE, Condition.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Stats getStat() {
        return this._stat;
    }

    public int getOrder() {
        return this._order;
    }

    public double getValue() {
        return this._value;
    }

    public AbstractFunction getFunc(L2Character caster, L2Character target, Skill skill, Object owner) {
        return this.getFunc(caster, target, skill, null, owner);
    }

    public AbstractFunction getFunc(L2Character caster, L2Character target, L2ItemInstance item, Object owner) {
        return this.getFunc(caster, target, null, item, owner);
    }

    private AbstractFunction getFunc(L2Character caster, L2Character target, Skill skill, L2ItemInstance item, Object owner) {
        if (this._attachCond != null && !this._attachCond.test(caster, target, skill)) {
            return null;
        }
        try {
            return (AbstractFunction)this._constructor.newInstance(new Object[]{this._stat, this._order, owner, this._value, this._applyCond});
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return null;
        }
    }
}

