/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats.functions.formulas;

import com.l2jserver.gameserver.data.xml.impl.ArmorSetsData;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import java.util.HashMap;
import java.util.Map;

public class FuncArmorSet
extends AbstractFunction {
    private static final Map<Stats, FuncArmorSet> _fh_instance = new HashMap<Stats, FuncArmorSet>();

    public static AbstractFunction getInstance(Stats st) {
        if (!_fh_instance.containsKey((Object)st)) {
            _fh_instance.put(st, new FuncArmorSet(st));
        }
        return _fh_instance.get((Object)st);
    }

    private FuncArmorSet(Stats stat) {
        super(stat, 1, null, 0.0, null);
    }

    @Override
    public double calc(L2Character effector, L2Character effected, Skill skill, double initVal) {
        L2ArmorSet set;
        L2ItemInstance chest;
        double value = initVal;
        L2PcInstance player = effector.getActingPlayer();
        if (player != null && (chest = player.getChestArmorInstance()) != null && (set = ArmorSetsData.getInstance().getSet(chest.getId())) != null && set.containAll(player)) {
            switch (this.getStat()) {
                case STAT_STR: {
                    value += (double)set.getSTR();
                    break;
                }
                case STAT_DEX: {
                    value += (double)set.getDEX();
                    break;
                }
                case STAT_INT: {
                    value += (double)set.getINT();
                    break;
                }
                case STAT_MEN: {
                    value += (double)set.getMEN();
                    break;
                }
                case STAT_CON: {
                    value += (double)set.getCON();
                    break;
                }
                case STAT_WIT: {
                    value += (double)set.getWIT();
                }
            }
        }
        return value;
    }
}

