/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.variables;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.variables.AbstractVariables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerVariables
extends AbstractVariables {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerVariables.class);
    private static final String SELECT_QUERY = "SELECT * FROM character_variables WHERE charId = ?";
    private static final String DELETE_QUERY = "DELETE FROM character_variables WHERE charId = ?";
    private static final String INSERT_QUERY = "INSERT INTO character_variables (charId, var, val) VALUES (?, ?, ?)";
    private final int _objectId;

    public PlayerVariables(int objectId) {
        this._objectId = objectId;
        this.restoreMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreMe() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_QUERY);){
            ps.setInt(1, this._objectId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.set(rs.getString("var"), rs.getString("val"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't restore variables for: {}", (Object)this.getPlayer(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeMe() {
        if (!this.hasChanges()) {
            return false;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            try (PreparedStatement st = con.prepareStatement(DELETE_QUERY);){
                st.setInt(1, this._objectId);
                st.execute();
            }
            st = con.prepareStatement(INSERT_QUERY);
            try {
                st.setInt(1, this._objectId);
                for (Map.Entry<String, Object> entry : this.getSet().entrySet()) {
                    st.setString(2, entry.getKey());
                    st.setString(3, String.valueOf(entry.getValue()));
                    st.addBatch();
                }
                st.executeBatch();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't update variables for: {}", (Object)this.getPlayer(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.compareAndSetChanges(true, false);
        }
        return true;
    }

    public L2PcInstance getPlayer() {
        return L2World.getInstance().getPlayer(this._objectId);
    }
}

