/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.character.CreatureZoneEnter;
import com.l2jserver.gameserver.model.events.impl.character.CreatureZoneExit;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneForm;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2ZoneType
extends ListenersContainer {
    private static final Logger LOG = LoggerFactory.getLogger(L2ZoneType.class);
    private final int _id;
    protected L2ZoneForm _zone;
    protected Map<Integer, L2Character> _characterList;
    private boolean _checkAffected = false;
    private String _name = null;
    private int _instanceId = -1;
    private String _instanceTemplate = "";
    private int _minLvl;
    private int _maxLvl;
    private int[] _race;
    private int[] _class;
    private char _classType;
    private InstanceType _target = InstanceType.L2Character;
    private boolean _allowStore;
    private boolean _enabled;
    private AbstractZoneSettings _settings;

    protected L2ZoneType(int id) {
        this._id = id;
        this._characterList = new ConcurrentHashMap<Integer, L2Character>();
        this._minLvl = 0;
        this._maxLvl = 255;
        this._classType = '\u0000';
        this._race = null;
        this._class = null;
        this._allowStore = true;
        this._enabled = true;
    }

    public int getId() {
        return this._id;
    }

    public void setParameter(String name, String value) {
        this._checkAffected = true;
        switch (name) {
            case "name": {
                this._name = value;
                break;
            }
            case "instanceId": {
                this._instanceId = Integer.parseInt(value);
                break;
            }
            case "instanceTemplate": {
                this._instanceTemplate = value;
                this._instanceId = InstanceManager.getInstance().createDynamicInstance(value);
                break;
            }
            case "affectedLvlMin": {
                this._minLvl = Integer.parseInt(value);
                break;
            }
            case "affectedLvlMax": {
                this._maxLvl = Integer.parseInt(value);
                break;
            }
            case "affectedRace": {
                if (this._race == null) {
                    this._race = new int[1];
                    this._race[0] = Integer.parseInt(value);
                    break;
                }
                int[] temp = new int[this._race.length + 1];
                for (int i = 0; i < this._race.length; ++i) {
                    temp[i] = this._race[i];
                }
                temp[i] = Integer.parseInt(value);
                this._race = temp;
                break;
            }
            case "affectedClassId": {
                if (this._class == null) {
                    this._class = new int[1];
                    this._class[0] = Integer.parseInt(value);
                    break;
                }
                int[] temp = new int[this._class.length + 1];
                for (int i = 0; i < this._class.length; ++i) {
                    temp[i] = this._class[i];
                }
                temp[i] = Integer.parseInt(value);
                this._class = temp;
                break;
            }
            case "affectedClassType": {
                if (value.equals("Fighter")) {
                    this._classType = '\u0001';
                    break;
                }
                this._classType = (char)2;
                break;
            }
            case "targetClass": {
                this._target = Enum.valueOf(InstanceType.class, value);
                break;
            }
            case "allowStore": {
                this._allowStore = Boolean.parseBoolean(value);
                break;
            }
            case "default_enabled": {
                this._enabled = Boolean.parseBoolean(value);
                break;
            }
            default: {
                LOG.info("Unknown parameter - {} in zone: {}", (Object)name, (Object)this.getId());
            }
        }
    }

    private boolean isAffected(L2Character character) {
        if (character.getLevel() < this._minLvl || character.getLevel() > this._maxLvl) {
            return false;
        }
        if (!character.isInstanceTypes(this._target)) {
            return false;
        }
        if (character instanceof L2PcInstance) {
            boolean ok;
            if (this._classType != '\u0000' && (((L2PcInstance)character).isMageClass() ? this._classType == '\u0001' : this._classType == '\u0002')) {
                return false;
            }
            if (this._race != null) {
                ok = false;
                for (int element : this._race) {
                    if (character.getRace().ordinal() != element) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
            }
            if (this._class != null) {
                ok = false;
                for (int classId : this._class) {
                    if (((L2PcInstance)character).getClassId().ordinal() != classId) continue;
                    ok = true;
                    break;
                }
                return ok;
            }
        }
        return true;
    }

    public void setZone(L2ZoneForm zone) {
        if (this._zone != null) {
            throw new IllegalStateException("Zone already set");
        }
        this._zone = zone;
    }

    public L2ZoneForm getZone() {
        return this._zone;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setInstanceId(int instanceId) {
        this._instanceId = instanceId;
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public String getInstanceTemplate() {
        return this._instanceTemplate;
    }

    public boolean isInsideZone(int x, int y) {
        return this._zone.isInsideZone(x, y, this._zone.getHighZ());
    }

    public boolean isInsideZone(ILocational loc) {
        return this._zone.isInsideZone(loc.getX(), loc.getY(), loc.getZ());
    }

    public boolean isInsideZone(int x, int y, int z) {
        return this._zone.isInsideZone(x, y, z);
    }

    public boolean isInsideZone(int x, int y, int z, int instanceId) {
        if (this._instanceId == -1 || instanceId == -1 || this._instanceId == instanceId) {
            return this._zone.isInsideZone(x, y, z);
        }
        return false;
    }

    public boolean isInsideZone(L2Object object) {
        return this.isInsideZone(object.getX(), object.getY(), object.getZ(), object.getInstanceId());
    }

    public double getDistanceToZone(int x, int y) {
        return this.getZone().getDistanceToZone(x, y);
    }

    public double getDistanceToZone(L2Object object) {
        return this.getZone().getDistanceToZone(object.getX(), object.getY());
    }

    public void revalidateInZone(L2Character character) {
        if (this._checkAffected && !this.isAffected(character)) {
            return;
        }
        if (this.isInsideZone(character)) {
            if (!this._characterList.containsKey(character.getObjectId())) {
                EventDispatcher.getInstance().notifyEventAsync(new CreatureZoneEnter(character, this), this);
                this._characterList.put(character.getObjectId(), character);
                this.onEnter(character);
            }
        } else {
            this.removeCharacter(character);
        }
    }

    public void removeCharacter(L2Character character) {
        if (this._characterList.containsKey(character.getObjectId())) {
            EventDispatcher.getInstance().notifyEventAsync(new CreatureZoneExit(character, this), this);
            this._characterList.remove(character.getObjectId());
            this.onExit(character);
        }
    }

    public boolean isCharacterInZone(L2Character character) {
        return this._characterList.containsKey(character.getObjectId());
    }

    public AbstractZoneSettings getSettings() {
        return this._settings;
    }

    public void setSettings(AbstractZoneSettings settings) {
        if (this._settings != null) {
            this._settings.clear();
        }
        this._settings = settings;
    }

    protected abstract void onEnter(L2Character var1);

    protected abstract void onExit(L2Character var1);

    public void onDieInside(L2Character character) {
    }

    public void onReviveInside(L2Character character) {
    }

    public void onPlayerLoginInside(L2PcInstance player) {
    }

    public void onPlayerLogoutInside(L2PcInstance player) {
    }

    public Map<Integer, L2Character> getCharacters() {
        return this._characterList;
    }

    public Collection<L2Character> getCharactersInside() {
        return this._characterList.values();
    }

    public List<L2PcInstance> getPlayersInside() {
        ArrayList<L2PcInstance> players = new ArrayList<L2PcInstance>();
        for (L2Character ch : this._characterList.values()) {
            if (ch == null || !ch.isPlayer()) continue;
            players.add(ch.getActingPlayer());
        }
        return players;
    }

    public void broadcastPacket(L2GameServerPacket packet) {
        if (this._characterList.isEmpty()) {
            return;
        }
        for (L2Character character : this._characterList.values()) {
            if (character == null || !character.isPlayer()) continue;
            character.sendPacket(packet);
        }
    }

    public InstanceType getTargetType() {
        return this._target;
    }

    public void setTargetType(InstanceType type) {
        this._target = type;
        this._checkAffected = true;
    }

    public boolean getAllowStore() {
        return this._allowStore;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    public void visualizeZone(int z) {
        this.getZone().visualizeZone(z);
    }

    public void setEnabled(boolean state) {
        this._enabled = state;
    }

    public boolean isEnabled() {
        return this._enabled;
    }
}

